/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.clipboard;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.dnd.GenericDataFlavor;
import docking.dnd.StringTransferable;
import docking.widgets.fieldpanel.Layout;
import docking.widgets.fieldpanel.internal.EmptyLayoutBackgroundColorManager;
import docking.widgets.fieldpanel.internal.LayoutBackgroundColorManager;
import docking.widgets.fieldpanel.internal.PaintContext;
import generic.text.TextLayoutGraphics;
import ghidra.app.cmd.comments.CodeUnitInfoPasteCmd;
import ghidra.app.cmd.comments.SetCommentCmd;
import ghidra.app.cmd.function.SetVariableNameCmd;
import ghidra.app.cmd.label.RenameLabelCmd;
import ghidra.app.plugin.core.codebrowser.CodeViewerActionContext;
import ghidra.app.services.ClipboardContentProviderService;
import ghidra.app.util.ByteCopier;
import ghidra.app.util.ClipboardType;
import ghidra.app.util.CodeUnitInfo;
import ghidra.app.util.CodeUnitInfoTransferable;
import ghidra.app.util.CommentTypes;
import ghidra.app.util.viewer.listingpanel.ListingModel;
import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObject;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.database.mem.AddressSourceInfo;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitIterator;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.util.AddressFieldLocation;
import ghidra.program.util.BytesFieldLocation;
import ghidra.program.util.CommentFieldLocation;
import ghidra.program.util.FunctionNameFieldLocation;
import ghidra.program.util.InteriorSelection;
import ghidra.program.util.LabelFieldLocation;
import ghidra.program.util.MnemonicFieldLocation;
import ghidra.program.util.OperandFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.program.util.VariableLocation;
import ghidra.util.Msg;
import ghidra.util.bean.opteditor.OptionsVetoException;
import ghidra.util.task.CancellableIterator;
import ghidra.util.task.TaskMonitor;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang3.StringUtils;
import util.CollectionUtils;

public class CodeBrowserClipboardProvider
extends ByteCopier
implements ClipboardContentProviderService,
OptionsChangeListener {
    protected static final PaintContext PAINT_CONTEXT = new PaintContext();
    private static int[] COMMENT_TYPESx = CommentTypes.getTypes();
    public static final ClipboardType ADDRESS_TEXT_TYPE = new ClipboardType(DataFlavor.stringFlavor, "Address");
    public static final ClipboardType ADDRESS_TEXT_WITH_OFFSET_TYPE = new ClipboardType(DataFlavor.stringFlavor, "Address w/ Offset");
    public static final ClipboardType BYTE_SOURCE_OFFSET_TYPE = new ClipboardType(DataFlavor.stringFlavor, "Byte Source Offset");
    public static final ClipboardType FUNCTION_OFFSET_TYPE = new ClipboardType(DataFlavor.stringFlavor, "Function Offset");
    public static final ClipboardType IMAGEBASE_OFFSET_TYPE = new ClipboardType(DataFlavor.stringFlavor, "Imagebase Offset");
    public static final ClipboardType BLOCK_OFFSET_TYPE = new ClipboardType(DataFlavor.stringFlavor, "Memory Block Offset");
    public static final ClipboardType CODE_TEXT_TYPE = new ClipboardType(DataFlavor.stringFlavor, "Formatted Code");
    public static final ClipboardType LABELS_COMMENTS_TYPE = new ClipboardType(CodeUnitInfoTransferable.localDataTypeFlavor, "Labels and Comments");
    public static final ClipboardType LABELS_TYPE = new ClipboardType(CodeUnitInfoTransferable.localDataTypeFlavor, "Labels");
    public static final ClipboardType COMMENTS_TYPE = new ClipboardType(CodeUnitInfoTransferable.localDataTypeFlavor, "Comments");
    public static final ClipboardType GHIDRA_LOCAL_URL_TYPE = new ClipboardType(DataFlavor.stringFlavor, "Local GhidraURL");
    public static final ClipboardType GHIDRA_SHARED_URL_TYPE = new ClipboardType(DataFlavor.stringFlavor, "Shared GhidraURL");
    public static final ClipboardType GHIDRA_DATA_TEXT_TYPE = new ClipboardType(DataFlavor.stringFlavor, "Data");
    public static final ClipboardType GHIDRA_DEREFERENCED_DATA_TEXT_TYPE = new ClipboardType(DataFlavor.stringFlavor, "Dereferenced Data");
    private static final List<ClipboardType> COPY_TYPES = CodeBrowserClipboardProvider.createCopyTypesList();
    protected boolean copyFromSelectionEnabled;
    protected ComponentProvider componentProvider;
    private ListingModel model;
    private Set<ChangeListener> listeners = new CopyOnWriteArraySet<ChangeListener>();
    private String stringContent;
    private boolean includeQuotesForStringData;

    private static List<ClipboardType> createCopyTypesList() {
        LinkedList<ClipboardType> list = new LinkedList<ClipboardType>();
        list.add(CODE_TEXT_TYPE);
        list.add(LABELS_COMMENTS_TYPE);
        list.add(LABELS_TYPE);
        list.add(COMMENTS_TYPE);
        list.add(BYTE_STRING_TYPE);
        list.add(BYTE_STRING_NO_SPACE_TYPE);
        list.add(GHIDRA_DATA_TEXT_TYPE);
        list.add(GHIDRA_DEREFERENCED_DATA_TEXT_TYPE);
        list.add(PYTHON_BYTE_STRING_TYPE);
        list.add(PYTHON_LIST_TYPE);
        list.add(CPP_BYTE_ARRAY_TYPE);
        list.add(ADDRESS_TEXT_TYPE);
        list.add(ADDRESS_TEXT_WITH_OFFSET_TYPE);
        list.add(BYTE_SOURCE_OFFSET_TYPE);
        list.add(BLOCK_OFFSET_TYPE);
        list.add(FUNCTION_OFFSET_TYPE);
        list.add(IMAGEBASE_OFFSET_TYPE);
        return list;
    }

    public CodeBrowserClipboardProvider(PluginTool tool, ComponentProvider componentProvider) {
        this.tool = tool;
        this.componentProvider = componentProvider;
        PAINT_CONTEXT.setTextCopying(true);
        ToolOptions options = tool.getOptions("Tool");
        this.includeQuotesForStringData = !options.getBoolean("Copy Strings Without Quotes", false);
        options.addOptionsChangeListener((OptionsChangeListener)this);
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyStateChanged() {
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(event);
        }
    }

    @Override
    public Transferable copy(TaskMonitor monitor) {
        if (this.stringContent != null) {
            return CodeBrowserClipboardProvider.createStringTransferable(this.stringContent);
        }
        if (this.copyFromSelectionEnabled) {
            return this.copyCode(monitor);
        }
        return this.copyFromCurrentLocation();
    }

    @Override
    public boolean paste(Transferable pasteData) {
        try {
            DataFlavor[] flavors;
            for (DataFlavor element : flavors = pasteData.getTransferDataFlavors()) {
                if (element.equals(LABELS_COMMENTS_TYPE.getFlavor())) {
                    return this.pasteLabelsComments(pasteData, true, true);
                }
                if (element.equals(LABELS_TYPE.getFlavor())) {
                    return this.pasteLabelsComments(pasteData, true, false);
                }
                if (element.equals(COMMENTS_TYPE.getFlavor())) {
                    return this.pasteLabelsComments(pasteData, false, true);
                }
                if (element.equals(LabelStringTransferable.labelStringFlavor)) {
                    return this.pasteLabelString(pasteData);
                }
                if (!element.equals(NonLabelStringTransferable.nonLabelStringFlavor)) continue;
                return this.pasteNonLabelString(pasteData);
            }
            if (super.pasteBytes(pasteData)) {
                return true;
            }
            this.tool.setStatusInfo("Paste failed: unsupported data type", true);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg == null) {
                msg = e.toString();
            }
            Msg.error((Object)this, (Object)("Unexpected Exception: " + msg), (Throwable)e);
            this.tool.setStatusInfo("Paste failed: " + msg, true);
        }
        return false;
    }

    @Override
    public List<ClipboardType> getCurrentCopyTypes() {
        ClipboardType urlType = this.getGhidraUrlClipboardType();
        if (urlType == null) {
            return COPY_TYPES;
        }
        ArrayList<ClipboardType> currentCopyTypes = new ArrayList<ClipboardType>(COPY_TYPES);
        currentCopyTypes.add(urlType);
        return currentCopyTypes;
    }

    private ClipboardType getGhidraUrlClipboardType() {
        if (this.currentProgram == null) {
            return null;
        }
        DomainFile domainFile = this.currentProgram.getDomainFile();
        if (domainFile == null) {
            return null;
        }
        if (domainFile.getLocalProjectURL(null) != null) {
            return GHIDRA_LOCAL_URL_TYPE;
        }
        if (domainFile.getSharedProjectURL(null) != null) {
            return GHIDRA_SHARED_URL_TYPE;
        }
        return null;
    }

    @Override
    public Transferable copySpecial(ClipboardType copyType, TaskMonitor monitor) {
        if (copyType == ADDRESS_TEXT_TYPE) {
            return this.copyAddress(monitor);
        }
        if (copyType == ADDRESS_TEXT_WITH_OFFSET_TYPE) {
            return this.copySymbolString(monitor);
        }
        if (copyType == BYTE_SOURCE_OFFSET_TYPE) {
            return this.copyByteSourceOffset(monitor);
        }
        if (copyType == BLOCK_OFFSET_TYPE) {
            return this.copyBlockSourceOffset(monitor);
        }
        if (copyType == FUNCTION_OFFSET_TYPE) {
            return this.copyFunctionSourceOffset(monitor);
        }
        if (copyType == IMAGEBASE_OFFSET_TYPE) {
            return this.copyImagebaseSourceOffset(monitor);
        }
        if (copyType == CODE_TEXT_TYPE) {
            return this.copyCode(monitor);
        }
        if (copyType == LABELS_COMMENTS_TYPE) {
            return this.copyLabelsComments(true, true, monitor);
        }
        if (copyType == LABELS_TYPE) {
            return this.copyLabelsComments(true, false, monitor);
        }
        if (copyType == COMMENTS_TYPE) {
            return this.copyLabelsComments(false, true, monitor);
        }
        if (copyType == GHIDRA_LOCAL_URL_TYPE) {
            return this.copyLocalGhidraURL();
        }
        if (copyType == GHIDRA_SHARED_URL_TYPE) {
            return this.copySharedGhidraURL();
        }
        if (copyType == GHIDRA_DATA_TEXT_TYPE) {
            return this.copyDataText();
        }
        if (copyType == GHIDRA_DEREFERENCED_DATA_TEXT_TYPE) {
            return this.copyReferencedDataText();
        }
        return this.copyBytes(copyType, monitor);
    }

    public void setStringContent(String text) {
        this.stringContent = text;
    }

    public String getStringContent() {
        return this.stringContent;
    }

    public void setLocation(ProgramLocation location) {
        this.currentLocation = location;
    }

    public void setSelection(ProgramSelection selection) {
        this.currentSelection = selection;
        this.copyFromSelectionEnabled = selection != null && !selection.isEmpty();
        this.notifyStateChanged();
    }

    public void setProgram(Program p) {
        this.currentProgram = p;
        this.currentLocation = null;
        this.currentSelection = null;
    }

    public void setListingLayoutModel(ListingModel model) {
        this.model = model;
    }

    protected ListingModel getListingModel() {
        return this.model;
    }

    private Transferable copyFromCurrentLocation() {
        Address address = this.currentLocation.getAddress();
        if (this.currentLocation instanceof AddressFieldLocation) {
            return new NonLabelStringTransferable(address.toString());
        }
        if (this.currentLocation instanceof LabelFieldLocation) {
            LabelFieldLocation labelFieldLocation = (LabelFieldLocation)this.currentLocation;
            return new LabelStringTransferable(labelFieldLocation.getName());
        }
        if (this.currentLocation instanceof FunctionNameFieldLocation) {
            FunctionNameFieldLocation functionNameLocation = (FunctionNameFieldLocation)this.currentLocation;
            return new LabelStringTransferable(functionNameLocation.getFunctionName());
        }
        if (this.currentLocation instanceof CommentFieldLocation) {
            CommentFieldLocation commentFieldLocation = (CommentFieldLocation)this.currentLocation;
            String[] comment = commentFieldLocation.getComment();
            return new NonLabelStringTransferable(comment);
        }
        if (this.currentLocation instanceof BytesFieldLocation) {
            return this.copyByteString(address);
        }
        if (this.currentLocation instanceof OperandFieldLocation) {
            return this.getOperandLocationTransferable((OperandFieldLocation)this.currentLocation);
        }
        if (this.currentLocation instanceof MnemonicFieldLocation) {
            MnemonicFieldLocation location = (MnemonicFieldLocation)this.currentLocation;
            return new NonLabelStringTransferable(location.getMnemonic());
        }
        if (this.currentLocation instanceof VariableLocation) {
            VariableLocation variableLocation = (VariableLocation)this.currentLocation;
            Variable variable = variableLocation.getVariable();
            return new LabelStringTransferable(variable.getName());
        }
        return null;
    }

    private Transferable getOperandLocationTransferable(OperandFieldLocation location) {
        int opIndex = location.getOperandIndex();
        Listing listing = this.currentProgram.getListing();
        Instruction instruction = listing.getInstructionAt(location.getAddress());
        if (instruction == null) {
            return new NonLabelStringTransferable(location.getOperandRepresentation());
        }
        Reference reference = instruction.getPrimaryReference(opIndex);
        if (reference == null) {
            return new NonLabelStringTransferable(location.getOperandRepresentation());
        }
        Variable variable = this.currentProgram.getReferenceManager().getReferencedVariable(reference);
        if (variable != null) {
            return new LabelStringTransferable(variable.getName());
        }
        SymbolTable symbolTable = this.currentProgram.getSymbolTable();
        Symbol symbol = symbolTable.getSymbol(reference);
        if (symbol != null) {
            return new LabelStringTransferable(symbol.getName());
        }
        return new NonLabelStringTransferable(location.getOperandRepresentation());
    }

    private Transferable copyAddress(TaskMonitor monitor) {
        AddressSetView addrs = this.getSelectedAddresses();
        AddressIterator iterable = addrs.getAddresses(true);
        CancellableIterator it = new CancellableIterator(iterable.iterator(), monitor);
        return CodeBrowserClipboardProvider.createStringTransferable(StringUtils.join((Iterator)it, (String)"\n"));
    }

    private Transferable copySymbolString(TaskMonitor monitor) {
        Listing listing = this.currentProgram.getListing();
        ArrayList<String> strings = new ArrayList<String>();
        CodeUnitIterator codeUnits = listing.getCodeUnits(this.getSelectedAddresses(), true);
        while (codeUnits.hasNext() && !monitor.isCancelled()) {
            CodeUnit cu = codeUnits.next();
            Address addr = cu.getAddress();
            Function function = listing.getFunctionContaining(addr);
            if (function == null) {
                strings.add(addr.toString());
                continue;
            }
            String name = function.getName(true);
            Address entry = function.getEntryPoint();
            int delta = addr.compareTo((Object)entry);
            if (delta == 0) {
                strings.add(name);
                continue;
            }
            if (delta > 0) {
                strings.add(String.format("%s + %#x", name, addr.subtract(entry)));
                continue;
            }
            strings.add(String.format("%s - %#x", name, entry.subtract(addr)));
        }
        return CodeBrowserClipboardProvider.createStringTransferable(StringUtils.join(strings, (String)"\n"));
    }

    private Transferable copyByteSourceOffset(TaskMonitor monitor) {
        AddressSetView addrs = this.getSelectedAddresses();
        Memory currentMemory = this.currentProgram.getMemory();
        ArrayList<String> strings = new ArrayList<String>();
        AddressIterator addresses = addrs.getAddresses(true);
        while (addresses.hasNext() && !monitor.isCancelled()) {
            AddressSourceInfo addressSourceInfo = currentMemory.getAddressSourceInfo(addresses.next());
            if (addressSourceInfo == null) continue;
            long fileOffset = addressSourceInfo.getFileOffset();
            String fileOffsetString = fileOffset != -1L ? "%x".formatted(fileOffset) : "<NO_OFFSET>";
            strings.add(fileOffsetString);
        }
        return CodeBrowserClipboardProvider.createStringTransferable(String.join((CharSequence)"\n", strings));
    }

    private Transferable copyBlockSourceOffset(TaskMonitor monitor) {
        AddressSetView addrs = this.getSelectedAddresses();
        Memory mem = this.currentProgram.getMemory();
        ArrayList<String> strings = new ArrayList<String>();
        AddressIterator addresses = addrs.getAddresses(true);
        while (addresses.hasNext() && !monitor.isCancelled()) {
            Address addr = addresses.next();
            MemoryBlock block = mem.getBlock(addr);
            strings.add(block != null ? "%x".formatted(addr.subtract(block.getStart())) : "<NO_OFFSET>");
        }
        return CodeBrowserClipboardProvider.createStringTransferable(String.join((CharSequence)"\n", strings));
    }

    private Transferable copyFunctionSourceOffset(TaskMonitor monitor) {
        AddressSetView addrs = this.getSelectedAddresses();
        Listing listing = this.currentProgram.getListing();
        ArrayList<String> strings = new ArrayList<String>();
        AddressIterator addresses = addrs.getAddresses(true);
        while (addresses.hasNext() && !monitor.isCancelled()) {
            Address addr = addresses.next();
            Function function = listing.getFunctionContaining(addr);
            strings.add(function != null ? "%x".formatted(addr.subtract(function.getEntryPoint())) : "<NO_OFFSET>");
        }
        return CodeBrowserClipboardProvider.createStringTransferable(String.join((CharSequence)"\n", strings));
    }

    private Transferable copyImagebaseSourceOffset(TaskMonitor monitor) {
        AddressSetView addrs = this.getSelectedAddresses();
        ArrayList<String> strings = new ArrayList<String>();
        AddressIterator addresses = addrs.getAddresses(true);
        while (addresses.hasNext() && !monitor.isCancelled()) {
            Address imagebase;
            Address addr = addresses.next();
            strings.add(addr.hasSameAddressSpace(imagebase = this.currentProgram.getImageBase()) ? "%x".formatted(addr.subtract(imagebase)) : "<NO_OFFSET>");
        }
        return CodeBrowserClipboardProvider.createStringTransferable(String.join((CharSequence)"\n", strings));
    }

    protected Transferable copyCode(TaskMonitor monitor) {
        AddressSetView addressSet = this.getSelectedAddresses();
        ListingModel listingModel = this.getListingModel();
        TextLayoutGraphics g = new TextLayoutGraphics();
        EmptyLayoutBackgroundColorManager colorMap = new EmptyLayoutBackgroundColorManager(PAINT_CONTEXT.getBackground());
        Rectangle rect = new Rectangle(Integer.MAX_VALUE, Integer.MAX_VALUE);
        AddressRangeIterator ranges = addressSet.getAddressRanges();
        while (ranges.hasNext() && !monitor.isCancelled()) {
            AddressRange curRange = (AddressRange)ranges.next();
            Address address = curRange.getMinAddress();
            Address maxAddress = curRange.getMaxAddress();
            while (address != null && address.compareTo((Object)maxAddress) <= 0 && !monitor.isCancelled()) {
                Layout layout = listingModel.getLayout(address, false);
                if (layout != null) {
                    layout.paint(null, (Graphics)g, PAINT_CONTEXT, rect, (LayoutBackgroundColorManager)colorMap, null);
                    g.flush();
                }
                address = listingModel.getAddressAfter(address);
            }
        }
        return CodeBrowserClipboardProvider.createStringTransferable(g.getBuffer());
    }

    private Transferable copyByteString(Address address) {
        AddressSet set = new AddressSet(address);
        return CodeBrowserClipboardProvider.createStringTransferable(this.copyBytesAsString((AddressSetView)set, false, TaskMonitor.DUMMY));
    }

    private CodeUnitInfoTransferable copyLabelsComments(boolean copyLabels, boolean copyComments, TaskMonitor monitor) {
        AddressSetView addressSet = this.getSelectedAddresses();
        ArrayList<CodeUnitInfo> list = new ArrayList<CodeUnitInfo>();
        Address startAddr = addressSet.getMinAddress();
        this.getCodeUnitInfo(addressSet, startAddr, list, copyLabels, copyComments, monitor);
        return new CodeUnitInfoTransferable(list);
    }

    private Transferable copyLocalGhidraURL() {
        String address = this.currentLocation.getAddress().toString();
        URL url = this.currentProgram.getDomainFile().getLocalProjectURL(address);
        return CodeBrowserClipboardProvider.createStringTransferable(url.toString());
    }

    private Transferable copySharedGhidraURL() {
        String address = this.currentLocation.getAddress().toString();
        URL url = this.currentProgram.getDomainFile().getSharedProjectURL(address);
        return CodeBrowserClipboardProvider.createStringTransferable(url.toString());
    }

    private Transferable copyDataText() {
        return this.copyDataText(false);
    }

    private Transferable copyReferencedDataText() {
        return this.copyDataText(true);
    }

    private Transferable copyDataText(boolean followPointers) {
        ProgramSelection programSelection;
        AddressSetView addrs = this.getSelectedAddresses();
        ArrayList<String> strings = new ArrayList<String>();
        Listing listing = this.currentProgram.getListing();
        if (addrs instanceof ProgramSelection && (programSelection = (ProgramSelection)addrs).getInteriorSelection() != null) {
            InteriorSelection interiorSelection = programSelection.getInteriorSelection();
            this.copyInteriorDataText(strings, listing, interiorSelection, followPointers);
        } else {
            for (Data data : listing.getData(addrs, true)) {
                String string = this.getString(data, followPointers);
                if (string == null) continue;
                strings.add(string);
            }
        }
        return CodeBrowserClipboardProvider.createStringTransferable(String.join((CharSequence)"\n", strings));
    }

    private void copyInteriorDataText(List<String> strings, Listing listing, InteriorSelection interior, boolean followPointers) {
        Data outer = listing.getDataContaining(interior.getStartAddress());
        ProgramLocation from = interior.getFrom();
        ProgramLocation to = interior.getTo();
        Data first = outer.getComponent(from.getComponentPath());
        Data last = outer.getComponent(to.getComponentPath());
        if (first == null || last == null) {
            return;
        }
        Data parent = first.getParent();
        int startIndex = first.getComponentIndex();
        int endIndex = last.getComponentIndex();
        for (int i = startIndex; i <= endIndex; ++i) {
            Data child = parent.getComponent(i);
            String string = this.getString(child, followPointers);
            if (string == null) continue;
            strings.add(string);
        }
    }

    private Data getReferencedData(Data data, Set<Address> visited) {
        Object value = data.getValue();
        if (!(value instanceof Address)) {
            return null;
        }
        Address address = (Address)value;
        if (visited.contains(address)) {
            return null;
        }
        visited.add(address);
        Data referenced = this.currentProgram.getListing().getDataAt(address);
        if (referenced == null) {
            return null;
        }
        if (referenced.isPointer()) {
            return this.getReferencedData(referenced, visited);
        }
        return referenced;
    }

    private String getString(Data data, boolean followPointers) {
        if (!followPointers) {
            return this.getString(data);
        }
        if (!data.isPointer()) {
            return null;
        }
        HashSet<Address> visited = new HashSet<Address>();
        Data referenced = this.getReferencedData(data, visited);
        return this.getString(referenced);
    }

    private String getString(Data data) {
        if (data == null || data.getNumComponents() > 0) {
            return null;
        }
        Object value = data.getValue();
        if (value instanceof String) {
            String s = (String)value;
            if (this.includeQuotesForStringData) {
                return "\"" + s + "\"";
            }
            return s;
        }
        return data.getDefaultValueRepresentation();
    }

    private boolean pasteLabelsComments(Transferable pasteData, boolean pasteLabels, boolean pasteComments) {
        try {
            List list = (List)pasteData.getTransferData(CodeUnitInfoTransferable.localDataTypeFlavor);
            List infos = CollectionUtils.asList((List)list, CodeUnitInfo.class);
            CodeUnitInfoPasteCmd cmd = new CodeUnitInfoPasteCmd(this.currentLocation.getAddress(), infos, pasteLabels, pasteComments);
            return this.tool.execute((Command)cmd, (DomainObject)this.currentProgram);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg == null) {
                msg = e.toString();
            }
            this.tool.setStatusInfo("Paste failed: " + msg, true);
            return false;
        }
    }

    private boolean pasteLabelString(Transferable pasteData) throws UnsupportedFlavorException, IOException {
        String labelName = (String)pasteData.getTransferData(LabelStringTransferable.labelStringFlavor);
        Address address = this.currentLocation.getAddress();
        if (this.currentLocation instanceof LabelFieldLocation) {
            LabelFieldLocation labelFieldLocation = (LabelFieldLocation)this.currentLocation;
            String oldName = labelFieldLocation.getName();
            RenameLabelCmd cmd = new RenameLabelCmd(address, oldName, labelName, SourceType.USER_DEFINED);
            return this.tool.execute((Command)cmd, (DomainObject)this.currentProgram);
        }
        if (this.currentLocation instanceof FunctionNameFieldLocation) {
            FunctionNameFieldLocation functionNameLocation = (FunctionNameFieldLocation)this.currentLocation;
            String oldName = functionNameLocation.getFunctionName();
            RenameLabelCmd cmd = new RenameLabelCmd(address, oldName, labelName, SourceType.USER_DEFINED);
            return this.tool.execute((Command)cmd, (DomainObject)this.currentProgram);
        }
        if (this.currentLocation instanceof OperandFieldLocation) {
            return this.pasteOperandField((OperandFieldLocation)this.currentLocation, labelName);
        }
        return this.maybePasteNonLabelString(labelName);
    }

    private boolean pasteOperandField(OperandFieldLocation operandLocation, String labelName) {
        int opIndex = operandLocation.getOperandIndex();
        Listing listing = this.currentProgram.getListing();
        Instruction instruction = listing.getInstructionAt(operandLocation.getAddress());
        if (instruction == null) {
            return false;
        }
        Reference reference = instruction.getPrimaryReference(opIndex);
        if (reference == null) {
            return false;
        }
        Variable var = this.currentProgram.getReferenceManager().getReferencedVariable(reference);
        if (var != null) {
            SetVariableNameCmd cmd = new SetVariableNameCmd(var, labelName, SourceType.USER_DEFINED);
            return this.tool.execute((Command)cmd, (DomainObject)this.currentProgram);
        }
        SymbolTable symbolTable = this.currentProgram.getSymbolTable();
        Symbol symbol = symbolTable.getSymbol(reference);
        if (symbol == null) {
            return false;
        }
        SymbolType type = symbol.getSymbolType();
        if (type == SymbolType.LABEL || type == SymbolType.FUNCTION) {
            RenameLabelCmd cmd = new RenameLabelCmd(symbol, labelName, SourceType.USER_DEFINED);
            return this.tool.execute((Command)cmd, (DomainObject)this.currentProgram);
        }
        return this.maybePasteNonLabelString(labelName);
    }

    private boolean pasteNonLabelString(Transferable pasteData) throws UnsupportedFlavorException, IOException {
        String text = (String)pasteData.getTransferData(NonLabelStringTransferable.nonLabelStringFlavor);
        return this.maybePasteNonLabelString(text);
    }

    private boolean maybePasteNonLabelString(String string) {
        if (this.currentLocation instanceof CommentFieldLocation) {
            CommentFieldLocation commentFieldLocation = (CommentFieldLocation)this.currentLocation;
            Address address = commentFieldLocation.getAddress();
            CommentType commentType = commentFieldLocation.getCommentType();
            if (commentType != null) {
                SetCommentCmd cmd = new SetCommentCmd(address, commentType, string);
                return this.tool.execute((Command)cmd, (DomainObject)this.currentProgram);
            }
        }
        return false;
    }

    private void getCodeUnitInfo(AddressSetView set, Address startAddr, List<CodeUnitInfo> list, boolean copyLabels, boolean copyComments, TaskMonitor monitor) {
        HashMap<Address, CodeUnitInfo> map = new HashMap<Address, CodeUnitInfo>();
        if (copyLabels) {
            this.getFunctions(startAddr, set, list, map, monitor);
            this.getLabels(startAddr, set, list, map, monitor);
        }
        if (copyComments) {
            this.getComments(startAddr, set, list, map, monitor);
        }
    }

    private void getFunctions(Address startAddr, AddressSetView set, List<CodeUnitInfo> list, Map<Address, CodeUnitInfo> map, TaskMonitor monitor) {
        FunctionIterator it = this.currentProgram.getListing().getFunctions(set, true);
        while (it.hasNext() && !monitor.isCancelled()) {
            Function function = (Function)it.next();
            Address entry = function.getEntryPoint();
            CodeUnitInfo info = this.getInfoFromMap(list, map, entry, startAddr);
            info.setFunction(function);
        }
    }

    private void getComments(Address startAddr, AddressSetView set, List<CodeUnitInfo> list, Map<Address, CodeUnitInfo> map, TaskMonitor monitor) {
        Listing listing = this.currentProgram.getListing();
        CodeUnitIterator it = listing.getCodeUnitIterator("COMMENT__GHIDRA_", set, true);
        while (it.hasNext() && !monitor.isCancelled()) {
            CodeUnit cu = it.next();
            Address minAddress = cu.getMinAddress();
            CodeUnitInfo info = this.getInfoFromMap(list, map, minAddress, startAddr);
            this.setCommentInfo(cu, info);
        }
    }

    private void setCommentInfo(CodeUnit cu, CodeUnitInfo info) {
        for (CommentType type : CommentType.values()) {
            String[] comments = cu.getCommentAsArray(type);
            if (comments == null || comments.length <= 0) continue;
            info.setComment(type, comments);
        }
    }

    private void getLabels(Address startAddr, AddressSetView set, List<CodeUnitInfo> list, Map<Address, CodeUnitInfo> map, TaskMonitor monitor) {
        SymbolIterator it = this.currentProgram.getSymbolTable().getPrimarySymbolIterator(set, true);
        while (it.hasNext() && !monitor.isCancelled()) {
            Symbol symbol = it.next();
            Address minAddress = symbol.getAddress();
            Symbol[] symbols = this.currentProgram.getSymbolTable().getSymbols(minAddress);
            CodeUnitInfo info = this.getInfoFromMap(list, map, minAddress, startAddr);
            info.setSymbols(symbols);
        }
    }

    private CodeUnitInfo getInfoFromMap(List<CodeUnitInfo> list, Map<Address, CodeUnitInfo> map, Address minAddress, Address startAddr) {
        CodeUnitInfo info = map.get(minAddress);
        if (info == null) {
            long index = minAddress.subtract(startAddr);
            info = new CodeUnitInfo((int)index);
            map.put(minAddress, info);
            list.add(info);
        }
        return info;
    }

    @Override
    public boolean isValidContext(ActionContext context) {
        if (!(context instanceof CodeViewerActionContext)) {
            return false;
        }
        return context.getComponentProvider() == this.componentProvider;
    }

    @Override
    public ComponentProvider getComponentProvider() {
        return this.componentProvider;
    }

    @Override
    public boolean enableCopy() {
        return true;
    }

    @Override
    public boolean enableCopySpecial() {
        return true;
    }

    @Override
    public boolean canCopy() {
        return this.copyFromSelectionEnabled || this.stringContent != null || this.canCopyCurrentLocationWithNoSelection();
    }

    @Override
    public boolean canCopySpecial() {
        return this.currentLocation != null;
    }

    private boolean canCopyCurrentLocationWithNoSelection() {
        if (this.currentLocation instanceof AddressFieldLocation) {
            return true;
        }
        if (this.currentLocation instanceof LabelFieldLocation) {
            return true;
        }
        if (this.currentLocation instanceof FunctionNameFieldLocation) {
            return true;
        }
        if (this.currentLocation instanceof CommentFieldLocation) {
            return true;
        }
        if (this.currentLocation instanceof BytesFieldLocation) {
            return true;
        }
        if (this.currentLocation instanceof OperandFieldLocation) {
            return true;
        }
        if (this.currentLocation instanceof MnemonicFieldLocation) {
            return true;
        }
        return this.currentLocation instanceof VariableLocation;
    }

    @Override
    public boolean enablePaste() {
        return true;
    }

    @Override
    public boolean canPaste(DataFlavor[] availableFlavors) {
        if (availableFlavors != null) {
            for (DataFlavor flavor : availableFlavors) {
                if (flavor.equals(LABELS_COMMENTS_TYPE.getFlavor()) || flavor.equals(LABELS_TYPE.getFlavor()) || flavor.equals(COMMENTS_TYPE.getFlavor()) || flavor.equals(BYTE_STRING_TYPE.getFlavor()) || flavor.equals(LabelStringTransferable.labelStringFlavor) || flavor.equals(NonLabelStringTransferable.nonLabelStringFlavor)) {
                    return true;
                }
                if (!flavor.equals(DataFlavor.stringFlavor)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void lostOwnership(Transferable transferable) {
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) throws OptionsVetoException {
        if (optionName.equals("Copy Strings Without Quotes")) {
            this.includeQuotesForStringData = !options.getBoolean("Copy Strings Without Quotes", false);
        }
    }

    private static class LabelStringTransferable
    extends StringTransferable {
        public static final DataFlavor labelStringFlavor = new GenericDataFlavor("application/x-java-jvm-local-objectref; class=java.lang.String", "Local label as string object");
        private final DataFlavor[] flavors = new DataFlavor[]{labelStringFlavor, DataFlavor.stringFlavor};
        private final List<DataFlavor> flavorList = Arrays.asList(this.flavors);

        LabelStringTransferable(String name) {
            super(name);
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(labelStringFlavor)) {
                return this.data;
            }
            if (flavor.equals(DataFlavor.stringFlavor)) {
                return this.data;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        public DataFlavor[] getTransferDataFlavors() {
            return this.flavors;
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return this.flavorList.contains(flavor);
        }
    }

    private static class NonLabelStringTransferable
    extends StringTransferable {
        public static final DataFlavor nonLabelStringFlavor = new GenericDataFlavor("application/x-java-jvm-local-objectref; class=java.lang.String", "Local non-label as string object");
        private final DataFlavor[] flavors = new DataFlavor[]{nonLabelStringFlavor, DataFlavor.stringFlavor};
        private final List<DataFlavor> flavorList = Arrays.asList(this.flavors);

        NonLabelStringTransferable(String[] text) {
            super(NonLabelStringTransferable.combine(text));
        }

        private static String combine(String[] text) {
            StringBuilder buildy = new StringBuilder();
            for (String string : text) {
                if (buildy.length() > 0) {
                    buildy.append('\n');
                }
                buildy.append(string);
            }
            return buildy.toString();
        }

        NonLabelStringTransferable(String text) {
            super(text);
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(nonLabelStringFlavor)) {
                return this.data;
            }
            if (flavor.equals(DataFlavor.stringFlavor)) {
                return this.data;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        public DataFlavor[] getTransferDataFlavors() {
            return this.flavors;
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return this.flavorList.contains(flavor);
        }
    }
}

