/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.om.AnimationShorthandBuilder;
import io.sf.carte.doc.style.css.om.BackgroundBuilder;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.BorderBuilder;
import io.sf.carte.doc.style.css.om.BorderImageBuilder;
import io.sf.carte.doc.style.css.om.BorderRadiusBuilder;
import io.sf.carte.doc.style.css.om.FlexShorthandBuilder;
import io.sf.carte.doc.style.css.om.FontBuilder;
import io.sf.carte.doc.style.css.om.FontVariantBuilder;
import io.sf.carte.doc.style.css.om.GenericShorthandBuilder;
import io.sf.carte.doc.style.css.om.GridAreaShorthandBuilder;
import io.sf.carte.doc.style.css.om.GridPlacementShorthandBuilder;
import io.sf.carte.doc.style.css.om.GridShorthandBuilder;
import io.sf.carte.doc.style.css.om.ListStyleShorthandBuilder;
import io.sf.carte.doc.style.css.om.MarginBuilder;
import io.sf.carte.doc.style.css.om.MaskBuilder;
import io.sf.carte.doc.style.css.om.OrderedTwoValueShorthandBuilder;
import io.sf.carte.doc.style.css.om.OutlineShorthandBuilder;
import io.sf.carte.doc.style.css.om.PaddingBuilder;
import io.sf.carte.doc.style.css.om.SequenceShorthandBuilder;
import io.sf.carte.doc.style.css.om.ShorthandBuilder;
import io.sf.carte.doc.style.css.om.ShorthandBuilderFactory;
import io.sf.carte.doc.style.css.om.TransitionShorthandBuilder;
import java.util.HashMap;

class ShorthandBuilders {
    private static final HashMap<String, ShorthandBuilderFactory> factories = ShorthandBuilders.createFactoryMap();
    private static final ShorthandBuilders instance = new ShorthandBuilders();

    private ShorthandBuilders() {
    }

    private static HashMap<String, ShorthandBuilderFactory> createFactoryMap() {
        HashMap<String, ShorthandBuilderFactory> factoryMap = new HashMap<String, ShorthandBuilderFactory>(34);
        factoryMap.put("animation", new ShorthandBuilderFactory(){

            @Override
            public ShorthandBuilder createBuilder(BaseCSSStyleDeclaration style, String shorthand) {
                return new AnimationShorthandBuilder(style);
            }
        });
        factoryMap.put("background", new ShorthandBuilderFactory(){

            @Override
            public ShorthandBuilder createBuilder(BaseCSSStyleDeclaration style, String shorthand) {
                return new BackgroundBuilder(style);
            }
        });
        factoryMap.put("border", new ShorthandBuilderFactory(){

            @Override
            public ShorthandBuilder createBuilder(BaseCSSStyleDeclaration style, String shorthand) {
                return new BorderBuilder(style);
            }
        });
        factoryMap.put("border-image", new ShorthandBuilderFactory(){

            @Override
            public ShorthandBuilder createBuilder(BaseCSSStyleDeclaration style, String shorthand) {
                return new BorderImageBuilder(style);
            }
        });
        factoryMap.put("border-radius", new ShorthandBuilderFactory(){

            @Override
            public ShorthandBuilder createBuilder(BaseCSSStyleDeclaration style, String shorthand) {
                return new BorderRadiusBuilder(style);
            }
        });
        factoryMap.put("columns", new ShorthandBuilderFactory(){

            @Override
            public ShorthandBuilder createBuilder(BaseCSSStyleDeclaration style, String shorthand) {
                return new GenericShorthandBuilder(shorthand, style, "auto");
            }
        });
        ShorthandBuilderFactory generic = new ShorthandBuilderFactory(){

            @Override
            public ShorthandBuilder createBuilder(BaseCSSStyleDeclaration style, String shorthand) {
                return new GenericShorthandBuilder(shorthand, style, "none");
            }
        };
        factoryMap.put("column-rule", generic);
        factoryMap.put("text-decoration", generic);
        factoryMap.put("text-emphasis", generic);
        factoryMap.put("outline", new ShorthandBuilderFactory(){

            @Override
            public ShorthandBuilder createBuilder(BaseCSSStyleDeclaration style, String shorthand) {
                return new OutlineShorthandBuilder(style);
            }
        });
        factoryMap.put("flex", new ShorthandBuilderFactory(){

            @Override
            public ShorthandBuilder createBuilder(BaseCSSStyleDeclaration style, String shorthand) {
                return new FlexShorthandBuilder(style);
            }
        });
        factoryMap.put("flex-flow", new ShorthandBuilderFactory(){

            @Override
            public ShorthandBuilder createBuilder(BaseCSSStyleDeclaration style, String shorthand) {
                return new GenericShorthandBuilder(shorthand, style, "row");
            }
        });
        factoryMap.put("font", new ShorthandBuilderFactory(){

            @Override
            public ShorthandBuilder createBuilder(BaseCSSStyleDeclaration style, String shorthand) {
                return new FontBuilder(style);
            }
        });
        factoryMap.put("font-variant", new ShorthandBuilderFactory(){

            @Override
            public ShorthandBuilder createBuilder(BaseCSSStyleDeclaration style, String shorthand) {
                return new FontVariantBuilder(style);
            }
        });
        ShorthandBuilderFactory gridPlacement = new ShorthandBuilderFactory(){

            @Override
            public ShorthandBuilder createBuilder(BaseCSSStyleDeclaration style, String shorthand) {
                return new GridPlacementShorthandBuilder(shorthand, style);
            }
        };
        factoryMap.put("grid-column", gridPlacement);
        factoryMap.put("grid-row", gridPlacement);
        factoryMap.put("grid-area", new ShorthandBuilderFactory(){

            @Override
            public ShorthandBuilder createBuilder(BaseCSSStyleDeclaration style, String shorthand) {
                return new GridAreaShorthandBuilder(style);
            }
        });
        ShorthandBuilderFactory grid = new ShorthandBuilderFactory(){

            @Override
            public ShorthandBuilder createBuilder(BaseCSSStyleDeclaration style, String shorthand) {
                return new GridShorthandBuilder(style);
            }
        };
        factoryMap.put("grid", grid);
        factoryMap.put("grid-template", grid);
        factoryMap.put("list-style", new ShorthandBuilderFactory(){

            @Override
            public ShorthandBuilder createBuilder(BaseCSSStyleDeclaration style, String shorthand) {
                return new ListStyleShorthandBuilder(style);
            }
        });
        factoryMap.put("mask", new ShorthandBuilderFactory(){

            @Override
            public ShorthandBuilder createBuilder(BaseCSSStyleDeclaration style, String shorthand) {
                return new MaskBuilder(style);
            }
        });
        ShorthandBuilderFactory orderedTwoNormal = new ShorthandBuilderFactory(){

            @Override
            public ShorthandBuilder createBuilder(BaseCSSStyleDeclaration style, String shorthand) {
                return new OrderedTwoValueShorthandBuilder(shorthand, style, "normal");
            }
        };
        factoryMap.put("place-content", orderedTwoNormal);
        factoryMap.put("place-items", orderedTwoNormal);
        factoryMap.put("place-self", orderedTwoNormal);
        factoryMap.put("gap", orderedTwoNormal);
        factoryMap.put("margin", new ShorthandBuilderFactory(){

            @Override
            public ShorthandBuilder createBuilder(BaseCSSStyleDeclaration style, String shorthand) {
                return new MarginBuilder(style);
            }
        });
        factoryMap.put("padding", new ShorthandBuilderFactory(){

            @Override
            public ShorthandBuilder createBuilder(BaseCSSStyleDeclaration style, String shorthand) {
                return new PaddingBuilder(style);
            }
        });
        ShorthandBuilderFactory orderedTwoZero = new ShorthandBuilderFactory(){

            @Override
            public ShorthandBuilder createBuilder(BaseCSSStyleDeclaration style, String shorthand) {
                return new OrderedTwoValueShorthandBuilder(shorthand, style, "0");
            }
        };
        factoryMap.put("margin-inline", orderedTwoZero);
        factoryMap.put("padding-inline", orderedTwoZero);
        factoryMap.put("transition", new ShorthandBuilderFactory(){

            @Override
            public ShorthandBuilder createBuilder(BaseCSSStyleDeclaration style, String shorthand) {
                return new TransitionShorthandBuilder(style);
            }
        });
        ShorthandBuilderFactory sequence = new ShorthandBuilderFactory(){

            @Override
            public ShorthandBuilder createBuilder(BaseCSSStyleDeclaration style, String shorthand) {
                return new SequenceShorthandBuilder(shorthand, style);
            }
        };
        factoryMap.put("cue", sequence);
        factoryMap.put("pause", sequence);
        factoryMap.put("rest", sequence);
        return factoryMap;
    }

    public static ShorthandBuilders getInstance() {
        return instance;
    }

    public ShorthandBuilderFactory get(String shorthandPropertyName) {
        return factories.get(shorthandPropertyName);
    }
}

