import { jsx as _jsx } from "react/jsx-runtime";
/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { render } from '../../test-utils/render.js';
import { ShowMoreLines } from './ShowMoreLines.js';
import { describe, it, expect, vi, beforeEach } from 'vitest';
import { useOverflowState } from '../contexts/OverflowContext.js';
import { useStreamingContext } from '../contexts/StreamingContext.js';
import { useAlternateBuffer } from '../hooks/useAlternateBuffer.js';
import { StreamingState } from '../types.js';
vi.mock('../contexts/OverflowContext.js');
vi.mock('../contexts/StreamingContext.js');
vi.mock('../hooks/useAlternateBuffer.js');
describe('ShowMoreLines', () => {
    const mockUseOverflowState = vi.mocked(useOverflowState);
    const mockUseStreamingContext = vi.mocked(useStreamingContext);
    const mockUseAlternateBuffer = vi.mocked(useAlternateBuffer);
    beforeEach(() => {
        vi.clearAllMocks();
        mockUseAlternateBuffer.mockReturnValue(false);
    });
    it.each([
        [new Set(), StreamingState.Idle, true], // No overflow
        [new Set(['1']), StreamingState.Idle, false], // Not constraining height
        [new Set(['1']), StreamingState.Responding, true], // Streaming
    ])('renders nothing when: overflow=%s, streaming=%s, constrain=%s', (overflowingIds, streamingState, constrainHeight) => {
        mockUseOverflowState.mockReturnValue({ overflowingIds });
        mockUseStreamingContext.mockReturnValue(streamingState);
        const { lastFrame } = render(_jsx(ShowMoreLines, { constrainHeight: constrainHeight }));
        expect(lastFrame()).toBe('');
    });
    it.each([[StreamingState.Idle], [StreamingState.WaitingForConfirmation]])('renders message when overflowing and state is %s', (streamingState) => {
        mockUseOverflowState.mockReturnValue({
            overflowingIds: new Set(['1']),
        });
        mockUseStreamingContext.mockReturnValue(streamingState);
        const { lastFrame } = render(_jsx(ShowMoreLines, { constrainHeight: true }));
        expect(lastFrame()).toContain('Press ctrl-o to show more lines');
    });
});
//# sourceMappingURL=ShowMoreLines.test.js.map