/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver.catalog.entry;

import java.net.URI;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import org.xml.sax.Locator;
import org.xmlresolver.ResolverConfiguration;
import org.xmlresolver.catalog.entry.Entry;
import org.xmlresolver.catalog.entry.EntryDelegatePublic;
import org.xmlresolver.catalog.entry.EntryDelegateSystem;
import org.xmlresolver.catalog.entry.EntryDelegateUri;
import org.xmlresolver.catalog.entry.EntryDoctype;
import org.xmlresolver.catalog.entry.EntryDocument;
import org.xmlresolver.catalog.entry.EntryDtddecl;
import org.xmlresolver.catalog.entry.EntryEntity;
import org.xmlresolver.catalog.entry.EntryGroup;
import org.xmlresolver.catalog.entry.EntryLinktype;
import org.xmlresolver.catalog.entry.EntryNextCatalog;
import org.xmlresolver.catalog.entry.EntryNotation;
import org.xmlresolver.catalog.entry.EntryPublic;
import org.xmlresolver.catalog.entry.EntryRewriteSystem;
import org.xmlresolver.catalog.entry.EntryRewriteUri;
import org.xmlresolver.catalog.entry.EntrySgmldecl;
import org.xmlresolver.catalog.entry.EntrySystem;
import org.xmlresolver.catalog.entry.EntrySystemSuffix;
import org.xmlresolver.catalog.entry.EntryUri;
import org.xmlresolver.catalog.entry.EntryUriSuffix;

public class EntryCatalog
extends Entry {
    public final boolean preferPublic;
    protected static final ArrayList<Entry> none = new ArrayList();
    protected final ArrayList<Entry> entries = new ArrayList();
    protected final HashMap<Entry.Type, ArrayList<Entry>> typedEntries = new HashMap();
    protected Locator locator = null;

    public EntryCatalog(ResolverConfiguration config, URI baseURI, String id, boolean prefer) {
        super(config, baseURI, id);
        this.preferPublic = prefer;
    }

    @Override
    public Entry.Type getType() {
        return Entry.Type.CATALOG;
    }

    public synchronized List<Entry> entries() {
        return this.entries;
    }

    public synchronized List<Entry> entries(Entry.Type type) {
        return this.typedEntries.getOrDefault((Object)type, none);
    }

    protected synchronized void add(Entry entry) {
        this.entries.add(entry);
        if (!this.typedEntries.containsKey((Object)entry.getType())) {
            this.typedEntries.put(entry.getType(), new ArrayList());
        }
        this.typedEntries.get((Object)entry.getType()).add(entry);
    }

    protected synchronized void remove(Entry entry) {
        this.entries.remove(entry);
        if (this.typedEntries.containsKey((Object)entry.getType())) {
            this.typedEntries.get((Object)entry.getType()).remove(entry);
        }
    }

    public void setLocator(Locator locator) {
        this.locator = locator;
    }

    protected void error(String message, Object ... params) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.baseURI);
        if (this.locator != null && this.locator.getLineNumber() > 0) {
            sb.append(":");
            sb.append(this.locator.getLineNumber());
            if (this.locator.getColumnNumber() > 0) {
                sb.append(":");
                sb.append(this.locator.getColumnNumber());
            }
        }
        sb.append(":");
        Formatter formatter = new Formatter(sb);
        formatter.format(message, params);
        this.logger.log("error", sb.toString(), new Object[0]);
    }

    public EntryGroup addGroup(URI baseURI, String id, boolean prefer) {
        EntryGroup entry = new EntryGroup(this.config, baseURI, id, prefer);
        this.add(entry);
        return entry;
    }

    public EntryPublic addPublic(URI baseURI, String id, String publicId, String uri, boolean prefer) {
        EntryPublic entry = null;
        if (publicId != null && uri != null) {
            entry = new EntryPublic(this.config, baseURI, id, publicId, uri, prefer);
            this.add(entry);
        } else {
            this.error("Invalid public entry (missing publicId or uri attribute)", new Object[0]);
        }
        return entry;
    }

    public EntrySystem addSystem(URI baseURI, String id, String systemId, String uri) {
        EntrySystem entry = null;
        if (systemId != null && uri != null) {
            entry = new EntrySystem(this.config, baseURI, id, systemId, uri);
            this.add(entry);
        } else {
            this.error("Invalid system entry (missing systemId or uri attribute)", new Object[0]);
        }
        return entry;
    }

    public EntrySystemSuffix addSystemSuffix(URI baseURI, String id, String suffix, String uri) {
        EntrySystemSuffix entry = null;
        if (suffix != null && uri != null) {
            entry = new EntrySystemSuffix(this.config, baseURI, id, suffix, uri);
            this.add(entry);
        } else {
            this.error("Invalid systemSuffix entry (missing systemIdSuffix or uri attribute)", new Object[0]);
        }
        return entry;
    }

    public EntryRewriteSystem addRewriteSystem(URI baseURI, String id, String startString, String prefix) {
        EntryRewriteSystem entry = null;
        if (startString != null && prefix != null) {
            entry = new EntryRewriteSystem(this.config, baseURI, id, startString, prefix);
            this.add(entry);
        } else {
            this.error("Invalid rewriteSystem entry (missing systemIdStartString or prefix attribute)", new Object[0]);
        }
        return entry;
    }

    public EntryDelegateSystem addDelegateSystem(URI baseURI, String id, String startString, String catalog) {
        EntryDelegateSystem entry = null;
        if (startString != null && catalog != null) {
            entry = new EntryDelegateSystem(this.config, baseURI, id, startString, catalog);
            this.add(entry);
        } else {
            this.error("Invalid delegateSystem entry (missing systemIdStartString or catalog attribute)", new Object[0]);
        }
        return entry;
    }

    public EntryDelegatePublic addDelegatePublic(URI baseURI, String id, String startString, String catalog, boolean prefer) {
        EntryDelegatePublic entry = null;
        if (startString != null && catalog != null) {
            entry = new EntryDelegatePublic(this.config, baseURI, id, startString, catalog, prefer);
            this.add(entry);
        } else {
            this.error("Invalid delegatePublic entry (missing publicIdStartString or catalog attribute)", new Object[0]);
        }
        return entry;
    }

    public EntryUri addUri(URI baseURI, String id, String name, String uri, String nature, String purpose) {
        EntryUri entry = null;
        if (name != null && uri != null) {
            entry = new EntryUri(this.config, baseURI, id, name, uri, nature, purpose);
            this.add(entry);
        } else {
            this.error("Invalid uri entry (missing name or uri attribute)", new Object[0]);
        }
        return entry;
    }

    public EntryRewriteUri addRewriteUri(URI baseURI, String id, String start, String prefix) {
        EntryRewriteUri entry = null;
        if (start != null && prefix != null) {
            entry = new EntryRewriteUri(this.config, baseURI, id, start, prefix);
            this.add(entry);
        } else {
            this.error("Invalid rewriteURI entry (missing uriStartString or prefix attribute)", new Object[0]);
        }
        return entry;
    }

    public EntryUriSuffix addUriSuffix(URI baseURI, String id, String suffix, String uri) {
        EntryUriSuffix entry = null;
        if (suffix != null && uri != null) {
            entry = new EntryUriSuffix(this.config, baseURI, id, suffix, uri);
            this.add(entry);
        } else {
            this.error("Invalid uriSuffix entry (missing uriStartString or uri attribute)", new Object[0]);
        }
        return entry;
    }

    public EntryDelegateUri addDelegateUri(URI baseURI, String id, String startString, String catalog) {
        EntryDelegateUri entry = null;
        if (startString != null && catalog != null) {
            entry = new EntryDelegateUri(this.config, baseURI, id, startString, catalog);
            this.add(entry);
        } else {
            this.error("Invalid delegateURI entry (missing uriStartString or catalog attribute)", new Object[0]);
        }
        return entry;
    }

    public EntryNextCatalog addNextCatalog(URI baseURI, String id, String catalog) {
        EntryNextCatalog entry = null;
        if (catalog != null) {
            entry = new EntryNextCatalog(this.config, baseURI, id, catalog);
            this.add(entry);
        } else {
            this.error("Invalid nextCatalog entry (missing catalog attribute)", new Object[0]);
        }
        return entry;
    }

    public EntryDoctype addDoctype(URI baseURI, String id, String name, String uri) {
        EntryDoctype entry = null;
        if (name != null && uri != null) {
            entry = new EntryDoctype(this.config, baseURI, id, name, uri);
            this.add(entry);
        } else {
            this.error("Invalid doctype entry (missing name or uri attribute)", new Object[0]);
        }
        return entry;
    }

    public EntryDocument addDocument(URI baseURI, String id, String uri) {
        EntryDocument entry = null;
        if (uri != null) {
            entry = new EntryDocument(this.config, baseURI, id, uri);
            this.add(entry);
        } else {
            this.error("Invalid document entry (missing uri attribute)", new Object[0]);
        }
        return entry;
    }

    public EntryDtddecl addDtdDecl(URI baseURI, String id, String publicId, String uri) {
        EntryDtddecl entry = null;
        if (publicId != null && uri != null) {
            entry = new EntryDtddecl(this.config, baseURI, id, publicId, uri);
            this.add(entry);
        } else {
            this.error("Invalid dtddecl entry (missing publicId or uri attribute)", new Object[0]);
        }
        return entry;
    }

    public EntryEntity addEntity(URI baseURI, String id, String name, String uri) {
        EntryEntity entry = null;
        if (name != null && uri != null) {
            entry = new EntryEntity(this.config, baseURI, id, name, uri);
            this.add(entry);
        } else {
            this.error("Invalid entity entry (missing name or uri attribute)", new Object[0]);
        }
        return entry;
    }

    public EntryLinktype addLinktype(URI baseURI, String id, String name, String uri) {
        EntryLinktype entry = null;
        if (name != null && uri != null) {
            entry = new EntryLinktype(this.config, baseURI, id, name, uri);
            this.add(entry);
        } else {
            this.error("Invalid linktype entry (missing name or uri attribute)", new Object[0]);
        }
        return entry;
    }

    public EntryNotation addNotation(URI baseURI, String id, String name, String uri) {
        EntryNotation entry = null;
        if (name != null && uri != null) {
            entry = new EntryNotation(this.config, baseURI, id, name, uri);
            this.add(entry);
        } else {
            this.error("Invalid notation entry (missing name or uri attribute)", new Object[0]);
        }
        return entry;
    }

    public EntrySgmldecl addSgmlDecl(URI baseURI, String id, String uri) {
        EntrySgmldecl entry = null;
        if (uri != null) {
            entry = new EntrySgmldecl(this.config, baseURI, id, uri);
            this.add(entry);
        } else {
            this.error("Invalid sgmldecl entry (uri attribute)", new Object[0]);
        }
        return entry;
    }

    public String toString() {
        return "catalog prefer=" + (this.preferPublic ? "public" : "system");
    }
}

