/*
 * Decompiled with CFR 0.152.
 */
package java.util.function;

import java.util.Comparator;
import java.util.Objects;
import java.util.function.BiFunction;

@FunctionalInterface
public interface BinaryOperator<T>
extends BiFunction<T, T, T> {
    public static <T> BinaryOperator<T> minBy(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator);
        return (object, object2) -> comparator.compare(object, object2) <= 0 ? object : object2;
    }

    public static <T> BinaryOperator<T> maxBy(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator);
        return (object, object2) -> comparator.compare(object, object2) >= 0 ? object : object2;
    }
}

