/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import sun.misc.DoubleConsts;
import sun.misc.FloatingDecimal;

public final class Double
extends Number
implements Comparable<Double> {
    public static final double POSITIVE_INFINITY = 1.0 / 0.0;
    public static final double NEGATIVE_INFINITY = -1.0 / 0.0;
    public static final double NaN = 0.0 / 0.0;
    public static final double MAX_VALUE = 1.7976931348623157E308;
    public static final double MIN_NORMAL = Double.longBitsToDouble(0x10000000000000L);
    public static final double MIN_VALUE = Double.longBitsToDouble(1L);
    public static final int MAX_EXPONENT = 1023;
    public static final int MIN_EXPONENT = -1022;
    public static final int SIZE = 64;
    public static final int BYTES = 8;
    public static final Class<Double> TYPE = Class.getPrimitiveClass("double");
    private final double value;
    private static final long serialVersionUID = -9172774392245257468L;

    public static String toString(double d) {
        return FloatingDecimal.toJavaFormatString(d);
    }

    public static String toHexString(double d) {
        if (!Double.isFinite(d)) {
            return Double.toString(d);
        }
        StringBuilder stringBuilder = new StringBuilder(24);
        if (Math.copySign(1.0, d) == -1.0) {
            stringBuilder.append("-");
        }
        stringBuilder.append("0x");
        d = Math.abs(d);
        if (d == 0.0) {
            stringBuilder.append("0.0p0");
        } else {
            boolean bl = d < DoubleConsts.MIN_NORMAL;
            long l = Double.doubleToLongBits(d) & 0xFFFFFFFFFFFFFL | 0x1000000000000000L;
            stringBuilder.append(bl ? "0." : "1.");
            String string = Long.toHexString(l).substring(3, 16);
            stringBuilder.append(string.equals("0000000000000") ? "0" : string.replaceFirst("0{1,12}$", ""));
            stringBuilder.append('p');
            stringBuilder.append(bl ? -1022 : Math.getExponent(d));
        }
        return stringBuilder.toString();
    }

    public static Double valueOf(String string) throws NumberFormatException {
        return new Double(Double.parseDouble(string));
    }

    public static Double valueOf(double d) {
        return new Double(d);
    }

    public static double parseDouble(String string) throws NumberFormatException {
        return FloatingDecimal.parseDouble(string);
    }

    public static boolean isNaN(double d) {
        return d != d;
    }

    public static boolean isInfinite(double d) {
        return d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY;
    }

    public static boolean isFinite(double d) {
        return Math.abs(d) <= Double.MAX_VALUE;
    }

    public Double(double d) {
        this.value = d;
    }

    public Double(String string) throws NumberFormatException {
        this.value = Double.parseDouble(string);
    }

    public boolean isNaN() {
        return Double.isNaN(this.value);
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.value);
    }

    public String toString() {
        return Double.toString(this.value);
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public int hashCode() {
        return Double.hashCode(this.value);
    }

    public static int hashCode(double d) {
        long l = Double.doubleToLongBits(d);
        return (int)(l ^ l >>> 32);
    }

    public boolean equals(Object object) {
        return object instanceof Double && Double.doubleToLongBits(((Double)object).value) == Double.doubleToLongBits(this.value);
    }

    public static long doubleToLongBits(double d) {
        long l = Double.doubleToRawLongBits(d);
        if ((l & 0x7FF0000000000000L) == 0x7FF0000000000000L && (l & 0xFFFFFFFFFFFFFL) != 0L) {
            l = 9221120237041090560L;
        }
        return l;
    }

    public static native long doubleToRawLongBits(double var0);

    public static native double longBitsToDouble(long var0);

    @Override
    public int compareTo(Double d) {
        return Double.compare(this.value, d.value);
    }

    public static int compare(double d, double d2) {
        long l;
        if (d < d2) {
            return -1;
        }
        if (d > d2) {
            return 1;
        }
        long l2 = Double.doubleToLongBits(d);
        return l2 == (l = Double.doubleToLongBits(d2)) ? 0 : (l2 < l ? -1 : 1);
    }

    public static double sum(double d, double d2) {
        return d + d2;
    }

    public static double max(double d, double d2) {
        return Math.max(d, d2);
    }

    public static double min(double d, double d2) {
        return Math.min(d, d2);
    }
}

