<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\YouTube;

class CommentThread extends \Google\Model
{
  public $etag;
  public $id;
  public $kind;
  protected $repliesType = CommentThreadReplies::class;
  protected $repliesDataType = '';
  protected $snippetType = CommentThreadSnippet::class;
  protected $snippetDataType = '';

  public function setEtag($etag)
  {
    $this->etag = $etag;
  }
  public function getEtag()
  {
    return $this->etag;
  }
  public function setId($id)
  {
    $this->id = $id;
  }
  public function getId()
  {
    return $this->id;
  }
  public function setKind($kind)
  {
    $this->kind = $kind;
  }
  public function getKind()
  {
    return $this->kind;
  }
  /**
   * @param CommentThreadReplies
   */
  public function setReplies(CommentThreadReplies $replies)
  {
    $this->replies = $replies;
  }
  /**
   * @return CommentThreadReplies
   */
  public function getReplies()
  {
    return $this->replies;
  }
  /**
   * @param CommentThreadSnippet
   */
  public function setSnippet(CommentThreadSnippet $snippet)
  {
    $this->snippet = $snippet;
  }
  /**
   * @return CommentThreadSnippet
   */
  public function getSnippet()
  {
    return $this->snippet;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(CommentThread::class, 'Google_Service_YouTube_CommentThread');
