<?php
// $Id: kakasi.php,v 1.2 2007/06/10 14:39:45 ohwada Exp $

//=========================================================
// Happy Linux Framework Module
// 2007-06-01 K.OHWADA
//=========================================================

//---------------------------------------------------------
// kanji kana simple inverter
// http://kakasi.namazu.org/
// kakasi [options] [jisyo1 [jisyo2 [jisyo1,,]]]
// -w: wkatigaki
// -c: read except for the blank and the line feed which is contained in the kanji phrase.
// -i{jis, oldjis, euc, dec, sjis}: charset
// The repartition of the character
// a: ASCII 
// j: JIS romaji
// g: DEC graphic
// k: katakana (GR repartition in JIS x0201)
// J: kanji
// H: hiragana
// K: kakatakan (in 5 repartition)
// E: kigouexcept the above)
//---------------------------------------------------------

class happy_linux_kakasi
{
	var $_kakasi_path = '/usr/local/bin/kakasi';
	var $_mode_excute = 0;	// file mode

	var $_encoding   = 'euc';
	var $_dicts      = array();

	var $_words     = '';
	var $_errors    = '';
	var $_cmd_error = '';

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function happy_linux_kakasi()
{
	$DIR_TMP   = '/tmp';
	$DIR_CACHE = XOOPS_ROOT_PATH.'/modules/happy_linux/cache';

// UNIX
	if ( is_dir( $DIR_TMP ) && is_writable( $DIR_TMP ) )
	{
		$dir_work = $DIR_TMP;
	}
// MS-Windows or othes
	else
	{
		$dir_work = $DIR_CACHE;
	}

	$this->set_dir_work( $dir_work );
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new happy_linux_kakasi();
	}
	return $instance;
}

//---------------------------------------------------------
// public
//---------------------------------------------------------
function execute(&$str, $opt)
{
	if ( !$this->is_executable_kakasi() )
	{	return false;	}

	if ( $this->_mode_excute )
	{
		return $this->execute_pipe($str, $opt);
	}

	return $this->execute_file($str, $opt);
}

// this method works well in MS-Windows
function execute_file(&$str, $opt)
{
	$this->_words     = '';
	$this->_errors    = '';
	$this->_cmd_error = '';

	$file_in  = tempnam($this->_dir_work, "kki");
	$file_out = tempnam($this->_dir_work, "kko");

	$cmd = $this->_kakasi_path.' '.$opt;

// set content
	$fp_in = fopen($file_in, "w");
	if ( !$fp_in )
	{
		$this->_cmd_error = 'cannot open file: '.$file_in;
		return false;
	}

	fwrite($fp_in, $str);
	fclose($fp_in);

// kakasi
	exec( "$cmd < $file_in > $file_out" );

// get parsing words
	$fp_out = fopen($file_out, "r");
	if ( !$fp_out )
	{
		$this->_cmd_error = 'cannot open file: '.$file_out;
		return false;
	}
	while ($w = fgets($fp_out) )
	{
		$this->_words .= $w."\n";
	}
	fclose($fp_out);

	unlink($file_in);
	unlink($file_out);

	return true;
}

// this method is more efficient than using file
// but, doesn't work in MS-Windows
function execute_pipe(&$str, $opt)
{
	$this->_words     = '';
	$this->_errors    = '';
	$this->_cmd_error = '';

	$cmd = $this->_kakasi_path.' '.$opt;

	$descriptorspec = array(
		0 => array("pipe", "r"),  // stdin
		1 => array("pipe", "w"),  // stdout
		2 => array("pipe", "w"),  // stderr
	);

	$pipes = array();

	$rp = proc_open($cmd, $descriptorspec, $pipes);
	if ( !is_resource($rp) )
	{
		$this->_cmd_error = 'cannot excute command: '.$opt;
		return false;
	}

// set content
	fwrite($pipes[0], $str);
	fclose($pipes[0]);

// get parsing words
	while ($w = fgets($pipes[1]) )
	{
		$this->_words .= $w."\n";
	}
	fclose($pipes[1]);

// get errors
	while ($w = fgets($pipes[2]) )
	{
		$this->_errors .= $w."\n";
	}
	fclose($pipes[2]);

	proc_close($rp);
	return true;
}

function is_executable_kakasi( $path=null )
{
	if ( empty($path) )
	{
		$path = $this->_kakasi_path;
	}

	if ( file_exists($path) )
	{
		if ( function_exists('is_executable') )
		{
			return is_executable($path);
		}
		else
		{
			return true;	// WIN or PHP 4
		}
	}
	return false;
}

function get_opt()
{
	$opt = $this->get_opt_encoding()." ".$this->get_opt_dicts();
	return $opt;
}

function get_opt_dicts()
{
	$opt = '';
	if ($this->_dicts)
	{
		$opt = " ".implode(", ",$this->_dicts);
	}
	return $opt;
}

function get_opt_encoding()
{
	$opt = '';
	if ($this->_encoding)
	{
		$opt = " -i".$this->_encoding;
	}
	return $opt;
}

//---------------------------------------------------------
// set and get property
//---------------------------------------------------------
function set_kakasi_path($val)
{
	$this->_kakasi_path = $val;
}

function set_mode_execute($val)
{
	$this->_mode_excute = intval($val);
}

function set_dir_work($value)
{
	$this->_dir_work = $value;
}

function get_words()
{
	return $this->_words;
}

function get_errors()
{
	return $this->_errors;
}

function get_cmd_error()
{
	return $this->_cmd_error;
}

// --- class end ---
}

?>