<?php
/**
 * @package user
 * @version $Id
 */

if (!defined('XOOPS_ROOT_PATH')) die();

class User_PrimaryFilter extends XCube_ActionFilter
{
	function preFilter()
	{
		$root =& XCube_Root::getSingleton();
		$root->mDelegateManager->add("Site.Login", "User_Login::login");

		$file = XOOPS_ROOT_PATH . "/modules/user/kernel/LegacypageFunctions.class.php";
		
		$root->mDelegateManager->add("Legacypage.Userinfo.Access", "User_LegacypageFunctions::userinfo", $file);
		$root->mDelegateManager->add("Legacypage.Edituser.Access", "User_LegacypageFunctions::edituser", $file);
		$root->mDelegateManager->add("Legacypage.Register.Access", "User_LegacypageFunctions::register", $file);
		$root->mDelegateManager->add("Legacypage.User.Access", "User_LegacypageFunctions::user", $file);
		$root->mDelegateManager->add("Legacypage.Lostpass.Access", "User_LegacypageFunctions::lostpass", $file);
		$root->mDelegateManager->add("Site.CheckLogin", "User_LegacypageFunctions::checkLogin", $file);
		$root->mDelegateManager->add("Site.CheckLogin.Success", "User_LegacypageFunctions::checkLoginSuccess", $file);
		$root->mDelegateManager->add("Site.Logout", "User_LegacypageFunctions::logout", $file);
		
		$root->mDelegateManager->add("Legacypage.Misc.Access", "User_LegacypageFunctions::misc", XCUBE_DELEGATE_PRIORITY_NORMAL - 5, $file);
	}
}

/**
 * This static class has a static member function for login process. Because
 * this process is always called, this class is always loaded. We may move this
 * class to other file. This file is a preload and no good for normal class
 * definition. 
 * 
 * @todo We may move this class to other file.
 */
class User_Login
{
	function login(&$xoopsUser)
	{
		if (is_object($xoopsUser)) {
			return;
		}
		
		if (!empty($_SESSION['xoopsUserId'])) {
			$memberHandler=xoops_gethandler('member');
			$user =& $memberHandler->getUser($_SESSION['xoopsUserId']);
			$xoopsUser = $user;
			if(!is_object($xoopsUser)) {
				$xoopsUser = null;
				$_SESSION = array();
			}
			else {
				$xoopsUser->setGroups($_SESSION['xoopsUserGroups']);
				
				//
				// Use 'mysession'
				//
				$root =& XCube_Root::getSingleton();
				$xoopsConfig = $root->mController->getConfig();
		
				if ($xoopsConfig['use_mysession'] && $xoopsConfig['session_name'] != '') {
					setcookie($xoopsConfig['session_name'], session_id(), time() + (60 * $xoopsConfig['session_expire']), '/', '', 0);
				}
			}
		}
	}
}

?>