<?php
/**
 * @package stdCache
 * @version $Id$
 */

if (!defined('XOOPS_ROOT_PATH')) exit();
 
class StdCache_Initialize extends XCube_ActionFilter
{
	function preBlockFilter()
	{
		$this->mController->mCheckEnableBlockCache->add(array(&$this, 'checkForBlock'), XCUBE_DELEGATE_PRIORITY_FIRST + 10);
		$this->mController->mCheckEnableModuleCache->add(array(&$this, 'checkForModule'), XCUBE_DELEGATE_PRIORITY_FIRST + 10);
	}
	
	function checkForBlock(&$cacheInfo)
	{
		$user =& $this->mController->mXoopsUser;
		if (is_object($user)) {
			$cacheInfo->mGroupArr = $user->getGroups();
			$cacheInfo->setEnableCache(!in_array(XOOPS_GROUP_ADMIN, $user->getGroups()));
		}
		else {
			$cacheInfo->mGroupArr = array(XOOPS_GROUP_ANONYMOUS);
			$cacheInfo->setEnableCache(true);
		}
	}

	function checkForModule(&$cacheInfo)
	{
		$user =& $this->mController->mXoopsUser;
		if (is_object($user)) {
			$cacheInfo->mGroupArr = $user->getGroups();
			$cacheInfo->setEnableCache(!in_array(XOOPS_GROUP_ADMIN, $user->getGroups()));
		}
		else {
			$cacheInfo->mGroupArr = array(XOOPS_GROUP_ANONYMOUS);
			$cacheInfo->setEnableCache(true);
		}
	}
}

?>