// Copyright (C) 2005-2006 Code Synthesis Tools CC
//
// This program was generated by XML Schema Definition Compiler (XSD)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
//
// In addition, as a special exception, Code Synthesis Tools CC gives
// permission to link this program with the Xerces-C++ library (or with
// modified versions of Xerces-C++ that use the same license as Xerces-C++),
// and distribute linked combinations including the two. You must obey
// the GNU General Public License version 2 in all respects for all of
// the code used other than Xerces-C++. If you modify this copy of the
// program, you may extend this exception to your version of the program,
// but you are not obligated to do so. If you do not wish to do so, delete
// this exception statement from your version.
//
// In addition, Code Synthesis Tools CC makes a special exception for
// the Free/Libre and Open Source Software (FLOSS) which is described
// in the accompanying FLOSSE file.
//

#ifndef PLS_PARSER_HXX
#define PLS_PARSER_HXX

#include <xsd/cxx/version.hxx>

#if (XSD_INT_VERSION != 2030051L)
#error XSD runtime version mismatch
#endif

// Begin prologue.
//
//
// End prologue.

#include <xsd/cxx/pre.hxx>

#include <xsd/cxx/tree/exceptions.hxx>
#include <xsd/cxx/tree/elements.hxx>
#include <xsd/cxx/tree/types.hxx>
#include <xsd/cxx/xml/error-handler.hxx>

namespace xml_schema
{
  namespace parser
  {
    // anyType and anySimpleType.
    //
    typedef ::xsd::cxx::tree::type type;
    typedef ::xsd::cxx::tree::simple_type<type> simple_type;

    // 8-bit
    //
    typedef signed char byte;
    typedef unsigned char unsigned_byte;

    // 16-bit
    //
    typedef short short_;
    typedef unsigned short unsigned_short;

    // 32-bit
    //
    typedef int int_;
    typedef unsigned int unsigned_int;

    // 64-bit
    //
    typedef long long long_;
    typedef unsigned long long unsigned_long;

    // Supposed to be arbitrary-length integral types.
    //
    typedef long long integer;
    typedef integer non_positive_integer;
    typedef integer non_negative_integer;
    typedef integer positive_integer;
    typedef integer negative_integer;

    // Boolean.
    //
    typedef bool boolean;

    // Floating-point types.
    //
    typedef float float_;
    typedef double double_;
    typedef long double decimal;

    // String types.
    //
    typedef ::xsd::cxx::tree::string< char, simple_type > string;
    typedef ::xsd::cxx::tree::normalized_string< char, string > normalized_string;
    typedef ::xsd::cxx::tree::token< char, normalized_string > token;
    typedef ::xsd::cxx::tree::name< char, token > name;
    typedef ::xsd::cxx::tree::nmtoken< char, token > nmtoken;
    typedef ::xsd::cxx::tree::nmtokens< char, simple_type, nmtoken> nmtokens;
    typedef ::xsd::cxx::tree::ncname< char, name > ncname;
    typedef ::xsd::cxx::tree::language< char, token > language;

    // ID/IDREF.
    //
    typedef ::xsd::cxx::tree::id< char, ncname > id;
    typedef ::xsd::cxx::tree::idref< type, char, ncname > idref;
    typedef ::xsd::cxx::tree::idrefs< char, simple_type, idref > idrefs;

    // URI.
    //
    typedef ::xsd::cxx::tree::uri< char, simple_type > uri;

    // Qualified name.
    //
    typedef ::xsd::cxx::tree::qname< char, simple_type, uri, ncname > qname;

    // Binary.
    //
    typedef ::xsd::cxx::tree::buffer< char > buffer;
    typedef ::xsd::cxx::tree::base64_binary< char, simple_type > base64_binary;
    typedef ::xsd::cxx::tree::hex_binary< char, simple_type > hex_binary;

    // Date/time.
    //
    typedef ::xsd::cxx::tree::date< char, simple_type > date;
    typedef ::xsd::cxx::tree::date_time< char, simple_type > date_time;
    typedef ::xsd::cxx::tree::duration< char, simple_type > duration;
    typedef ::xsd::cxx::tree::day< char, simple_type > day;
    typedef ::xsd::cxx::tree::month< char, simple_type > month;
    typedef ::xsd::cxx::tree::month_day< char, simple_type > month_day;
    typedef ::xsd::cxx::tree::year< char, simple_type > year;
    typedef ::xsd::cxx::tree::year_month< char, simple_type > year_month;
    typedef ::xsd::cxx::tree::time< char, simple_type > time;

    // Entity.
    //
    typedef ::xsd::cxx::tree::entity< char, ncname > entity;
    typedef ::xsd::cxx::tree::entities< char, simple_type, entity > entities;

    // Exceptions.
    //
    typedef ::xsd::cxx::tree::exception< char > exception;
    typedef ::xsd::cxx::tree::parsing< char > parsing;
    typedef ::xsd::cxx::tree::expected_element< char > expected_element;
    typedef ::xsd::cxx::tree::unexpected_element< char > unexpected_element;
    typedef ::xsd::cxx::tree::expected_attribute< char > expected_attribute;
    typedef ::xsd::cxx::tree::unexpected_enumerator< char > unexpected_enumerator;
    typedef ::xsd::cxx::tree::no_type_info< char > no_type_info;
    typedef ::xsd::cxx::tree::not_derived< char > not_derived;
    typedef ::xsd::cxx::tree::duplicate_id< char > duplicate_id;
    typedef ::xsd::cxx::tree::serialization< char > serialization;
    typedef ::xsd::cxx::tree::no_namespace_mapping< char > no_namespace_mapping;
    typedef ::xsd::cxx::tree::no_prefix_mapping< char > no_prefix_mapping;
    typedef ::xsd::cxx::tree::xsi_already_in_use< char > xsi_already_in_use;
    typedef ::xsd::cxx::tree::bounds< char > bounds;

    // Parsing/serialization error.
    //
    typedef ::xsd::cxx::tree::error< char > error;
    typedef ::xsd::cxx::tree::errors< char > errors;

    // Error handler interface.
    //
    typedef ::xsd::cxx::xml::error_handler< char > error_handler;

    // Flags and properties.
    //
    typedef ::xsd::cxx::tree::flags flags;
    typedef ::xsd::cxx::tree::properties< char > properties;

    // DOM user data key for back pointers to tree nodes.
    //
#ifndef XSD_CXX_TREE_TREE_NODE_KEY_IN___XML_SCHEMA__PARSER
#define XSD_CXX_TREE_TREE_NODE_KEY_IN___XML_SCHEMA__PARSER

    const XMLCh* const tree_node_key = ::xsd::cxx::tree::user_data_keys::node;

#endif
  }
}

// Forward declarations.
//
namespace pls
{
  namespace parser
  {
    class role_type;
    class lexicon;
    class alphabet;
    class meta;
    class metadata;
    class lexeme;
    class prefer;
    class phoneme;
    class alias;
    class version;
    class role;
    class alphabet1;
  }
}


#ifndef XSD_USE_CHAR
#define XSD_USE_CHAR
#endif

#ifndef XSD_CXX_TREE_USE_CHAR
#define XSD_CXX_TREE_USE_CHAR
#endif

#include <memory>    // std::auto_ptr
#include <algorithm> // std::binary_search

#include <xsd/cxx/tree/exceptions.hxx>
#include <xsd/cxx/tree/elements.hxx>
#include <xsd/cxx/tree/containers.hxx>
#include <xsd/cxx/tree/list.hxx>

#include "xml-parser.hxx"

namespace pls
{
  namespace parser
  {
    class role_type: public ::xml_schema::parser::simple_type, public ::xsd::cxx::tree::list< ::xml_schema::parser::qname, char >
    {
      public:
      role_type ();

      role_type (const ::xercesc::DOMElement&,
                 ::xml_schema::parser::flags = 0,
                 ::xml_schema::parser::type* = 0);

      role_type (const ::xercesc::DOMAttr&,
                 ::xml_schema::parser::flags = 0,
                 ::xml_schema::parser::type* = 0);

      role_type (const ::std::basic_string< char >&,
                 const ::xercesc::DOMElement*,
                 ::xml_schema::parser::flags = 0,
                 ::xml_schema::parser::type* = 0);

      role_type (const role_type&,
                 ::xml_schema::parser::flags = 0,
                 ::xml_schema::parser::type* = 0);

      virtual role_type*
      _clone (::xml_schema::parser::flags = 0,
              ::xml_schema::parser::type* = 0) const;
    };

    class lexicon: public ::xml_schema::parser::type
    {
      public:

      struct _xsd_lexicon
      {
        typedef ::xml_schema::parser::type base_;
      };

      // meta
      // 
      public:
      struct meta
      {
        typedef ::pls::parser::meta type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::sequence< type > container;
        typedef container::iterator iterator;
        typedef container::const_iterator const_iterator;
      };

      const meta::container&
      meta () const;

      meta::container&
      meta ();

      void
      meta (const meta::container&);

      // metadata
      // 
      public:
      struct metadata
      {
        typedef ::pls::parser::metadata type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const metadata::container&
      metadata () const;

      metadata::container&
      metadata ();

      void
      metadata (const metadata::type&);

      void
      metadata (const metadata::container&);

      void
      metadata (::std::auto_ptr< metadata::type >);

      // lexeme
      // 
      public:
      struct lexeme
      {
        typedef ::pls::parser::lexeme type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::sequence< type > container;
        typedef container::iterator iterator;
        typedef container::const_iterator const_iterator;
      };

      const lexeme::container&
      lexeme () const;

      lexeme::container&
      lexeme ();

      void
      lexeme (const lexeme::container&);

      // version
      // 
      public:
      struct version
      {
        typedef ::pls::parser::version type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const version::type&
      version () const;

      version::type&
      version ();

      void
      version (const version::type&);

      void
      version (::std::auto_ptr< version::type >);

      // base
      // 
      public:
      struct base
      {
        typedef ::xml_schema::parser::uri type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const base::container&
      base () const;

      base::container&
      base ();

      void
      base (const base::type&);

      void
      base (const base::container&);

      void
      base (::std::auto_ptr< base::type >);

      // lang
      // 
      public:
      struct lang
      {
        typedef ::namespace_::lang type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const lang::type&
      lang () const;

      lang::type&
      lang ();

      void
      lang (const lang::type&);

      void
      lang (::std::auto_ptr< lang::type >);

      // alphabet
      // 
      public:
      struct alphabet
      {
        typedef ::pls::parser::alphabet type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const alphabet::type&
      alphabet () const;

      alphabet::type&
      alphabet ();

      void
      alphabet (const alphabet::type&);

      void
      alphabet (::std::auto_ptr< alphabet::type >);

      // Constructors.
      //
      public:
      lexicon (const version::type&,
               const lang::type&,
               const alphabet::type&);

      lexicon (const ::xercesc::DOMElement&,
               ::xml_schema::parser::flags = 0,
               ::xml_schema::parser::type* = 0);

      lexicon (const lexicon&,
               ::xml_schema::parser::flags = 0,
               ::xml_schema::parser::type* = 0);

      virtual lexicon*
      _clone (::xml_schema::parser::flags = 0,
              ::xml_schema::parser::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::parser::flags);

      ::xsd::cxx::tree::sequence< meta::type > _xsd_meta_;
      ::xsd::cxx::tree::optional< metadata::type > _xsd_metadata_;
      ::xsd::cxx::tree::sequence< lexeme::type > _xsd_lexeme_;
      ::xsd::cxx::tree::one< version::type > _xsd_version_;
      ::xsd::cxx::tree::optional< base::type > _xsd_base_;
      ::xsd::cxx::tree::one< lang::type > _xsd_lang_;
      ::xsd::cxx::tree::one< alphabet::type > _xsd_alphabet_;
    };

    class alphabet: public ::xml_schema::parser::string
    {
      public:

      struct _xsd_alphabet
      {
        typedef ::xml_schema::parser::string base_;
      };

      // Constructors.
      //
      public:
      alphabet (const _xsd_alphabet::base_& );

      alphabet (const ::xercesc::DOMElement&,
                ::xml_schema::parser::flags = 0,
                ::xml_schema::parser::type* = 0);

      alphabet (const ::xercesc::DOMAttr&,
                ::xml_schema::parser::flags = 0,
                ::xml_schema::parser::type* = 0);

      alphabet (const ::std::basic_string< char >&,
                const ::xercesc::DOMElement*,
                ::xml_schema::parser::flags = 0,
                ::xml_schema::parser::type* = 0);

      alphabet (const alphabet&,
                ::xml_schema::parser::flags = 0,
                ::xml_schema::parser::type* = 0);

      virtual alphabet*
      _clone (::xml_schema::parser::flags = 0,
              ::xml_schema::parser::type* = 0) const;
    };

    class meta: public ::xml_schema::parser::type
    {
      public:

      struct _xsd_meta
      {
        typedef ::xml_schema::parser::type base_;
      };

      // name
      // 
      public:
      struct name
      {
        typedef ::xml_schema::parser::string type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const name::container&
      name () const;

      name::container&
      name ();

      void
      name (const name::type&);

      void
      name (const name::container&);

      void
      name (::std::auto_ptr< name::type >);

      // http-equiv
      // 
      public:
      struct http_equiv
      {
        typedef ::xml_schema::parser::string type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const http_equiv::container&
      http_equiv () const;

      http_equiv::container&
      http_equiv ();

      void
      http_equiv (const http_equiv::type&);

      void
      http_equiv (const http_equiv::container&);

      void
      http_equiv (::std::auto_ptr< http_equiv::type >);

      // content
      // 
      public:
      struct content
      {
        typedef ::xml_schema::parser::string type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const content::type&
      content () const;

      content::type&
      content ();

      void
      content (const content::type&);

      void
      content (::std::auto_ptr< content::type >);

      // Constructors.
      //
      public:
      meta (const content::type&);

      meta (const ::xercesc::DOMElement&,
            ::xml_schema::parser::flags = 0,
            ::xml_schema::parser::type* = 0);

      meta (const meta&,
            ::xml_schema::parser::flags = 0,
            ::xml_schema::parser::type* = 0);

      virtual meta*
      _clone (::xml_schema::parser::flags = 0,
              ::xml_schema::parser::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::parser::flags);

      ::xsd::cxx::tree::optional< name::type > _xsd_name_;
      ::xsd::cxx::tree::optional< http_equiv::type > _xsd_http_equiv_;
      ::xsd::cxx::tree::one< content::type > _xsd_content_;
    };

    class metadata: public ::xml_schema::parser::type
    {
      public:

      struct _xsd_metadata
      {
        typedef ::xml_schema::parser::type base_;
      };

      // Constructors.
      //
      public:
      metadata ();

      metadata (const ::xercesc::DOMElement&,
                ::xml_schema::parser::flags = 0,
                ::xml_schema::parser::type* = 0);

      metadata (const ::xercesc::DOMAttr&,
                ::xml_schema::parser::flags = 0,
                ::xml_schema::parser::type* = 0);

      metadata (const ::std::basic_string< char >&,
                const ::xercesc::DOMElement*,
                ::xml_schema::parser::flags = 0,
                ::xml_schema::parser::type* = 0);

      metadata (const metadata&,
                ::xml_schema::parser::flags = 0,
                ::xml_schema::parser::type* = 0);

      virtual metadata*
      _clone (::xml_schema::parser::flags = 0,
              ::xml_schema::parser::type* = 0) const;
    };

    class lexeme: public ::xml_schema::parser::type
    {
      public:

      struct _xsd_lexeme
      {
        typedef ::xml_schema::parser::type base_;
      };

      // grapheme
      // 
      public:
      struct grapheme
      {
        typedef ::xml_schema::parser::string type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::sequence< type > container;
        typedef container::iterator iterator;
        typedef container::const_iterator const_iterator;
      };

      const grapheme::container&
      grapheme () const;

      grapheme::container&
      grapheme ();

      void
      grapheme (const grapheme::container&);

      // phoneme
      // 
      public:
      struct phoneme
      {
        typedef ::pls::parser::phoneme type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::sequence< type > container;
        typedef container::iterator iterator;
        typedef container::const_iterator const_iterator;
      };

      const phoneme::container&
      phoneme () const;

      phoneme::container&
      phoneme ();

      void
      phoneme (const phoneme::container&);

      // alias
      // 
      public:
      struct alias
      {
        typedef ::pls::parser::alias type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::sequence< type > container;
        typedef container::iterator iterator;
        typedef container::const_iterator const_iterator;
      };

      const alias::container&
      alias () const;

      alias::container&
      alias ();

      void
      alias (const alias::container&);

      // example
      // 
      public:
      struct example
      {
        typedef ::xml_schema::parser::string type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::sequence< type > container;
        typedef container::iterator iterator;
        typedef container::const_iterator const_iterator;
      };

      const example::container&
      example () const;

      example::container&
      example ();

      void
      example (const example::container&);

      // id
      // 
      public:
      struct id
      {
        typedef ::xml_schema::parser::id type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const id::container&
      id () const;

      id::container&
      id ();

      void
      id (const id::type&);

      void
      id (const id::container&);

      void
      id (::std::auto_ptr< id::type >);

      // role
      // 
      public:
      struct role
      {
        typedef ::pls::parser::role type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const role::container&
      role () const;

      role::container&
      role ();

      void
      role (const role::type&);

      void
      role (const role::container&);

      void
      role (::std::auto_ptr< role::type >);

      // Constructors.
      //
      public:
      lexeme ();

      lexeme (const ::xercesc::DOMElement&,
              ::xml_schema::parser::flags = 0,
              ::xml_schema::parser::type* = 0);

      lexeme (const lexeme&,
              ::xml_schema::parser::flags = 0,
              ::xml_schema::parser::type* = 0);

      virtual lexeme*
      _clone (::xml_schema::parser::flags = 0,
              ::xml_schema::parser::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::parser::flags);

      ::xsd::cxx::tree::sequence< grapheme::type > _xsd_grapheme_;
      ::xsd::cxx::tree::sequence< phoneme::type > _xsd_phoneme_;
      ::xsd::cxx::tree::sequence< alias::type > _xsd_alias_;
      ::xsd::cxx::tree::sequence< example::type > _xsd_example_;
      ::xsd::cxx::tree::optional< id::type > _xsd_id_;
      ::xsd::cxx::tree::optional< role::type > _xsd_role_;
    };

    class prefer: public ::xml_schema::parser::token
    {
      public:
      enum _xsd_prefer
      {
        true_,
        false_
      };

      prefer (_xsd_prefer);

      prefer (const ::xml_schema::parser::token&);

      prefer (const ::xercesc::DOMElement&,
              ::xml_schema::parser::flags = 0,
              ::xml_schema::parser::type* = 0);

      prefer (const ::xercesc::DOMAttr&,
              ::xml_schema::parser::flags = 0,
              ::xml_schema::parser::type* = 0);

      prefer (const ::std::basic_string< char >&,
              const ::xercesc::DOMElement*,
              ::xml_schema::parser::flags = 0,
              ::xml_schema::parser::type* = 0);

      prefer (const prefer&,
              ::xml_schema::parser::flags = 0,
              ::xml_schema::parser::type* = 0);

      virtual prefer*
      _clone (::xml_schema::parser::flags = 0,
              ::xml_schema::parser::type* = 0) const;

      prefer&
      operator= (_xsd_prefer);

      virtual
      operator _xsd_prefer () const
      {
        return _xsd_prefer_convert ();
      }

      protected:
      _xsd_prefer
      _xsd_prefer_convert () const;

      public:
      static const char* const _xsd_prefer_literals_[2];
      static const _xsd_prefer _xsd_prefer_indexes_[2];
    };

    class phoneme: public ::xml_schema::parser::type
    {
      public:

      struct _xsd_phoneme
      {
        typedef ::xml_schema::parser::type base_;
      };

      // prefer
      // 
      public:
      struct prefer
      {
        typedef ::pls::parser::prefer type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const prefer::container&
      prefer () const;

      prefer::container&
      prefer ();

      void
      prefer (const prefer::type&);

      void
      prefer (const prefer::container&);

      void
      prefer (::std::auto_ptr< prefer::type >);

      // alphabet
      // 
      public:
      struct alphabet
      {
        typedef ::pls::parser::alphabet1 type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const alphabet::container&
      alphabet () const;

      alphabet::container&
      alphabet ();

      void
      alphabet (const alphabet::type&);

      void
      alphabet (const alphabet::container&);

      void
      alphabet (::std::auto_ptr< alphabet::type >);

      // Constructors.
      //
      public:
      phoneme ();

      phoneme (const ::xercesc::DOMElement&,
               ::xml_schema::parser::flags = 0,
               ::xml_schema::parser::type* = 0);

      phoneme (const phoneme&,
               ::xml_schema::parser::flags = 0,
               ::xml_schema::parser::type* = 0);

      virtual phoneme*
      _clone (::xml_schema::parser::flags = 0,
              ::xml_schema::parser::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::parser::flags);

      ::xsd::cxx::tree::optional< prefer::type > _xsd_prefer_;
      ::xsd::cxx::tree::optional< alphabet::type > _xsd_alphabet_;
    };

    class alias: public ::xml_schema::parser::type
    {
      public:

      struct _xsd_alias
      {
        typedef ::xml_schema::parser::type base_;
      };

      // prefer
      // 
      public:
      struct prefer
      {
        typedef ::pls::parser::prefer type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const prefer::container&
      prefer () const;

      prefer::container&
      prefer ();

      void
      prefer (const prefer::type&);

      void
      prefer (const prefer::container&);

      void
      prefer (::std::auto_ptr< prefer::type >);

      // Constructors.
      //
      public:
      alias ();

      alias (const ::xercesc::DOMElement&,
             ::xml_schema::parser::flags = 0,
             ::xml_schema::parser::type* = 0);

      alias (const alias&,
             ::xml_schema::parser::flags = 0,
             ::xml_schema::parser::type* = 0);

      virtual alias*
      _clone (::xml_schema::parser::flags = 0,
              ::xml_schema::parser::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::parser::flags);

      ::xsd::cxx::tree::optional< prefer::type > _xsd_prefer_;
    };

    class version: public ::xml_schema::parser::token
    {
      public:
      enum _xsd_version
      {
        cxx_1_0
      };

      version (_xsd_version);

      version (const ::xml_schema::parser::token&);

      version (const ::xercesc::DOMElement&,
               ::xml_schema::parser::flags = 0,
               ::xml_schema::parser::type* = 0);

      version (const ::xercesc::DOMAttr&,
               ::xml_schema::parser::flags = 0,
               ::xml_schema::parser::type* = 0);

      version (const ::std::basic_string< char >&,
               const ::xercesc::DOMElement*,
               ::xml_schema::parser::flags = 0,
               ::xml_schema::parser::type* = 0);

      version (const version&,
               ::xml_schema::parser::flags = 0,
               ::xml_schema::parser::type* = 0);

      virtual version*
      _clone (::xml_schema::parser::flags = 0,
              ::xml_schema::parser::type* = 0) const;

      version&
      operator= (_xsd_version);

      virtual
      operator _xsd_version () const
      {
        return _xsd_version_convert ();
      }

      protected:
      _xsd_version
      _xsd_version_convert () const;

      public:
      static const char* const _xsd_version_literals_[1];
      static const _xsd_version _xsd_version_indexes_[1];
    };

    class role: public ::pls::parser::role_type
    {
      public:

      struct _xsd_role
      {
        typedef ::pls::parser::role_type base_;
      };

      // Constructors.
      //
      public:
      role (const _xsd_role::base_& );

      role (const ::xercesc::DOMElement&,
            ::xml_schema::parser::flags = 0,
            ::xml_schema::parser::type* = 0);

      role (const ::xercesc::DOMAttr&,
            ::xml_schema::parser::flags = 0,
            ::xml_schema::parser::type* = 0);

      role (const ::std::basic_string< char >&,
            const ::xercesc::DOMElement*,
            ::xml_schema::parser::flags = 0,
            ::xml_schema::parser::type* = 0);

      role (const role&,
            ::xml_schema::parser::flags = 0,
            ::xml_schema::parser::type* = 0);

      virtual role*
      _clone (::xml_schema::parser::flags = 0,
              ::xml_schema::parser::type* = 0) const;
    };

    class alphabet1: public ::xml_schema::parser::string
    {
      public:

      struct _xsd_alphabet1
      {
        typedef ::xml_schema::parser::string base_;
      };

      // Constructors.
      //
      public:
      alphabet1 (const _xsd_alphabet1::base_& );

      alphabet1 (const ::xercesc::DOMElement&,
                 ::xml_schema::parser::flags = 0,
                 ::xml_schema::parser::type* = 0);

      alphabet1 (const ::xercesc::DOMAttr&,
                 ::xml_schema::parser::flags = 0,
                 ::xml_schema::parser::type* = 0);

      alphabet1 (const ::std::basic_string< char >&,
                 const ::xercesc::DOMElement*,
                 ::xml_schema::parser::flags = 0,
                 ::xml_schema::parser::type* = 0);

      alphabet1 (const alphabet1&,
                 ::xml_schema::parser::flags = 0,
                 ::xml_schema::parser::type* = 0);

      virtual alphabet1*
      _clone (::xml_schema::parser::flags = 0,
              ::xml_schema::parser::type* = 0) const;
    };
  }
}

#include <iosfwd>

#include <xercesc/dom/DOMDocument.hpp>
#include <xercesc/dom/DOMInputSource.hpp>
#include <xercesc/dom/DOMErrorHandler.hpp>

#include <xsd/cxx/tree/parsing.hxx>

namespace pls
{
  namespace parser
  {
    // Read from a URI or a local file.
    //

    ::std::auto_ptr< ::pls::parser::lexicon >
    lexicon_ (const ::std::basic_string< char >&,
              ::xml_schema::parser::flags = 0,
              const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());

    ::std::auto_ptr< ::pls::parser::lexicon >
    lexicon_ (const ::std::basic_string< char >&,
              ::xsd::cxx::xml::error_handler< char >&,
              ::xml_schema::parser::flags = 0,
              const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());

    ::std::auto_ptr< ::pls::parser::lexicon >
    lexicon_ (const ::std::basic_string< char >&,
              ::xercesc::DOMErrorHandler&,
              ::xml_schema::parser::flags = 0,
              const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());


    // Read from std::istream.
    //

    ::std::auto_ptr< ::pls::parser::lexicon >
    lexicon_ (::std::istream&,
              ::xml_schema::parser::flags = 0,
              const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());

    ::std::auto_ptr< ::pls::parser::lexicon >
    lexicon_ (::std::istream&,
              ::xsd::cxx::xml::error_handler< char >&,
              ::xml_schema::parser::flags = 0,
              const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());

    ::std::auto_ptr< ::pls::parser::lexicon >
    lexicon_ (::std::istream&,
              ::xercesc::DOMErrorHandler&,
              ::xml_schema::parser::flags = 0,
              const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());


    ::std::auto_ptr< ::pls::parser::lexicon >
    lexicon_ (::std::istream&,
              const ::std::basic_string< char >& id,
              ::xml_schema::parser::flags = 0,
              const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());

    ::std::auto_ptr< ::pls::parser::lexicon >
    lexicon_ (::std::istream&,
              const ::std::basic_string< char >& id,
              ::xsd::cxx::xml::error_handler< char >&,
              ::xml_schema::parser::flags = 0,
              const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());

    ::std::auto_ptr< ::pls::parser::lexicon >
    lexicon_ (::std::istream&,
              const ::std::basic_string< char >& id,
              ::xercesc::DOMErrorHandler&,
              ::xml_schema::parser::flags = 0,
              const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());


    // Read from InputSource.
    //

    ::std::auto_ptr< ::pls::parser::lexicon >
    lexicon_ (const ::xercesc::DOMInputSource&,
              ::xml_schema::parser::flags = 0,
              const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());

    ::std::auto_ptr< ::pls::parser::lexicon >
    lexicon_ (const ::xercesc::DOMInputSource&,
              ::xsd::cxx::xml::error_handler< char >&,
              ::xml_schema::parser::flags = 0,
              const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());

    ::std::auto_ptr< ::pls::parser::lexicon >
    lexicon_ (const ::xercesc::DOMInputSource&,
              ::xercesc::DOMErrorHandler&,
              ::xml_schema::parser::flags = 0,
              const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());


    // Read from DOM.
    //

    ::std::auto_ptr< ::pls::parser::lexicon >
    lexicon_ (const ::xercesc::DOMDocument&,
              ::xml_schema::parser::flags = 0,
              const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());
  }
}

#include <xsd/cxx/post.hxx>

// Begin epilogue.
//
//
// End epilogue.

#endif // PLS_PARSER_HXX
