// Copyright (C) 2005-2006 Code Synthesis Tools CC
//
// This program was generated by XML Schema Definition Compiler (XSD)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
//
// In addition, as a special exception, Code Synthesis Tools CC gives
// permission to link this program with the Xerces-C++ library (or with
// modified versions of Xerces-C++ that use the same license as Xerces-C++),
// and distribute linked combinations including the two. You must obey
// the GNU General Public License version 2 in all respects for all of
// the code used other than Xerces-C++. If you modify this copy of the
// program, you may extend this exception to your version of the program,
// but you are not obligated to do so. If you do not wish to do so, delete
// this exception statement from your version.
//
// In addition, Code Synthesis Tools CC makes a special exception for
// the Free/Libre and Open Source Software (FLOSS) which is described
// in the accompanying FLOSSE file.
//

// Begin prologue.
//
//
// End prologue.

#include <xsd/cxx/pre.hxx>

#include "pls-parser.hxx"

namespace pls
{
  namespace parser
  {
    // role_type
    //

    role_type::
    role_type ()
    {
    }

    role_type::
    role_type (const role_type& o,
               ::xml_schema::parser::flags f,
               ::xml_schema::parser::type* c)
    : ::xml_schema::parser::simple_type (o, f, c),
    ::xsd::cxx::tree::list< ::xml_schema::parser::qname, char > (o, f, c)
    {
    }

    // lexicon
    // 

    const lexicon::meta::container& lexicon::
    meta () const
    {
      return this->_xsd_meta_;
    }

    lexicon::meta::container& lexicon::
    meta ()
    {
      return this->_xsd_meta_;
    }

    void lexicon::
    meta (const meta::container& meta)
    {
      this->_xsd_meta_ = meta;
    }

    const lexicon::metadata::container& lexicon::
    metadata () const
    {
      return this->_xsd_metadata_;
    }

    lexicon::metadata::container& lexicon::
    metadata ()
    {
      return this->_xsd_metadata_;
    }

    void lexicon::
    metadata (const metadata::type& metadata)
    {
      this->_xsd_metadata_.set (metadata);
    }

    void lexicon::
    metadata (const metadata::container& metadata)
    {
      this->_xsd_metadata_ = metadata;
    }

    void lexicon::
    metadata (::std::auto_ptr< metadata::type > metadata)
    {
      this->_xsd_metadata_.set (metadata);
    }

    const lexicon::lexeme::container& lexicon::
    lexeme () const
    {
      return this->_xsd_lexeme_;
    }

    lexicon::lexeme::container& lexicon::
    lexeme ()
    {
      return this->_xsd_lexeme_;
    }

    void lexicon::
    lexeme (const lexeme::container& lexeme)
    {
      this->_xsd_lexeme_ = lexeme;
    }

    const lexicon::version::type& lexicon::
    version () const
    {
      return this->_xsd_version_.get ();
    }

    lexicon::version::type& lexicon::
    version ()
    {
      return this->_xsd_version_.get ();
    }

    void lexicon::
    version (const version::type& version)
    {
      this->_xsd_version_.set (version);
    }

    void lexicon::
    version (::std::auto_ptr< version::type > version)
    {
      this->_xsd_version_.set (version);
    }

    const lexicon::base::container& lexicon::
    base () const
    {
      return this->_xsd_base_;
    }

    lexicon::base::container& lexicon::
    base ()
    {
      return this->_xsd_base_;
    }

    void lexicon::
    base (const base::type& base)
    {
      this->_xsd_base_.set (base);
    }

    void lexicon::
    base (const base::container& base)
    {
      this->_xsd_base_ = base;
    }

    void lexicon::
    base (::std::auto_ptr< base::type > base)
    {
      this->_xsd_base_.set (base);
    }

    const lexicon::lang::type& lexicon::
    lang () const
    {
      return this->_xsd_lang_.get ();
    }

    lexicon::lang::type& lexicon::
    lang ()
    {
      return this->_xsd_lang_.get ();
    }

    void lexicon::
    lang (const lang::type& lang)
    {
      this->_xsd_lang_.set (lang);
    }

    void lexicon::
    lang (::std::auto_ptr< lang::type > lang)
    {
      this->_xsd_lang_.set (lang);
    }

    const lexicon::alphabet::type& lexicon::
    alphabet () const
    {
      return this->_xsd_alphabet_.get ();
    }

    lexicon::alphabet::type& lexicon::
    alphabet ()
    {
      return this->_xsd_alphabet_.get ();
    }

    void lexicon::
    alphabet (const alphabet::type& alphabet)
    {
      this->_xsd_alphabet_.set (alphabet);
    }

    void lexicon::
    alphabet (::std::auto_ptr< alphabet::type > alphabet)
    {
      this->_xsd_alphabet_.set (alphabet);
    }


    // alphabet
    // 


    // meta
    // 

    const meta::name::container& meta::
    name () const
    {
      return this->_xsd_name_;
    }

    meta::name::container& meta::
    name ()
    {
      return this->_xsd_name_;
    }

    void meta::
    name (const name::type& name)
    {
      this->_xsd_name_.set (name);
    }

    void meta::
    name (const name::container& name)
    {
      this->_xsd_name_ = name;
    }

    void meta::
    name (::std::auto_ptr< name::type > name)
    {
      this->_xsd_name_.set (name);
    }

    const meta::http_equiv::container& meta::
    http_equiv () const
    {
      return this->_xsd_http_equiv_;
    }

    meta::http_equiv::container& meta::
    http_equiv ()
    {
      return this->_xsd_http_equiv_;
    }

    void meta::
    http_equiv (const http_equiv::type& http_equiv)
    {
      this->_xsd_http_equiv_.set (http_equiv);
    }

    void meta::
    http_equiv (const http_equiv::container& http_equiv)
    {
      this->_xsd_http_equiv_ = http_equiv;
    }

    void meta::
    http_equiv (::std::auto_ptr< http_equiv::type > http_equiv)
    {
      this->_xsd_http_equiv_.set (http_equiv);
    }

    const meta::content::type& meta::
    content () const
    {
      return this->_xsd_content_.get ();
    }

    meta::content::type& meta::
    content ()
    {
      return this->_xsd_content_.get ();
    }

    void meta::
    content (const content::type& content)
    {
      this->_xsd_content_.set (content);
    }

    void meta::
    content (::std::auto_ptr< content::type > content)
    {
      this->_xsd_content_.set (content);
    }


    // metadata
    // 


    // lexeme
    // 

    const lexeme::grapheme::container& lexeme::
    grapheme () const
    {
      return this->_xsd_grapheme_;
    }

    lexeme::grapheme::container& lexeme::
    grapheme ()
    {
      return this->_xsd_grapheme_;
    }

    void lexeme::
    grapheme (const grapheme::container& grapheme)
    {
      this->_xsd_grapheme_ = grapheme;
    }

    const lexeme::phoneme::container& lexeme::
    phoneme () const
    {
      return this->_xsd_phoneme_;
    }

    lexeme::phoneme::container& lexeme::
    phoneme ()
    {
      return this->_xsd_phoneme_;
    }

    void lexeme::
    phoneme (const phoneme::container& phoneme)
    {
      this->_xsd_phoneme_ = phoneme;
    }

    const lexeme::alias::container& lexeme::
    alias () const
    {
      return this->_xsd_alias_;
    }

    lexeme::alias::container& lexeme::
    alias ()
    {
      return this->_xsd_alias_;
    }

    void lexeme::
    alias (const alias::container& alias)
    {
      this->_xsd_alias_ = alias;
    }

    const lexeme::example::container& lexeme::
    example () const
    {
      return this->_xsd_example_;
    }

    lexeme::example::container& lexeme::
    example ()
    {
      return this->_xsd_example_;
    }

    void lexeme::
    example (const example::container& example)
    {
      this->_xsd_example_ = example;
    }

    const lexeme::id::container& lexeme::
    id () const
    {
      return this->_xsd_id_;
    }

    lexeme::id::container& lexeme::
    id ()
    {
      return this->_xsd_id_;
    }

    void lexeme::
    id (const id::type& id)
    {
      this->_xsd_id_.set (id);
    }

    void lexeme::
    id (const id::container& id)
    {
      this->_xsd_id_ = id;
    }

    void lexeme::
    id (::std::auto_ptr< id::type > id)
    {
      this->_xsd_id_.set (id);
    }

    const lexeme::role::container& lexeme::
    role () const
    {
      return this->_xsd_role_;
    }

    lexeme::role::container& lexeme::
    role ()
    {
      return this->_xsd_role_;
    }

    void lexeme::
    role (const role::type& role)
    {
      this->_xsd_role_.set (role);
    }

    void lexeme::
    role (const role::container& role)
    {
      this->_xsd_role_ = role;
    }

    void lexeme::
    role (::std::auto_ptr< role::type > role)
    {
      this->_xsd_role_.set (role);
    }


    // prefer
    // 

    prefer::
    prefer (_xsd_prefer v)
    : ::xml_schema::parser::token (_xsd_prefer_literals_[v])
    {
    }

    prefer::
    prefer (const ::xml_schema::parser::token& _xsd_prefer)
    : ::xml_schema::parser::token (_xsd_prefer)
    {
    }

    prefer::
    prefer (const prefer& v,
            ::xml_schema::parser::flags f,
            ::xml_schema::parser::type* c)
    : ::xml_schema::parser::token (v, f, c)
    {
    }

    prefer& prefer::
    operator= (_xsd_prefer v)
    {
      static_cast< ::xml_schema::parser::token& > (*this) = 
      ::xml_schema::parser::token (_xsd_prefer_literals_[v]);

      return *this;
    }


    // phoneme
    // 

    const phoneme::prefer::container& phoneme::
    prefer () const
    {
      return this->_xsd_prefer_;
    }

    phoneme::prefer::container& phoneme::
    prefer ()
    {
      return this->_xsd_prefer_;
    }

    void phoneme::
    prefer (const prefer::type& prefer)
    {
      this->_xsd_prefer_.set (prefer);
    }

    void phoneme::
    prefer (const prefer::container& prefer)
    {
      this->_xsd_prefer_ = prefer;
    }

    void phoneme::
    prefer (::std::auto_ptr< prefer::type > prefer)
    {
      this->_xsd_prefer_.set (prefer);
    }

    const phoneme::alphabet::container& phoneme::
    alphabet () const
    {
      return this->_xsd_alphabet_;
    }

    phoneme::alphabet::container& phoneme::
    alphabet ()
    {
      return this->_xsd_alphabet_;
    }

    void phoneme::
    alphabet (const alphabet::type& alphabet)
    {
      this->_xsd_alphabet_.set (alphabet);
    }

    void phoneme::
    alphabet (const alphabet::container& alphabet)
    {
      this->_xsd_alphabet_ = alphabet;
    }

    void phoneme::
    alphabet (::std::auto_ptr< alphabet::type > alphabet)
    {
      this->_xsd_alphabet_.set (alphabet);
    }


    // alias
    // 

    const alias::prefer::container& alias::
    prefer () const
    {
      return this->_xsd_prefer_;
    }

    alias::prefer::container& alias::
    prefer ()
    {
      return this->_xsd_prefer_;
    }

    void alias::
    prefer (const prefer::type& prefer)
    {
      this->_xsd_prefer_.set (prefer);
    }

    void alias::
    prefer (const prefer::container& prefer)
    {
      this->_xsd_prefer_ = prefer;
    }

    void alias::
    prefer (::std::auto_ptr< prefer::type > prefer)
    {
      this->_xsd_prefer_.set (prefer);
    }


    // version
    // 

    version::
    version (_xsd_version v)
    : ::xml_schema::parser::token (_xsd_version_literals_[v])
    {
    }

    version::
    version (const ::xml_schema::parser::token& _xsd_version)
    : ::xml_schema::parser::token (_xsd_version)
    {
    }

    version::
    version (const version& v,
             ::xml_schema::parser::flags f,
             ::xml_schema::parser::type* c)
    : ::xml_schema::parser::token (v, f, c)
    {
    }

    version& version::
    operator= (_xsd_version v)
    {
      static_cast< ::xml_schema::parser::token& > (*this) = 
      ::xml_schema::parser::token (_xsd_version_literals_[v]);

      return *this;
    }


    // role
    // 


    // alphabet1
    // 
  }
}

#include <xsd/cxx/xml/dom/elements.hxx>
#include <xsd/cxx/xml/dom/parser.hxx>

namespace pls
{
  namespace parser
  {
    // role_type
    //

    role_type::
    role_type (const ::xercesc::DOMElement& e,
               ::xml_schema::parser::flags f,
               ::xml_schema::parser::type* c)
    : ::xml_schema::parser::simple_type (e, f, c),
    ::xsd::cxx::tree::list< ::xml_schema::parser::qname, char > (e, f, c)
    {
    }

    role_type::
    role_type (const ::xercesc::DOMAttr& a,
               ::xml_schema::parser::flags f,
               ::xml_schema::parser::type* c)
    : ::xml_schema::parser::simple_type (a, f, c),
    ::xsd::cxx::tree::list< ::xml_schema::parser::qname, char > (a, f, c)
    {
    }

    role_type::
    role_type (const ::std::basic_string< char >& s,
               const ::xercesc::DOMElement* e,
               ::xml_schema::parser::flags f,
               ::xml_schema::parser::type* c)
    : ::xml_schema::parser::simple_type (s, e, f, c),
    ::xsd::cxx::tree::list< ::xml_schema::parser::qname, char > (s, e, f, c)
    {
    }

    role_type* role_type::
    _clone (::xml_schema::parser::flags f,
            ::xml_schema::parser::type* c) const
    {
      return new role_type (*this, f, c);
    }

    // lexicon
    //

    lexicon::
    lexicon (const version::type& _xsd_version,
             const lang::type& _xsd_lang,
             const alphabet::type& _xsd_alphabet)
    : ::xml_schema::parser::type (),
    _xsd_meta_ (::xml_schema::parser::flags (), this),
    _xsd_metadata_ (::xml_schema::parser::flags (), this),
    _xsd_lexeme_ (::xml_schema::parser::flags (), this),
    _xsd_version_ (_xsd_version,
                   ::xml_schema::parser::flags (),
                   this),
    _xsd_base_ (::xml_schema::parser::flags (), this),
    _xsd_lang_ (_xsd_lang,
                ::xml_schema::parser::flags (),
                this),
    _xsd_alphabet_ (_xsd_alphabet,
                    ::xml_schema::parser::flags (),
                    this)
    {
    }

    lexicon::
    lexicon (const lexicon& _xsd_lexicon,
             ::xml_schema::parser::flags f,
             ::xml_schema::parser::type* c)
    : ::xml_schema::parser::type (_xsd_lexicon, f, c),
    _xsd_meta_ (_xsd_lexicon._xsd_meta_,
                f | ::xml_schema::parser::flags::not_root,
                this),
    _xsd_metadata_ (_xsd_lexicon._xsd_metadata_,
                    f | ::xml_schema::parser::flags::not_root,
                    this),
    _xsd_lexeme_ (_xsd_lexicon._xsd_lexeme_,
                  f | ::xml_schema::parser::flags::not_root,
                  this),
    _xsd_version_ (_xsd_lexicon._xsd_version_,
                   f | ::xml_schema::parser::flags::not_root,
                   this),
    _xsd_base_ (_xsd_lexicon._xsd_base_,
                f | ::xml_schema::parser::flags::not_root,
                this),
    _xsd_lang_ (_xsd_lexicon._xsd_lang_,
                f | ::xml_schema::parser::flags::not_root,
                this),
    _xsd_alphabet_ (_xsd_lexicon._xsd_alphabet_,
                    f | ::xml_schema::parser::flags::not_root,
                    this)
    {
    }

    lexicon::
    lexicon (const ::xercesc::DOMElement& e,
             ::xml_schema::parser::flags f,
             ::xml_schema::parser::type* c)
    : ::xml_schema::parser::type (e, f, c),
    _xsd_meta_ (f | ::xml_schema::parser::flags::not_root, this),
    _xsd_metadata_ (f | ::xml_schema::parser::flags::not_root, this),
    _xsd_lexeme_ (f | ::xml_schema::parser::flags::not_root, this),
    _xsd_version_ (f | ::xml_schema::parser::flags::not_root, this),
    _xsd_base_ (f | ::xml_schema::parser::flags::not_root, this),
    _xsd_lang_ (f | ::xml_schema::parser::flags::not_root, this),
    _xsd_alphabet_ (f | ::xml_schema::parser::flags::not_root, this)
    {
      parse (e, f);
    }

    void lexicon::
    parse (const ::xercesc::DOMElement& e, ::xml_schema::parser::flags f)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e);

      while (p.more_elements ())
      {
        const ::xsd::cxx::xml::dom::element< char > e (p.next_element ());

        // meta
        //
        {
          if (e.name () == "meta" && e.namespace_ () == "http://www.w3.org/2005/01/pronunciation-lexicon")
          {
            ::std::auto_ptr< meta::type > r (
              meta::traits::create (
                e.dom_element (),
                f | ::xml_schema::parser::flags::not_root,
                this));

            this->meta ().push_back (r);
            continue;
          }
        }

        // metadata
        //
        {
          if (e.name () == "metadata" && e.namespace_ () == "http://www.w3.org/2005/01/pronunciation-lexicon")
          {
            ::std::auto_ptr< metadata::type > r (
              metadata::traits::create (
                e.dom_element (),
                f | ::xml_schema::parser::flags::not_root,
                this));

            if (this->metadata ())
              continue;
            this->metadata (r);
            continue;
          }
        }

        // lexeme
        //
        {
          if (e.name () == "lexeme" && e.namespace_ () == "http://www.w3.org/2005/01/pronunciation-lexicon")
          {
            ::std::auto_ptr< lexeme::type > r (
              lexeme::traits::create (
                e.dom_element (),
                f | ::xml_schema::parser::flags::not_root,
                this));

            this->lexeme ().push_back (r);
            continue;
          }
        }
      }

      while (p.more_attributes ())
      {
        const ::xsd::cxx::xml::dom::attribute< char > a (p.next_attribute ());

        if (a.name () == "version" && a.namespace_ ().empty ())
        {
          ::std::auto_ptr< version::type > r (
            version::traits::create (
              a.dom_attribute (),
              f | ::xml_schema::parser::flags::not_root,
              this));

          this->version (r);
          continue;
        }

        if (a.name () == "base" && a.namespace_ () == "http://www.w3.org/XML/1998/namespace")
        {
          ::std::auto_ptr< base::type > r (
            base::traits::create (
              a.dom_attribute (),
              f | ::xml_schema::parser::flags::not_root,
              this));

          this->base (r);
          continue;
        }

        if (a.name () == "lang" && a.namespace_ () == "http://www.w3.org/XML/1998/namespace")
        {
          ::std::auto_ptr< lang::type > r (
            lang::traits::create (
              a.dom_attribute (),
              f | ::xml_schema::parser::flags::not_root,
              this));

          this->lang (r);
          continue;
        }

        if (a.name () == "alphabet" && a.namespace_ ().empty ())
        {
          ::std::auto_ptr< alphabet::type > r (
            alphabet::traits::create (
              a.dom_attribute (),
              f | ::xml_schema::parser::flags::not_root,
              this));

          this->alphabet (r);
          continue;
        }
      }

      if (!_xsd_version_.present ())
      {
        throw ::xsd::cxx::tree::expected_attribute< char > (
          "version",
          "");
      }

      if (!_xsd_lang_.present ())
      {
        throw ::xsd::cxx::tree::expected_attribute< char > (
          "lang",
          "http://www.w3.org/XML/1998/namespace");
      }

      if (!_xsd_alphabet_.present ())
      {
        throw ::xsd::cxx::tree::expected_attribute< char > (
          "alphabet",
          "");
      }
    }

    lexicon* lexicon::
    _clone (::xml_schema::parser::flags f,
            ::xml_schema::parser::type* c) const
    {
      return new lexicon (*this, f, c);
    }

    // alphabet
    //

    alphabet::
    alphabet (const _xsd_alphabet::base_& _xsd_alphabet)
    : ::xml_schema::parser::string (_xsd_alphabet)
    {
    }

    alphabet::
    alphabet (const alphabet& _xsd_alphabet,
              ::xml_schema::parser::flags f,
              ::xml_schema::parser::type* c)
    : ::xml_schema::parser::string (_xsd_alphabet, f, c)
    {
    }

    alphabet::
    alphabet (const ::xercesc::DOMElement& e,
              ::xml_schema::parser::flags f,
              ::xml_schema::parser::type* c)
    : ::xml_schema::parser::string (e, f, c)
    {
    }

    alphabet::
    alphabet (const ::xercesc::DOMAttr& a,
              ::xml_schema::parser::flags f,
              ::xml_schema::parser::type* c)
    : ::xml_schema::parser::string (a, f, c)
    {
    }

    alphabet::
    alphabet (const ::std::basic_string< char >& s,
              const ::xercesc::DOMElement* e,
              ::xml_schema::parser::flags f,
              ::xml_schema::parser::type* c)
    : ::xml_schema::parser::string (s, e, f, c)
    {
    }

    alphabet* alphabet::
    _clone (::xml_schema::parser::flags f,
            ::xml_schema::parser::type* c) const
    {
      return new alphabet (*this, f, c);
    }

    // meta
    //

    meta::
    meta (const content::type& _xsd_content)
    : ::xml_schema::parser::type (),
    _xsd_name_ (::xml_schema::parser::flags (), this),
    _xsd_http_equiv_ (::xml_schema::parser::flags (), this),
    _xsd_content_ (_xsd_content,
                   ::xml_schema::parser::flags (),
                   this)
    {
    }

    meta::
    meta (const meta& _xsd_meta,
          ::xml_schema::parser::flags f,
          ::xml_schema::parser::type* c)
    : ::xml_schema::parser::type (_xsd_meta, f, c),
    _xsd_name_ (_xsd_meta._xsd_name_,
                f | ::xml_schema::parser::flags::not_root,
                this),
    _xsd_http_equiv_ (_xsd_meta._xsd_http_equiv_,
                      f | ::xml_schema::parser::flags::not_root,
                      this),
    _xsd_content_ (_xsd_meta._xsd_content_,
                   f | ::xml_schema::parser::flags::not_root,
                   this)
    {
    }

    meta::
    meta (const ::xercesc::DOMElement& e,
          ::xml_schema::parser::flags f,
          ::xml_schema::parser::type* c)
    : ::xml_schema::parser::type (e, f, c),
    _xsd_name_ (f | ::xml_schema::parser::flags::not_root, this),
    _xsd_http_equiv_ (f | ::xml_schema::parser::flags::not_root, this),
    _xsd_content_ (f | ::xml_schema::parser::flags::not_root, this)
    {
      parse (e, f);
    }

    void meta::
    parse (const ::xercesc::DOMElement& e, ::xml_schema::parser::flags f)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e);

      while (p.more_attributes ())
      {
        const ::xsd::cxx::xml::dom::attribute< char > a (p.next_attribute ());

        if (a.name () == "name" && a.namespace_ ().empty ())
        {
          ::std::auto_ptr< name::type > r (
            name::traits::create (
              a.dom_attribute (),
              f | ::xml_schema::parser::flags::not_root,
              this));

          this->name (r);
          continue;
        }

        if (a.name () == "http-equiv" && a.namespace_ ().empty ())
        {
          ::std::auto_ptr< http_equiv::type > r (
            http_equiv::traits::create (
              a.dom_attribute (),
              f | ::xml_schema::parser::flags::not_root,
              this));

          this->http_equiv (r);
          continue;
        }

        if (a.name () == "content" && a.namespace_ ().empty ())
        {
          ::std::auto_ptr< content::type > r (
            content::traits::create (
              a.dom_attribute (),
              f | ::xml_schema::parser::flags::not_root,
              this));

          this->content (r);
          continue;
        }
      }

      if (!_xsd_content_.present ())
      {
        throw ::xsd::cxx::tree::expected_attribute< char > (
          "content",
          "");
      }
    }

    meta* meta::
    _clone (::xml_schema::parser::flags f,
            ::xml_schema::parser::type* c) const
    {
      return new meta (*this, f, c);
    }

    // metadata
    //

    metadata::
    metadata ()
    : ::xml_schema::parser::type ()
    {
    }

    metadata::
    metadata (const metadata& _xsd_metadata,
              ::xml_schema::parser::flags f,
              ::xml_schema::parser::type* c)
    : ::xml_schema::parser::type (_xsd_metadata, f, c)
    {
    }

    metadata::
    metadata (const ::xercesc::DOMElement& e,
              ::xml_schema::parser::flags f,
              ::xml_schema::parser::type* c)
    : ::xml_schema::parser::type (e, f, c)
    {
    }

    metadata::
    metadata (const ::xercesc::DOMAttr& a,
              ::xml_schema::parser::flags f,
              ::xml_schema::parser::type* c)
    : ::xml_schema::parser::type (a, f, c)
    {
    }

    metadata::
    metadata (const ::std::basic_string< char >& s,
              const ::xercesc::DOMElement* e,
              ::xml_schema::parser::flags f,
              ::xml_schema::parser::type* c)
    : ::xml_schema::parser::type (s, e, f, c)
    {
    }

    metadata* metadata::
    _clone (::xml_schema::parser::flags f,
            ::xml_schema::parser::type* c) const
    {
      return new metadata (*this, f, c);
    }

    // lexeme
    //

    lexeme::
    lexeme ()
    : ::xml_schema::parser::type (),
    _xsd_grapheme_ (::xml_schema::parser::flags (), this),
    _xsd_phoneme_ (::xml_schema::parser::flags (), this),
    _xsd_alias_ (::xml_schema::parser::flags (), this),
    _xsd_example_ (::xml_schema::parser::flags (), this),
    _xsd_id_ (::xml_schema::parser::flags (), this),
    _xsd_role_ (::xml_schema::parser::flags (), this)
    {
    }

    lexeme::
    lexeme (const lexeme& _xsd_lexeme,
            ::xml_schema::parser::flags f,
            ::xml_schema::parser::type* c)
    : ::xml_schema::parser::type (_xsd_lexeme, f, c),
    _xsd_grapheme_ (_xsd_lexeme._xsd_grapheme_,
                    f | ::xml_schema::parser::flags::not_root,
                    this),
    _xsd_phoneme_ (_xsd_lexeme._xsd_phoneme_,
                   f | ::xml_schema::parser::flags::not_root,
                   this),
    _xsd_alias_ (_xsd_lexeme._xsd_alias_,
                 f | ::xml_schema::parser::flags::not_root,
                 this),
    _xsd_example_ (_xsd_lexeme._xsd_example_,
                   f | ::xml_schema::parser::flags::not_root,
                   this),
    _xsd_id_ (_xsd_lexeme._xsd_id_,
              f | ::xml_schema::parser::flags::not_root,
              this),
    _xsd_role_ (_xsd_lexeme._xsd_role_,
                f | ::xml_schema::parser::flags::not_root,
                this)
    {
    }

    lexeme::
    lexeme (const ::xercesc::DOMElement& e,
            ::xml_schema::parser::flags f,
            ::xml_schema::parser::type* c)
    : ::xml_schema::parser::type (e, f, c),
    _xsd_grapheme_ (f | ::xml_schema::parser::flags::not_root, this),
    _xsd_phoneme_ (f | ::xml_schema::parser::flags::not_root, this),
    _xsd_alias_ (f | ::xml_schema::parser::flags::not_root, this),
    _xsd_example_ (f | ::xml_schema::parser::flags::not_root, this),
    _xsd_id_ (f | ::xml_schema::parser::flags::not_root, this),
    _xsd_role_ (f | ::xml_schema::parser::flags::not_root, this)
    {
      parse (e, f);
    }

    void lexeme::
    parse (const ::xercesc::DOMElement& e, ::xml_schema::parser::flags f)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e);

      while (p.more_elements ())
      {
        const ::xsd::cxx::xml::dom::element< char > e (p.next_element ());

        // grapheme
        //
        {
          if (e.name () == "grapheme" && e.namespace_ () == "http://www.w3.org/2005/01/pronunciation-lexicon")
          {
            ::std::auto_ptr< grapheme::type > r (
              grapheme::traits::create (
                e.dom_element (),
                f | ::xml_schema::parser::flags::not_root,
                this));

            this->grapheme ().push_back (r);
            continue;
          }
        }

        // phoneme
        //
        {
          if (e.name () == "phoneme" && e.namespace_ () == "http://www.w3.org/2005/01/pronunciation-lexicon")
          {
            ::std::auto_ptr< phoneme::type > r (
              phoneme::traits::create (
                e.dom_element (),
                f | ::xml_schema::parser::flags::not_root,
                this));

            this->phoneme ().push_back (r);
            continue;
          }
        }

        // alias
        //
        {
          if (e.name () == "alias" && e.namespace_ () == "http://www.w3.org/2005/01/pronunciation-lexicon")
          {
            ::std::auto_ptr< alias::type > r (
              alias::traits::create (
                e.dom_element (),
                f | ::xml_schema::parser::flags::not_root,
                this));

            this->alias ().push_back (r);
            continue;
          }
        }

        // example
        //
        {
          if (e.name () == "example" && e.namespace_ () == "http://www.w3.org/2005/01/pronunciation-lexicon")
          {
            ::std::auto_ptr< example::type > r (
              example::traits::create (
                e.dom_element (),
                f | ::xml_schema::parser::flags::not_root,
                this));

            this->example ().push_back (r);
            continue;
          }
        }
      }

      while (p.more_attributes ())
      {
        const ::xsd::cxx::xml::dom::attribute< char > a (p.next_attribute ());

        if (a.name () == "id" && a.namespace_ () == "http://www.w3.org/XML/1998/namespace")
        {
          ::std::auto_ptr< id::type > r (
            id::traits::create (
              a.dom_attribute (),
              f | ::xml_schema::parser::flags::not_root,
              this));

          this->id (r);
          continue;
        }

        if (a.name () == "role" && a.namespace_ ().empty ())
        {
          ::std::auto_ptr< role::type > r (
            role::traits::create (
              a.dom_attribute (),
              f | ::xml_schema::parser::flags::not_root,
              this));

          this->role (r);
          continue;
        }
      }
    }

    lexeme* lexeme::
    _clone (::xml_schema::parser::flags f,
            ::xml_schema::parser::type* c) const
    {
      return new lexeme (*this, f, c);
    }

    // prefer
    //

    prefer::
    prefer (const ::xercesc::DOMElement& e,
            ::xml_schema::parser::flags f,
            ::xml_schema::parser::type* c)
    : ::xml_schema::parser::token (e, f, c)
    {
      _xsd_prefer_convert ();
    }

    prefer::
    prefer (const ::xercesc::DOMAttr& a,
            ::xml_schema::parser::flags f,
            ::xml_schema::parser::type* c)
    : ::xml_schema::parser::token (a, f, c)
    {
      _xsd_prefer_convert ();
    }

    prefer::
    prefer (const ::std::basic_string< char >& s,
            const ::xercesc::DOMElement* e,
            ::xml_schema::parser::flags f,
            ::xml_schema::parser::type* c)
    : ::xml_schema::parser::token (s, e, f, c)
    {
      _xsd_prefer_convert ();
    }

    prefer* prefer::
    _clone (::xml_schema::parser::flags f,
            ::xml_schema::parser::type* c) const
    {
      return new prefer (*this, f, c);
    }

    prefer::_xsd_prefer prefer::
    _xsd_prefer_convert () const
    {
      ::xsd::cxx::tree::enum_comparator< char > c (_xsd_prefer_literals_);
      const _xsd_prefer* i (::std::lower_bound (
                              _xsd_prefer_indexes_,
                              _xsd_prefer_indexes_ + 2,
                              *this,
                              c));

      if (i == _xsd_prefer_indexes_ + 2 || _xsd_prefer_literals_[*i] != *this)
      {
        throw ::xsd::cxx::tree::unexpected_enumerator < char > (*this);
      }

      return *i;
    }

    const char* const prefer::
    _xsd_prefer_literals_[2] =
    {
      "true",
      "false"
    };

    const prefer::_xsd_prefer prefer::
    _xsd_prefer_indexes_[2] =
    {
      ::pls::parser::prefer::false_,
      ::pls::parser::prefer::true_
    };

    // phoneme
    //

    phoneme::
    phoneme ()
    : ::xml_schema::parser::type (),
    _xsd_prefer_ (::xml_schema::parser::flags (), this),
    _xsd_alphabet_ (::xml_schema::parser::flags (), this)
    {
    }

    phoneme::
    phoneme (const phoneme& _xsd_phoneme,
             ::xml_schema::parser::flags f,
             ::xml_schema::parser::type* c)
    : ::xml_schema::parser::type (_xsd_phoneme, f, c),
    _xsd_prefer_ (_xsd_phoneme._xsd_prefer_,
                  f | ::xml_schema::parser::flags::not_root,
                  this),
    _xsd_alphabet_ (_xsd_phoneme._xsd_alphabet_,
                    f | ::xml_schema::parser::flags::not_root,
                    this)
    {
    }

    phoneme::
    phoneme (const ::xercesc::DOMElement& e,
             ::xml_schema::parser::flags f,
             ::xml_schema::parser::type* c)
    : ::xml_schema::parser::type (e, f, c),
    _xsd_prefer_ (f | ::xml_schema::parser::flags::not_root, this),
    _xsd_alphabet_ (f | ::xml_schema::parser::flags::not_root, this)
    {
      parse (e, f);
    }

    void phoneme::
    parse (const ::xercesc::DOMElement& e, ::xml_schema::parser::flags f)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e);

      while (p.more_attributes ())
      {
        const ::xsd::cxx::xml::dom::attribute< char > a (p.next_attribute ());

        if (a.name () == "prefer" && a.namespace_ ().empty ())
        {
          ::std::auto_ptr< prefer::type > r (
            prefer::traits::create (
              a.dom_attribute (),
              f | ::xml_schema::parser::flags::not_root,
              this));

          this->prefer (r);
          continue;
        }

        if (a.name () == "alphabet" && a.namespace_ ().empty ())
        {
          ::std::auto_ptr< alphabet::type > r (
            alphabet::traits::create (
              a.dom_attribute (),
              f | ::xml_schema::parser::flags::not_root,
              this));

          this->alphabet (r);
          continue;
        }
      }
    }

    phoneme* phoneme::
    _clone (::xml_schema::parser::flags f,
            ::xml_schema::parser::type* c) const
    {
      return new phoneme (*this, f, c);
    }

    // alias
    //

    alias::
    alias ()
    : ::xml_schema::parser::type (),
    _xsd_prefer_ (::xml_schema::parser::flags (), this)
    {
    }

    alias::
    alias (const alias& _xsd_alias,
           ::xml_schema::parser::flags f,
           ::xml_schema::parser::type* c)
    : ::xml_schema::parser::type (_xsd_alias, f, c),
    _xsd_prefer_ (_xsd_alias._xsd_prefer_,
                  f | ::xml_schema::parser::flags::not_root,
                  this)
    {
    }

    alias::
    alias (const ::xercesc::DOMElement& e,
           ::xml_schema::parser::flags f,
           ::xml_schema::parser::type* c)
    : ::xml_schema::parser::type (e, f, c),
    _xsd_prefer_ (f | ::xml_schema::parser::flags::not_root, this)
    {
      parse (e, f);
    }

    void alias::
    parse (const ::xercesc::DOMElement& e, ::xml_schema::parser::flags f)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e);

      while (p.more_attributes ())
      {
        const ::xsd::cxx::xml::dom::attribute< char > a (p.next_attribute ());

        if (a.name () == "prefer" && a.namespace_ ().empty ())
        {
          ::std::auto_ptr< prefer::type > r (
            prefer::traits::create (
              a.dom_attribute (),
              f | ::xml_schema::parser::flags::not_root,
              this));

          this->prefer (r);
          continue;
        }
      }
    }

    alias* alias::
    _clone (::xml_schema::parser::flags f,
            ::xml_schema::parser::type* c) const
    {
      return new alias (*this, f, c);
    }

    // version
    //

    version::
    version (const ::xercesc::DOMElement& e,
             ::xml_schema::parser::flags f,
             ::xml_schema::parser::type* c)
    : ::xml_schema::parser::token (e, f, c)
    {
      _xsd_version_convert ();
    }

    version::
    version (const ::xercesc::DOMAttr& a,
             ::xml_schema::parser::flags f,
             ::xml_schema::parser::type* c)
    : ::xml_schema::parser::token (a, f, c)
    {
      _xsd_version_convert ();
    }

    version::
    version (const ::std::basic_string< char >& s,
             const ::xercesc::DOMElement* e,
             ::xml_schema::parser::flags f,
             ::xml_schema::parser::type* c)
    : ::xml_schema::parser::token (s, e, f, c)
    {
      _xsd_version_convert ();
    }

    version* version::
    _clone (::xml_schema::parser::flags f,
            ::xml_schema::parser::type* c) const
    {
      return new version (*this, f, c);
    }

    version::_xsd_version version::
    _xsd_version_convert () const
    {
      ::xsd::cxx::tree::enum_comparator< char > c (_xsd_version_literals_);
      const _xsd_version* i (::std::lower_bound (
                               _xsd_version_indexes_,
                               _xsd_version_indexes_ + 1,
                               *this,
                               c));

      if (i == _xsd_version_indexes_ + 1 || _xsd_version_literals_[*i] != *this)
      {
        throw ::xsd::cxx::tree::unexpected_enumerator < char > (*this);
      }

      return *i;
    }

    const char* const version::
    _xsd_version_literals_[1] =
    {
      "1.0"
    };

    const version::_xsd_version version::
    _xsd_version_indexes_[1] =
    {
      ::pls::parser::version::cxx_1_0
    };

    // role
    //

    role::
    role (const _xsd_role::base_& _xsd_role)
    : ::pls::parser::role_type (_xsd_role)
    {
    }

    role::
    role (const role& _xsd_role,
          ::xml_schema::parser::flags f,
          ::xml_schema::parser::type* c)
    : ::pls::parser::role_type (_xsd_role, f, c)
    {
    }

    role::
    role (const ::xercesc::DOMElement& e,
          ::xml_schema::parser::flags f,
          ::xml_schema::parser::type* c)
    : ::pls::parser::role_type (e, f, c)
    {
    }

    role::
    role (const ::xercesc::DOMAttr& a,
          ::xml_schema::parser::flags f,
          ::xml_schema::parser::type* c)
    : ::pls::parser::role_type (a, f, c)
    {
    }

    role::
    role (const ::std::basic_string< char >& s,
          const ::xercesc::DOMElement* e,
          ::xml_schema::parser::flags f,
          ::xml_schema::parser::type* c)
    : ::pls::parser::role_type (s, e, f, c)
    {
    }

    role* role::
    _clone (::xml_schema::parser::flags f,
            ::xml_schema::parser::type* c) const
    {
      return new role (*this, f, c);
    }

    // alphabet1
    //

    alphabet1::
    alphabet1 (const _xsd_alphabet1::base_& _xsd_alphabet1)
    : ::xml_schema::parser::string (_xsd_alphabet1)
    {
    }

    alphabet1::
    alphabet1 (const alphabet1& _xsd_alphabet1,
               ::xml_schema::parser::flags f,
               ::xml_schema::parser::type* c)
    : ::xml_schema::parser::string (_xsd_alphabet1, f, c)
    {
    }

    alphabet1::
    alphabet1 (const ::xercesc::DOMElement& e,
               ::xml_schema::parser::flags f,
               ::xml_schema::parser::type* c)
    : ::xml_schema::parser::string (e, f, c)
    {
    }

    alphabet1::
    alphabet1 (const ::xercesc::DOMAttr& a,
               ::xml_schema::parser::flags f,
               ::xml_schema::parser::type* c)
    : ::xml_schema::parser::string (a, f, c)
    {
    }

    alphabet1::
    alphabet1 (const ::std::basic_string< char >& s,
               const ::xercesc::DOMElement* e,
               ::xml_schema::parser::flags f,
               ::xml_schema::parser::type* c)
    : ::xml_schema::parser::string (s, e, f, c)
    {
    }

    alphabet1* alphabet1::
    _clone (::xml_schema::parser::flags f,
            ::xml_schema::parser::type* c) const
    {
      return new alphabet1 (*this, f, c);
    }
  }
}

#include <istream>
#include <xercesc/framework/Wrapper4InputSource.hpp>
#include <xsd/cxx/xml/sax/std-input-source.hxx>
#include <xsd/cxx/tree/error-handler.hxx>

namespace pls
{
  namespace parser
  {
    ::std::auto_ptr< ::pls::parser::lexicon >
    lexicon_ (const ::std::basic_string< char >& u,
              ::xml_schema::parser::flags f,
              const ::xsd::cxx::tree::properties< char >& p)
    {
      ::xsd::cxx::xml::auto_initializer i (
        (f & ::xml_schema::parser::flags::dont_initialize) == 0,
        (f & ::xml_schema::parser::flags::keep_dom) == 0);

      ::xsd::cxx::tree::error_handler< char > h;

      ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
        ::xsd::cxx::xml::dom::parse< char > (u, h, p, f));

      h.throw_if_failed< ::xsd::cxx::tree::parsing< char > > ();

      return ::pls::parser::lexicon_ (
        static_cast< const ::xercesc::DOMDocument& > (*d), f);
    }

    ::std::auto_ptr< ::pls::parser::lexicon >
    lexicon_ (const ::std::basic_string< char >& u,
              ::xsd::cxx::xml::error_handler< char >& h,
              ::xml_schema::parser::flags f,
              const ::xsd::cxx::tree::properties< char >& p)
    {
      ::xsd::cxx::xml::auto_initializer i (
        (f & ::xml_schema::parser::flags::dont_initialize) == 0,
        (f & ::xml_schema::parser::flags::keep_dom) == 0);

      ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
        ::xsd::cxx::xml::dom::parse< char > (u, h, p, f));

      if (!d)
      {
        throw ::xsd::cxx::tree::parsing< char > ();
      }

      return ::pls::parser::lexicon_ (
        static_cast< const ::xercesc::DOMDocument& > (*d), f);
    }

    ::std::auto_ptr< ::pls::parser::lexicon >
    lexicon_ (const ::std::basic_string< char >& u,
              ::xercesc::DOMErrorHandler& h,
              ::xml_schema::parser::flags f,
              const ::xsd::cxx::tree::properties< char >& p)
    {
      ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
        ::xsd::cxx::xml::dom::parse< char > (u, h, p, f));

      if (!d)
      {
        throw ::xsd::cxx::tree::parsing< char > ();
      }

      return ::pls::parser::lexicon_ (
        static_cast< const ::xercesc::DOMDocument& > (*d), f);
    }

    ::std::auto_ptr< ::pls::parser::lexicon >
    lexicon_ (::std::istream& is,
              ::xml_schema::parser::flags f,
              const ::xsd::cxx::tree::properties< char >& p)
    {
      ::xsd::cxx::xml::auto_initializer i (
        (f & ::xml_schema::parser::flags::dont_initialize) == 0,
        (f & ::xml_schema::parser::flags::keep_dom) == 0);

      ::xsd::cxx::xml::sax::std_input_source isrc (is);
      ::xercesc::Wrapper4InputSource wrap (&isrc, false);
      return ::pls::parser::lexicon_ (wrap, f, p);
    }

    ::std::auto_ptr< ::pls::parser::lexicon >
    lexicon_ (::std::istream& is,
              ::xsd::cxx::xml::error_handler< char >& h,
              ::xml_schema::parser::flags f,
              const ::xsd::cxx::tree::properties< char >& p)
    {
      ::xsd::cxx::xml::auto_initializer i (
        (f & ::xml_schema::parser::flags::dont_initialize) == 0,
        (f & ::xml_schema::parser::flags::keep_dom) == 0);

      ::xsd::cxx::xml::sax::std_input_source isrc (is);
      ::xercesc::Wrapper4InputSource wrap (&isrc, false);
      return ::pls::parser::lexicon_ (wrap, h, f, p);
    }

    ::std::auto_ptr< ::pls::parser::lexicon >
    lexicon_ (::std::istream& is,
              ::xercesc::DOMErrorHandler& h,
              ::xml_schema::parser::flags f,
              const ::xsd::cxx::tree::properties< char >& p)
    {
      ::xsd::cxx::xml::sax::std_input_source isrc (is);
      ::xercesc::Wrapper4InputSource wrap (&isrc, false);
      return ::pls::parser::lexicon_ (wrap, h, f, p);
    }

    ::std::auto_ptr< ::pls::parser::lexicon >
    lexicon_ (::std::istream& is,
              const ::std::basic_string< char >& sid,
              ::xml_schema::parser::flags f,
              const ::xsd::cxx::tree::properties< char >& p)
    {
      ::xsd::cxx::xml::auto_initializer i (
        (f & ::xml_schema::parser::flags::dont_initialize) == 0,
        (f & ::xml_schema::parser::flags::keep_dom) == 0);

      ::xsd::cxx::xml::sax::std_input_source isrc (is, sid);
      ::xercesc::Wrapper4InputSource wrap (&isrc, false);
      return ::pls::parser::lexicon_ (wrap, f, p);
    }

    ::std::auto_ptr< ::pls::parser::lexicon >
    lexicon_ (::std::istream& is,
              const ::std::basic_string< char >& sid,
              ::xsd::cxx::xml::error_handler< char >& h,
              ::xml_schema::parser::flags f,
              const ::xsd::cxx::tree::properties< char >& p)
    {
      ::xsd::cxx::xml::auto_initializer i (
        (f & ::xml_schema::parser::flags::dont_initialize) == 0,
        (f & ::xml_schema::parser::flags::keep_dom) == 0);

      ::xsd::cxx::xml::sax::std_input_source isrc (is, sid);
      ::xercesc::Wrapper4InputSource wrap (&isrc, false);
      return ::pls::parser::lexicon_ (wrap, h, f, p);
    }

    ::std::auto_ptr< ::pls::parser::lexicon >
    lexicon_ (::std::istream& is,
              const ::std::basic_string< char >& sid,
              ::xercesc::DOMErrorHandler& h,
              ::xml_schema::parser::flags f,
              const ::xsd::cxx::tree::properties< char >& p)
    {
      ::xsd::cxx::xml::sax::std_input_source isrc (is, sid);
      ::xercesc::Wrapper4InputSource wrap (&isrc, false);
      return ::pls::parser::lexicon_ (wrap, h, f, p);
    }

    ::std::auto_ptr< ::pls::parser::lexicon >
    lexicon_ (const ::xercesc::DOMInputSource& i,
              ::xml_schema::parser::flags f,
              const ::xsd::cxx::tree::properties< char >& p)
    {
      ::xsd::cxx::tree::error_handler< char > h;

      ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
        ::xsd::cxx::xml::dom::parse< char > (i, h, p, f));

      h.throw_if_failed< ::xsd::cxx::tree::parsing< char > > ();

      return ::pls::parser::lexicon_ (
        static_cast< const ::xercesc::DOMDocument& > (*d), f, p);
    }

    ::std::auto_ptr< ::pls::parser::lexicon >
    lexicon_ (const ::xercesc::DOMInputSource& i,
              ::xsd::cxx::xml::error_handler< char >& h,
              ::xml_schema::parser::flags f,
              const ::xsd::cxx::tree::properties< char >& p)
    {
      ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
        ::xsd::cxx::xml::dom::parse< char > (i, h, p, f));

      if (!d)
      {
        throw ::xsd::cxx::tree::parsing< char > ();
      }

      return ::pls::parser::lexicon_ (
        static_cast< const ::xercesc::DOMDocument& > (*d), f, p);
    }

    ::std::auto_ptr< ::pls::parser::lexicon >
    lexicon_ (const ::xercesc::DOMInputSource& i,
              ::xercesc::DOMErrorHandler& h,
              ::xml_schema::parser::flags f,
              const ::xsd::cxx::tree::properties< char >& p)
    {
      ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
        ::xsd::cxx::xml::dom::parse< char > (i, h, p, f));

      if (!d)
      {
        throw ::xsd::cxx::tree::parsing< char > ();
      }

      return ::pls::parser::lexicon_ (
        static_cast< const ::xercesc::DOMDocument& > (*d), f, p);
    }

    ::std::auto_ptr< ::pls::parser::lexicon >
    lexicon_ (const ::xercesc::DOMDocument& d,
              ::xml_schema::parser::flags f,
              const ::xsd::cxx::tree::properties< char >&)
    {
      ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > c (
        (f & ::xml_schema::parser::flags::keep_dom) 
        ? static_cast< ::xercesc::DOMDocument* > (d.cloneNode (true))
        : 0);

      const ::xsd::cxx::xml::dom::element< char > e (
        c.get ()
        ? *c->getDocumentElement ()
        : *d.getDocumentElement ());

      if (e.name () == "lexicon" &&
          e.namespace_ () == "http://www.w3.org/2005/01/pronunciation-lexicon")
      {
        ::std::auto_ptr< ::pls::parser::lexicon > r (
          ::xsd::cxx::tree::traits< ::pls::parser::lexicon, char >::create (
            e.dom_element (), f, 0));
        if (f & ::xml_schema::parser::flags::keep_dom) c.release ();
        return r;
      }

      throw ::xsd::cxx::tree::unexpected_element < char > (
        e.name (),
        e.namespace_ (),
        "lexicon",
        "http://www.w3.org/2005/01/pronunciation-lexicon");
    }
  }
}

#include <xsd/cxx/post.hxx>

// Begin epilogue.
//
//
// End epilogue.

