# -*- coding: UTF-8 -*-

# $Id$
#=============================================================================
#
#  @file    kanatable.py
#
#  @author Fukasawa Mitsuo
#
#
#    Copyright (C) 2006 BEE Co.,Ltd. All rights reserved.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#=============================================================================

import getopt, sys, string, os, shutil

#
# kana converter
#
kanatable = [
  [u'\u3042', u'\u30a2'], ### [u"あ", u"ア"],
  [u"い", u"イ"], [u"う", u"ウ"], [u"え", u"エ"], [u"お", u"オ"],
  [u"か", u"カ"], [u"き", u"キ"], [u"く", u"ク"], [u"け", u"ケ"], [u"こ", u"コ"],
  [u"さ", u"サ"], [u"し", u"シ"], [u"す", u"ス"], [u"せ", u"セ"], [u"そ", u"ソ"],
  [u"た", u"タ"], [u"ち", u"チ"], [u"つ", u"ツ"], [u"て", u"テ"], [u"と", u"ト"],
  [u"な", u"ナ"], [u"に", u"ニ"], [u"ぬ", u"ヌ"], [u"ね", u"ネ"], [u"の", u"ノ"],
  [u"は", u"ハ"], [u"ひ", u"ヒ"], [u"ふ", u"フ"], [u"へ", u"ヘ"], [u"ほ", u"ホ"],
  [u"ま", u"マ"], [u"み", u"ミ"], [u"む", u"ム"], [u"め", u"メ"], [u"も", u"モ"],
  [u"や", u"ヤ"], [u"ゆ", u"ユ"], [u"よ", u"ヨ"],
  [u"ら", u"ラ"], [u"り", u"リ"], [u"る", u"ル"], [u"れ", u"レ"], [u"ろ", u"ロ"],
  [u"わ", u"ワ"], [u"を", u"ヲ"], [u"ん", u"ン"],
  [u"が", u"ガ"], [u"ぎ", u"ギ"], [u"ぐ", u"グ"], [u"げ", u"ゲ"], [u"ご", u"ゴ"],
  [u"ざ", u"ザ"], [u"じ", u"ジ"], [u"ず", u"ズ"], [u"ぜ", u"ゼ"], [u"ぞ", u"ゾ"],
  [u"だ", u"ダ"], [u"ぢ", u"ヂ"], [u"づ", u"ヅ"], [u"で", u"デ"], [u"ど", u"ド"],
  [u"ば", u"バ"], [u"び", u"ビ"], [u"ぶ", u"ブ"], [u"べ", u"ベ"], [u"ぼ", u"ボ"],
  [u"ぱ", u"パ"], [u"ぴ", u"ピ"], [u"ぷ", u"プ"], [u"ぺ", u"ペ"], [u"ぽ", u"ポ"],
  [u"ぁ", u"ァ"], [u"ぃ", u"ィ"], [u"ヴ", u"ヴ"], [u"ぇ", u"ェ"], [u"ぉ", u"ォ"],
  [u"っ", u"ッ"],
  [u"ゃ", u"ャ"], [u"ゅ", u"ュ"], [u"ょ", u"ョ"],
]

alphabet = {
  "a": u'\u30a2',  ### "a": u"ア",
  "i": u"イ",
  "u": u"ウ",
  "e": u"エ",
  "o": u"オ",
  "ka": u"カ",
  "ki": u"キ",
  "ku": u"ク",
  "ke": u"ケ",
  "ko": u"コ",
  "sa": u"サ",
  "si": u"シ",
  "su": u"ス",
  "se": u"セ",
  "so": u"ソ",
  "ta": u"タ",
  "ti": u"チ",
  "tu": u"ツ",
  "tsu": u"ツ",
  "te": u"テ",
  "to": u"ト",
  "na": u"ナ",
  "ni": u"ニ",
  "nu": u"ヌ",
  "ne": u"ネ",
  "no": u"ノ",
  "ha": u"ハ",
  "hi": u"ヒ",
  "hu": u"フ",
  "he": u"ヘ",
  "ho": u"ホ",
  "ma": u"マ",
  "mi": u"ミ",
  "mu": u"ム",
  "me": u"メ",
  "mo": u"モ",
  "ya": u"ヤ",
  "yu": u"ユ",
  "yo": u"ヨ",
  "ra": u"ラ",
  "ri": u"リ",
  "ru": u"ル",
  "re": u"レ",
  "ro": u"ロ",
  "wa": u"ワ",
  "wo": u"ヲ",
  "N":  u"ン",
  "ga": u"ガ",
  "gi": u"ギ",
  "gu": u"グ",
  "ge": u"ゲ",
  "go": u"ゴ",
  "za": u"ザ",
  "zi": u"ジ",
  "zu": u"ズ",
  "ze": u"ゼ",
  "zo": u"ゾ",
  "da": u"ダ",
  "di": u"ヂ",
  "du": u"ヅ",
  "de": u"デ",
  "do": u"ド",
  "ba": u"バ", 
  "bi": u"ビ",
  "bu": u"ブ",
  "be": u"ベ",
  "bo": u"ボ",
  "pa": u"パ",
  "pi": u"ピ",
  "pu": u"プ",
  "pe": u"ペ",
  "po": u"ポ",
  "fa": u"ファ",
  "fi": u"フィ",
  "fu": u"フ",
  "fe": u"フェ",
  "fo": u"フォ",
  "ja": u"ジャ",
  "ji": u"ジ",
  "ju": u"ジュ",
  "je": u"ジェ",
  "jo": u"ジョ",
  "bya" : u"ビャ",
  "byi" : u"ビ",
  "byu" : u"ビュ",
  "bye" : u"ビェ",
  "byo" : u"ビョ",
  "cha" : u"チャ",
  "chi" : u"チ",
  "chu" : u"チュ",
  "che" : u"チェ",
  "cho" : u"チョ",
  "gya" : u"ギャ",
  "gyi" : u"ギ",
  "gyu" : u"ギュ",
  "gye" : u"ギェ",
  "gyo" : u"ギョ",
  "kya" : u"キャ",
  "kyi" : u"キ",
  "kyu" : u"キュ",
  "kye" : u"キェ",
  "kyo" : u"キョ",
  "hya" : u"ヒャ",
  "hyi" : u"ヒ",
  "hyu" : u"ヒュ",
  "hye" : u"ヒェ",
  "hyo" : u"ヒョ",
  "mya" : u"ミャ",
  "myi" : u"ミ",
  "myu" : u"ミュ",
  "mye" : u"ミェ",
  "myo" : u"ミョ",
  "nya" : u"ニャ",
  "nyi" : u"ニ",
  "nyu" : u"ニュ",
  "nye" : u"ニェ",
  "nyo" : u"ニョ",
  "rya" : u"リャ",
  "ryi" : u"リ",
  "ryu" : u"リュ",
  "rye" : u"リェ",
  "ryo" : u"リョ",
  "sha" : u"シャ",
  "shi" : u"シ",
  "shu" : u"シュ",
  "she" : u"シェ",
  "sho" : u"ショ",
  "sya" : u"シャ",
  "syi" : u"シ",
  "syu" : u"シュ",
  "sye" : u"シェ",
  "syo" : u"ショ",
  "tya" : u"チャ",
  "tyi" : u"チ",
  "tyu" : u"チュ",
  "tye" : u"チェ",
  "tyo" : u"チョ",
  "q":    u"ッ",
  ":":    u"ー",
}

def kata_to_hira(katakana):
    for c in kanatable:
        if c[1] == katakana:
            return c[0]
    return u"？"


def alphabet_to_kana(phoneme):
    last = ''
    k = u""
    for c in phoneme.split(' '):
        if c == 'N':
            last = ''
            k += u"ン"
        elif c == 'q':
            last = ''
            k += u"ッ"
        elif c in ('a', 'i', 'u', 'e', 'o'):
            last += c
            k += alphabet[last]
            last = ""
        elif c in ('a:', 'i:', 'u:', 'e:', 'o:'):
            last += c[0]
            k += alphabet[last]
            k += u"ー"
            last = ""
        else:
            last = c
    return k


def kana_compare(kana, phoneme):
    k = alphabet_to_kana(phoneme)
    if kana == k:
        return True
    # print kana + ":" + k + "(" + phoneme + ")"
    return False

