/* 
 This file was generated by Dashcode and is covered by the 
 license.txt included in the project.  You may edit this file, 
 however it is recommended to first turn off the Dashcode 
 code generator otherwise the changes will be lost.
 */

// Note: Properties and methods beginning with underbar ("_") are considered private and subject to change in future Dashcode releases.

function CreatePopupButton(elementOrID, spec)
{
    var popupElement = elementOrID;
    if (elementOrID.nodeType != Node.ELEMENT_NODE) {
        popupElement = document.getElementById(elementOrID);
    }
    if (!popupElement.loaded) {
        popupElement.loaded = true;
        popupElement.object = new PopupButton(popupElement, spec);
        return popupElement.object;
    }
}


function PopupButton(popupElement, spec)
{
	var leftImageWidth = spec.leftImageWidth || 0;
	var rightImageWidth = spec.rightImageWidth || 0;
    // when cloning template, get size from original
    var styleElement = popupElement;
    if (spec.originalID) {
        styleElement = document.getElementById(spec.originalID);
    }
    var imagePrefix = "Images/" + styleElement.id + "_";
    var width = dashcode.getElementWidth(styleElement) || 20;
	var height = dashcode.getElementHeight(styleElement) || 20;
	var _self = this;

    this.element = popupElement;
    
	// setup the button
    while (popupElement.firstChild) {
        popupElement.removeChild(popupElement.firstChild);
    }
	this.button = new AppleButton(popupElement, '', height, imagePrefix + "left.png", imagePrefix + "left_clicked.png", leftImageWidth, imagePrefix + "middle.png", imagePrefix + "middle_clicked.png", imagePrefix + "right.png", imagePrefix + "right_clicked.png", rightImageWidth, null);
	this.button._container.childNodes.item(2).style.width = rightImageWidth + "px";
	this.button.textElement.style.width = (width - (leftImageWidth + rightImageWidth)) + "px";
	this.button.textElement.style.textIndent = Math.max(10-leftImageWidth, 0) + "px";
	var eventsDiv = document.createElement("div");
	eventsDiv.setAttribute("style", "position: absolute; left: 0; top: 0; width: 100%; height: 100%");
	popupElement.appendChild(eventsDiv);
	var clickHandler = function(event) {
		_self.select.dispatchEvent(event);
		event.stopPropagation();
		event.preventDefault();
	}
	eventsDiv.addEventListener("mousedown", clickHandler, true);


	// setup the select
	this.select = document.createElement("select");
	var onchange = spec.onchange || null;
	try { onchange = eval(onchange); } catch (e) { onchange = null; }
	this.onchange = onchange;
    if (spec.name) {
        this.select.name = spec.name;
    }
	this._setOptions(spec.options);
	this.select.setAttribute("style", "position: absolute; left: 0; top: 0; width: 100%; height: 100%; opacity: 0;");
	popupElement.appendChild(this.select);
	this.select.style.top = Math.max((height - dashcode.getElementHeight(this.select)) / 2, 0) + "px";

	// onchange event handler
	this.select.onchange = function (event) {
		var selectedOption = this.options[this.selectedIndex];
		if (selectedOption) {
			_self.button.textElement.innerText = selectedOption.text;
			// if it is a real event, forward it to the custom handler
			if (_self.onchange && event) {
				_self.onchange(event);
			}
		}
	};

	this.setEnabled(!spec.disabled);
}

PopupButton.prototype.getValue = function()
{
	return this.select.value;
}

PopupButton.prototype.getSelectedIndex = function()
{
	return this.select.selectedIndex;
}

PopupButton.prototype.setSelectedIndex = function(index)
{
	this.select.selectedIndex = index;
	this.select.onchange(null);
}

PopupButton.prototype.getName = function()
{
	return this.select.name;
}

PopupButton.prototype.setName = function(name)
{
	this.select.name = name;
}

PopupButton.prototype.setEnabled = function(enabled)
{
	this.button.setEnabled(enabled);
	this.select.disabled=!enabled;
}

PopupButton.prototype.setOptions = function(options, shouldLocalize)
{
	if (!options || !(options instanceof Array)) options = [];
	var text = '';

	this.select.options.length = 0;
	for (var i = 0; i < options.length; i++) {
		var defaultSelected = false;
		var optionLabel = '';
		var optionValue = null;
		if ((options[i]) instanceof Array) {
			if (options[i].length > 0) {
				optionLabel = options[i][0];
				if (options[i].length > 1) {
					optionValue = options[i][1];
					if (options[i].length > 2 && options[i][2]) {
						defaultSelected = true;
					}
				}
			}
		}
		else {
			optionLabel = options[i];
		}
		
		if (shouldLocalize) {
			optionLabel = dashcode.getLocalizedString(optionLabel);
		}
		if (i==0 || defaultSelected) {
			text = optionLabel;
		}
		if (!optionValue || optionValue.length == 0) {
			optionValue = optionLabel;
		}
        
		this.select.options[this.select.length] = new Option(optionLabel, optionValue, defaultSelected);
	}
	this.button.textElement.innerText = text;
}

PopupButton.prototype._setOptions = function(options)
{
	this.setOptions(options, true);
}
