/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DropTargetEffect;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.win32.LVHITTESTINFO;
import org.eclipse.swt.internal.win32.LVINSERTMARK;
import org.eclipse.swt.internal.win32.LVITEM;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class TableDropTargetEffect
extends DropTargetEffect {
    static final int SCROLL_HYSTERESIS = 200;
    int scrollIndex = -1;
    long scrollBeginTime;
    TableItem dropHighlight;
    int iItemInsert = -1;

    public TableDropTargetEffect(Table table) {
        super(table);
    }

    int checkEffect(int n) {
        if ((n & 1) != 0) {
            n = n & 0xFFFFFFFB & 0xFFFFFFFD;
        }
        if ((n & 2) != 0) {
            n &= 0xFFFFFFFB;
        }
        return n;
    }

    @Override
    public void dragEnter(DropTargetEvent dropTargetEvent) {
        this.scrollBeginTime = 0L;
        this.scrollIndex = -1;
        this.dropHighlight = null;
        this.iItemInsert = -1;
    }

    @Override
    public void dragLeave(DropTargetEvent dropTargetEvent) {
        Object object;
        Table table = (Table)this.control;
        int n = table.handle;
        if (this.dropHighlight != null) {
            object = new LVITEM();
            ((LVITEM)object).stateMask = 8;
            OS.SendMessage(n, 4139, -1, (LVITEM)object);
            this.dropHighlight = null;
        }
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(5, 1) && this.iItemInsert != -1) {
            object = new LVINSERTMARK();
            ((LVINSERTMARK)object).cbSize = LVINSERTMARK.sizeof;
            ((LVINSERTMARK)object).iItem = -1;
            OS.SendMessage(n, 4262, 0, (LVINSERTMARK)object);
            this.iItemInsert = -1;
        }
        this.scrollBeginTime = 0L;
        this.scrollIndex = -1;
    }

    @Override
    public void dragOver(DropTargetEvent dropTargetEvent) {
        Table table = (Table)this.getControl();
        int n = this.checkEffect(dropTargetEvent.feedback);
        int n2 = table.handle;
        Point point = new Point(dropTargetEvent.x, dropTargetEvent.y);
        point = DPIUtil.autoScaleUp(table.toControl(point));
        LVHITTESTINFO lVHITTESTINFO = new LVHITTESTINFO();
        lVHITTESTINFO.x = point.x;
        lVHITTESTINFO.y = point.y;
        OS.SendMessage(n2, 4114, 0, lVHITTESTINFO);
        if ((n & 8) == 0) {
            this.scrollBeginTime = 0L;
            this.scrollIndex = -1;
        } else if (lVHITTESTINFO.iItem != -1 && this.scrollIndex == lVHITTESTINFO.iItem && this.scrollBeginTime != 0L) {
            if (System.currentTimeMillis() >= this.scrollBeginTime) {
                int n3 = Math.max(0, OS.SendMessage(n2, 4135, 0, 0));
                int n4 = OS.SendMessage(n2, 4100, 0, 0);
                int n5 = this.scrollIndex - 1 < n3 ? Math.max(0, this.scrollIndex - 1) : Math.min(n4 - 1, this.scrollIndex + 1);
                boolean bl = true;
                if (lVHITTESTINFO.iItem == n3) {
                    bl = lVHITTESTINFO.iItem != n5;
                } else {
                    RECT rECT = new RECT();
                    rECT.left = 0;
                    if (OS.SendMessage(n2, 4110, lVHITTESTINFO.iItem, rECT) != 0) {
                        RECT rECT2 = new RECT();
                        OS.GetClientRect(n2, rECT2);
                        POINT pOINT = new POINT();
                        pOINT.x = rECT.left;
                        pOINT.y = rECT.top;
                        if (OS.PtInRect(rECT2, pOINT)) {
                            pOINT.y = rECT.bottom;
                            if (OS.PtInRect(rECT2, pOINT)) {
                                bl = false;
                            }
                        }
                    }
                }
                if (bl) {
                    OS.SendMessage(n2, 4115, n5, 0);
                    table.redraw();
                }
                this.scrollBeginTime = 0L;
                this.scrollIndex = -1;
            }
        } else {
            this.scrollBeginTime = System.currentTimeMillis() + 200L;
            this.scrollIndex = lVHITTESTINFO.iItem;
        }
        if (lVHITTESTINFO.iItem != -1 && (n & 1) != 0) {
            TableItem tableItem = table.getItem(lVHITTESTINFO.iItem);
            if (this.dropHighlight != tableItem) {
                LVITEM lVITEM = new LVITEM();
                lVITEM.stateMask = 8;
                OS.SendMessage(n2, 4139, -1, lVITEM);
                lVITEM.state = 8;
                OS.SendMessage(n2, 4139, lVHITTESTINFO.iItem, lVITEM);
                this.dropHighlight = tableItem;
            }
        } else if (this.dropHighlight != null) {
            LVITEM lVITEM = new LVITEM();
            lVITEM.stateMask = 8;
            OS.SendMessage(n2, 4139, -1, lVITEM);
            this.dropHighlight = null;
        }
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(5, 1)) {
            if (lVHITTESTINFO.iItem != -1 && (n & 6) != 0) {
                LVINSERTMARK lVINSERTMARK = new LVINSERTMARK();
                lVINSERTMARK.cbSize = LVINSERTMARK.sizeof;
                lVINSERTMARK.dwFlags = (n & 4) != 0 ? 1 : 0;
                lVINSERTMARK.iItem = lVHITTESTINFO.iItem;
                if (OS.SendMessage(n2, 4262, 0, lVINSERTMARK) != 0) {
                    this.iItemInsert = lVHITTESTINFO.iItem;
                }
            } else if (this.iItemInsert != -1) {
                LVINSERTMARK lVINSERTMARK = new LVINSERTMARK();
                lVINSERTMARK.cbSize = LVINSERTMARK.sizeof;
                lVINSERTMARK.iItem = -1;
                OS.SendMessage(n2, 4262, 0, lVINSERTMARK);
                this.iItemInsert = -1;
            }
        }
    }
}

