/*
 * Decompiled with CFR 0.152.
 */
package saccubus.net;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import javax.swing.JLabel;
import saccubus.ConvertStopFlag;
import saccubus.WayBackDate;
import saccubus.conv.ChatSave;
import saccubus.net.BrowserInfo;
import saccubus.net.NicoMap;
import saccubus.net.Path;
import saccubus.util.Stopwatch;

public class NicoClient {
    private final String User;
    private final String Pass;
    private boolean Logged_in = false;
    private final Proxy ConProxy;
    boolean Debug = false;
    private final NicoMap nicomap;
    private Stopwatch Stopwatch;
    private Path titleHtml = null;
    public static final String DEBUG_PROXY = "debug";
    private String Cookie = null;
    private static Pattern safeFileName_SPACE = Pattern.compile(" {2}+");
    private String VideoTitle = null;
    private int VideoLength = -1;
    private static final String TITLE_PARSE_STR_START = "<title>";
    private static final String TITLE_END = "\u2010";
    private static final String TITLE_ZERO_DIV = "id=\"videoHeaderDetail\"";
    private static final String TITLE_ZERO_DUMMY = "<title>\u30cb\u30b3\u30cb\u30b3\u52d5\u753b:Zero</title>";
    private static final String TITLE_GINZA_DIV = "DataContainer\"";
    private static final String TITLE_GINZA_DUMMY = "<title>\u30cb\u30b3\u30cb\u30b3\u52d5\u753b:GINZA</title>";
    private boolean NeedsKey = false;
    private String Premium = "";
    private String OptionalThraedID = "";
    private boolean economy = false;
    private String ownerFilter = "";
    private byte[] buf = new byte[0x100000];
    private String VideoUrl = null;
    private String ContentType = null;
    private String ContentDisp;
    private String UserID = null;
    private String ThreadID = null;
    private String MsgUrl = null;
    public static final String STR_OWNER_COMMENT = "1000";
    private static final long NEW_COMMENT_BEGIN_SECOND = new WayBackDate("2010/12/22 18:00").getSecond();
    private String Official = "";
    private String threadKey = null;
    private String force184 = null;
    private String WayBackKey = "0";
    private String WayBackTime = "0";
    private String ExtraError = "";
    private boolean hasNewCommentBegun = true;
    private int dsCount = 0;
    private int dsMax;
    private int dsMin;
    private int dsSum;

    public NicoClient(String user, String pass, String proxy, int proxy_port, Stopwatch stopwatch) {
        this.User = user;
        this.Pass = pass;
        this.Stopwatch = stopwatch;
        this.nicomap = new NicoMap();
        this.ConProxy = this.conProxy(proxy, proxy_port);
        this.Logged_in = this.login();
    }

    private Proxy conProxy(String proxy, int proxy_port) {
        if (proxy != null && proxy.startsWith(DEBUG_PROXY)) {
            System.out.println("Print debug information.");
            this.Debug = true;
            proxy = proxy.substring(proxy.indexOf(47, DEBUG_PROXY.length()) + 1);
        }
        if (proxy != null && !proxy.isEmpty() && proxy_port >= 0 && proxy_port <= 65535) {
            try {
                Proxy tmpProxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxy, proxy_port));
                return tmpProxy;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.out.println("Unable to make Proxy. maybe bug.");
                return null;
            }
        }
        return Proxy.NO_PROXY;
    }

    public NicoClient(BrowserInfo.BrowserCookieKind browser_kind, String user_session, String proxy, int proxy_port, Stopwatch stopwatch) {
        this.User = "";
        this.Pass = "";
        this.Stopwatch = stopwatch;
        this.nicomap = new NicoMap();
        this.ConProxy = this.conProxy(proxy, proxy_port);
        if (user_session == null || user_session.isEmpty()) {
            System.out.println("Invalid user session" + browser_kind.toString());
            this.setExtraError("\u30bb\u30c3\u30b7\u30e7\u30f3\u3092\u53d6\u5f97\u51fa\u6765\u307e\u305b\u3093");
            this.Logged_in = false;
        } else {
            String[] sessions;
            String[] stringArray = sessions = user_session.split(" ");
            int n = sessions.length;
            int n2 = 0;
            while (n2 < n) {
                String session = stringArray[n2];
                if (session != null && !session.isEmpty()) {
                    String this_session;
                    this.Cookie = this_session = "user_session=" + session;
                    if (this.loginCheck()) {
                        this.nicomap.add("Set-Cookie", this_session);
                        this.Cookie = this.nicomap.get("Set-Cookie");
                        this.Logged_in = true;
                        return;
                    }
                    this.Cookie = "";
                    System.out.println("Fault user session" + browser_kind.toString());
                    this.setExtraError("\u30bb\u30c3\u30b7\u30e7\u30f3\u304c\u7121\u52b9\u3067\u3059");
                }
                ++n2;
            }
            this.Logged_in = false;
        }
    }

    void debug(String messege) {
        if (this.Debug) {
            System.out.print(messege);
        }
    }

    HttpURLConnection urlConnectGET(String url) {
        return this.urlConnect(url, "GET");
    }

    private HttpURLConnection urlConnect(String url, String method) {
        return this.urlConnect(url, method, this.Cookie, true, false, "close");
    }

    private HttpURLConnection urlConnect(String url, String method, String cookieProp, boolean doInput, boolean doOutput, String connectionProp) {
        return this.urlConnect(url, method, cookieProp, doInput, doOutput, connectionProp, false);
    }

    private HttpURLConnection urlConnect(String url, String method, String cookieProp, boolean doInput, boolean doOutput, String connectionProp, boolean followRedirect) {
        try {
            this.debug("\n\u25a0URL<" + url + ">\n");
            HttpURLConnection con = (HttpURLConnection)new URL(url).openConnection(this.ConProxy);
            con.setRequestMethod(method);
            con.addRequestProperty("Cookie", cookieProp);
            con.setRequestProperty("Content-Type", "text/plain; charset=UTF-8");
            if (connectionProp != null) {
                con.addRequestProperty("Connection", connectionProp);
            }
            if (doInput) {
                con.setDoInput(true);
            }
            if (doOutput) {
                con.setDoOutput(true);
            }
            HttpURLConnection.setFollowRedirects(followRedirect);
            this.connect(con);
            if (doOutput) {
                return con;
            }
            int code = con.getResponseCode();
            if (code >= 200 && code < 400) {
                this.debug("\u25a0Response:" + Integer.toString(code) + " " + con.getResponseMessage() + "\n");
                return con;
            }
            System.out.println("Error Response:" + Integer.toString(code) + " " + con.getResponseMessage());
            this.setExtraError("" + code);
            return null;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            System.out.println("Connection error. Check proxy ?");
            this.setExtraError("\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u30a8\u30e9\u30fc\u3002\u30d7\u30ed\u30ad\u30b7\u304c\u4e0d\u6b63\uff1f");
        }
        catch (IllegalStateException ex) {
            ex.printStackTrace();
            System.out.println("Connection error. Check proxy ?");
            this.setExtraError("\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u30a8\u30e9\u30fc\u3002\u30d7\u30ed\u30ad\u30b7\u304c\u4e0d\u6b63\uff1f");
        }
        return null;
    }

    private void connect(HttpURLConnection con) throws IOException {
        this.Stopwatch.show();
        this.debug("\u25a0Connect: " + con.getRequestMethod() + "," + (this.Cookie == null ? "" : "Cookie<" + con.getRequestProperty("Cookie") + ">,") + (con.getDoInput() ? "DoInput," : "") + (con.getDoOutput() ? "DoOutput," : "") + (HttpURLConnection.getFollowRedirects() ? "FollowRedirects," : "") + (con.getRequestProperty("Connection") == null ? "" : "Connection " + con.getRequestProperty("Connection")) + "\n");
        con.connect();
    }

    private String readConnection(HttpURLConnection con) {
        try {
            this.Stopwatch.show();
            BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream()));
            String ret = br.readLine();
            br.close();
            this.debug("\u25a0readLine:" + ret + "\n");
            con.disconnect();
            return ret;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return "";
        }
    }

    private String detectCookie(HttpURLConnection con) {
        this.nicomap.putConnection(con);
        if (this.Debug) {
            this.nicomap.printAll(System.out);
        }
        String cookie = this.nicomap.get("Set-Cookie");
        this.debug("\u25a0<Set-Cookie><" + cookie + ">\n");
        return cookie;
    }

    private boolean login() {
        HttpsURLConnection con;
        block4: {
            try {
                System.out.print("Trying login...");
                String url = "https://secure.nicovideo.jp/secure/login?site=niconico";
                this.debug("\n\u25a0HTTPS<" + url + ">\n");
                con = (HttpsURLConnection)new URL(url).openConnection(this.ConProxy);
                con.setDoOutput(true);
                HttpURLConnection.setFollowRedirects(false);
                con.setInstanceFollowRedirects(false);
                con.setRequestMethod("POST");
                con.addRequestProperty("Connection", "close");
                this.connect(con);
                StringBuffer sb = new StringBuffer(4096);
                sb.append("next_url=/&");
                sb.append("mail=");
                sb.append(URLEncoder.encode(this.User, "Shift_JIS"));
                sb.append("&password=");
                sb.append(URLEncoder.encode(this.Pass, "Shift_JIS"));
                sb.append("&submit.x=103&submit.y=16");
                this.debug("\u25a0write:" + sb.toString() + "\n");
                OutputStream os = con.getOutputStream();
                os.write(sb.substring(0).getBytes());
                os.flush();
                os.close();
                this.Stopwatch.show();
                this.debug("\u25a0Response:" + Integer.toString(con.getResponseCode()) + " " + con.getResponseMessage() + "\n");
                int code = con.getResponseCode();
                if (code >= 200 && code < 400) break block4;
                System.out.println("Can't login:" + con.getResponseMessage());
                return false;
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return false;
            }
        }
        this.Cookie = this.detectCookie(con);
        con.disconnect();
        if (this.Cookie == null || this.Cookie.isEmpty()) {
            System.out.println("Can't login: cannot set cookie.");
            return false;
        }
        return true;
    }

    public boolean isLoggedIn() {
        return this.Logged_in;
    }

    public String getVideoTitle() {
        return this.VideoTitle;
    }

    public static String safeFileName(String str) {
        int old_index = 0;
        int new_index = 0;
        StringBuffer sb = new StringBuffer();
        while ((new_index = str.indexOf("&#", old_index)) >= 0) {
            sb.append(str, old_index, new_index);
            old_index = str.indexOf(";", new_index);
            String ch = str.substring(new_index + 2, old_index);
            sb.append(new String(new char[]{(char)Integer.parseInt(ch)}));
            ++old_index;
        }
        sb.append(str, old_index, str.length());
        str = sb.toString();
        str = NicoClient.toSafeString(str, "MS932");
        str = str.replace('/', '\uff0f');
        str = str.replace('\\', '\uffe5');
        str = str.replace('?', '\uff1f');
        str = str.replace('*', '\uff0a');
        str = str.replace(':', '\uff1a');
        str = str.replace('|', '\uff5c');
        str = str.replace('\"', '\u201d');
        str = str.replace('<', '\uff1c');
        str = str.replace('>', '\uff1e');
        str = str.replace('.', '\uff0e');
        str = safeFileName_SPACE.matcher(str).replaceAll(" ");
        str = str.trim();
        return str;
    }

    private static String toSafeString(String str, String encoding) {
        StringBuilder sb = new StringBuilder(64);
        int i = 0;
        while (i < str.length()) {
            String s = str.substring(i, i + 1);
            byte[] b = new byte[]{45};
            int len = 1;
            try {
                b = s.getBytes(encoding);
                len = b.length;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (len == 1 && b[0] == 63) {
                b[0] = 45;
                s = "-";
            }
            sb.append(s);
            ++i;
        }
        String dest = sb.toString();
        return dest;
    }

    public boolean getVideoHistoryAndTitle(String tag, String watchInfo, boolean saveWatchPage) {
        if (this.getThumbInfoFile(tag) != null) {
            // empty if block
        }
        return this.getVideoHistoryAndTitle1(tag, watchInfo, saveWatchPage);
    }

    public boolean getVideoHistoryAndTitle1(String tag, String watchInfo, boolean saveWatchPage) {
        HttpURLConnection con;
        boolean zero_title;
        boolean found;
        String thumbTitle;
        block16: {
            thumbTitle = this.getVideoTitle();
            this.VideoTitle = null;
            found = false;
            String url = "http://www.nicovideo.jp/watch/" + tag + watchInfo;
            System.out.print("Getting video history...");
            zero_title = false;
            con = this.urlConnectGET(url);
            if (con != null && con.getResponseCode() == 200) break block16;
            System.out.println("ng.\nCan't getVideoHistory:" + url);
            return false;
        }
        try {
            String ret;
            String encoding;
            String new_cookie = this.detectCookie(con);
            if (new_cookie == null || new_cookie.isEmpty()) {
                System.out.println("ng.\nCan't getVideoHistory: cannot get cookie.");
                new_cookie = this.Cookie;
            }
            if ((encoding = con.getContentEncoding()) == null) {
                encoding = "UTF-8";
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream(), encoding));
            System.out.print("ok.\nChecking VideoTitle...");
            this.debug("\n");
            int index = -1;
            StringBuilder sb = new StringBuilder();
            while ((ret = br.readLine()) != null) {
                this.Stopwatch.show();
                sb.append(String.valueOf(ret) + "\n");
                if (found) continue;
                if (ret.contains(TITLE_ZERO_DUMMY) || ret.contains(TITLE_GINZA_DIV) || ret.contains(TITLE_GINZA_DUMMY)) {
                    zero_title = true;
                    continue;
                }
                if (ret.contains(TITLE_ZERO_DIV)) {
                    zero_title = true;
                }
                if (zero_title) {
                    if ((ret = NicoClient.getXmlElement(ret, "h2")) == null) continue;
                    String tmp = ret;
                    if (tmp.contains("span")) {
                        ret = NicoClient.getXmlElement2(tmp, "span");
                    }
                    if (ret == null) {
                        ret = tmp;
                    }
                    found = true;
                    zero_title = false;
                    if (this.getVideoTitle() == null) {
                        this.VideoTitle = NicoClient.safeFileName(ret);
                    }
                    System.out.print("<" + this.VideoTitle + ">...");
                    continue;
                }
                if (!ret.contains(TITLE_PARSE_STR_START)) continue;
                ret = NicoClient.getXmlElement(ret, "title");
                index = 0;
                int index2 = ret.lastIndexOf(TITLE_END);
                if (index2 < 0) continue;
                found = true;
                if (this.getVideoTitle() == null) {
                    this.VideoTitle = NicoClient.safeFileName(ret.substring(index, index2));
                }
                System.out.print("<" + this.VideoTitle + ">...");
            }
            br.close();
            con.disconnect();
            boolean bl = found = this.getVideoTitle() != null;
            if (!found) {
                this.VideoTitle = thumbTitle;
                boolean bl2 = found = this.getVideoTitle() != null;
            }
            if (!found || saveWatchPage) {
                this.titleHtml = Path.mkTemp(String.valueOf(tag) + "watch.htm");
                PrintWriter pw = new PrintWriter((File)this.titleHtml, encoding);
                pw.write(sb.toString());
                pw.flush();
                pw.close();
                if (!found) {
                    System.out.print(" Title not found.");
                }
                System.out.println(" <" + Path.toUnixPath(this.titleHtml) + "> saved.");
            }
            System.out.println("ok.");
            this.Cookie = new_cookie;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean getVideoInfo(String tag, String watchInfo, String time, boolean saveWatchPage) {
        block18: {
            String ret;
            String encoding;
            HttpURLConnection con;
            String url;
            block17: {
                block16: {
                    if (!this.getVideoHistoryAndTitle(tag, watchInfo, saveWatchPage)) {
                        return false;
                    }
                    try {
                        url = "http://flapi.nicovideo.jp/api/getflv/" + tag;
                        if (tag.startsWith("nm")) {
                            url = String.valueOf(url) + "?as3=1";
                        }
                        if (url.contains("?") && !watchInfo.isEmpty()) {
                            watchInfo = "&" + watchInfo.substring(1);
                        }
                        System.out.print("Getting video informations...");
                        con = this.urlConnectGET(String.valueOf(url) + watchInfo);
                        if (con != null && con.getResponseCode() == 200) break block16;
                        System.out.println("ng.\nCan't getVideoInfo:" + url + watchInfo);
                        if (this.loginCheck(con)) break block16;
                        System.out.println("Can't login.");
                        return false;
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        return false;
                    }
                }
                encoding = con.getContentEncoding();
                if (encoding == null) {
                    encoding = "UTF-8";
                }
                if ((ret = this.readConnection(con)) != null && !ret.isEmpty()) break block17;
                System.out.println("ng.\nCan't getVideoInfo: null respense.");
                return false;
            }
            this.nicomap.putArrayURLDecode(ret, encoding);
            if (this.Debug) {
                this.nicomap.printAll(System.out);
            }
            this.ThreadID = this.nicomap.get("thread_id");
            this.VideoUrl = this.nicomap.get("url");
            this.MsgUrl = this.nicomap.get("ms");
            this.UserID = this.nicomap.get("user_id");
            if (this.OptionalThraedID.isEmpty() && this.nicomap.containsKey("optional_thread_id")) {
                this.OptionalThraedID = this.nicomap.get("optional_thread_id");
            }
            if (this.nicomap.containsKey("needs_key")) {
                this.NeedsKey = true;
            }
            this.Premium = this.nicomap.get("is_premium");
            try {
                this.VideoLength = Integer.parseInt(this.nicomap.get("l"));
            }
            catch (NumberFormatException e) {
                this.VideoLength = -1;
            }
            this.ownerFilter = this.nicomap.get("ng_up");
            if (this.ThreadID != null && this.VideoUrl != null && this.MsgUrl != null && this.UserID != null) break block18;
            System.out.println("ng.\nCan't get video information keys.");
            con = this.urlConnectGET(String.valueOf(url) + watchInfo);
            if (!this.loginCheck(con)) {
                System.out.println("Can't logged In.");
            }
            return false;
        }
        this.economy = this.VideoUrl.toLowerCase().contains("low");
        System.out.println("ok.");
        System.out.println("Video:<" + this.VideoUrl + ">; Comment:<" + this.MsgUrl + (this.NeedsKey ? ">; needs_key=1" : ">"));
        System.out.println("Video time length: " + this.VideoLength + "sec");
        System.out.println("ThreadID:<" + this.ThreadID + "> Maybe uploaded on " + WayBackDate.format(this.ThreadID));
        if (this.OptionalThraedID != null && !this.OptionalThraedID.isEmpty()) {
            System.out.println("OptionalThreadID:<" + this.OptionalThraedID + ">");
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File getVideo(File file, JLabel status, ConvertStopFlag flag, boolean renameMp4) {
        try {
            HttpURLConnection con;
            System.out.print("Getting video size...");
            if (this.VideoUrl == null) {
                System.out.println("Video url is not detected.");
                return null;
            }
            if (file.canRead() && file.delete()) {
                System.out.print("previous video deleted...");
            }
            if ((con = this.urlConnect(this.VideoUrl, "GET", this.Cookie, true, false, null)) == null || con.getResponseCode() != 200) {
                System.out.println("Can't get video:" + this.VideoUrl);
                if (!"403".equals(this.getExtraError())) return null;
                this.setExtraError("=\u4e0d\u9069\u5207\u306a\u52d5\u753b\u306e\u53ef\u80fd\u6027\u3002readmeNew.txt\u53c2\u7167");
                return null;
            }
            InputStream is = con.getInputStream();
            if (this.Debug) {
                NicoMap videoMap = new NicoMap();
                videoMap.putConnection(con);
                videoMap.printAll(System.out);
            }
            if (this.ContentType == null) {
                this.ContentType = con.getHeaderField("Content-Type");
                if (this.ContentType == null) {
                    this.ContentType = "";
                }
            }
            this.ContentDisp = con.getHeaderField("Content-Disposition");
            int max_size = con.getContentLength();
            System.out.print("size=" + max_size / 1000 + "Kbytes");
            System.out.println(", type=" + this.ContentType + ", " + this.ContentDisp);
            System.out.print("Downloading video...");
            if (renameMp4 && this.ContentType.contains("mp4")) {
                String filepath = file.getPath();
                int index = filepath.lastIndexOf(".");
                if (filepath.lastIndexOf(File.separator) < index) {
                    filepath = String.valueOf(filepath.substring(0, index)) + ".mp4";
                }
                file = new File(filepath);
            }
            FileOutputStream os = new FileOutputStream(file);
            int size = 0;
            int read = 0;
            this.debugsInit();
            do {
                if ((read = is.read(this.buf, 0, this.buf.length)) <= 0) {
                    this.debugsOut("\n\u25a0read+write statistics(bytes) ");
                    System.out.println("ok.");
                    is.close();
                    os.flush();
                    ((OutputStream)os).close();
                    con.disconnect();
                    return file;
                }
                this.debugsAdd(read);
                ((OutputStream)os).write(this.buf, 0, read);
                this.sendStatus(status, "\u52d5\u753b", max_size, size += read);
                this.Stopwatch.show();
            } while (!flag.needStop());
            System.out.println("\nStopped.");
            is.close();
            os.flush();
            ((OutputStream)os).close();
            con.disconnect();
            if (!file.delete()) return null;
            System.out.println("video deleted.");
            return null;
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
            return null;
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public File getComment(File file, JLabel status, String back_comment, String time, ConvertStopFlag flag, int comment_mode) {
        if (time != null && !time.isEmpty() && "0".equals(this.WayBackKey) && !this.getWayBackKey(time)) {
            System.out.println("It may be wrong Date.");
        }
        boolean useNewComment = true;
        if (comment_mode == 2 || comment_mode == 0 && !this.hasNewCommentBegun) {
            useNewComment = false;
        }
        return this.downloadComment(file, status, back_comment, CommentType.USER, flag, useNewComment);
    }

    public File getOwnerComment(File file, JLabel status, ConvertStopFlag flag) {
        return this.downloadComment(file, status, STR_OWNER_COMMENT, CommentType.OWNER, flag, false);
    }

    public File getOptionalThread(File file, JLabel status, String optionalThreadID, String back_comment, String time, ConvertStopFlag flag, int comment_mode) {
        this.ThreadID = optionalThreadID;
        this.NeedsKey = false;
        this.Official = "";
        if (time != null && !time.isEmpty()) {
            this.WayBackKey = "0";
            if (!this.getWayBackKey(time)) {
                System.out.println("It may be wrong Date.");
            }
        }
        boolean useNewComment = true;
        if (comment_mode == 2 || comment_mode == 0 && !this.hasNewCommentBegun) {
            useNewComment = false;
        }
        return this.downloadComment(file, status, back_comment, CommentType.OPTIONAL, flag, useNewComment);
    }

    private String commentCommand2006(CommentType comType, String back_comment) {
        if (!back_comment.endsWith("-")) {
            back_comment = "-" + back_comment;
        }
        return "<thread user_id=\"" + this.UserID + "\" scores=\"1" + "\" when=\"" + this.WayBackTime + "\" waybackkey=\"" + this.WayBackKey + "\" res_from=\"" + back_comment + "\" version=\"20061206\" thread=\"" + this.ThreadID + this.Official + (comType == CommentType.OWNER ? "\" fork=\"1\"/>" : "\"/>");
    }

    private String commentCommand2009(CommentType commentType, String back_comment) {
        String wayback = "\" when=\"" + this.WayBackTime + "\" waybackkey=\"" + this.WayBackKey;
        String resfrom = !back_comment.endsWith("-") ? "\" res_from=\"-" + back_comment : "\" res_from=\"" + back_comment;
        StringBuffer sb = new StringBuffer();
        sb.append("<packet>");
        sb.append("<thread thread=\"" + this.ThreadID);
        sb.append("\" version=\"20090904");
        sb.append(resfrom);
        sb.append("\" user_id=\"" + this.UserID);
        if (this.NeedsKey) {
            sb.append(this.Official);
        }
        if (!"0".equals(this.WayBackKey)) {
            sb.append(wayback);
        }
        sb.append("\" scores=\"1");
        sb.append("\" nicoru=\"1");
        sb.append("\" with_global=\"1");
        sb.append("\"/>");
        sb.append("<thread_leaves thread=\"" + this.ThreadID);
        sb.append("\" version=\"20090904");
        sb.append(resfrom);
        sb.append("\" user_id=\"" + this.UserID);
        if (this.NeedsKey) {
            sb.append(this.Official);
        }
        if (!"0".equals(this.WayBackKey)) {
            sb.append(wayback);
        }
        sb.append("\" scores=\"1");
        sb.append("\" nicoru=\"1");
        sb.append("\" with_global=\"1");
        sb.append("\">0-");
        sb.append((this.VideoLength + 59) / 60);
        sb.append(":100,");
        sb.append(back_comment);
        sb.append("</thread_leaves>");
        sb.append("</packet>");
        String req = sb.toString();
        return req;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File downloadComment(File file, JLabel status, String back_comment, CommentType commentType, ConvertStopFlag flag, boolean useNewComment) {
        System.out.print("Downloading " + commentType.toString().toLowerCase() + " comment, size:" + back_comment + "...");
        if (this.NeedsKey && this.Official.isEmpty()) {
            if (!(this.force184 != null && this.threadKey != null || this.getOfficialOption(this.ThreadID))) {
                return null;
            }
            this.Official = "\" force_184=\"" + this.force184 + "\" threadkey=\"" + this.threadKey;
        }
        FileOutputStream fos = null;
        try {
            HttpURLConnection con;
            block33: {
                String ownerText;
                String req;
                if (file.canRead() && file.delete()) {
                    System.out.print("previous " + commentType.toString().toLowerCase() + " comment deleted...");
                }
                fos = new FileOutputStream(file);
                con = this.urlConnect(this.MsgUrl, "POST", this.Cookie, true, true, "keep-alive", true);
                OutputStream os = con.getOutputStream();
                if (useNewComment) {
                    req = this.commentCommand2009(commentType, back_comment);
                    System.out.print("New comment mode...");
                } else {
                    req = this.commentCommand2006(commentType, back_comment);
                    System.out.print("Old comment mode...");
                }
                this.debug("\n\u25a0write:" + req + "\n");
                os.write(req.getBytes());
                os.flush();
                os.close();
                this.debug("\u25a0Response:" + Integer.toString(con.getResponseCode()) + " " + con.getResponseMessage() + "\n");
                if (con.getResponseCode() != 200) {
                    System.out.println("ng.\nCan't download " + commentType.toString().toLowerCase() + " comment:" + this.MsgUrl);
                    return null;
                }
                InputStream is = con.getInputStream();
                int read = 0;
                int max_size = 0;
                String content_length_str = con.getHeaderField("Content-length");
                if (content_length_str != null && !content_length_str.isEmpty()) {
                    max_size = Integer.parseInt(content_length_str);
                }
                int size = 0;
                this.debugsInit();
                do {
                    if ((read = is.read(this.buf, 0, this.buf.length)) <= 0) {
                        this.debugsOut("\u25a0read+write statistics(bytes) ");
                        System.out.println("ok.");
                        is.close();
                        fos.flush();
                        if (this.ownerFilter != null && commentType == CommentType.OWNER) {
                            fos.close();
                            ownerText = Path.readAllText(file.getAbsolutePath(), "UTF-8");
                            if (!ownerText.isEmpty()) {
                                int lastIndex = ownerText.toLowerCase().lastIndexOf("</packet>");
                                this.ownerFilter = "<chat filter=\"1\">" + ChatSave.safeReference(this.ownerFilter) + "</chat>";
                                ownerText = lastIndex >= 0 ? String.valueOf(ownerText.substring(0, lastIndex)) + this.ownerFilter + ownerText.substring(lastIndex) : String.valueOf(ownerText) + this.ownerFilter + "</packet>\n";
                            }
                        }
                        break block33;
                    }
                    this.debugsAdd(read);
                    fos.write(this.buf, 0, read);
                    this.sendStatus(status, commentType.dlmsg(), max_size, size += read);
                    this.Stopwatch.show();
                } while (!flag.needStop());
                System.out.println("\nStopped.");
                is.close();
                os.flush();
                os.close();
                con.disconnect();
                fos.close();
                if (!file.delete()) return null;
                System.out.println(String.valueOf(commentType.toString().toLowerCase()) + " comment deleted.");
                return null;
                new Path(file).writeAllText(ownerText, "UTF-8");
            }
            con.disconnect();
            File file2 = file;
            return file2;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            if (!ex.toString().contains("Unexpected end of file from server")) return null;
            this.setExtraError("\u30b5\u30fc\u30d0\u30fc\u304b\u3089\u5207\u65ad\u3055\u308c\u307e\u3057\u305f\u3002\u30bf\u30a4\u30e0\u30a2\u30a6\u30c8\uff1f");
            return null;
        }
        catch (NumberFormatException ex) {
            ex.printStackTrace();
            return null;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private boolean getOfficialOption(String threadId) {
        block9: {
            String ret;
            block8: {
                HttpURLConnection con;
                block7: {
                    String url;
                    block6: {
                        url = "http://flapi.nicovideo.jp/api/getthreadkey?thread=" + threadId;
                        System.out.print("\nGetting Official options (threadkey)...");
                        try {
                            if (this.force184 == null || this.threadKey == null) break block6;
                            System.out.println("ok. But this call twice, not necessary.");
                            return true;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            return false;
                        }
                    }
                    con = this.urlConnectGET(url);
                    if (con != null && con.getResponseCode() == 200) break block7;
                    System.out.println("ng.\nCan't get Oficial option:" + url);
                    return false;
                }
                ret = this.readConnection(con);
                if (ret != null && !ret.isEmpty()) break block8;
                System.out.println("ng.\nNull response.");
                return false;
            }
            this.nicomap.splitAndPut(ret, "&");
            this.threadKey = this.nicomap.get("threadkey");
            this.force184 = this.nicomap.get("force_184");
            if (this.threadKey != null && this.force184 != null) break block9;
            System.out.println("ng.\nCan't get Oficial option.");
            System.out.println("ret: " + ret);
            return false;
        }
        System.out.println("ok.  Thread Key: " + this.threadKey);
        return true;
    }

    private boolean getWayBackKey(String time) {
        String waybackkey;
        String waybacktime;
        WayBackDate wayback;
        block12: {
            String ret;
            block11: {
                HttpURLConnection con;
                block10: {
                    block9: {
                        block8: {
                            System.out.print("Setting wayback time...");
                            try {
                                if ("0".equals(this.WayBackKey)) break block8;
                                System.out.println("ok. But this call twice, not necessary.");
                                this.hasNewCommentBegun = true;
                                return true;
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                return false;
                            }
                        }
                        wayback = new WayBackDate(time);
                        if (wayback.isValid()) break block9;
                        System.out.println("ng.\nCannot parse time.\"" + time + "\"");
                        this.setExtraError("\u904e\u53bb\u30ed\u30b0\u6307\u5b9a\u6587\u5b57\u5217\u304c\u9055\u3044\u307e\u3059");
                        return false;
                    }
                    waybacktime = wayback.getWayBackTime();
                    System.out.println("ok. [" + wayback.format() + "]: " + waybacktime);
                    System.out.print("Getting wayback key...");
                    String url = "http://flapi.nicovideo.jp/api/getwaybackkey?thread=" + this.ThreadID;
                    con = this.urlConnectGET(url);
                    if (con != null && con.getResponseCode() == 200) break block10;
                    System.out.println("ng.\nCan't open connection: " + url);
                    return false;
                }
                ret = this.readConnection(con);
                if (ret != null) break block11;
                System.out.println("ng.\nCannot find waybackkey from response.");
                return false;
            }
            this.nicomap.splitAndPut(ret, "&");
            waybackkey = this.nicomap.get("waybackkey");
            if (waybackkey != null && !waybackkey.isEmpty()) break block12;
            System.out.println("ng.\nCannot get wayback key. it's invalid");
            if ("0".equals(this.Premium)) {
                this.setExtraError("\u4e00\u822c\u4f1a\u54e1\u306f\u904e\u53bb\u30ed\u30b0\u4e0d\u53ef\u3067\u3059");
            }
            return false;
        }
        System.out.println("ok.  Wayback key: " + waybackkey);
        this.WayBackTime = waybacktime;
        this.WayBackKey = waybackkey;
        this.hasNewCommentBegun = wayback.getSecond() > NEW_COMMENT_BEGIN_SECOND;
        return true;
    }

    public boolean loginCheck() {
        String url = "http://www.nicovideo.jp";
        System.out.print("Checking login...");
        HttpURLConnection con = this.urlConnectGET(url);
        if (con == null) {
            System.out.println("ng.\nCan't read TopPage at loginCheck:" + url);
            return false;
        }
        return this.loginCheck(con);
    }

    private boolean loginCheck(HttpURLConnection con) {
        String auth;
        String new_cookie = this.detectCookie(con);
        if (new_cookie == null || new_cookie.isEmpty()) {
            System.out.print(" new_cookie isEmpty. ");
        }
        if ((auth = this.nicomap.get("x-niconico-authflag")) == null || auth.isEmpty() || auth.equals("0")) {
            System.out.println("ng. Not logged in. authflag=" + auth);
            con.disconnect();
            return false;
        }
        if (new_cookie != null && !new_cookie.isEmpty()) {
            this.Cookie = new_cookie;
        }
        this.debug("\n\u25a0Now Cookie is<" + this.Cookie + ">\n");
        System.out.println("ok.");
        return true;
    }

    public String getBackCommentFromLength(String def) {
        if (this.VideoLength < 0) {
            return def;
        }
        if (this.VideoLength >= 0 && this.VideoLength < 60) {
            return "100";
        }
        if (this.VideoLength >= 60 && this.VideoLength < 300) {
            return "250";
        }
        if (this.VideoLength >= 300 && this.VideoLength < 600) {
            return "500";
        }
        return STR_OWNER_COMMENT;
    }

    private void debugsInit() {
        if (!this.Debug) {
            return;
        }
        this.dsSum = 0;
        this.dsMax = 0;
        this.dsCount = 0;
        this.dsMin = Integer.MAX_VALUE;
    }

    private void debugsAdd(int data) {
        if (!this.Debug) {
            return;
        }
        ++this.dsCount;
        this.dsSum += data;
        this.dsMax = Math.max(this.dsMax, data);
        this.dsMin = Math.min(this.dsMin, data);
    }

    private void debugsOut(String header) {
        if (!this.Debug) {
            return;
        }
        System.out.print(header);
        if (this.dsCount == 0) {
            System.out.println("Count 0");
        } else {
            System.out.print("Count " + this.dsCount + ", Min " + this.dsMin + ", Max " + this.dsMax);
            System.out.println(", Sum " + this.dsSum + ", Avg " + this.dsSum / this.dsCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendStatus(JLabel status, String msg, int max_size, int size) {
        if (max_size > 0) {
            String per = Double.toString((double)size * 100.0 / (double)max_size);
            per = per.substring(0, Math.min(per.indexOf(".") + 3, per.length()));
            JLabel jLabel = status;
            synchronized (jLabel) {
                status.setText(String.valueOf(msg) + "\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\uff1a" + per + "\u30d1\u30fc\u30bb\u30f3\u30c8\u5b8c\u4e86");
            }
        }
        JLabel jLabel = status;
        synchronized (jLabel) {
            status.setText(String.valueOf(msg) + "\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u4e2d\uff1a" + Integer.toString(size >> 10) + "kbytes\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9");
        }
    }

    public void setExtraError(String extraError) {
        this.ExtraError = extraError;
    }

    public String getExtraError() {
        return this.ExtraError;
    }

    public String getOptionalThreadID() {
        return this.OptionalThraedID;
    }

    public int getVideoLength() {
        return this.VideoLength;
    }

    public boolean isEco() {
        return this.economy;
    }

    public Path getThumbInfoFile(String tag) {
        Path thumbXml;
        block11: {
            HttpURLConnection con;
            block10: {
                String THUMBINFO_URL = "http://ext.nicovideo.jp/api/getthumbinfo/";
                String url = "http://ext.nicovideo.jp/api/getthumbinfo/" + tag;
                System.out.print("Getting thumb Info...");
                thumbXml = null;
                con = this.urlConnectGET(url);
                if (con != null && con.getResponseCode() == 200) break block10;
                System.out.println("ng.\nCan't getThumbInfo:" + url);
                return null;
            }
            try {
                String ret;
                this.detectCookie(con);
                String encoding = con.getContentEncoding();
                if (encoding == null) {
                    encoding = "UTF-8";
                }
                BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream(), encoding));
                System.out.print("ok.\nSaving thumb Info...");
                StringBuilder sb = new StringBuilder();
                while ((ret = br.readLine()) != null) {
                    this.Stopwatch.show();
                    sb.append(String.valueOf(ret) + "\n");
                }
                br.close();
                con.disconnect();
                String s = sb.toString();
                String title = this.getVideoTitle();
                if (title == null) {
                    if (s != null && s.contains("title")) {
                        title = NicoClient.safeFileName(NicoClient.getXmlElement(s, "title"));
                    }
                    if (title == null) {
                        title = this.getVideoHistoryAndTitle1(tag, "", false) ? this.getVideoTitle() : this.VideoTitle;
                    }
                }
                if (this.ContentType == null) {
                    this.ContentType = NicoClient.getXmlElement(s, "movie_type");
                }
                thumbXml = Path.mkTemp(String.valueOf(tag) + "_" + title + ".xml");
                PrintWriter pw = new PrintWriter((File)thumbXml, encoding);
                pw.write(sb.toString());
                pw.flush();
                pw.close();
                if (thumbXml != null && sb.indexOf("status=\"ok\"") >= 0) break block11;
                System.out.println("ng.\nSee file:" + thumbXml);
                return null;
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return null;
            }
        }
        System.out.println("ok.");
        return thumbXml;
    }

    public static String getXmlElement(String xml, String tag) {
        int index = xml.indexOf("<" + tag + ">");
        int endIx = xml.indexOf("</", index + 2);
        if (index < 0 || endIx < 0) {
            return null;
        }
        String dest = xml.substring(index += tag.length() + 2, endIx);
        return dest;
    }

    public static String getXmlElement2(String xml, String tag) {
        int index = xml.indexOf("<" + tag);
        if (index < 0) {
            return null;
        }
        index += tag.length() + 1;
        if ((index = xml.indexOf(">", index)) < 0) {
            return null;
        }
        int endIx = xml.indexOf("</", index + 1);
        if (endIx < 0) {
            endIx = xml.length();
        }
        String dest = xml.substring(index + 1, endIx);
        return dest;
    }

    public Path getThumbUserFile(String userID, File userFolder) {
        HttpURLConnection con;
        Path userHtml;
        block5: {
            String THUMBUSER_URL = "http://ext.nicovideo.jp/thumb_user/";
            String url = "http://ext.nicovideo.jp/thumb_user/" + userID;
            System.out.print("Getting thumb User...");
            userHtml = null;
            con = this.urlConnectGET(url);
            if (con != null && con.getResponseCode() == 200) break block5;
            System.out.println("ng.\nCan't getThumbUser:" + url);
            return null;
        }
        try {
            String ret;
            this.detectCookie(con);
            String encoding = con.getContentEncoding();
            if (encoding == null) {
                encoding = "UTF-8";
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream(), encoding));
            System.out.print("ok.\nSaving thumb user...");
            StringBuilder sb = new StringBuilder();
            while ((ret = br.readLine()) != null) {
                this.Stopwatch.show();
                sb.append(String.valueOf(ret) + "\n");
            }
            br.close();
            con.disconnect();
            userHtml = new Path(userFolder, String.valueOf(userID) + ".htm");
            PrintWriter pw = new PrintWriter((File)userHtml, encoding);
            pw.write(sb.toString());
            pw.flush();
            pw.close();
            System.out.println("ok.");
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
        return userHtml;
    }

    public Path getUserInfoFile(String userID, File userFolder) {
        HttpURLConnection con;
        Path userHtml;
        block6: {
            String USER_URL = "http://www.nicovideo.jp/user/";
            String url = "http://www.nicovideo.jp/user/" + userID;
            System.out.print("Getting User Info...");
            userHtml = null;
            con = this.urlConnectGET(url);
            if (con != null && con.getResponseCode() == 200) break block6;
            System.out.println("ng.\nCan't getUserInfo:" + url);
            return null;
        }
        try {
            String ret;
            this.detectCookie(con);
            String encoding = con.getContentEncoding();
            if (encoding == null) {
                encoding = "UTF-8";
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream(), encoding));
            System.out.print("ok.\nSaving user info...");
            StringBuilder sb = new StringBuilder();
            while ((ret = br.readLine()) != null) {
                this.Stopwatch.show();
                sb.append(String.valueOf(ret) + "\n");
                if (ret.contains("</title>")) break;
            }
            br.close();
            con.disconnect();
            String text = sb.toString();
            int index = text.indexOf("<title");
            if (index < 0) {
                index = 0;
            }
            text = text.substring(index);
            userHtml = new Path(userFolder, String.valueOf(userID) + ".htm");
            PrintWriter pw = new PrintWriter((File)userHtml, encoding);
            pw.write(text);
            pw.flush();
            pw.close();
            System.out.println("ok.");
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
        return userHtml;
    }

    public boolean getThumbnailJpg(String url, File thumbnalJpgFile) {
        HttpURLConnection con;
        block4: {
            System.out.print("Getting thumbnail...");
            con = this.urlConnectGET(url);
            if (con != null && con.getResponseCode() == 200) break block4;
            System.out.println("ng.\nCan't getThumbnailJpg:" + url);
            return false;
        }
        try {
            this.detectCookie(con);
            InputStream is = con.getInputStream();
            FileOutputStream fos = new FileOutputStream(thumbnalJpgFile);
            byte[] buf = new byte[4096];
            System.out.print("ok.\nSaving thumbnail...");
            int len = 0;
            while ((len = is.read(buf, 0, buf.length)) > 0) {
                fos.write(buf, 0, len);
                this.Stopwatch.show();
            }
            System.out.println("ok.");
            is.close();
            fos.flush();
            fos.close();
            con.disconnect();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    private static enum CommentType {
        USER{

            @Override
            public String dlmsg() {
                return "\u30b3\u30e1\u30f3\u30c8";
            }
        }
        ,
        OWNER{

            @Override
            public String dlmsg() {
                return "\u6295\u7a3f\u8005\u30b3\u30e1\u30f3\u30c8";
            }
        }
        ,
        OPTIONAL{

            @Override
            public String dlmsg() {
                return "\u30aa\u30d7\u30b7\u30e7\u30ca\u30eb\u30b9\u30ec\u30c3\u30c9";
            }
        };


        public abstract String dlmsg();
    }
}

