/*
 * Decompiled with CFR 0.152.
 */
package saccubus.conv;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.LinkedHashMap;
import saccubus.conv.ChatAttribute;
import saccubus.conv.ChatSave;

public class ChatArray {
    private String thread = Integer.toString(Integer.MAX_VALUE);
    private LinkedHashMap<ChatAttribute, ChatSave> chatMap = new LinkedHashMap();

    public void addChat(ChatSave chat) {
        this.chatMap.put(chat.getAttributes(), chat);
    }

    public void writeXML(File file) throws IOException {
        PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8")));
        pw.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        pw.println("<packet><thread thread=\"" + this.thread + "\" />");
        pw.flush();
        for (ChatSave chat : this.chatMap.values()) {
            chat.printXML(pw);
        }
        pw.println("</packet>");
        pw.flush();
        pw.close();
    }

    public void setThread(String newThread) {
        if (this.thread == null) {
            this.thread = newThread;
            return;
        }
        try {
            int t = Integer.parseInt(this.thread);
            int nt = Integer.parseInt(newThread);
            if (nt < t) {
                this.thread = newThread;
            }
        }
        catch (NumberFormatException ex) {
            System.out.println("thread is not number, maybe no problem.");
        }
    }
}

