/*
 * Decompiled with CFR 0.152.
 */
package saccubus;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import psi.lib.swing.PopupRightClick;

public class HtmlView
extends JDialog
implements ActionListener {
    private final Frame parent;
    private JEditorPane editorPane;
    private static final double WIDTH_RATE = 1.5;
    private static final double HEIGHT_RATE = 1.1;

    public HtmlView(Frame owner, String title, String text) {
        super(owner, title, false);
        this.parent = owner;
        this.init(text);
    }

    private void init(String text) {
        try {
            this.setDefaultCloseOperation(2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Font f = this.parent.getFont();
        f = new Font(f.getName(), f.getStyle(), f.getSize() - 2);
        this.setFont(f);
        this.editorPane = new JEditorPane("text/html", HtmlView.markupHtml(text));
        this.editorPane.setEditable(false);
        this.editorPane.setOpaque(false);
        this.editorPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    URL url = e.getURL();
                    Desktop desktop = Desktop.getDesktop();
                    try {
                        desktop.browse(url.toURI());
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    catch (URISyntaxException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        this.editorPane.addMouseListener(new PopupRightClick(this.editorPane));
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.editorPane), "Center");
        this.pack();
        Dimension dim = this.parent.getSize();
        dim.width = (int)(1.5 * (double)dim.width);
        dim.height = (int)(1.1 * (double)dim.height);
        this.setSize(dim);
        Point pt = this.parent.getLocation();
        this.setLocation(pt.x + 20, pt.y + 20);
        this.editorPane.setCaretPosition(0);
        this.setVisible(true);
        this.setResizable(true);
    }

    public void setText(String text) {
        this.editorPane.setText(text);
        this.editorPane.setCaretPosition(0);
        this.update(this.getGraphics());
    }

    public static String markupHtml(String text) {
        text = text.replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\n", "<br/>").replaceAll("http://[a-zA-Z0-9%._\\-\\?=/]+", "<a href=\"$0\">$0</a>");
        text = "<html>" + text + "<br/></html>";
        return text;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }
}

