/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.pmx.parser;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import jp.sfjp.mikutoga.bin.parser.CommonParser;
import jp.sfjp.mikutoga.bin.parser.MmdEofException;
import jp.sfjp.mikutoga.bin.parser.MmdFormatException;
import jp.sfjp.mikutoga.bin.parser.TextDecoder;
import jp.sfjp.mikutoga.pmx.BoneFlags;
import jp.sfjp.mikutoga.pmx.parser.PmxBasicHandler;
import jp.sfjp.mikutoga.pmx.parser.PmxBoneHandler;
import jp.sfjp.mikutoga.pmx.parser.PmxFaceHandler;
import jp.sfjp.mikutoga.pmx.parser.PmxMaterialHandler;
import jp.sfjp.mikutoga.pmx.parser.PmxUnifiedHandler;
import jp.sfjp.mikutoga.pmx.parser.PmxVertexHandler;

public class PmxParserBase
extends CommonParser {
    public static final Charset[] encodes = new Charset[]{Charset.forName("UTF-16LE"), Charset.forName("UTF-8")};
    protected static final String CR = "\r";
    protected static final String LF = "\n";
    protected static final String CRLF = "\r\n";
    private static final byte[] MAGIC_BYTES = new byte[]{80, 77, 88, 32};
    private PmxBasicHandler basicHandler = PmxUnifiedHandler.EMPTY;
    private PmxVertexHandler vertexHandler = PmxUnifiedHandler.EMPTY;
    private PmxFaceHandler faceHandler = PmxUnifiedHandler.EMPTY;
    private PmxMaterialHandler materialHandler = PmxUnifiedHandler.EMPTY;
    private PmxBoneHandler boneHandler = PmxUnifiedHandler.EMPTY;
    private byte encode;
    private byte num_uv;
    private byte size_vertex;
    private byte size_texture;
    private byte size_material;
    private byte size_bone;
    private byte size_morph;
    private byte size_rigid;
    private TextDecoder decoder;
    private int vertexCount = -1;
    private int faceCount = -1;
    private int textureCount = -1;
    private int materialCount = -1;
    private int boneCount = -1;
    private int morphCount = -1;
    private int boneGroupCount = -1;
    private int rigidCount = -1;

    public PmxParserBase(InputStream source) {
        super(source);
    }

    public static String chopLastLF(String name) {
        String result = name.endsWith(LF) ? name.substring(0, name.length() - 1) : name;
        return result;
    }

    public void setBasicHandler(PmxBasicHandler handler) {
        this.basicHandler = handler == null ? PmxUnifiedHandler.EMPTY : handler;
    }

    public void setVertexHandler(PmxVertexHandler handler) {
        this.vertexHandler = handler == null ? PmxUnifiedHandler.EMPTY : handler;
    }

    public void setFaceHandler(PmxFaceHandler handler) {
        this.faceHandler = handler == null ? PmxUnifiedHandler.EMPTY : handler;
    }

    public void setMaterialHandler(PmxMaterialHandler handler) {
        this.materialHandler = handler == null ? PmxUnifiedHandler.EMPTY : handler;
    }

    public void setBoneHandler(PmxBoneHandler handler) {
        this.boneHandler = handler == null ? PmxUnifiedHandler.EMPTY : handler;
    }

    protected int getBoneCount() {
        return this.boneCount;
    }

    protected int getMorphCount() {
        return this.morphCount;
    }

    protected int getBoneGroupCount() {
        return this.boneGroupCount;
    }

    protected String parsePmxText() throws IOException, MmdEofException, MmdFormatException {
        int byteLen = this.parseLeInt();
        String result = this.parseString(this.decoder, byteLen);
        return result;
    }

    protected int parsePmxId(byte size) throws IOException, MmdEofException {
        int id = -1;
        switch (size) {
            case 1: {
                id = this.parseByte();
                break;
            }
            case 2: {
                id = this.parseLeShort();
                break;
            }
            case 4: {
                id = this.parseLeInt();
            }
        }
        return id;
    }

    protected int parsePmxUId(byte size) throws IOException, MmdEofException {
        int id = -1;
        switch (size) {
            case 1: {
                id = this.parseUByteAsInt();
                break;
            }
            case 2: {
                id = this.parseLeUShortAsInt();
                break;
            }
            case 4: {
                id = this.parseLeInt();
            }
        }
        return id;
    }

    public void parsePmx() throws IOException, MmdFormatException {
        this.basicHandler.pmxParseStart();
        this.parseBody();
        boolean hasMoreData = this.hasMore();
        this.basicHandler.pmxParseEnd(hasMoreData);
    }

    protected void parseBody() throws IOException, MmdFormatException {
        this.parsePmxHeader();
        this.parseVertexList();
        this.parseFaceList();
        this.parseMaterialList();
        this.parseBoneList();
    }

    private void parsePmxHeader() throws IOException, MmdFormatException {
        byte[] header = new byte[MAGIC_BYTES.length];
        this.parseByteArray(header);
        if (!Arrays.equals(header, MAGIC_BYTES)) {
            throw new MmdFormatException("unknown PMX-header type");
        }
        float version = this.parseLeFloat();
        byte n = this.parseByte();
        byte[] barray = new byte[n];
        this.parseByteArray(barray);
        this.encode = barray[0];
        this.decoder = new TextDecoder(encodes[this.encode]);
        this.num_uv = barray[1];
        this.basicHandler.pmxHeaderInfo(version, this.encode, this.num_uv);
        this.size_vertex = barray[2];
        this.size_texture = barray[3];
        this.size_material = barray[4];
        this.size_bone = barray[5];
        this.size_morph = barray[6];
        this.size_rigid = barray[7];
        String modelName = this.parsePmxText();
        String modelNameE = this.parsePmxText();
        this.basicHandler.pmxModelName(modelName, modelNameE);
        String description = this.parsePmxText();
        String descriptionE = this.parsePmxText();
        description = description.replace(CRLF, LF);
        descriptionE = descriptionE.replace(CRLF, LF);
        this.basicHandler.pmxModelDescription(description, descriptionE);
    }

    private void parseVertexList() throws IOException, MmdFormatException {
        int vertexNum = this.parseLeInt();
        this.vertexHandler.loopStart(PmxVertexHandler.VERTEX_LIST, vertexNum);
        for (int ct = 0; ct < vertexNum; ++ct) {
            int i;
            float xPos = this.parseLeFloat();
            float yPos = this.parseLeFloat();
            float zPos = this.parseLeFloat();
            this.vertexHandler.pmxVertexPosition(xPos, yPos, zPos);
            float xVec = this.parseLeFloat();
            float yVec = this.parseLeFloat();
            float zVec = this.parseLeFloat();
            this.vertexHandler.pmxVertexNormal(xVec, yVec, zVec);
            float uVal = this.parseLeFloat();
            float vVal = this.parseLeFloat();
            this.vertexHandler.pmxVertexUV(uVal, vVal);
            for (byte i2 = 0; i2 < this.num_uv; i2 = (byte)(i2 + 1)) {
                float x = this.parseLeFloat();
                float y = this.parseLeFloat();
                float z = this.parseLeFloat();
                float w = this.parseLeFloat();
                this.vertexHandler.pmxVertexExUV(i2, x, y, z, w);
            }
            byte bdef = this.parseByte();
            int[] boneIds = bdef < 3 ? new int[4 >> 2 - bdef] : (bdef == 3 ? new int[2] : new int[2]);
            float[] weights = new float[boneIds.length];
            for (i = 0; i < boneIds.length; i = (int)((byte)(i + 1))) {
                boneIds[i] = this.parsePmxId(this.size_bone);
            }
            if (bdef == 0) {
                weights[0] = 1.0f;
            } else if (bdef == 2) {
                for (i = 0; i < 4; i = (int)((byte)(i + 1))) {
                    weights[i] = this.parseLeFloat();
                }
            } else {
                weights[0] = this.parseLeFloat();
                weights[1] = 1.0f - weights[0];
            }
            float[] sdef = null;
            if (bdef == 3) {
                sdef = new float[9];
                for (int i3 = 0; i3 < 9; ++i3) {
                    sdef[i3] = this.parseLeFloat();
                }
            }
            this.vertexHandler.pmxVertexWeight(boneIds, weights, sdef);
            float edge = this.parseLeFloat();
            this.vertexHandler.pmxVertexEdge(edge);
            this.vertexHandler.loopNext(PmxVertexHandler.VERTEX_LIST);
        }
        this.vertexHandler.loopEnd(PmxVertexHandler.VERTEX_LIST);
    }

    private void parseFaceList() throws IOException, MmdFormatException {
        int faceNum = this.parseLeInt();
        this.faceCount = faceNum / 3;
        if (this.faceCount * 3 - faceNum != 0) {
            throw new MmdFormatException();
        }
        this.faceHandler.loopStart(PmxFaceHandler.FACE_LIST, this.faceCount);
        for (int ct = 0; ct < this.faceCount; ++ct) {
            int vertexId1 = this.parsePmxUId(this.size_vertex);
            int vertexId2 = this.parsePmxUId(this.size_vertex);
            int vertexId3 = this.parsePmxUId(this.size_vertex);
            this.faceHandler.pmxFaceTriangle(vertexId1, vertexId2, vertexId3);
            this.faceHandler.loopNext(PmxFaceHandler.FACE_LIST);
        }
        this.faceHandler.loopEnd(PmxFaceHandler.FACE_LIST);
    }

    private void parseMaterialList() throws IOException, MmdFormatException {
        int textureNum = this.parseLeInt();
        this.materialHandler.loopStart(PmxMaterialHandler.TEXTURE_LIST, textureNum);
        for (int ct = 0; ct < textureNum; ++ct) {
            String textureFile = this.parsePmxText();
            this.materialHandler.pmxTexture(textureFile);
        }
        this.materialHandler.loopEnd(PmxMaterialHandler.TEXTURE_LIST);
        int materialNum = this.parseLeInt();
        this.materialHandler.loopStart(PmxMaterialHandler.MATERIAL_LIST, materialNum);
        for (int ct = 0; ct < materialNum; ++ct) {
            String materialName = this.parsePmxText();
            String materialNameE = this.parsePmxText();
            this.materialHandler.pmxMaterialNames(materialName, materialNameE);
            this.parseColor();
            byte flags = this.parseByte();
            float red = this.parseLeFloat();
            float green = this.parseLeFloat();
            float blue = this.parseLeFloat();
            float alpha = this.parseLeFloat();
            float thick = this.parseLeFloat();
            this.materialHandler.pmxMaterialEdges(flags, red, green, blue, alpha, thick);
            int texture = this.parsePmxId(this.size_texture);
            int sphere = this.parsePmxId(this.size_texture);
            byte mode = this.parseByte();
            this.materialHandler.pmxMaterialTexture(texture, sphere, mode);
            byte sharedToon = this.parseByte();
            int toon = sharedToon == 0 ? this.parsePmxId(this.size_texture) : this.parseByte();
            this.materialHandler.pmxMaterialToon(sharedToon, toon);
            String script = this.parsePmxText();
            int faceCount = this.parseLeInt();
            this.materialHandler.pmxMaterialInfo(script, faceCount);
            this.materialHandler.loopNext(PmxMaterialHandler.MATERIAL_LIST);
        }
        this.materialHandler.loopEnd(PmxMaterialHandler.MATERIAL_LIST);
    }

    private void parseColor() throws IOException, MmdFormatException {
        float red = this.parseLeFloat();
        float green = this.parseLeFloat();
        float blue = this.parseLeFloat();
        float alpha = this.parseLeFloat();
        this.materialHandler.pmxMaterialDiffuse(red, green, blue, alpha);
        red = this.parseLeFloat();
        green = this.parseLeFloat();
        blue = this.parseLeFloat();
        float shininess = this.parseLeFloat();
        this.materialHandler.pmxMaterialSpecular(red, green, blue, shininess);
        red = this.parseLeFloat();
        green = this.parseLeFloat();
        blue = this.parseLeFloat();
        this.materialHandler.pmxMaterialAmbient(red, green, blue);
    }

    private void parseBoneList() throws IOException, MmdFormatException {
        this.boneCount = this.parseLeInt();
        this.boneHandler.loopStart(PmxBoneHandler.BONE_LIST, this.boneCount);
        for (int ct = 0; ct < this.boneCount; ++ct) {
            String boneName = this.parsePmxText();
            String boneNameE = this.parsePmxText();
            this.boneHandler.pmxBoneInfo(boneName, boneNameE);
            float xPos = this.parseLeFloat();
            float yPos = this.parseLeFloat();
            float zPos = this.parseLeFloat();
            this.boneHandler.pmxBonePosition(xPos, yPos, zPos);
            int parentId = this.parsePmxId(this.size_bone);
            int depth = this.parseLeInt();
            this.boneHandler.pmxBoneStructure(parentId, depth);
            short flags = this.parseLeShort();
            this.boneHandler.pmxBoneFlags(flags);
            if (!BoneFlags.OFFSET.check(flags)) {
                float offX = this.parseLeFloat();
                float offY = this.parseLeFloat();
                float offZ = this.parseLeFloat();
                this.boneHandler.pmxBoneOffset(offX, offY, offZ);
            } else {
                int arrowId = this.parsePmxId(this.size_bone);
                this.boneHandler.pmxBoneArrowhead(arrowId);
            }
            if (BoneFlags.ROTATE_LINK.check(flags) || BoneFlags.MOVE_LINK.check(flags)) {
                int linkParent = this.parsePmxId(this.size_bone);
                float r = this.parseLeFloat();
                this.boneHandler.pmxBoneLink(linkParent, r);
            }
            if (BoneFlags.AXIS_ROTATE.check(flags)) {
                float x = this.parseLeFloat();
                float y = this.parseLeFloat();
                float z = this.parseLeFloat();
                this.boneHandler.pmxBoneRotateAxe(x, y, z);
            }
            if (BoneFlags.LOCAL_AXIS.check(flags)) {
                float xx = this.parseLeFloat();
                float xy = this.parseLeFloat();
                float xz = this.parseLeFloat();
                float zx = this.parseLeFloat();
                float zy = this.parseLeFloat();
                float zz = this.parseLeFloat();
                this.boneHandler.pmxBoneLocalAxis(xx, xy, xz, zx, zy, zz);
            }
            if (BoneFlags.EXTRA.check(flags)) {
                int extraParent = this.parseLeInt();
                this.boneHandler.pmxBoneExtraParent(extraParent);
            }
            if (BoneFlags.IK.check(flags)) {
                int targetId = this.parsePmxId(this.size_bone);
                int trial = this.parseLeInt();
                float radian = this.parseLeFloat();
                this.boneHandler.pmxBoneIKInfo(targetId, trial, radian);
                int bones = this.parseLeInt();
                this.boneHandler.loopStart(PmxBoneHandler.IKCHAIN_LIST, bones);
                for (int i = 0; i < bones; ++i) {
                    int ikElement = this.parsePmxId(this.size_bone);
                    byte limit = this.parseByte();
                    float[] limit_rotation = null;
                    if (limit > 0) {
                        limit_rotation = new float[]{this.parseLeFloat(), this.parseLeFloat(), this.parseLeFloat(), this.parseLeFloat(), this.parseLeFloat(), this.parseLeFloat()};
                    }
                    this.boneHandler.pmxIKChainInfo(ikElement, limit_rotation);
                    this.boneHandler.loopNext(PmxBoneHandler.IKCHAIN_LIST);
                }
                this.boneHandler.loopEnd(PmxBoneHandler.IKCHAIN_LIST);
            }
            this.boneHandler.loopNext(PmxBoneHandler.BONE_LIST);
        }
        this.boneHandler.loopEnd(PmxBoneHandler.BONE_LIST);
    }
}

