static char sccsid[]="%Z% %M% %I% %E% %U%";
/************************************************/
/*												*/
/*	akbCrePack.c								*/
/*												*/
/*			coded by A.Kobayashi 2010/06/10		*/
/*												*/
/************************************************/
#include "akbcommon.h"

/********************************************************/
/*														*/
/********************************************************/
int akb_create_pk_data(applid,tpHead,tpSendMsgCom,cppPacket)
char            *applid;
qCommPackHead   *tpHead;
tdtMsgCom       *tpSendMsgCom;
char            **cppPacket;
{
	INT4 lPackLen, lFileLen, lw, lLen;
	char *cpPacket,*cp,*cpF,cver;
	int i,l,iHSize,iINDIRECT;
	struct stat tStat;

	if (!tpHead || !tpSendMsgCom || !cppPacket) return -1;
	*cppPacket = NULL;
	if (tpSendMsgCom->lMsgLen < 0 ||
	    (tpSendMsgCom->lMsgLen>0 && !tpSendMsgCom->cpMsg))
		return -1;
	iINDIRECT = (tpSendMsgCom->ucPackForm & AKB_PFM_INDIRECT);
	if (tpSendMsgCom->ucFilec>0 && tpSendMsgCom->cpFilev) iINDIRECT = 1;
	AKBGETHSIZEETC(tpHead,cver,iHSize,lLen)
	if (iINDIRECT) {
		lPackLen = iHSize+tpSendMsgCom->lMsgLen+4+sizeof(INT4);
		if (tpSendMsgCom->ucFilec>0 && !tpSendMsgCom->cpFilev) return -2; 
		for (i=0;i<tpSendMsgCom->ucFilec;i++) {
			if (!(cpF=tpSendMsgCom->cpFilev[i])) return -3; 
			if (!(l=strlen(cpF))) return -4;
			lPackLen += l+4+sizeof(INT4);
		}
		if (!(cpPacket=Malloc(lPackLen+1))) return D_ERR_MEM_ALLOC;
		*cppPacket = cpPacket;
		lw = lPackLen - iHSize;
		tpHead->lPackLen = htonl(lw);
		memcpy(cpPacket,tpHead,iHSize);
		cp = cpPacket + iHSize;
		*cp++ = 'P';
		*cp++ = '\0';
		*cp++ = '\0';
		*cp++ = '\0';
		lw = htonl(tpSendMsgCom->lMsgLen);
		memcpy(cp,(char *)&lw,sizeof(INT4));
		cp += sizeof(INT4);
		if (tpSendMsgCom->lMsgLen && tpSendMsgCom->cpMsg)
			memcpy(cp,tpSendMsgCom->cpMsg,tpSendMsgCom->lMsgLen);
		cp += tpSendMsgCom->lMsgLen;
		for (i=0;i<tpSendMsgCom->ucFilec;i++) {
			if (!(cpF = tpSendMsgCom->cpFilev[i])) return -3; 
			l   = strlen(cpF);
			*cp++ = 'F';
			*cp++ = l + sizeof(INT4);
			*cp++ = '\0';
			*cp++ = '\0';
			if (stat(akb_akb_home_add(cpF),&tStat)) return -5;
			lFileLen = tStat.st_size;
			lw = htonl(lFileLen);
			memcpy(cp,(char *)&lw,sizeof(INT4));
			cp += sizeof(INT4);
			memcpy(cp,cpF,l);
			cp += l;
		}
		tpHead = (pCommPackHead)cpPacket;
		tpHead->PrtclId.cSendPrtcl |= AKB_PFM_INDIRECT;
	}
	else {
		if ((l=tpSendMsgCom->lMsgLen) > 0) l++;
		if (!(cpPacket=Malloc(iHSize+l)))
			return -6;
		tpHead->lPackLen = htonl(tpSendMsgCom->lMsgLen);
		memcpy(cpPacket,tpHead,iHSize);
		if (tpSendMsgCom->lMsgLen && tpSendMsgCom->cpMsg)
			memcpy(cpPacket+iHSize,tpSendMsgCom->cpMsg,
			       tpSendMsgCom->lMsgLen);
	}
	*cppPacket = cpPacket;
	tpHead = (pCommPackHead)cpPacket;
	AKBGETHSIZEETC(tpHead,cver,iHSize,lLen)
	lPackLen = iHSize + lLen;
	return lPackLen;
}

/********************************************************/
/*														*/
/********************************************************/
int akb_set_recv_msg(pPacket,tpRcMsg,cppFilev,cppToFree)
char       *pPacket;
tdtMsgCom  *tpRcMsg;
char       **cppFilev;
char       **cppToFree;
{
	qCommPackHead   *pHead,tHead;
	char *pPa, cver;
	int iRc,iHSize;
	INT4 lLen, lm, ld, lw;

	if (!pPacket || !tpRcMsg || !cppToFree) {
/*
printf("akb_set_recv_msg: pPacket=%08x tpRcMsg=%08x cppToFree=%08x\n",pPacket,tpRcMsg,cppToFree);
*/
		return -1;
	}
	pHead = (pCommPackHead)pPacket;
	AKBGETHSIZE(pHead,iHSize)
	*cppToFree = NULL;
	pPa = pPacket;

	memset(tpRcMsg,0,sizeof(tdtMsgCom));
	pHead = (pCommPackHead)pPa;
	AKBGETHSIZE(pHead,iHSize)
	cver = pHead->PrtclId.cVer;
	tpRcMsg->ucPackForm = pHead->PrtclId.cSendPrtcl;
	if (pHead->SrcInf.ucThread) {	/* Command */
		tpRcMsg->usDisposition = 0;
		tpRcMsg->ucAkbOption  |= pHead->DestInf.ucDispos;
		tpRcMsg->sPackRet      = ntohs(pHead->DestInf.sPacketNo);
		tpRcMsg->ucResv        = pHead->SrcInf.ucDispos;
	}
	else {
		tpRcMsg->usDisposition = pHead->DestInf.ucDispos;
		tpRcMsg->ucAkbOption  |= pHead->SrcInf.ucDispos;
		tpRcMsg->sPackRet      = ntohs(pHead->SrcInf.sPacketNo);
	}
/*	tpRcMsg->usClassId = ntohs(pHead->SrcInf.usClassId);	*/
	lLen = ntohl(pHead->lPackLen);
	tpRcMsg->cpMsg   = NULL;
	tpRcMsg->ucFilec = 0;
	tpRcMsg->cpFilev = cppFilev;
	if (lLen < 0) return -3;
	else if (lLen > 0) {
		pPa += iHSize;
	    if (tpRcMsg->ucPackForm & AKB_PFM_INDIRECT) {
			while (lLen>8) {
				lm = *(unsigned char *)(pPa+1);
				memcpy((char *)&lw,pPa+4,sizeof(INT4));
				ld = ntohl(lw);
				if (ld < 0) return -4;
				if (*pPa== 'P') {
					if (ld > 0)
						tpRcMsg->cpMsg = pPa + 4 + sizeof(INT4);
					else
						tpRcMsg->cpMsg = NULL;
					tpRcMsg->lMsgLen = lm = ld;
				}		
				else if (*pPa== 'F') {
					if (!tpRcMsg->cpFilev) {
						if (!(tpRcMsg->cpFilev=(char **)Malloc(256*sizeof(char *))))
							return -5;
					}
					lm -= sizeof(INT4);
					memcpy(pPa+1,pPa+8,lm);
					*(pPa+1+lm) = '\0';
					memcpy(pPa+lm+2,(char *)&ld,sizeof(INT4));
					if (tpRcMsg->ucFilec < 255)
						tpRcMsg->cpFilev[tpRcMsg->ucFilec++] = pPa+1;
				}
				else return -6;
				pPa  += lm + 4 + sizeof(INT4);
				lLen -= lm + 4 + sizeof(INT4);
			}
		}
		else {
			tpRcMsg->lMsgLen = lLen;
			tpRcMsg->cpMsg   = pPa;
		}
	}
	if (tpRcMsg->cpFilev) tpRcMsg->cpFilev[tpRcMsg->ucFilec] = NULL;

	return 0;
}
