static char sccsid[]="%Z% %M% %I% %E% %U%";
#include "colmn.h"

extern CLPRTBL  *pCLprocTable;
extern GlobalCt *pGlobTable;
extern CLCOMMON CLcommon;
extern int giHOST_ID_SIZE;

/* ̊֐Ŏg\ p[^ */
typedef struct _SndParameter {
	char *pBody;
	int   iLeng;
} qSndPara;

/****************************************/
/*										*/
/* int cl_process_get_ipaddr( )			*/
/*										*/
/*			2010/05/31 by A.Koba		*/
/*										*/
/****************************************/
int cl_process_get_ipaddr( pszHostId, pNetId )
char *pszHostId;
int  *pNetId;
{
	int iIPAddr, procid,ret;
	char pszNetId[256];

	if ((ret = getdchostbyname(pszHostId, pszNetId, &iIPAddr, &procid)) < 0)
		return ret;

	*pNetId = iIPAddr;
	return procid;
}
 
/****************************************/
/*										*/
/* int cl_process_get_attr(prmp, para)	*/
/*										*/
/*			2010/05/31 by A.Koba		*/
/*										*/
/****************************************/
int cl_process_get_attr(prmp, Obj, para)
parmList *prmp;
int      *Obj;
qSndPara *para;
{
	FORM_S sForm;
	char *pBD;
	int  iBD,iWrtPos;
	tdtInfoParm rInfoParm;
	char c;
	int  rc, i;

	if (rc=cl_arg_to_char(prmp,Obj,&rInfoParm,FORMAT(571))) return rc;	/* w */
	pBD = rInfoParm.pi_data;
	iBD = rInfoParm.pi_dlen;
	for (i=0;i<iBD;i++,pBD++) {
		if ((c=toupper(*pBD))==' ' || c=='C' || c=='D' || c=='X') ;
		else {
				/* cl_process_get_attr: w蕶G[ */
			ERROROUT(FORMAT(572));
			return ECL_SCRIPT_ERROR;
		}
	}

	sForm.zoksei = (uchar)((DEF_ZOK_CHAR << 4) | 0x01);
	sForm.datlen = (uchar)iBD;

	para->pBody = Malloc(sizeof(FORM_S)+iBD);
	if (para->pBody == NULL) return SYSTEMERROR;

	iWrtPos = cmn_mem_wrt(para->pBody, &sForm, sizeof(FORM_S));
	if (iBD) iWrtPos += cmn_mem_wrt(para->pBody+iWrtPos, pBD, iBD);

	para->iLeng = iWrtPos;
	return NORMAL;
}

/****************************************/
/*										*/
/* int cl_process_get_sql(  )			*/
/*										*/
/*			2010/05/31 by A.Koba		*/
/*										*/
/****************************************/
int cl_process_get_sql( prmp, para, piCmd, piPrm, TrnId , pszHostId)
parmList *prmp;
qSndPara *para;
short    *piCmd;
short    *piPrm;
char     *TrnId;
char     *pszHostId;
{
	static char *_fn_=" cl_process_get_sql";
	FILE   *SQLfp;
	FORM_S sForm;
	FORM_K kForm;
	qIndirectInfo iForm;
	char *p,*pszRet,cM_QUOTE1;
	char *pBD,buf[D_RECORD_BUFSIZE];
	char samehost[D_RECORD_BUFSIZE];
	int    iBD,irc,iWrtPos=0;
	int i,m, numsql;
	INT4 wkl;
	tdtInfoParm *pInfoParm;

	memset(&sForm,0,sizeof(FORM_S));
	memset(&kForm,0,sizeof(FORM_K));
	memset(&iForm,0,sizeof(qIndirectInfo));

	pBD = prmp->prp;
	iBD = prmp->prmlen;

	if ((iBD=cl_sqlcnvt(pBD,&pszRet)) < 0) return iBD;
	else if (iBD > 0) pBD = pszRet;

	if ((irc = cl_sqltype(pBD,&numsql)) < 0) {
			/* %s: ԍĂ܂B */
		ERROROUT1(FORMAT(573),_fn_);
		return ECL_EX_SQL;
	}
	else if (irc > 0) {
		/* ԍ̎ */
		if (numsql < 0 || numsql > MAX_PROC_NUM) {
				/* %s: ԍ͈͊OłB */
			ERROROUT1(FORMAT(574),_fn_);
			return (ECL_EX_SQL);
		}
		*piCmd = numsql;
		*piPrm = 1;
		sForm.zoksei = (uchar)((DEF_ZOK_CHAR << 4) | 0x01);
		sForm.zoksei |=  CLcommon.cDataCode << 1;
		sForm.datlen = (uchar)sizeof(INT4) * 3;
		iWrtPos += cmn_mem_wrt(TrnId,&sForm,sizeof(FORM_S));
		wkl = htonl(CLcommon.iOwnIPAddr);
		iWrtPos += cmn_mem_wrt(TrnId+iWrtPos,&wkl,sizeof(INT4));
		wkl = htonl(CLcommon.ProcessId);
		iWrtPos += cmn_mem_wrt(TrnId+iWrtPos,&wkl,sizeof(INT4));
		iWrtPos += cmn_mem_wrt(TrnId+iWrtPos,pCLprocTable->CurCmdId,sizeof(INT4));
		if (numsql == 1) {
			if ((i=getsamehost(pszHostId,samehost))<=0)
				strcpy(samehost,pszHostId);
			if (strlen(samehost) != giHOST_ID_SIZE) {
				ERROROUT(FORMAT(3));	/* zXghcsłB */
				return ECL_EX_SQL;
			}
			if (pInfoParm = cl_get_global_var(D_NAM_TRNSHID)) {
				p = pInfoParm->pi_data;
				m = pInfoParm->pi_dlen/giHOST_ID_SIZE;
				for (i=0;i<m;i++) {
					if (!memcmp(p,samehost,giHOST_ID_SIZE)) break;
					p += giHOST_ID_SIZE;
				}
				if (i>=m) {
					if (sizeof(buf) < strlen(D_NAM_TRNSHID)*2+giHOST_ID_SIZE+13) return -1;
					cM_QUOTE1 = pGlobTable->Quat[0];
					sprintf(buf,"$%s &+= %c%s*%c",
					        D_NAM_TRNSHID,cM_QUOTE1,samehost,cM_QUOTE1);
					if ((irc=cl_gx_exps_obj_opt(buf,&pCLprocTable->bxobj[2],NULL,
					                      NULL,D_GX_OPT_ALC_CONST)) < 0) return irc;
				}
			}
			else {
					/* %s: Oϐ[%s]`łB */
				ERROROUT2(FORMAT(575),_fn_,D_NAM_TRNSHID);
				return ECL_EX_SQL;
			}
		}
	}
	else {
		/* rpk̎ */
		if (cl_chk_sql(pBD) == D_FIND_SELECT) *piCmd = 101;
		else *piCmd = 102;
		*piPrm = 3;

		if (iBD > 255) { 
			kForm.zoksei = (DEF_ZOK_CHAR << 4) | 0x00;
			kForm.zoksei |=  CLcommon.cDataCode << 1;
			wkl = htonl(iBD);
			memcpy(kForm.datlen,&wkl,4);
			para->pBody = Malloc( sizeof(FORM_K) + iBD );
			if (para->pBody == NULL) return SYSTEMERROR;
			iWrtPos += cmn_mem_wrt(para->pBody,&kForm,sizeof(FORM_K));
			iWrtPos += cmn_mem_wrt(para->pBody+iWrtPos,pBD,iBD);
			para->iLeng = sizeof(FORM_K) + iBD;
		}
		else {
			sForm.zoksei = (DEF_ZOK_CHAR << 4) | 0x01;
			sForm.zoksei |=  CLcommon.cDataCode << 1;
			sForm.datlen = (unsigned char)iBD;
			para->pBody = Malloc( sizeof(FORM_S) + iBD );
			if (para->pBody == NULL) return SYSTEMERROR;
			iWrtPos += cmn_mem_wrt(para->pBody,&sForm,sizeof(FORM_S));
			iWrtPos += cmn_mem_wrt(para->pBody+iWrtPos,pBD,iBD);
			para->iLeng = sizeof(FORM_S) + iBD;
		}
	}
	return NORMAL;
}

/****************************************/
/*										*/
/* int cl_process_get_area_id(prmp,para)*/
/*										*/
/*			2010/05/31 by A.Koba		*/
/*										*/
/****************************************/
int cl_process_get_area_id(prmnum, prmp, Obj, para, sCmdNo)
int      prmnum;
parmList *prmp[];
int      *Obj;
qSndPara *para;
short sCmdNo;
{
	char *name;
	FORM_S sForm;
	char  *pBD     = NULL,
	      *pFlPath = NULL,
	       pAreaId[256],
	       szFlPath[256],c;
	int    iBD     = 0,
	       irc     = 0,
	       iAraLen = 0,
	       iWrtPos = 0;
	tdtInfoParm     rPrm;
	parmList *prmw;

	memset(&sForm,0,sizeof(FORM_S));
	if (sCmdNo == 101) {
		if (prmnum>=4) prmw = prmp[3];
		else prmw = NULL;
		if (irc = cl_get_area_id(prmw,Obj,&name)) return irc;
		iAraLen = strlen(name);
		strnzcpy(pAreaId,CLcommon.dcHostId,sizeof(pAreaId)-1);
		iWrtPos  = strlen(pAreaId);
		if (iAraLen+iWrtPos+1 > sizeof(pAreaId)) return -1;
		iWrtPos += cmn_mem_wrt(pAreaId+iWrtPos,name,strlen(name));
		if (iWrtPos+7 > sizeof(szFlPath)) return -1;
		pAreaId[iWrtPos] = '\0';
		sprintf(szFlPath, "spool/%s%d", pAreaId, pCLprocTable->iThread);
		iAraLen = strlen( szFlPath );
		sForm.zoksei = DEF_ZOK_CHAR << 4 | D_FMT_STD ;
		sForm.datlen = iAraLen;

		if ((para->pBody = Malloc(sizeof(FORM_S)+sForm.datlen)) == NULL)
			return ECL_SYSTEM_ERROR;

		iWrtPos =cmn_mem_wrt(para->pBody,&sForm,sizeof(FORM_S));
		iWrtPos+=cmn_mem_wrt(para->pBody+iWrtPos,szFlPath,iAraLen);
		para->iLeng = iWrtPos;
	}
	else {
		/* w肳Ă`FbN邾 */
		if (prmnum>=4 && prmp[3]->prmlen>0) {
			if (irc = cl_get_area_id(prmp[3],Obj,&name)) return irc;
		}
		sForm.zoksei = (DEF_ZOK_CHAR << 4) | 0x01;
		sForm.datlen = 0x00;

		if ((para->pBody = Malloc( sizeof(FORM_S))) == NULL)
			return ECL_SYSTEM_ERROR;

		para->iLeng = cmn_mem_wrt(para->pBody, &sForm, sizeof(FORM_S));
	}
	return NORMAL;
}

/*****************************************/
/*                                       */
/*****************************************/
static int _get_wait_time(nprm, prmp, Obj, pwtime, msg)
int nprm;
parmList *prmp[];
int      *Obj;
int *pwtime;
char *msg;
{
	tdtInfoParm rInfoParm;
	int     rc,atr,iAttr[3],Value,Val[2],n;
	double  dValue;

	n = 0;
	if (rc = cl_gx_exp_obj(nprm,prmp,Obj,&rInfoParm)) {
			/* _get_wait_time: %s̎Ă܁B */
		ERROROUT1(FORMAT(57),msg);
		rc = ECL_EX_SLEEP;
	}
	else if (rc=cl_get_parm_double(&rInfoParm,Val,msg,iAttr)) rc = ECL_EX_SLEEP;
	else {
		atr = iAttr[0];
		if (atr == DEF_ZOK_BINA) n = CL_GET_VAL_BIN(Val) * 1000;
		else if (atr == DEF_ZOK_FLOA) {
			memcpy(&dValue,Val,sizeof(double));
			n = cl_chk_over_flow_d2_i(dValue * 1000.0,msg);
		}
		else rc = ECL_EX_SLEEP;
	}
	*pwtime = n;
	return rc;
}

/*****************************************/
/*                                       */
/* int cl_process_sqlsnd( prmp )         */
/*                                       */
/*           2010/05/31 by A.Koba        */
/*                                       */
/*****************************************/
int cl_process_sqlsnd(prmnum, prmp, Obj)
int      prmnum;
parmList *prmp[];
int      *Obj;
{
	static long lMsgNo;		/* bZ[Wmn          */
	qColToDb rPack;			/* MpPbg ʕ   */
	qSndPara rPara[3];		/* MpPbg p[^ */
	INT4     lHostId  = 0L;	/* zXghc              */
	char     *pszHostId;
	int      idlen,time_out;
	int      rc       = 0,
	         iHFile   = 0,
	         ialloc   = 0,
	         ipack ,
	        *pipack   = NULL;
	short    sCmdNo   = 0,
	         sPrmNo   = 0;
	char    *pSndPack = NULL,
	        *pHstFile = NULL,
	         cHead1[8],cHead2[8],
	         rTrnId[sizeof(FORM_S)+12];
	tdtInfoParm rPrm, rInfoParm;
	char	*pBD, c;
	int     iProcId;
	AKAMSGCOM *tpMsgCom;
	int iWrtPos = 0;

	/* gp\̂̏ */
	memset(&rPrm,0,sizeof(tdtInfoParm));
	memset(&rInfoParm,0,sizeof(tdtInfoParm));
	memset(&rPack,0,sizeof(qColToDb));
	memset(&rPara[0],0,sizeof(qSndPara));
	memset(&rPara[1],0,sizeof(qSndPara));
	memset(&rPara[2],0,sizeof(qSndPara));

	/* prmp[0] zXghc̎擾 */
	iProcId = pCLprocTable->usDbProcId;
	if (rc=cl_arg_to_char(prmp[0],Obj,&rInfoParm,FORMAT(516))) return rc;	/* zXghc */
	pBD   = rInfoParm.pi_data;
	idlen = rInfoParm.pi_dlen;
	if (idlen) {
		/* zXghoAhX擾 */
		pszHostId = pBD;
		rc = cl_process_get_ipaddr( pszHostId, &lHostId );
		if (rc < 0) {
			/* zXg[%s]dchostsɂȂAAhX擾ł܂B ret=%d */
			ERROROUT2(FORMAT(517),pszHostId,rc);
			return ECL_EX_SQL;
		}
		else if (rc > 0) iProcId = rc;
		rc = 0;
	}
	else {
		pszHostId = CLcommon.dbHostId;
		lHostId = CLcommon.dbHostAddr; 
	}

	/* prmp[1] wip[^j */
	rc = cl_process_get_attr(prmp[1],Obj,&rPara[1]);
	if (rc != NORMAL) goto Err;

	/* prmp[2] rpkiOp[^j */
	rc = cl_process_get_sql(prmp[2],&rPara[2],&sCmdNo,&sPrmNo,rTrnId,pszHostId);
	if (rc != NORMAL) goto Err;

	/* prmp[3] f[^i[GAʎq */
	rc = cl_process_get_area_id(prmnum, prmp, Obj, &rPara[0], sCmdNo );
	if (rc != NORMAL) goto Err;

	/* prmp[4] ^CAEgl(sec) */
	if (prmnum >= 5) {
															/* ^CAEgl */
		if (rc = _get_wait_time(prmnum-4,&prmp[4],Obj,&time_out,FORMAT(518))) goto Err;
	}
	else time_out = -1;

	if (sCmdNo >= 101) sCmdNo = 101;

	/* MpPbg쐬 */
	tpMsgCom = (AKAMSGCOM *)pCLprocTable->WrPacketp;
	tpMsgCom->lHostId   = lHostId;
	tpMsgCom->usProcId  = iProcId;
	tpMsgCom->usClassId = pCLprocTable->usDbClassId;

	rPack.lMsgNo   = time(0);
	rPack.usCmdNo  = htons(sCmdNo);
	rPack.usPrmNum = htons(sPrmNo);
	rPack.lret     = htonl(time_out);
	memcpy( rPack.cItfId, "DB", 2 );
	memcpy( rPack.cMsgId, "CM", 2 );

	if( sCmdNo == 101 ){
		tpMsgCom->lMsgLen = sizeof(qColToDb)+rPara[0].iLeng+rPara[1].iLeng+
		                    rPara[2].iLeng;
		pSndPack = Malloc(tpMsgCom->lMsgLen);
		if( pSndPack == NULL ) {
			rc = SYSTEMERROR;
			goto Err;
		}
		iWrtPos  = cmn_mem_wrt(pSndPack,&rPack,sizeof(qColToDb));
		iWrtPos += cmn_mem_wrt(pSndPack+iWrtPos, rPara[0].pBody, rPara[0].iLeng);
		iWrtPos += cmn_mem_wrt(pSndPack+iWrtPos, rPara[1].pBody, rPara[1].iLeng);
		iWrtPos += cmn_mem_wrt(pSndPack+iWrtPos, rPara[2].pBody, rPara[2].iLeng);
	}
	else {
		tpMsgCom->lMsgLen = sizeof(qColToDb)+sizeof(rTrnId);
		pSndPack = Malloc(tpMsgCom->lMsgLen);
		if( pSndPack == NULL ) {
			rc = SYSTEMERROR;
			goto Err;
		}

		iWrtPos  = cmn_mem_wrt(pSndPack,&rPack,sizeof(qColToDb));
		iWrtPos += cmn_mem_wrt(pSndPack+iWrtPos, rTrnId, sizeof(rTrnId));
	}

	tpMsgCom->cpMsg = pSndPack;
	tpMsgCom->ucFilec = 0;
	rc = NORMAL;
 Err:
	if (rPrm.pi_data)   Free(rPrm.pi_data);
	if (pHstFile)       Free(pHstFile);
	if (rPara[0].pBody) Free(rPara[0].pBody);
	if (rPara[1].pBody) Free(rPara[1].pBody);
	if (rPara[2].pBody) Free(rPara[2].pBody);

	return rc;
}

/*****************************************/
/*                                       */
/* int cl_process_sleep_snd( nprm, prmp )*/
/*                                       */
/*                                       */
/*****************************************/
int cl_process_sleep_snd(nprm, prmp, proc)
int nprm;
parmList *prmp[];
ProcCT  *proc;
{
	qColToDb *pDTD;		/* MpPbg ʕ   */
	int       n = 1;
	AKAMSGCOM *tpMsgCom;
	int     rc;

	if (nprm > 0) {
														/* rkddol */
		if (rc = _get_wait_time(nprm, prmp, proc->Obj, &n, FORMAT(519))) return rc;
#ifdef OLD_COAL
		if (n == ECL_DO_STACK_ZERO) {
/*
printf("cl_process_sleep_snd: iStackDepth=%d\n",pCLprocTable->iStackDepth);
*/
			if (pCLprocTable->iStackDepth < MAX_DO_STACK_DEPTH)
				return ECL_DO_STACK_ZERO;
			n = 0;
		}
		else 
#endif
		if (n < 0) {
			ERROROUT(FORMAT(520));	/* cl_process_sleep_snd: rkddolłB */
			return( ECL_EX_SLEEP );
		}
	}

	/* MpPbg쐬 */
	tpMsgCom = (AKAMSGCOM *)pCLprocTable->WrPacketp;
	memset((char *)tpMsgCom,0,sizeof(AKAMSGCOM));
	tpMsgCom->lMsgLen = sizeof(qColToDb);
	if (!(pDTD = (qColToDb *)Malloc(tpMsgCom->lMsgLen))) {
		return SYSTEMERROR;
	}
	tpMsgCom->cpMsg = (char *)pDTD;
	pDTD->lMsgNo   = time(0);
	pDTD->usCmdNo  = htons(30001);
	pDTD->usPrmNum = 0;
	pDTD->lret     = htonl(n);
	memcpy( pDTD->cItfId, "DB", 2 );
	memcpy( pDTD->cMsgId, "CM", 2 );

	return NORMAL;
}

/*****************************************/
/*                                       */
/* int cl_process_sleep_rcv( nprm, prmp )*/
/*                                       */
/*                                       */
/*****************************************/
int cl_process_sleep_rcv( nprm, prmp )
int nprm;
parmList *prmp[];
{
	return 0;
}

/****************************************/
/*										*/
/****************************************/
static int _set_array_tbl(pTBL,pIndex,ix,pInfoParmW)
tdtInfoParm ***pTBL;
tdtArrayIndex *pIndex;
int ix;
tdtInfoParm *pInfoParmW;
{
	int rc;
	tdtInfoParm *pInfoParm;

	pInfoParm = cl_get_array_and_var_ent(pIndex,pTBL,ix);
	if (pInfoParm) {
		rc = cl_gx_rep_info_set(pInfoParm,pInfoParmW,1);
	}
	else rc = -1;
	return rc;
}

/*****************************************/
/* int cl_process_msg_snd( nprm, prmp )   */
/*****************************************/
int cl_process_msg_snd(nprm,prmp,Obj)
int nprm;
parmList *prmp[];
int      *Obj;
{
	static char *_fn_="cl_process_msg_snd";
	tdtInfoParm *pInfoParm,rInfoParm,rInfoParmW;
	tdtInfoParm ***pTBL;
	int rc,n,i,len,ix,iVal,time_out;
	char w1[32],*p1;
	char c,*p,*name;
	tdtArrayIndex tIndex;
	AKAMSGCOM *tpMsgCom;
	ulong ulpaddr_h;
	parmList *pparmList;

	/* FORMAT(515): %s:%dp[^[%s]Ă܂Brc=%d */

	/* MpPbg쐬 */
	tpMsgCom = (AKAMSGCOM *)pCLprocTable->WrPacketp;
	/* SEND Host Proc Class Msg file -r recv */
	time_out = -1;
	pparmList = prmp[0];
	p = pparmList->prp;
	for (i=1;i<nprm;i++) {
		if (!stricmp((p=prmp[i]->prp),"RECV")) {
			i++;
			break;
		}
		else if (!stricmp((p=prmp[i]->prp),"CHANNEL")) {
			if (i == 1) {
				tpMsgCom->ucAkbOption = AKA_AKO_CHANNEL;
				continue;
			}
			else {
				ERROROUT4(FORMAT(515),_fn_,i,p,rc);
				return ECL_EX_MSG;
			}
		}
		rc = cl_gx_exp_obj(1,&prmp[i],Obj,&rInfoParm);
		if (rc) {
			ERROROUT4(FORMAT(515),_fn_,i,p,rc);
			return ECL_EX_MSG;
		}
		switch (i) {
		case 1:	/* HostName */
		case 4:	/* Msg */
		case 5:	/* file */
			p1 = w1;
			if ((len = parm_to_char(&rInfoParm,&p1,NULL)) < 0) return len;
			if (len > 0) {

DEBUGOUTL2(200,"cl_process_msg_snd: i=%d p1=[%s]",i,p1);

				if (i==1) {
#if 0
					if (rc=akb_get_host_addr(p1,&ulpaddr_h)) {
						return ECL_EX_MSG;
					}
					tpMsgCom->lHostId = ulpaddr_h;
#else
					tpMsgCom->lHostId = 0;
#endif
				}
				else if (i==4) {
					if (!(tpMsgCom->cpMsg=Malloc(len+1+sizeof(int)))) {
						ERROROUT1("cl_process_msg_snd: malloc error len=%d",len);
						return ECL_EX_MSG;
					}
					memcpy(tpMsgCom->cpMsg,p1,len+1);
					tpMsgCom->lMsgLen = len + 1;
				}
				else {
					tpMsgCom->ucFilec = 1;
					strnzcpy(tpMsgCom->cpFilev[0],p1,255);
				}
			}
			break;
		case 2:	/* ProcNo */
		case 3:	/* ClassNo */
		case 6:	/* TimeOut(msec) */
			if (rc = cl_get_parm_bin(&rInfoParm,&iVal,"Proc/Class: "))
				return ECL_EX_MSG;
			if (i==2) tpMsgCom->usProcId  = iVal;
			else if (i==3) tpMsgCom->usClassId = iVal;
			else time_out = iVal;
		}
	}
	if (i < nprm) {
		rc = cl_gx_exp_obj(1,&prmp[i],Obj,&rInfoParm);
		if (!rc) {
			if (!(rc=cl_check_use_mapped_array(&rInfoParm)))
				if (!(rc=cl_get_array_index_tbl(&rInfoParm,&tIndex,&pTBL,"recv IndexTBL:")))
					rc = cl_check_use_hash_array(&rInfoParm,&tIndex);
		}
		if (rc) {
			ERROROUT4(FORMAT(515),_fn_,i,prmp[i]->prp,rc);
			return ECL_EX_MSG;
		}
		cl_set_parm_bin(&rInfoParmW,0);
		rc = _set_array_tbl(pTBL,&tIndex,tIndex.index[0],&rInfoParmW);
		tpMsgCom->usDisposition = 1;
	}
	else tpMsgCom->usDisposition = 0;
	tpMsgCom->usDisposition |= 0x1000;
	memcpy(tpMsgCom->cpMsg+tpMsgCom->lMsgLen,&time_out,sizeof(int));

	return 0;
}

/*****************************************/
/* int cl_process_msg_rcv( nprm, prmp )   */
/*****************************************/
int cl_process_msg_rcv(nprm, prmp, Obj)
int nprm;
parmList *prmp[];
int      *Obj;
{
	static char *_fn_="cl_process_msg_rcv";
	int rc,i,msglen,len,n,ix;
	char *msg,*p,**pFv,c;
	AKAMSGCOM *tpMsgCom;
	tdtInfoParm rInfoParm,rInfoParm1,*pInfoParm;
	tdtInfoParm ***pTBL;
	tdtArrayIndex tIndex;
	int *index=NULL;

	pGlobTable->tuppl  = 0;
	pGlobTable->column = 0;
	pGlobTable->errmsg[0] = '\0';

	if (pCLprocTable->PrPacketp == NULL) return -1;
	tpMsgCom = (AKAMSGCOM *)pCLprocTable->PrPacketp;
	if ((pGlobTable->error = tpMsgCom->sPackRet) < 0 ) {
		strnzcpy(pGlobTable->errmsg,akb_str_error(pGlobTable->error),
		         sizeof(pGlobTable->errmsg)-1);
		pGlobTable->exception = cl_mk_exception_code(COMM_EXCEPTION,pGlobTable->error);
		return 0;
	}

	for (i=1;i<nprm;i++) {
		if (!stricmp(prmp[i]->prp,"RECV")) {
			i++;
			break;
		}
	}
	rc = 0;
	if (i < nprm) {
		index = tIndex.index;
		pInfoParm = &rInfoParm;
		rc = cl_gx_exp_obj(1,&prmp[i],Obj,&rInfoParm);
		if (!rc) {
			if (!(rc=cl_check_use_mapped_array(pInfoParm)))
				if (!(rc=cl_get_array_index_tbl(pInfoParm,&tIndex,&pTBL,"recv IndexTBL:")))
					rc = cl_check_use_hash_array(pInfoParm,&tIndex);
		}
		if (rc) {
			/* %s: %dp[^[%s]Ă܂Brc=%d */
			ERROROUT4(FORMAT(515),_fn_,i,prmp[i]->prp,rc);
			return ECL_EX_MSG;
		}
		c = pInfoParm->pi_id;
		msg = tpMsgCom->cpMsg;
		msglen = tpMsgCom->lMsgLen;
		n = tpMsgCom->ucFilec;
		if (msglen>0 || n) {
			n++;
			ix = index[0] + 1;
			pFv = tpMsgCom->cpFilev;
			rInfoParm.pi_id = ' ';
			rInfoParm.pi_attr = DEF_ZOK_CHAR;
			rInfoParm.pi_scale= 0;
			rInfoParm.pi_code = CLcommon.cDataCode;
			for (i=0;i<n;i++,ix++) {
				if (i == 0) {
					rInfoParm.pi_data   = msg;
					rInfoParm.pi_dlen = msglen;
				}
				else {
					rInfoParm.pi_data   = pFv[i-1];
					rInfoParm.pi_dlen = strlen(rInfoParm.pi_data);
				}
				if (rc = _set_array_tbl(pTBL,&tIndex,ix,&rInfoParm)) break;
			}
		}
		else n = 0;
		cl_set_parm_bin(&rInfoParm,n);
		rc = _set_array_tbl(pTBL,&tIndex,index[0],&rInfoParm);
	}
	return rc;
}
