static    char    sccsid[]="%Z% %M% %I% %E% %U%";
/********************************************************************/
/* <clfuncmath.c>                                                     */
/*      func_math                                           */
/*                              by Koba       (2007/12/22 Ver 0.1) */
/********************************************************************/

#include "colmn.h"        /* ֐vg^Cv錾 */

extern CLCOMMON  CLcommon;
extern CLPRTBL   *pCLprocTable;
extern GlobalCt  *pGlobTable; 
extern int giOptions[];

/****************************************/
/*										*/
/****************************************/
int func_math(pWork,pOperator,nparm,ppParm,ope)
char *pWork;
char *pOperator;
tdtInfoParm *ppParm[];
int nparm,ope;
{
	int ret,rc,atr1,atr2,iAttr[3];
	int Val1[2],Val2[2];
	double dValue1,dValue2,dVal;
/*
printf("func_math: pOperator=%s nparm=%d ope=%d\n",pOperator,nparm,ope);
*/
	ret = 0;
	dVal = 0.0;
	if (ope == D_FUC_RAND1) {
		if (nparm > 0) ERROROUT1(FORMAT(401),pOperator);	/* %s 𖳎܂B */
		dVal = drand48();
	}
	else if (ope == D_FUC_SRAND1) {
		if ((rc = cl_get_parm_bin(ppParm[0],Val1,"Parm1:"))  < 0) ret = rc;
		else if (rc > 0) ret = ECL_SCRIPT_ERROR;
		else srand48(Val1[0]);
	}
	else {
		if ((rc=cl_get_parm_double(ppParm[0],Val1,"Parm1:",iAttr)) < 0) return rc;
		else if (rc > 0) return ECL_SCRIPT_ERROR;

		atr1 = iAttr[0];
		if (atr1 == DEF_ZOK_BINA) dValue1 = CL_GET_VAL_BIN(Val1);
		else if (atr1 == DEF_ZOK_FLOA) memcpy(&dValue1,Val1,sizeof(double));
		else return ECL_SCRIPT_ERROR;

		switch (ope) {
			case D_FUC_SQRT:
				if (dValue1 >= 0.0) dVal = sqrt(dValue1);
				else {
					ERROROUT1(FORMAT(402),pOperator);	/* %s łB */
					ret = ECL_SCRIPT_ERROR;
				}
				break;
			case D_FUC_SIN:
				dVal = sin(dValue1);
				break;
			case D_FUC_COS:
				dVal = cos(dValue1);
				break;
			case D_FUC_TAN:
				dVal = tan(dValue1);
				break;
			case D_FUC_ATAN:
				dVal = atan(dValue1);
				break;
			case D_FUC_LOG:
			case D_FUC_LOG10:
				if (dValue1 < 1.0e-6) {
					ERROROUT1(FORMAT(403),pOperator);	/* %s słB */
					ret = ECL_SCRIPT_ERROR;
				}
				else {
					if (ope == D_FUC_LOG) dVal = log(dValue1);
					else dVal = log10(dValue1);
				}
				break;
			case D_FUC_EXP:
				dVal = exp(dValue1);
				break;
			case D_FUC_POWER:
				if (nparm < 2) {
					ERROROUT1(FORMAT(404),pOperator);	/* %s wl܂B */
					ret = ECL_SCRIPT_ERROR;
				}
				else {
					if ((rc=cl_get_parm_double(ppParm[1],Val2,"Parm2:",iAttr)) < 0) return rc;
					else if (rc > 0) return ECL_SCRIPT_ERROR;

					atr2 = iAttr[0];
					if (atr2 == DEF_ZOK_BINA) dValue2 = CL_GET_VAL_BIN(Val2);
					else if (atr2 == DEF_ZOK_FLOA) memcpy(&dValue2,Val2,sizeof(double));
					else return ECL_SCRIPT_ERROR;
					dVal = pow(dValue1,dValue2);
				}
				break;
			case D_FUC_CBRT:
				dVal = cbrt(dValue1);
				break;
			case D_FUC_SINH:
				dVal = sinh(dValue1);
				break;
			case D_FUC_COSH:
				dVal = cosh(dValue1);
				break;
			case D_FUC_TANH:
				dVal = tanh(dValue1);
				break;
			case D_FUC_ATANH:
				dVal = atanh(dValue1);
				break;
			case D_FUC_CEIL:
				dVal = ceil(dValue1);
				break;
			case D_FUC_FLOOR:
				dVal = floor(dValue1);
				break;
			case D_FUC_RINT:
				dVal = rint(dValue1);
				break;
			default:
				ERROROUT1("func_math: function=[%s] not defined!!",pOperator);
				ret = ECL_SCRIPT_ERROR;
		}
	}
	memcpy(pWork,&dVal,sizeof(double));
	return ret;
}
