static  char    sccsid[]="%Z% %M% %I% %E% %U%";
/*****************************************************/
/*                                                   */
/*       Execute expression imediately               */
/*                                                   */
/*****************************************************/
#include "colmn.h"

extern GlobalCt  *pGlobTable;
extern CLCOMMON  CLcommon;
extern int giOptions[];
extern char cmp_sep2[];
#if 1
	static char cmp_sep[]={" \t'+-*/&|=^~!<>[](),;?:{}"};
#else
	static char cmp_sep[]={" \t'+-*/&|=^~!<>[](),;?:"};
#endif

static char *logical[]={"AND","OR","NOT","&&","||","!",NULL};
static char *math[]={"+","-","*","/","&","^","|","~","%","<<",">>","**",NULL};
static char *hk[]={"<=","=<",">=","=>","==","==","<>","><","!=","!=","<",">",NULL};
static char *HK[]={"LT","GT","LE","GE","EQ","NE","iEQ","iNE",NULL};
static char *ex[]={"&=","^=","|=","","","","","","~=","",
"*=","/=","%=","+=","-=","<<=",">>=","&+=","|+=",NULL};
static char *cast[]={"CCHAR","CBIN","CINT","CLONG","CDEC","CFLOAT","CDOUBLE","CBULK","FUNC",NULL};

static short act[28][28]={																   /*  O   */
	{99, 2,-1, 2,-1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 2,-1, 2, 2, 2, 1}, /* 0       */
	{-1, 2, 4, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 6, 2,-1, 2, 2, 2, 1}, /* 1  (    */
	{-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1}, /* 2  )    */
	{-1, 2,-1, 2, 5, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 6, 2,-1, 2, 2, 2, 1}, /* 3  [    */
	{-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1}, /* 4  ]    */
	{ 3, 2, 3, 2, 3, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,-1, 3, 2, 3, 2, 3, 2, 1}, /* 5 ! ~   */
	{ 3, 2, 3, 2, 3, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,-1, 3, 2, 3, 2, 3, 2, 1}, /* 6 (x)   */
	{ 3, 2, 3, 2, 3, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,-1, 3, 2, 3, 2, 3, 2, 1}, /* 7 * /   */
	{ 3, 2, 3, 2, 3, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,-1, 3, 2, 3, 2, 3, 2, 1}, /* 8  +-   */
	{ 3, 2, 3, 2, 3, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,-1, 3, 2, 3, 2, 3, 2, 1}, /* 9 << >> */
	{ 3, 2, 3, 2, 3, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,-1, 3, 2, 3, 2, 3, 2, 1}, /*10 CONCAT*/
	{ 3, 2, 3, 2, 3, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3,-1, 3, 2, 3, 2, 3, 2, 1}, /*11 <= >  */
	{ 3, 2, 3, 2, 3, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3,-1, 3, 2, 3, 2, 3, 2, 1}, /*12 == != */
	{ 3, 2, 3, 2, 3, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3,-1, 3, 2, 3, 2, 3, 2, 1}, /*13  &    */
	{ 3, 2, 3, 2, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3,-1, 3, 2, 3, 2, 3, 2, 1}, /*14  ^    */
	{ 3, 2, 3, 2, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3,-1, 3, 2, 3, 2, 3, 2, 1}, /*15  |    */
	{ 3, 2, 3, 2, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3,-1, 3, 2, 3, 2, 3, 2, 1}, /*16  &&   */
	{ 3, 2, 3, 2, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3,-1, 3, 2, 3, 2, 3, 2, 1}, /*17  ||   */
	{ 3, 2, 3, 2, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3,-1, 3, 2, 3, 2, 3, 2, 1}, /*18  ?    */
	{ 3, 2, 3, 2, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3,-1, 3, 2, 3, 2, 3, 2, 1}, /*19  :    */
	{ 3, 2, 3, 2, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 2, 3, 2, 2, 2, 1}, /*20 = +=  */
	{ 3, 2, 3, 2, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,-1, 2, 3, 2, 2, 2, 1}, /*21  ,    */
	{-1, 2, 3, 2, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 6, 2, 4, 2, 2, 2, 1}, /*22  {    */
	{-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1}, /*23  }    */
	{ 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1}, /*24 .name */
	{ 3, 2, 3, 2, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,-1, 3, 2, 3, 2, 3, 2, 1}, /*25 ..    */
	{ 3, 2, 3, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,-1, 3, 2, 3, 2, 3, 2, 1}, /*26 **    */
	{-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1}  /*27     */
 /* {    (  )  [  ] !~ (x) *  +- << C  <= != &  ^  |  && || ?  : += ,  {  } .x .. ** }  <--  */
};

/****************************************/
/*										*/
/****************************************/
int cl_gx_expsn_obj_opt(buf,len,bxobj,Obj,pInfoParmW,opt)
char *buf;
int  len;
GXObject *bxobj[];
tdtInfoParm **Obj;
tdtInfoParm *pInfoParmW;
int opt;
{
	GWPRM_S gwprm;
	SSPL_S ssp;
	char wrk[4096];
/*
printf("cl_gx_expsn_obj_opt: len=%d buf=[%s]\n",len,buf);
*/
	ssp.sp = 0;
	ssp.wd = wrk;
	ssp.wdmax = sizeof(wrk);
	memset(&gwprm,0,sizeof(GWPRM_S));
	gwprm.iparam = -1;
	gwprm.line = buf;
	gwprm.line_len = len;
	return cl_gx_exp_gp_obj_opt(&gwprm,&ssp,bxobj,Obj,pInfoParmW,opt);
}

/****************************************/
/*										*/
/****************************************/
int cl_gx_exps_obj_opt(buf,bxobj,Obj,pInfoParmW,opt)
char *buf;
GXObject *bxobj[];
tdtInfoParm **Obj;
tdtInfoParm *pInfoParmW;
int opt;
{
	return cl_gx_expsn_obj_opt(buf,strlen(buf),bxobj,Obj,pInfoParmW,opt);
}

/****************************************/
/*										*/
/****************************************/
int cl_gx_exp(nparm,prmp,pInfoParmW)
int nparm;
parmList  *prmp[];
tdtInfoParm *pInfoParmW;
{
	return cl_gx_exp_obj_opt(nparm,prmp,NULL,pInfoParmW,0);
}

/****************************************/
/*										*/
/****************************************/
int cl_gx_exp_obj(nparm,prmp,Obj,pInfoParmW)
int nparm;
parmList  *prmp[];
tdtInfoParm **Obj;
tdtInfoParm *pInfoParmW;
{
DEBUGOUTL2(150,"cl_gx_exp_obj: nparm=%d prmp[0]->opt=0x%08x",nparm,prmp[0]->opt);
	return cl_gx_exp_obj_opt(nparm,prmp,Obj,pInfoParmW,0);
}

/****************************************/
/*										*/
/****************************************/
int cl_mk_gp_parm(mcat,pgwprm,nparm,prmp)
MCAT *mcat;
GWPRM_S *pgwprm;
int nparm;
parmList  *prmp[];
{
	int len,i,rc;
	char *p;

	if (nparm <= 0) {
		len = 0;
		p   = "";
	}
	else if (nparm > 1) {
		for (i=0;i<nparm;i++) {
			len = prmp[i]->prmlen;
			p   = prmp[i]->prp;
			if (len>0 && p) {
				if (i>0) if ((rc=akxtmcat(mcat," ",1))<0) return rc;
				if ((rc=akxtmcat(mcat,p,len))<0) return rc;
			}
		}
		if ((rc=akxtmcat(mcat,"",1))<0) return rc;
		len = mcat->mc_ipos;
		p   = mcat->mc_bufp;
	}
	else {
		len = prmp[0]->prmlen;
		p   = prmp[0]->prp;
	}
	pgwprm->line = p;
	pgwprm->line_len = len;
/*
printf("cl_mk_gp_parm: nparm=%d len=%d p=%08x [%s]\n",nparm,len,p,p);
*/
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_gx_exp_obj_opt(nparm,prmp,Obj,pInfoParmW,opt)
int nparm;
parmList  *prmp[];
tdtInfoParm **Obj;
tdtInfoParm *pInfoParmW;
int opt;
{
	GWPRM_S gwprm;
	MCAT mcat;
	SSPL_S ssp;
	int rc,i,len;
	char wrk[4096],*p;
	GXObject  **bxobj;

DEBUGOUTL2(150,"cl_gx_exp_obj_opt: prmp[0]->opt=0x%08x opt=0x%08x",prmp[0]->opt,opt);
	ssp.sp=0;
	ssp.wd=wrk;
	ssp.wdmax = sizeof(wrk);
	if (prmp[0]->opt & D_GX_OPT_NO_USE_OBJ) bxobj = NULL;
	else bxobj = &prmp[0]->bxobj;

	gwprm.nparam = nparm;
	gwprm.maxlen = sizeof(wrk)-1;
	gwprm.parmLp = prmp;
	gwprm.iparam = 0;
	rc = cl_gx_exp_gp_obj_opt(&gwprm,&ssp,bxobj,Obj,pInfoParmW,opt);

	return rc;
}

/************************************/
/*									*/
/************************************/
int cl_set_obj0_used(used)
int used;
{
	ScrPrCT *scrct;
	ProcCT *proc;
	Leaf *leaf;

	if (proc=cl_search_proc_ct()) {
		if (leaf = proc->ProcTop)
			leaf->cmd.parl[D_PROC_OBJ0_USED].parlen = used;
/*
printf("cl_set_obj0_used:proc=%08x used=%d\n",proc,used);
*/
	}
	else if (scrct=cl_search_src_ct()) {
		if (leaf = scrct->TreeTop)
			leaf->cmd.parl[D_SCRP_OBJ0_USED].parlen = used;
/*
printf("cl_set_obj0_used:scrct=%08x: used=%d\n",scrct,used);
*/
	}
	return 0;
}

/************************************/
/*									*/
/************************************/
int cl_get_obj0_used(proc,scrct)
ScrPrCT *scrct;
ProcCT *proc;
{
	int used;
	Leaf *leaf;

	used = 0;
	if (proc) {
		if (leaf = proc->ProcTop)
			used = leaf->cmd.parl[D_PROC_OBJ0_USED].parlen;
/*
printf("cl_get_obj0_used:proc=%08x used=%d\n",proc,used);
*/
	}
	else if (scrct) {
		if (leaf = scrct->TreeTop)
			used = leaf->cmd.parl[D_SCRP_OBJ0_USED].parlen;
/*
printf("cl_get_obj0_used:scrct=%08x: used=%d\n",scrct,used);
*/
	}
	return used;
}

/****************************************/
/*										*/
/****************************************/
static tdtObjHead *_add_obj0(Obj,pbxObj)
tdtObjHead *Obj;
GXObject *pbxObj;
{
	int im,ix;
	tdtInfoParm **ppObj0s,**ppObj0d,**Obj0,***p;
/*
printf("_add_obj0: Obj=%08x\n",Obj);
*/
	if (!Obj || !pbxObj) return NULL;
	ix = Obj->used;
	im = ix + pbxObj->nobj0;
	if (im > Obj->alsz) {
		if (!(Obj=cl_mk_add_obj0(Obj,im-Obj->alsz+MAX_CMD_OBJ0))) {
			ERROROUT("NULL return cl_mk_add_obj0()");
			return NULL;
		}
	}
	pbxObj->maxobj0 = ix;
	Obj->used = im;
DEBUGOUTL3(158,"_add_obj0: Obj=%08x ix=%d nobj0=%d",Obj,ix,pbxObj->nobj0);
	cl_set_obj0_used(im);
	return Obj;
}

/****************************************/
/*										*/
/****************************************/
static int _re_set_obj0(Obj,pbxObj)
tdtObjHead *Obj;
GXObject *pbxObj;
{
	int i,ix;
	tdtInfoParm **ppObj0s,**ppObj0d,**Obj0;
/*
printf("_re_set_obj0: Obj=%08x\n",Obj);
*/
	if (!Obj || !pbxObj) return -1;
	ix = pbxObj->maxobj0;
	Obj0 = Obj->Obj0;
	ppObj0d = &Obj0[ix];
	ppObj0s = pbxObj->obj0;

DEBUGOUTL4(158,"_re_set_obj0: Obj=%08x ix=%d Obj0=%08x nobj0=%d",Obj,ix,Obj0,pbxObj->nobj0);

	for (i=0;i<pbxObj->nobj0;i++) {

DEBUGOUT_InfoParm(158,"cl_gx_exp_gp_obj_opt:_re_set_obj0: *ppObj0s=",*ppObj0s,0,0);

		cl_gx_copy_info(*ppObj0d,*ppObj0s);

DEBUGOUT_InfoParm(158,"cl_gx_exp_gp_obj_opt:_re_set_obj0: *ppObj0d=",*ppObj0d,0,0);

		ppObj0d++;
		ppObj0s++;
	}
	return 0;
}

/****************************************/
/*										*/
/****************************************/
static tdtObjHead *_check_add_obj0(Obj,pbxObj)
tdtObjHead *Obj;
GXObject *pbxObj;
{
	int im,ix;
	tdtInfoParm **ppObj0s,**ppObj0d,**Obj0,***p;
/*
printf("_add_obj0: Obj=%08x\n",Obj);
*/
	if (!Obj || !pbxObj) return NULL;
	ix = pbxObj->maxobj0;
	im = ix + pbxObj->nobj0;
	if (im > Obj->alsz) {
		if (!(Obj=cl_mk_add_obj0(Obj,im-Obj->alsz+MAX_CMD_OBJ0))) {
			ERROROUT("NULL return cl_mk_add_obj0()");
			return NULL;
		}
	}
DEBUGOUTL3(158,"_check_add_obj0: Obj=%08x maxobj0=%d nobj0=%d",Obj,ix,pbxObj->nobj0);
	return Obj;
}

/****************************************/
/*										*/
/****************************************/
int cl_gx_exp_gp_obj_opt(pgwprm,pssp,bxobj,Obj,pInfoParmW,opt)
GWPRM_S *pgwprm;
SSPL_S  *pssp;
GXObject *bxobj[];
tdtObjHead *Obj;
tdtInfoParm *pInfoParmW;
int opt;
{
	static char *name="cl_gx_exp_gp_obj_opt";
	static MCAT mcat={'M','C',256,0,0,0,NULL,0};
	int rc,do_compile,i,im,imw,n,nob0,cnt,ix;
	GXObjectExpand bxObjExpand;
	MCAT Ms_obj,Ms_obj0,Ms_da;
	GXObject bxObj,*pbxObj;
	ProcCT *proc;
	tdtInfoParm **pObj0,*pInfo,**Obj0;

DEBUGENT2("bxobj=0x%08x Obj=0x%08x",bxobj,Obj);

DEBUGOUTL2(160,"cl_gx_exp_gp_obj_opt: bxobj=0x%08x Obj=0x%08x",bxobj,Obj);

	if (pInfoParmW) memset(pInfoParmW,0,sizeof(tdtInfoParm));
	do_compile = 1;
	rc = 0;
	if (bxobj) {
		if (pbxObj=bxobj[0]) {
			if (pbxObj->nobj > 0) do_compile = 0;
DEBUGOUTL2(161,"cl_gx_exp_gp_obj_opt: pbxObj=0x%08x nobj=%d",pbxObj,pbxObj->nobj);
		}
	}
	else {
		pbxObj = NULL;
		opt = (opt & ~D_GX_OPT_ALC_MASK) | D_GX_OPT_ALC_TMP;
	}

	if (CLcommon.dbgopt[2] & 0x01) do_compile = 1;

	if (do_compile) {
		if (pgwprm->iparam >= 0) {
			mcat.mc_ipos = 0;
			if ((rc=cl_mk_gp_parm(&mcat,pgwprm,pgwprm->nparam,pgwprm->parmLp)) < 0) return rc;
		}
		cl_gx_init_expand(&Ms_obj,"BJ",sizeof(short),MAX_OBJECT);
		cl_gx_init_expand(&Ms_obj0,"J0",sizeof(tdtInfoParm *),MAX_PMSTK);
		cl_gx_init_expand(&Ms_da,"DA",sizeof(char *),MAX_PMSTK);
		cl_gx_expand(&Ms_obj,0,NULL);
		cl_gx_expand(&Ms_da,0,NULL);
		cl_gx_expand(&Ms_obj0,0,NULL);
		bxObjExpand.ms_obj  = &Ms_obj;
		bxObjExpand.ms_da   = &Ms_da;
		bxObjExpand.ms_obj0 = &Ms_obj0;
		bxObjExpand.index0  = 0;
		if (pbxObj) opt = (opt & ~D_GX_OPT_ALC_MASK) | D_GX_OPT_ALC_TMP;
		rc=cl_gx_compile_gp_opt(pgwprm,pssp,opt,&bxObjExpand);
		if (rc) {
DEBUGOUTL1(150,"cl_gx_exp_gp_obj_opt:cl_gx_compile_gp_opt rc=%d",rc);
			switch (rc) {
				case ECL_SYNTAX_ERROR:
					/* SYNTAXG[B */
					ERROROUT1(FORMAT(171),name);
					break;
				case ECL_MAX_DA_ERROR:
					/* ev[EI[ot[B */
					ERROROUT1(FORMAT(172),name);
					break;
				case ECL_MAX_OBJ_ERROR:
					/* IuWFNgEI[ot[B */
					ERROROUT1(FORMAT(173),name);
					break;
				case ECL_MALLOC_ERROR:
					/* malloc error. */
					ERROROUT1(FORMAT(174),name);
					break;
				case -6:
					/* G[(ANVlsł)B */
					ERROROUT1(FORMAT(175),name);
					break;
				default:
					break;
			}
		}
		else {
			bxObj.nobj  = bxObjExpand.nobj;
			bxObj.nda   = bxObjExpand.nda;
			bxObj.nobj0 = bxObjExpand.nobj0;
			cl_gx_expand(&Ms_da,-1,&bxObj.da);
			cl_gx_expand(&Ms_obj,-1,&bxObj.obj);
			cl_gx_expand(&Ms_obj0,-1,&bxObj.obj0);
			bxObj.index0 = bxObjExpand.index0;
			if (opt & D_GX_OPT_PARMINFO2) bxObj.index0 |= 0x04;
/*
printf("%s: index0 = %08x\n",name,bxObj.index0);
*/
			pObj0 = bxObj.obj0;
			if (bxobj) {
				im = (opt & D_GX_OPT_ALC_MASK)>>12;
				if (!pbxObj) {
					bxobj[0] = pbxObj = (GXObject *)cl_opt_malloc(im,sizeof(GXObject));
					memset(pbxObj,0,sizeof(GXObject));
				}
DEBUGOUTL2(150,"cl_gx_exp_gp_obj_opt: im=%d pbxObj=0x%08x",im,pbxObj);
				pbxObj->nobj = bxObj.nobj;
				pbxObj->nda  = bxObj.nda;
				pbxObj->nobj0 = nob0 = bxObj.nobj0;
				pObj0 = pbxObj->obj0;
				if (bxObj.nobj) {
					n = sizeof(short)*bxObj.nobj + sizeof(tdtInfoParm *)*nob0;
					pbxObj->obj  = (short *)cl_opt_malloc(im,n);
					pbxObj->da   = (char **)cl_opt_malloc(im,sizeof(char **)*bxObj.nda);
					pbxObj->obj0 = (tdtInfoParm **)(pbxObj->obj + bxObj.nobj);
					pbxObj->index0 = bxObj.index0;
					memcpy((char *)pbxObj->obj,(char *)bxObj.obj,sizeof(short)*bxObj.nobj);
					memcpy((char *)pbxObj->da,(char *)bxObj.da,sizeof(char **)*bxObj.nda);
					memcpy((char *)pbxObj->obj0,(char *)bxObj.obj0,sizeof(tdtInfoParm *)*nob0);
					pObj0 = pbxObj->obj0;
					if (nob0) {
						if (Obj) {
							if (!(Obj=_add_obj0(Obj,pbxObj))) return ECL_MALLOC_ERROR;
							if (_re_set_obj0(Obj,pbxObj)) return -1;
							Obj0 = Obj->Obj0;
							pObj0 = &Obj0[pbxObj->maxobj0];
							_clear_obj_addr(pbxObj,NULL,pbxObj->obj0);
						}
					}
				}
			}
			else pbxObj = &bxObj;
		}
	}
	else {
		if (nob0=pbxObj->nobj0) {
			if (Obj) {
				if (!(Obj=_check_add_obj0(Obj,pbxObj))) return ECL_MALLOC_ERROR;
				if (_re_set_obj0(Obj,pbxObj)) return -1;
				Obj0 = Obj->Obj0;
				pObj0 = &Obj0[pbxObj->maxobj0];
			}
			else {
				pObj0 = pbxObj->obj0;
				_clear_obj_addr(pbxObj,NULL,pObj0);
			}
		}
if (DEBUGOUTCHECK(155)) {
char **daw;
short *objw;
int    nob,nda,nob0;
tdtInfoParm **objw0,**Objw0;
objw = pbxObj->obj;
daw = pbxObj->da;
nob = pbxObj->nobj;
nda = pbxObj->nda;
nob0 = pbxObj->nobj0;
if (Obj) {
	Objw0 = Obj->Obj0;
	objw0 = &Objw0[pbxObj->maxobj0];
}
else objw0 = pbxObj->obj0;
for (i=0;i<nob;i++) {
DEBUGOUTL2(155,"saved obj[%2d]=%d",i,objw[i]);
}
DEBUGOUTL1(155,"index0=%d",pbxObj->index0);
for (i=0;i<nob0;i++) {
DEBUGOUTL2(155,"saved obj0[%2d]=0x%08x",i,objw0[i]);
DEBUGOUT_InfoParm(165,"",objw0[i],0,0);
}
for (i=0;i<nda;i++) {
DEBUGOUTL2(155,"saved da[%2d]=[%s]",i,daw[i]);
}
}
	}
	if (rc == 0) {
		rc=cl_gx_ex_obj(pObj0,pbxObj,pInfoParmW,opt);
DEBUGOUTL1(150,"cl_gx_exp_gp_obj_opt:cl_gx_ex_obj rc=%d",rc);
		if (rc) {
			switch (rc) {
			case -3:
				/* ZX^bNEI[ot[B */
				ERROROUT1(FORMAT(181),name);
				break;
			case -4:
				/* G[(Zqlsł)B */
				ERROROUT1(FORMAT(182),name);
				break;
			case -5:
				/* f[^܂B */
				ERROROUT1(FORMAT(183),name);
				break;
			case -6:
				/* IuWFNgIĂ܂B */
				ERROROUT1(FORMAT(184),name);
				break;
			case -7:
				/* IuWFNgEf[^NULLłB */
				ERROROUT1(FORMAT(186),name);
				break;
			case 100:
											/* ܂B */
				if (!(pGlobTable->options[3] & 0x01)) ERROROUT1(FORMAT(185),name);
				if (pGlobTable->options[3] & 0x02) rc = 0;
				if (pGlobTable->options[3] & 0x04) rc = ECL_EX_LET;
				break;
			default:
				break;
			}
		}
	}
DEBUGRET1("rc=%d",rc);
	return rc;
}

/****************************************/
/*										*/
/****************************************/
int cl_gp_gwse(gwprm,ssp,sep,opt)
GWPRM_S *gwprm;
SSPL_S *ssp;
char *sep;
int opt;
{
	int len,line_len;
	char *line;
	parmList *pparmList;

	if (!gwprm || !ssp) return -1;
/*
DEBUGOUTL3(195,"cl_gp_gwse: nparam=%d iparam=%d sp=%d",
gwprm->nparam,gwprm->iparam,ssp->sp);
*/
	if (gwprm->iparam >= gwprm->nparam) return 0;
	if (!(pparmList = gwprm->parmLp[gwprm->iparam])) return -2;
	line_len = pparmList->prmlen;
	if (!(line = pparmList->prp)) return -3;
/*
DEBUGOUTL1(195,"cl_gp_gwse: line=[%s]",line);
*/
/*	if (line_len >= gwprm->maxlen) return -4;	*/
	while (!(len=akxtgwnsl(line,line_len,ssp,sep,opt))) {
		if (ssp->wdmax>0 && ssp->attr[1]) return -4;
/*
printf("cl_gp_gwse:i=%d\n",gwprm->iparam);
*/
DEBUGOUTL1(195,"cl_gp_gwse:i=%d",gwprm->iparam);
		if (++gwprm->iparam >= gwprm->nparam) return 0;
		if (!(pparmList = gwprm->parmLp[gwprm->iparam])) return -5;
		ssp->sp = 0;
		line_len = pparmList->prmlen;
		if (!(line = pparmList->prp)) return -6;
DEBUGOUTL1(195,"cl_gp_gwse: line=[%s]",line);
	/*	if (line_len >= gwprm->maxlen) return -7;	*/
	}
/*
printf("cl_gp_gwse:i=%d sp=%d wd=%s\n",gwprm->iparam,ssp->sp,ssp->wd);
*/
DEBUGOUTL3(195,"cl_gp_gwse: i=%d sp=%d wd=[%s]",gwprm->iparam,ssp->sp,ssp->wd);
	gwprm->line = line;
	gwprm->line_len = line_len;
	return len;
}

/****************************************/
/*										*/
/****************************************/
int cmp_peekwd(gwprm,ssp)
GWPRM_S *gwprm;
SSPL_S  *ssp;
{
	GWPRM_S qgwprm;
	SSPL_S  qssp;
	parmList *pparmList;
	char *line;

	if (!gwprm || !ssp) return -1;

	memcpy(&qssp,ssp,sizeof(SSPL_S));
	return cmp_gtwd(gwprm,&qssp);
}

/****************************************/
/*										*/
/****************************************/
int cmpgtwdx(line,line_len,ssp)
char *line;
int  line_len;
SSPL_S *ssp;
{
	SSPL_S  qssp;
	char *wd0,c,c1;
	int  len0,len,i,attr0;

	attr0 = ssp->attr[1];
	if ((len=akxtgwnsl(line,line_len,ssp,cmp_sep2,0x45)) <= 0) {
		if (len == -1) len = 0;
		return len;
	}
	if ((i=ssp->attr[0]) > 10) {
		if (*ssp->wd=='.') {
			if ((c=line[ssp->sp])=='.') {
				strcpy(ssp->wd,"..");
				ssp->sp++;
				len = 2;
/*
printf("cmpgtwdx: wd=%s\n",ssp->wd);
*/
			}
			else if ((!attr0 || attr0>10) && c>='0' && c<='9') {
				qssp.wd = ssp->wd;
				len0 = len;
				ssp->wd += len;
				len = akxtgwnsl(line,line_len,ssp,cmp_sep2,0x45);
				ssp->wd = qssp.wd;
				if (len > 0) len0 += len;
				len = len0;
			}
		}
		return len;
	}
/*	else if (i > 1) return len;	*/
	else if (i != 1) return len;
#if 1
	else if ((c=*ssp->wd)<'0' || c>'9') return len;
#else
	else if ((i=cl_gx_chk_opt(ssp->wd))!=NAME_CONST && i) return len;
#endif
	memcpy(&qssp,ssp,sizeof(SSPL_S));
	len0 = len;
	qssp.wd += len;
	len = akxtgwnsl(line,line_len,&qssp,cmp_sep2,0x45);
	if (len>0 && *qssp.wd=='.') {
		if ((c=line[qssp.sp]) == '.') {
			ssp->wd[len0] = '\0';
			return len0;
		}
		else if ((c>='0' && c<='9') ||
		         (strchr("efdEFD",c) && ((c1=line[qssp.sp+1])>='0' && c1<='9'))) {
			qssp.wd++;
			len0++;
			len = akxtgwnsl(line,line_len,&qssp,cmp_sep2,0x45);
			ssp->sp = qssp.sp;
			if (len > 0) len0 += len;
			return len0;
		}
		else if (strchr(cmp_sep,c)) {
			len0++;
			ssp->sp = qssp.sp;
		}
	}
	ssp->wd[len0] = '\0';
	return len0;
}

/****************************************/
/*										*/
/****************************************/
static int _chk_point(line,ssp,len0)
char *line;
SSPL_S *ssp;
int len0;
{
	int k,len=len0;
	char *spwd;

	spwd = ssp->wd;
	if ((k=akxnskipto(spwd,len,".")) < len) {
		ssp->sp -= len-k;
		while (line[ssp->sp] != '.') ssp->sp--;
		len = k;
		*(spwd+len) = '\0';
	}
	return len;
}

/****************************************/
/*										*/
/****************************************/
static int _chk_number(line,line_len,ssp,len0,cmp_sep)
char *line;
int  line_len;
SSPL_S *ssp;
int len0;
char *cmp_sep;
{
	int k,len=len0;
	char *spwd,c,*p;

	spwd = ssp->wd;
	if ((c=toupper(spwd[len-1]))=='E' || c=='D') {
		if ((c=line[ssp->sp])=='+' || c=='-' ||
		    (c>='0' && c<='9')) {
			p = spwd + len;
			if (c=='+' || c=='-') {
				*p++ = c;
				ssp->sp++;
			}
			ssp->wd = p;
			akxtgwnsl(line,line_len,ssp,cmp_sep,5);
			ssp->wd = spwd;
/*
printf("cmp_gtwd: wd=[%s]\n",spwd);
*/
		}
	}
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cmpgwnsl(line,line_len,ssp)
char *line;
int  line_len;
SSPL_S *ssp;
{
	parmList  **prmp;
	int len,atr,i,k,kk;
	char wk[5],c,*p,*spwd;

	atr=0;
#if 1
	if ((len=cmpgtwdx(line,line_len,ssp)) <= 0) return len;
#else
	if ((len=akxtgwnsl(line,line_len,ssp,cmp_sep,0x45)) <= 0) return len;
#endif
	ssp->attr[1] = ssp->attr[0];
	spwd = ssp->wd;

DEBUGOUTL4(152,"cmpgwnsl:cmpgtwdx len=%d, wd=[%s] ssp.sp=%d ssp.attr[0]=%d",
len,spwd,ssp->sp,ssp->attr[0]);

	if ((k=ssp->attr[0]) < 10) {
		if (k >= 5) atr = 5000;
		else {
			if ((c=*spwd)=='.' || (c>='0' && c<='9')) {
				atr=5000;
				_chk_number(line,line_len,ssp,len,cmp_sep);
			}
			else if (len >= 2 && len <= 3) {
				for(i=0,p=HK[i];p=HK[i];i++) {
					if (!stricmp(spwd,p)) {
						if (i >= 6) atr=i+59;
						else atr=i+31;
						return atr;
					}
				}
				if (!stricmp(spwd,"OR")) atr=52;
				else if (!stricmp(spwd,"NEW")) atr=13;
			}
		}
		if (!atr) {
			i = cl_gx_chk_opt(spwd);
			if (i==IS || i==TO || i==COMP) atr=61;
			else if (cl_gx_is_func_kubun(i)) atr=62;
			else if (i==FUNCCAST) atr = 10001;
			else if (i==STRING) {
				if (!stricmp(spwd,"CONCAT") && line[ssp->sp]=='=') {
					atr = 88;
					ssp->sp++;
					strcpy(spwd,"&+=");
				}
				else atr = 61;
			}
			else if (i==SYSVAR) {
				atr = 4000;	/* System Var. */
			}
			else if (i==NAME_CONST) {
				len = _chk_point(line,ssp,len);
				atr = 10000;
			}
			else if (!stricmp(spwd,"AND")) atr=51;
			else if (!stricmp(spwd,"NOT")) {
				if (line[ssp->sp] == '=') {
					atr = 36;
					ssp->sp++;
					strcpy(spwd,"!=");
				}
				else atr=18;
			}
			else if (!stricmp(spwd,"MOD") ||
			         !stricmp(spwd,"%")) {
				if (line[ssp->sp] == '=') {
					atr = 83;
					ssp->sp++;
					strcpy(spwd,"%=");
				}
				else if (!stricmp(spwd,"MOD")) atr = 63;
				else atr = 23;
			}
			else if (!stricmp(spwd,"ABS")) {
				atr = 28;
			}
			else {
				atr=5000;
			/*
				if (*spwd=='.') {
					if ((c=*(spwd+1))=='.') {
						atr = 97;
						ssp->sp -= len-2;
						*(spwd+2) = '\0';
					}
					else if (c<'0' || c>'9') {
						atr = 29;
						ssp->sp -= len-1;
						*(spwd+1) = '\0';
					}
					else {
						_chk_number(line,line_len,ssp,len,cmp_sep);
					}
				}
				else if ((c=*spwd)>='0' && c<='9') {
					_chk_number(line,line_len,ssp,len,cmp_sep);
				}
				else {
			*/
					len = _chk_point(line,ssp,len);
					if (c=='%' || c=='#') atr = 3000;	/* Variable */
					else if (c=='$') {
						if (cl_chk_sysvar_name(spwd+1,len-1)) atr = 4000;	/* SYSVAR */
						else atr = 3000;	/* Variable */
					}
			/*	}	*/
			}
		}
	}
	else if (len==2) atr=97;	/* .. */
	else if ((c=spwd[0])==';') atr=99;
	else if (c=='.') atr=29;
	else if (c==',') atr=98;
	else if (c=='(') atr=1;
	else if (c==')') atr=2;
	else if (c=='[') atr=3;
	else if (c==']') atr=4;
	else if (c=='{') atr=7;
	else if (c=='}') atr=8;
	else {
		wk[0]=c;
		wk[1]=line[ssp->sp];
		wk[2]='\0';
		for(i=0,p=hk[i];p=hk[i];i++) {
			if (!strcmp(wk,p)) {
				if (i<10) {
					atr=(i/2)+33;
					if (atr==37) atr=36;
					ssp->sp++;
					strcpy(spwd,wk);
				}
				else {
					atr = i + 21;	/* <, > */
/*
printf("cmp_gtwd: hk: wk=[%s] i=%d atr=%d\n",wk,i,atr);
*/
				}
				return atr;
			}
		}
		if (!strcmp(wk,"<<")) atr=26;
		else if (!strcmp(wk,">>")) atr=27;
		else if (!strcmp(wk,"&+")) atr=61;
		else if (!strcmp(wk,"|+")) atr=61;
		if (atr) {
			k = ssp->sp + 1;
/*
printf("cmp_gtwd: line_len=%d k=%d\n",line_len,k);
*/
			if (k<line_len && (c=line[k])=='=') {
				if (atr==61) {
					atr = 88;
					strcpy(wk,"&+=");
				}
				else {
					atr += 60;
					strcpy(&wk[2],"=");
				}
				ssp->sp++;
			}
			ssp->sp++;
			strcpy(spwd,wk);
/*
printf("cmp_gtwd: wk=[%s]\n",wk);
*/
			return atr;
		}
		for(i=0,p=ex[i];p=ex[i];i++) {
			if (!strcmp(wk,p)) {
				atr=i+71;
				ssp->sp++;
				strcpy(spwd,wk);
				return atr;
			}
		}
		if (!strcmp(wk,"++")) atr=14;
		else if (!strcmp(wk,"--")) atr=15;
		else if (!strcmp(wk,"||")) atr=52;
		else if (!strcmp(wk,"&&")) atr=51;
		else if (!strcmp(wk,"!!")) atr=16;
		else if (!strcmp(wk,"~~")) atr=17;
		else if (!strcmp(wk,"**")) atr=30;
		if (atr) {
			ssp->sp++;
			strcpy(spwd,wk);
		}
		else if (c=='*') atr=21;
		else if (c=='/') atr=22;
		else if (c=='+') atr=24;
		else if (c=='-') atr=25;
		else if (c=='=') atr=90;
		else if (c=='!') atr=18;
		else if (c=='~') atr=19;
		else if (c=='>') atr=32;
		else if (c=='<') atr=31;
		else if (c=='&') atr=41;
		else if (c=='^') atr=42;
		else if (c=='|') atr=43;
		else if (c=='?') atr=59;
		else if (c==':') atr=60;
		else atr = -1;
	}
	return atr;
}

/****************************************/
/*										*/
/****************************************/
int cmp_gtwd(gwprm,ssp)
GWPRM_S *gwprm;
SSPL_S *ssp;
{
	return cmpgwnsl(gwprm->line,gwprm->line_len,ssp);
}

/****************************************/
/*										*/
/****************************************/
int cmp_mkix(atr)
int atr;
{
	int atx,ix;

	if ((atx=atr)<0) {
		ix=5;					/*  */
	}
	else if (atx<=40) {
		if (atx<=20) {
			if      (atx<=4)  ix=atx;	/* ( ) [ ] */
			else if (atx<=6)  ix=1;		/* Function( Cast(*/
			else if (atx<=7)  ix=22;	/* { */
			else if (atx<=8)  ix=23;	/* } */
			else if (atx<=19) ix=5;		/* P ++ -- */
		/*	else if (atx<=20) ix=6;	*/	/* (CAST) */
			else ix=6;		/* (CAST) */
		}
		else {
			if      (atx<=23) ix=7;		/* * / % */
			else if (atx<=25) ix=8;		/* + - */
			else if (atx<=27) ix=9;		/* << >> */
			else if (atx<=29) ix=24;	/* .name */
			else if (atx<=30) ix=26;	/* ** */
			else if (atx<=34) ix=11;	/* < > <= >= */
		/*	else if (atx<=40) ix=12;*/	/* == != LIKE */
			else ix=12;	/* == != LIKE */
		}
	}
	else {
		if (atx<=60) {
			if      (atx<=41) ix=13;	/* & */
			else if (atx<=42) ix=14;	/* ^ */
			else if (atx<=50) ix=15;	/* | */
			else if (atx<=51) ix=16;	/* && */
			else if (atx<=52) ix=17;	/* || */
			else if (atx<=59) ix=18;	/* ? */
		/*	else if (atx<=60) ix=19;*/	/* : */
			else ix=19;	/* : */
		}
		else {
			if      (atx<=61) ix=10;	/* CONCAT */
			else if (atx<=70) ix=11;	/* IEQ NEQ */
			else if (atx<=90) ix=20;	/* &= ... = */
			else if (atx<=97) ix=25;	/* .. */
			else if (atx<=100) ix=21;	/* , */
			else if (atx<=2000) ix=10;	/* CONCAT */
			else ix=27;
		}
	}
	return ix;
}

/****************************************/
/*										*/
/****************************************/
int cmp_act(i1,i2)
int i1,i2;
{
	return act[i1][i2];

}

/****************************************/
/*										*/
/****************************************/
int cl_gx_func(ppmstk,irs,pW,opt,pmstk,dastk)
tdtInfoParm *pmstk,*pW,*ppmstk[];
int irs,opt;
char *dastk[];
{
	tdtInfoParm *pm,*pmW;
	int i,rc,iFunc,optW;
	char id;

	iFunc = 0;
	i = irs;
	while (i >= 0) {
		pm = ppmstk[i];
		pmW = pm;
		if (iFunc) optW = D_GX_OPT_NOERROR_NDEF | D_GX_OPT_NOEROUT_NDEF;
		else optW = 0;
		if (rc=_ex_conv_parm_opt(&pmW,optW,dastk[i])) return rc;
		cl_gx_copy_info(pm, pmW);

DEBUGOUT_InfoParm(194,"cl_gx_func: i=%d pScCT=%08x",pm,i,pm->pi_len);

		if (pm->pi_aux[1]==D_AUX1_FUNC_ARRY) {
			 if (pm->pi_pos == 1) iFunc = 1;
			 else {
				rc = cl_set_list(pW,irs-i,&ppmstk[i+1]);
				if (rc) return -1;
				return i;
			 }
		}
		else if (iFunc) {
			if ((id=pm->pi_id) == 'F') {
				if (pm->pi_aux[0] == 20) {
					rc = cl_gx_mk_cast(pW,pm,irs-(i+1),&ppmstk[i+2]);
				}
				else {
					if (i) opt = 0;	/* {z֑Ƃ́Aopt>0 ŌĂ΂B
									   ̂Ƃ́Ai==0 ̏ꍇ݂̂ł */
					pW->pi_paux = pm->pi_paux;
					rc = cl_gx_func_method(pW,pm,irs-(i+1),&ppmstk[i+2],opt,&pmstk[i+2]);
				}
				if (rc) return -1;
				return i;	/* mod "++i --> i" 2001.8.20 Koba */
			}
			else if (id == 'M') {
				opt = 0;
				rc = cl_ex_class_method(pW,pm,irs-(i+1),&ppmstk[i+2],opt);
				if (rc) return -1;
				return i;
			}
			else if (id == 'C') {
				cl_set_parm_bin(pW,i);
				return ECL_FUNC_CLASS;
			}
			else {
				/* [%s]͊֐ł͂܂B */
				ERROROUT1(FORMAT(191),dastk[i]);
				return -1;
			}
		}
		else if (rc=cl_check_data_id(pm,0x04)) return rc+ECL_CHK_VAR_ERROR;
		i--;
	}
	/* ֐܂B */
	ERROROUT(FORMAT(192));
	return i;
}

/****************************************/
/*										*/
/****************************************/
int cl_gx_array3(ppmstk,irs,pW,opt,pmstk,dastk)
tdtInfoParm *pmstk,*pW,*ppmstk[];
int irs,opt;
char *dastk[];
{
	tdtInfoParm *pm,*pmW;
	int i,rc,iARRAY;
	char c;

	iARRAY = 0;
	i = irs;
	while (i >= 0) {
		pm = ppmstk[i];
		pmW = pm;
		if (rc=_ex_conv_parm_opt(&pmW,0,dastk[i])) return rc;
		cl_gx_copy_info(pm, pmW);

DEBUGOUT_InfoParm(194,"cl_gx_array3: i=%d pScCT=%08x",pm,i,pm->pi_len);

		if (iARRAY) {
			if ((c=pm->pi_id) == 'A' || c == 'R') {
#if 0
				if (i) opt = 0;	/* {z֑Ƃ́Aopt>0 ŌĂ΂B
								   ̂Ƃ́Ai==0 ̏ꍇ݂̂ł */
#endif
				rc = cl_gx_array_bexp(pW,irs-i+1,&ppmstk[i],opt);
				if (rc > 0) return -1;
				else if (rc < 0) return rc;
				return i;
			}
			else {
				/* [%s]͔z񖼂ł͂܂B */
				ERROROUT1(FORMAT(196),dastk[i]);
				return -1;
			}
		}
		else {
			if (pm->pi_aux[1]==D_AUX1_FUNC_ARRY && pm->pi_pos==2) iARRAY = 1;
			else if (rc=cl_check_data_id(pm,0x04)) return rc+ECL_CHK_VAR_ERROR;
		}
		i--;
	}
	/* z񖼂܂B */
	ERROROUT(FORMAT(197));
	return i;
}

/****************************************/
/*										*/
/****************************************/
int cl_gx_array_bexp(pInfoParmW,nparm,ppParm,opti)
tdtInfoParm *pInfoParmW;
int nparm;
tdtInfoParm *ppParm[];
int opti;
{
	static char *func_name="cl_gx_array_bexp";
	tdtInfoParm IndexInfo;
	tdtInfoParm *pInfoParm1,*pParmI;
	tdtInfoParm ***pTBL;
	parmList  qprmList;
	int *index;
	int i,j,k,rc,opt,iEROUT_NDEF,iHASH,iCONST,f,iRANGE,attr,m;
	char c,c1,*name,cOpt,*pp,*p1,w1[32],*cpDat,cc[2],cCmd;
	int  ParmNo,i1,ix,iParm[4];
	tdtInfoParm	**pvParm;
	tdtArrayIndex tIndex,*pIndex;
	ScrPrCT     *pScCT;
	XHASHB *xhp;
	static MCAT mcat={'M','C',256,0,0,0,NULL,0};

DEBUGOUTL2(190,"cl_gx_array_bexp: nparm=%d opt=%08x",nparm,opti);

	nparm -= 2;
	if (nparm <= 0) {
		/* CfbNXw肳Ă܂B */
		ERROROUT1(FORMAT(201),func_name);
		return ECL_SCRIPT_ERROR;
	}

	iEROUT_NDEF = !(opti & D_GX_OPT_NOEROUT_NDEF);
#if 1
	opt= 0;
	cOpt= 'r';
#else
	opt = opti & D_GX_OPT_STORE;
	if (opt) cOpt = 's';
	else cOpt = 'r';
#endif
	pInfoParm1 = ppParm[0];
/*
printf("cl_gx_array_bexp: cOpt=%c pi_id = %c\n",cOpt,pInfoParm1->pi_id);
*/
	if ((c=pInfoParm1->pi_id) != 'A' && c != 'R') {
		/* zł͂܂B */
		ERROROUT1(FORMAT(202),func_name);
		return -2;
	}
	if (rc=cl_get_array_index_tbl(pInfoParm1,&tIndex,&pTBL,"cl_gx_array_bexp:")) return rc;

	iCONST = pInfoParm1->pi_aux[1] & D_AUX1_PROTECTED;

	if (!(name=(char *)pInfoParm1->pi_pos)) name = "";

	pParmI = NULL;
	mcat.mc_ipos = 0;
	index = tIndex.index;
	if (tIndex.xhp) {
		index[0] = 0;
		ParmNo = cl_gx_conv_index(pInfoParm1,&tIndex);

DEBUGOUTL1(194,"cl_gx_array_bexp: HASH: ParmNo=%d",ParmNo);

		if (ParmNo < 0) return ParmNo;
		mcat.mc_ipos = 0;
		for (i=1;i<=nparm;i++) {
			p1 = w1;
			if ((ix=parm_to_char(ppParm[i+1],&p1,NULL)) < 0) return ix;
			if (ix > 0) {
#if 1
			/*	if ((rc = akxtmcat(&mcat,p1,ix)) < 0) break;	*/
				for (j=0;j<ix;) {
					if ((m=akxqkanjilen(p1)) > 1) {
						pp = p1;
						p1 += m;
						j += m;
					}
					else {
						pp = cc;
						c = *p1;
						if (c=='`') {
							m = 2;
							c1 = *(p1+1);
							if (c1=='`' || c1==',') {
								pp = p1;
								p1++;
								j++;
							}
							else {
								cc[0] = '`';
								cc[1] = c;
							}
						}
						else {
							cc[0] = c;
							m = 1;
						}
						j++;
						p1++;
					}
					if ((rc = akxtmcat(&mcat,pp,m)) < 0) break;
				}
#else
				for (j=0;j<ix;) {
					if ((m=akxqkanjilen(p1)) > 1) {
						pp = p1;
						p1 += m;
						j += m;
					}
					else {
						pp = cc;
						c = *p1;
						if (c=='`' && *(p1+1)==',') {
							pp = p1;
							m = 2;
							p1++;
							j++;
						}
						else if (c=='`' || c==',') {
							cc[0] = '`';
							cc[1] = c;
							m = 2;
						}
						else {
							cc[0] = c;
							m = 1;
						}
						j++;
						p1++;
					}
					if ((rc = akxtmcat(&mcat,pp,m)) < 0) break;
				}
#endif
			}
			if (rc < 0) return rc;
			if (i < nparm) {
				if ((rc=akxtmcat(&mcat,"`,",2)) < 0) return rc;
			}
		}
		if ((rc=akxtmcat(&mcat,"",1)) < 0) return rc;
		xhp = (XHASHB *)tIndex.xhp;
		xhp->xha_xhix = 0;
		cCmd = 'r';
		ix = akxs_xhash2(xhp,cCmd,mcat.mc_bufp,&cpDat);

DEBUGOUTL2(194,"cl_gx_array_bexp: HASH: r mcat.mc_bufp=[%s] ix=%d",mcat.mc_bufp,ix);

		if (ix<0 || !pInfoParmW) return ix;
		else if (ix > 0) memcpy(&pParmI,cpDat,sizeof(tdtInfoParm *));
#if 0
		else {
			if (cOpt == 's' || (pGlobTable->options[0] & 0x01)) {
				if (!(pParmI=(tdtInfoParm *)Malloc(sizeof(tdtInfoParm)))) return -1;
				if (pGlobTable->options[0] & 0x04) cl_parm_set0(pParmI);
				else cl_null_data(pParmI);
				attr = tIndex.uAttr[0];
				if (attr && attr!=DEF_ZOK_VARI) {
					iParm[0] = attr;
					iParm[2] = tIndex.uAttr[2];
					iParm[3] = tIndex.uAttr[3];
					iParm[1] = tIndex.size;
					if (rc=cl_set_parm_init(pParmI,iParm,0x01)) return rc;
				}
				ix = akxs_xhash2(xhp,'s',mcat.mc_bufp,&pParmI);

DEBUGOUTL2(194,"cl_gx_array_bexp: HASH: s mcat.mc_bufp=[%s] ix=%d",mcat.mc_bufp,ix);

				if (ix <= 0) {
					if (ix == 0) ix = -12;
					cl_free_info_parm(pParmI);
					return ix;
				}
			}
			else {
				if (pGlobTable->options[0] & 0x04) {
					if (cOpt=='r' && iEROUT_NDEF)
						/* f[^ݒłB */
						ERROROUT1(FORMAT(203),func_name);
					return ECL_NDEFVAR_ERROR;
				}
				else {
					if (!(pParmI=(tdtInfoParm *)cl_tmp_const_malloc(sizeof(tdtInfoParm)))) return -1;
					cl_null_parm(pParmI);
				}
			}
		}
#endif
DEBUGOUT_InfoParm(194,"cl_gx_array_bexp: HASH: cmd=[%c] ix=%d",pParmI,cOpt,ix);
		if (pParmI) {
			if ((pGlobTable->options[0] & 0x01) && cl_is_undef_parm(pParmI)) cl_null_data(pParmI);
		}
	}
	else {
		if (nparm > MAX_ARRAY_DIM) {
			/* (%d)l(%d)𒴂Ă܂B */
			ERROROUT3(FORMAT(204),func_name,nparm,MAX_ARRAY_DIM);
			return ECL_SCRIPT_ERROR;
		}
		index[0] = nparm;
		f = 1;
		iRANGE = index[4];
		for (i=1;i<=MAX_ARRAY_DIM;i++) {
			if (i <= nparm) {
				if (rc=cl_get_parm_bin(ppParm[i+1],&index[i],"cl_gx_array_bexp: "))
					return rc;
			}
			else {
				if (iRANGE & f) index[i] = index[i+MAX_ARRAY_DIM+1];
				else index[i] = 0;
			}
			f <<= 1;
		}

DEBUGOUTL4(191,"cl_gx_array_bexp: index = %d %d %d %d",
index[0],index[1],index[2],index[3]);

		tIndex.pVarIndex = NULL;
		ParmNo = cl_gx_conv_index(pInfoParm1,&tIndex);

DEBUGOUTL1(194,"cl_gx_array_bexp: ParmNo=%d",ParmNo);

		if (ParmNo<0  || !pInfoParmW) return ParmNo;
		else if (ParmNo == 0) return -12;
		if ((rc=cl_array_get_info_parm(&pParmI,&tIndex,pTBL,ParmNo,cOpt)) < 0) return rc;
	}

	if (pInfoParm1->pi_scale & D_DATA_ARRAY_INDEX) {	/* 0x10 */
DEBUGOUT_InfoParm(194,"cl_gx_array_bexp: name=%s",pParmI,name,0);
		if (pParmI) {
			p1 = pp = name+strlen(name);
			if ((rc=parm_to_char(pParmI,&p1,NULL)) < 0) return rc;
			if (p1 != pp) strnzcpy(pp,p1,Var_NM_MAX*2);
DEBUGOUTL1(191,"cl_gx_array_bexp: Var name = [%s]",name);
			qprmList.prmlen = strlen(name);
			qprmList.prp    = name;
			if (rc = cl_conv_parm_opt(&qprmList,pInfoParmW,opti)) return rc;
		}
		else {
			cl_parm_set0(pInfoParmW);
		}
	}
	else if (pParmI) {
	/*
		if (opt || (opti & D_GX_OPT_SET_ADDR)) {
	*/
			cl_set_parm_long(pInfoParmW,(long)pParmI);
			pInfoParmW->pi_id   = 'S';
			if ((c=*name)=='%' || c=='#')
				pInfoParmW->pi_aux[1] = D_AUX1_PROTECTED;
	/*
		}
		else
			cl_gx_copy_info(pInfoParmW, pParmI);
	*/
	}
	else {
		if (!(cpDat=cl_tmp_const_malloc(sizeof(tdtArrayIndex)+mcat.mc_ipos+1))) return -1;
		pIndex = (tdtArrayIndex *)cpDat;
		memcpy(pIndex,&tIndex,sizeof(tdtArrayIndex));
		cpDat += sizeof(tdtArrayIndex);
		if (mcat.mc_ipos > 0) {
			memcpy(cpDat,mcat.mc_bufp,mcat.mc_ipos);
		}
		cpDat[mcat.mc_ipos] = '\0';
		cl_null_data(pInfoParmW);
		pInfoParmW->pi_id    = D_DATA_ID_UNDEFVAR;
		pInfoParmW->pi_attr  = DEF_ZOK_BULK;
	/*	pInfoParmW->pi_scale = D_DATA_MALLOC;	*/
		pInfoParmW->pi_dlen  = sizeof(tdtArrayIndex) + mcat.mc_ipos+1;
		pInfoParmW->pi_pos   = (long)name;
		pInfoParmW->pi_hlen  = ParmNo;
		pInfoParmW->pi_data  = (char *)pIndex;
		pInfoParmW->pi_len   = (long)cpDat;
		pInfoParmW->pi_paux  = (char *)pTBL;
	}
	pInfoParmW->pi_aux[1] |= iCONST;
DEBUGOUT_InfoParm(194,"cl_gx_array_bexp: return:",pInfoParmW,0,0);
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_gx_range(ppmstk,irs,pW,opt,pmstk,dastk,ms_ppmstk,ms_pmstk,ms_dastk)
tdtInfoParm *pmstk,*pW,*ppmstk[];
int irs,opt;
char *dastk[];
MCAT *ms_ppmstk,*ms_pmstk,*ms_dastk;
{
	tdtInfoParm *pmW,*pm[2],*pInfo;
	int i,len,rc,atr1,atr2,ic,ic2,irs_max;
	int Val[NMPA_INT*2+1];
	double d,d2;
	MPA ma,ma2;
	char *p,*p2;
	uchar uc,uc2;

	if (irs < 1) return -1;
	for (i=0;i<2;i++) {
		pmW = ppmstk[irs];
		if (rc=_ex_conv_parm_opt(&pmW,0,dastk[i])) return rc;

DEBUGOUT_InfoParm(194,"cl_gx_range: i=%d pScCT=%08x",pmW,irs,pmW->pi_len);

		if (rc=cl_check_data_id(pmW,0)) return rc;
		pm[i] = pmW;
		irs--;
	}
	irs++;
	atr1 = pm[1]->pi_attr;
	atr2 = pm[0]->pi_attr;
	if (atr1>DEF_ZOK_DECI || atr2>DEF_ZOK_DECI) {
		/* From(%d)܂To(%d)̃f[^^͎wł܂B */
		ERROROUT2(FORMAT(206),atr1,atr2);
		return ECL_SCRIPT_ERROR;
	}
	if (atr1!=DEF_ZOK_CHAR || atr2!=DEF_ZOK_CHAR) {
		if ((atr1=cl_cmpt_math(Val,"..", pm[1],pm[0])) < 0) return atr1;
	}

	if ((opt & D_GX_OPT_PARMINFO2) && !(opt & D_GX_OPT_GET_RANGE)) {
		p = (char *)&Val[1];
		p2 = p + Val[0];
		if (atr1 == DEF_ZOK_CHAR) {
			ic = *(uchar *)(pm[1]->pi_data);
			ic2 = *(uchar *)(pm[0]->pi_data);
		}
		else if (atr1 == DEF_ZOK_BINA) {
			i = Val[1];
		}
		else if (atr1 == DEF_ZOK_FLOA) {
			memcpy(&d,p,Val[0]);
			memcpy(&d2,p2,Val[0]);
		}
		else if (atr1 == DEF_ZOK_DECI) {
			memcpy(&ma,p,Val[0]);
			memcpy(&ma2,p2,Val[0]);
		}
		for (;;) {
			if (cl_gx_expand(ms_dastk,irs,&dastk) < 0) return -3;
			if (cl_gx_expand(ms_pmstk,irs,&pmstk) < 0) return -3;
			if ((irs_max=cl_gx_expand(ms_ppmstk,irs,&ppmstk)) < 0) return -3;
			else if (irs_max) _reset_addr(ppmstk,pmstk,irs);
			pmW = &pmstk[irs];
			if (atr1 == DEF_ZOK_CHAR) {
				if (ic > ic2) break;
				if (!(p=Malloc(2))) return -1;
				*p = ic;
				cl_set_parm_char(pmW,p,1);
				ic++;
			}
			else if (atr1 == DEF_ZOK_BINA) {
				if (i > Val[2]) break;
				cl_set_parm_bin(pmW,i);
				i++;
			}
			else if (atr1 == DEF_ZOK_FLOA) {
				if (d > d2) break;
				cl_set_parm_double(pmW,d);
				d++;
			}
			else if (atr1 == DEF_ZOK_DECI) {
				if (m_cmp(&ma,&ma2) > 0) break;
				if (rc=cl_set_parm_mpa(pmW,&ma)) return rc;
				m_add1(&ma,m_get_i(1));
			}
			ppmstk[irs++] = pmW;
		}
	}
	else {
		if (atr1==DEF_ZOK_CHAR && atr2==DEF_ZOK_CHAR) {
			len = X_MAX(pm[1]->pi_dlen,pm[0]->pi_dlen) + 1;
			if (!(p=cl_tmp_const_malloc(len*2))) return -1;
			memzcpy(p,pm[1]->pi_data,pm[1]->pi_dlen);
			memzcpy(p+len,pm[0]->pi_data,pm[0]->pi_dlen);
			cl_set_parm_char(pW,p,len);
		}
		else {
			cl_set_parm_bin(pW,Val[1]);
			len = Val[0];
			pW->pi_attr = atr1;
			pW->pi_dlen  = len;
			if (atr1 == DEF_ZOK_BINA) pW->pi_hlen = Val[2];
			else {
				if (!(p=cl_tmp_const_malloc(len*2))) return -1;
				memcpy(p,&Val[1],len*2);
				pW->pi_data = p;
				pW->pi_scale = 0;
			}
		}
		pW->pi_alen |= D_AULN_RANGE_DATA;
	}

DEBUGOUT_InfoParm(194,"cl_gx_range:pW: i=%d ",pW,irs,0);

	return irs;
}

/****************************************/
/*										*/
/****************************************/
static int _match(name_list,name)
char *name_list[],*name;
{
	char **nl,*p;
	int i;

	nl = name_list;
	for (i=1;p=*nl;i++,nl++) {
		if(!stricmp(p,name)) return i;
	}
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_gx_is_operator(pOperator,kubun)
char *pOperator;
int  kubun;
{
	int rc;
	char c,*p=pOperator;

	rc = 0;
	switch (kubun) {
		case MATH:
			if (_match(math,p)) rc = kubun;
			break;
		case COMP:
			if (_match(hk,p) || _match(HK,p)) rc = kubun;
			break;
		case LOGICAL:
			if (_match(logical,p)) rc = kubun;
			break;
		case FUNCCAST:
			if (_match(cast,p)) rc = kubun;
#if 1
			else if ((c=*p)=='C' || c=='c') {
				p++;
				if (cl_get_name_attr(p,strlen(p),0x01,0x20)) rc = kubun;
			}
#endif
			break;
	}
	return rc;
}

/****************************************/
/*										*/
/****************************************/
int cl_gx_is_separator(c)
char c;
{
	if (strchr(cmp_sep,c)) return 1;
	else return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_gx_is_func_kubun(i)
int i;
{
	if (i==FUNCMATH || i==FUNCTION || i==FUNCFILE || i==FUNCLOG) return 1;
	else return 0;
}

/****************************************/
/*										*/
/****************************************/
/*
	char   mc_id[2];     id[2]
	ushort mc_extlen;    size
	ushort mc_maxcnt;    max_cnt
	ushort mc_extcnt;    extent
	int    mc_alclen;
	char   *mc_bufp;     pbuf
	int    mc_ipos;      im
*/
int cl_im_init_expand(mcat,id,size,extent,im)
MCAT *mcat;
char *id;
int  size,extent,im;
{
/*
printf("cl_im_init_expand: %s size=%d extent=%d im=%d\n",id,size,extent,im);
*/
	if (!mcat) return -1;
	if (im<0 || im>4) return -2;
	memset(mcat,0,sizeof(MCAT));
	memcpy(mcat->mc_id,id,2);
	mcat->mc_ipos = im;
	mcat->mc_extlen = size;
	if (extent <= 0) extent = 8;
	mcat->mc_extcnt = extent;
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_im_expand(mcat,cnt,pbuf2)
MCAT *mcat;
int  cnt;
char **pbuf2;
{
	char *p;
	int  im,ret,len,max_cnt=mcat->mc_maxcnt;

	ret = 0;
	if (cnt >= max_cnt) {
		if (mcat->mc_extcnt <= 0) mcat->mc_extcnt = 8;
		while (cnt >= max_cnt) {
			max_cnt += mcat->mc_extcnt;
			mcat->mc_extcnt *= 2;
		}
		len = mcat->mc_extlen*max_cnt;
		if (mcat->mc_ipos == D_OPT_ALC_MALLOC) {
			p = MRealloc(mcat->mc_bufp,len);
			if (!p) return -1;
		}
		else {
			p = cl_opt_malloc(mcat->mc_ipos,len);
			if (!p) return -1;
			memcpy(p,mcat->mc_bufp,mcat->mc_alclen);
		}
		mcat->mc_bufp = p;
		mcat->mc_maxcnt = max_cnt;
		mcat->mc_alclen = len;
/*
printf("cl_im_expand: %c%c max_cnt=%d cnt=%d\n",mcat->mc_id[0],mcat->mc_id[1],max_cnt,cnt);
*/
		ret = max_cnt;
	}
	else {
		p = mcat->mc_bufp;
		if (cnt < 0) ret = max_cnt;
	}
/*
printf("cl_im_expand: pbuf2=%08x p=%08x\n",pbuf2,p);
*/
	if (pbuf2) *pbuf2 = p;
	return ret;
}

/****************************************/
/*										*/
/****************************************/
char *cl_im_init_set_expand(mcat,id,size,extent,buf,im)
MCAT *mcat;
char *id;
int  size,extent;
char *buf;
int  im;
{
	int len;

	cl_im_init_expand(mcat,id,size,extent,im);
	len = size*extent;
	mcat->mc_alclen = len;
	mcat->mc_maxcnt = extent;
	mcat->mc_bufp = buf;
/*
printf("cl_im_init_set_expand: buf=%08x len=%d\n",buf,len);
*/
	return buf + len;
}

/****************************************/
/*										*/
/****************************************/
int cl_gx_init_expand(mcat,id,size,extent)
MCAT *mcat;
char *id;
int  size,extent;
{
	return cl_im_init_expand(mcat,id,size,extent,D_OPT_ALC_TMP);
}

/****************************************/
/*										*/
/****************************************/
int cl_gx_expand(mcat,cnt,pbuf2)
MCAT *mcat;
int  cnt;
char **pbuf2;
{
	return cl_im_expand(mcat,cnt,pbuf2);
}

/****************************************/
/*										*/
/****************************************/
char *cl_gx_init_set_expand(mcat,id,size,extent,buf)
MCAT *mcat;
char *id;
int  size,extent;
char *buf;
{
	return cl_im_init_set_expand(mcat,id,size,extent,buf,D_OPT_ALC_TMP);
}
