static	char	sccsid[]="%Z% %M% %I% %E% %U%";
/******************************************************************************
*                                                                             *
*      ړI@@F  p[^                                         *
*                                                                             *
*      ֐@@@F@int cl_anal_parm( pparmList )                          *
*                      (I)prmList	*pparmList                                *
*                                                                             *
*            F@Ȃ                                                   *
*                                                                             *
*                                                                             *
*      ߂l@@@F@ERROR                                    @            *
*                      PARAMETER                                              *
*                      CONSTANT_NUM                                           *
*                      CONSTANT_CHR                                           *
*                      SYSVAR                                                 *
*                                                                             *
*      Tv@@F@                                                       *
*                                                                             *
******************************************************************************/
#include <colmn.h>

extern GlobalCt  *pGlobTable;
extern int giOptions[];
extern tdtExtValName ExtValName[];
extern tdtException ExceptionName[];

int cl_anal_parm(pparmList)
parmList *pparmList;
{
	int  len;
	char *p;

	if (!pparmList || !(p=pparmList->prp)) {
		ERROROUT(FORMAT(30));	/* VXeG[ */
		return ECL_SYSTEM_ERROR;
	}
	if (!(len=pparmList->prmlen)) {
		return NULL_PARM;
	}
	return cl_chk_parm(p,len);
}

int cl_chk_parm(p,len)
char *p;
int len;
{
	int  rc;
	char c;

	if (!p || len<0) return ECL_SYSTEM_ERROR;
	if (!len) return NULL_PARM;

	rc = NAME_CONST;
	switch (c = *p) {
		case	'%' :
		case	'#':
			if (len == 1) ;
			else rc = PARAMETER;
			break;
		case	'$':
			if (len == 1) ;
			else if (cl_chk_sysvar_name(p+1,len-1)) rc = SYSVAR;
			else rc = PARAMETER;
			break;
		case	'\'':
		case	'\"':
			rc = CONSTANT_CHR;
			break;
		case	'-':
		case	'+':
			if ((c=p[1])=='.' || (c>='0' && c<='9')) rc = CONSTANT_NUM;
			break;
		case	'.':
			if ((c=p[1])>='0' && c<='9') rc = CONSTANT_NUM;
			break;
		default :
			if (c>='0' && c<='9') rc = CONSTANT_NUM;
			else if (cl_chk_sysvar_name(p,len)) rc = SYSVAR;
		/*	else if (cl_gx_is_separator(c)) rc = SEPARATOR;	*/
	}
	return rc;
}

int cl_chk_name_opt(buf,buflen,opt)
uchar *buf;
int  buflen,opt;
{
	uchar c;
	int len,n,rc,opt1,opt2;
/*
	if (pGlobTable->options[1] & 0x01) return cl_chk_proc_name(buf,buflen);
*/
	rc = -1;
 	if ((len=buflen)<=0) return rc;
	opt1 = opt & 0x01;
	opt2 = opt & 0x02;
	n = 1;
	if (((c=*buf)>='A' && c<='Z') || (c>='a' && c<='z') ||
	    (c=='_') || (opt && c=='.') ||
	    (len>=2 && (n=akxqiskanji(buf)))
	/*||(len>=2 && (pGlobTable->options[1] & 0x02) && (c>='0' && c<='9'))*/
	   ) {
		rc = 0;
		len -= n;
		buf += n;
		while (len > 0) {
			if (len>=2 && (n=akxqiskanji(buf))) {
				len -= n;
				buf += n;
			}
			else {
				if (!(((c=*buf)>='0' && c<='9') ||
				      (c>='A' && c<='Z') || (c>='a' && c<='z') ||
				     c=='_' || (opt1 && c=='.') || (opt2 && c=='-'))) {
					rc = -1;
					break;
				}
				len--;
				buf++;
			}
		}
		if (len < 0) rc = -1;
	}
	return rc;
}

int cl_chk_name(buf, buflen)
uchar *buf;
int  buflen;
{
	return cl_chk_name_opt(buf,buflen,0);
}

int cl_chk_name_const(buf,buflen)
uchar *buf;
int  buflen;
{
	return cl_chk_name_opt(buf,buflen,1);
}

int cl_chk_proc_name(buf,buflen)
uchar *buf;
int  buflen;
{
	return cl_chk_name_opt(buf,buflen,2);
}

int cl_chk_file_name(buf, buflen)
uchar *buf;
int  buflen;
{
	uchar c;
	int len,i,n,rc = -1;

 	if ((len=buflen)<=0) return rc;
	rc = 0;
	while (len > 0) {
		if (len>=2 && (n=akxqiskanji(buf))) {
			len -= n;
			buf += n;
		}
		else {
		 	if ((c=*buf)==0x1b) ;
		 	else if (c<0x20 || c==0x7f || c==0xff) {
				rc = -1;
				break;
			}
			len--;
			buf++;
		}
	}
	if (len < 0) rc = -1;
	return rc;
}

int cl_chk_digit_n(prp,prmlen)
char *prp;
int   prmlen;
{
	int rc,ret;

	if ( prmlen>=3 && prp[0]=='0' ) {
		switch( prp[1] ) {
			case 'B':
			case 'b':
					rc = cl_chk_digit(2,&prp[2],prmlen-2);
					break;
			case 'O':
			case 'o':
					rc = cl_chk_digit(8,&prp[2],prmlen-2);
					break;
			case 'D':
			case 'd':
					rc = cl_chk_digit(10,&prp[2],prmlen-2);
					break;
			case 'X':
			case 'x':
					rc = cl_chk_digit_x(&(prp[2]),prmlen-2);
					break;
			default :
					if (!(rc=cl_chk_digit(10,prp,prmlen))) break;
					if (ret=cl_chk_digit_f(10,prp,prmlen)) rc = ret;
					break;
		}
	}
	else {
		if (rc=cl_chk_digit(10,prp,prmlen)) {
			if (ret=cl_chk_digit_f(10,prp,prmlen)) rc = ret;
		}
	}
	return rc;
}

/********************************************/
/*											*/
/********************************************/
tdtExtValName *cl_get_sysvar_name(name, name_len, opt)
char *name;
int  name_len,opt;
{
	tdtExtValName *p;
	int len,osize,plen;
	char *pn;

	len = name_len;

	p = &ExtValName[0];
	for (;(pn=p->name);p++) {
		osize = p->osize;
		plen = strlen(pn);
		if ((osize>0 && len>=osize && plen>=len) || (len==plen)) {
			if (opt & 0x01) {
				if (!memicmp(name,pn,len)) return p;
			}
			else {
				if (!memcmp(name,pn,len)) return p;
			}
		}
	}
	return NULL;
}

int cl_chk_sysvar_name(buf, len)
char *buf;
int  len;
{
	return (cl_get_exception_name(buf,len,0) ||
	        cl_get_sysvar_name(buf,len,0)) ? 1: 0;
}

char *strname(s,len)
char *s;
int  len;
{
	static char wrk[Var_NM_MAX+1];

	memnzcpy(wrk,s,len,sizeof(wrk)-1);
	return wrk;
}

char *strtemp(s,len)
char *s;
int  len;
{
	char *p;

	if (p=cl_tmp_const_malloc(len+1)) memzcpy(p,s,len);
	else p = strname(s,len);
	return p;
}

/********************************************/
/*											*/
/********************************************/
tdtException *cl_get_exception_name(name, name_len, opt)
char *name;
int  name_len,opt;
{
	tdtException *p;
	int len;
	char *pn;

	len = name_len;

	p = &ExceptionName[0];
	for (;(pn=p->name);p++) {
		if (len == strlen(pn)) {
			if (opt & 0x01) {
				if (!memicmp(name,pn,len)) return p;
			}
			else {
				if (!memcmp(name,pn,len)) return p;
			}
		}
	}
	return NULL;
}

int cl_mk_exception_code(e,rc)
int e,rc;
{
	return (e & 0xffff0000) | (X_ABS(rc) & 0x0000ffff);
}
