/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.StringValue;
import org.apache.flink.util.ExceptionUtils;

public final class StringUtils {
    private StringUtils() {
    }

    public static String stringifyException(Throwable e) {
        return ExceptionUtils.stringifyException(e);
    }

    public static String byteToHexString(byte[] bytes, int start, int end) {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes == null");
        }
        StringBuilder s = new StringBuilder();
        for (int i = start; i < end; ++i) {
            s.append(String.format("%02x", bytes[i]));
        }
        return s.toString();
    }

    public static String byteToHexString(byte[] bytes) {
        return StringUtils.byteToHexString(bytes, 0, bytes.length);
    }

    public static byte[] hexStringToByte(String hex) {
        byte[] bts = new byte[hex.length() / 2];
        for (int i = 0; i < bts.length; ++i) {
            bts[i] = (byte)Integer.parseInt(hex.substring(2 * i, 2 * i + 2), 16);
        }
        return bts;
    }

    public static String escapeHtml(String str) {
        int len = str.length();
        char[] s = str.toCharArray();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            char c = s[i];
            if (c == '\\' || c == '\"' || c == '/') {
                sb.append('\\');
                sb.append(c);
                continue;
            }
            if (c == '\b') {
                sb.append("\\b");
                continue;
            }
            if (c == '\t') {
                sb.append("\\t");
                continue;
            }
            if (c == '\n') {
                sb.append("<br>");
                continue;
            }
            if (c == '\f') {
                sb.append("\\f");
                continue;
            }
            if (c == '\r') {
                sb.append("\\r");
                continue;
            }
            if (c == '>') {
                sb.append("&gt;");
                continue;
            }
            if (c == '<') {
                sb.append("&lt;");
                continue;
            }
            if (c == '&') {
                sb.append("&amp;");
                continue;
            }
            if (c < ' ') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static final String arrayAwareToString(Object o) {
        if (o == null) {
            return "null";
        }
        if (o.getClass().isArray()) {
            return StringUtils.arrayToString(o);
        }
        return o.toString();
    }

    public static final String arrayToString(Object array) {
        if (array == null) {
            throw new NullPointerException();
        }
        if (array instanceof int[]) {
            return Arrays.toString((int[])array);
        }
        if (array instanceof long[]) {
            return Arrays.toString((long[])array);
        }
        if (array instanceof Object[]) {
            return Arrays.toString((Object[])array);
        }
        if (array instanceof byte[]) {
            return Arrays.toString((byte[])array);
        }
        if (array instanceof double[]) {
            return Arrays.toString((double[])array);
        }
        if (array instanceof float[]) {
            return Arrays.toString((float[])array);
        }
        if (array instanceof boolean[]) {
            return Arrays.toString((boolean[])array);
        }
        if (array instanceof char[]) {
            return Arrays.toString((char[])array);
        }
        if (array instanceof short[]) {
            return Arrays.toString((short[])array);
        }
        if (array.getClass().isArray()) {
            return "<unknown array type>";
        }
        throw new IllegalArgumentException("The given argument is no array.");
    }

    public static final String showControlCharacters(String str) {
        int len = str.length();
        StringBuilder sb = new StringBuilder();
        block7: for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\b': {
                    sb.append("\\b");
                    continue block7;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block7;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block7;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block7;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String getRandomString(Random rnd, int minLength, int maxLength) {
        int len = rnd.nextInt(maxLength - minLength + 1) + minLength;
        char[] data = new char[len];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (char)(rnd.nextInt(Short.MAX_VALUE) + 1);
        }
        return new String(data);
    }

    public static String getRandomString(Random rnd, int minLength, int maxLength, char minValue, char maxValue) {
        int len = rnd.nextInt(maxLength - minLength + 1) + minLength;
        char[] data = new char[len];
        int diff = maxValue - minValue + 1;
        for (int i = 0; i < data.length; ++i) {
            data[i] = (char)(rnd.nextInt(diff) + minValue);
        }
        return new String(data);
    }

    public static void writeNullableString(String str, DataOutputView out) throws IOException {
        if (str != null) {
            out.writeBoolean(true);
            StringValue.writeString(str, out);
        } else {
            out.writeBoolean(false);
        }
    }

    public static String readNullableString(DataInputView in) throws IOException {
        if (in.readBoolean()) {
            return StringValue.readString(in);
        }
        return null;
    }
}

