/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.memory.InputViewDataInputStreamWrapper;
import org.apache.flink.core.memory.OutputViewDataOutputStreamWrapper;

public class InstantiationUtil {
    public static <T> T instantiate(Class<T> clazz, Class<? super T> castTo) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        if (castTo != null && !castTo.isAssignableFrom(clazz)) {
            throw new RuntimeException("The class '" + clazz.getName() + "' is not a subclass of '" + castTo.getName() + "' as is required.");
        }
        return InstantiationUtil.instantiate(clazz);
    }

    public static <T> T instantiate(Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException iex) {
            InstantiationUtil.checkForInstantiation(clazz);
            throw new RuntimeException("Could not instantiate type '" + clazz.getName() + "' due to an unspecified exception: " + iex.getMessage(), iex);
        }
        catch (IllegalAccessException iaex) {
            InstantiationUtil.checkForInstantiation(clazz);
            throw new RuntimeException("Could not instantiate type '" + clazz.getName() + "' due to an unspecified exception: " + iaex.getMessage(), iaex);
        }
        catch (Throwable t) {
            String message = t.getMessage();
            throw new RuntimeException("Could not instantiate type '" + clazz.getName() + "' Most likely the constructor (or a member variable initialization) threw an exception" + (message == null ? "." : ": " + message), t);
        }
    }

    public static boolean hasPublicNullaryConstructor(Class<?> clazz) {
        Constructor<?>[] constructors = clazz.getConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            if (constructors[i].getParameterTypes().length != 0 || !Modifier.isPublic(constructors[i].getModifiers())) continue;
            return true;
        }
        return false;
    }

    public static boolean isPublic(Class<?> clazz) {
        return Modifier.isPublic(clazz.getModifiers());
    }

    public static boolean isProperClass(Class<?> clazz) {
        int mods = clazz.getModifiers();
        return !Modifier.isAbstract(mods) && !Modifier.isInterface(mods) && !Modifier.isNative(mods);
    }

    public static boolean isNonStaticInnerClass(Class<?> clazz) {
        if (clazz.getEnclosingClass() == null) {
            return false;
        }
        if (clazz.getDeclaringClass() != null) {
            return !Modifier.isStatic(clazz.getModifiers());
        }
        return true;
    }

    public static void checkForInstantiation(Class<?> clazz) {
        String errorMessage = InstantiationUtil.checkForInstantiationError(clazz);
        if (errorMessage != null) {
            throw new RuntimeException("The class '" + clazz.getName() + "' is not instantiable: " + errorMessage);
        }
    }

    public static String checkForInstantiationError(Class<?> clazz) {
        if (!InstantiationUtil.isPublic(clazz)) {
            return "The class is not public.";
        }
        if (clazz.isArray()) {
            return "The class is an array. An array cannot be simply instantiated, as with a parameterless constructor.";
        }
        if (!InstantiationUtil.isProperClass(clazz)) {
            return "The class is no proper class, it is either abstract, an interface, or a primitive type.";
        }
        if (InstantiationUtil.isNonStaticInnerClass(clazz)) {
            return "The class is an inner class, but not statically accessible.";
        }
        if (!InstantiationUtil.hasPublicNullaryConstructor(clazz)) {
            return "The class has no (implicit) public nullary constructor, i.e. a constructor without arguments.";
        }
        return null;
    }

    public static Object readObjectFromConfig(Configuration config, String key, ClassLoader cl) throws IOException, ClassNotFoundException {
        byte[] bytes = config.getBytes(key, null);
        if (bytes == null) {
            return null;
        }
        return InstantiationUtil.deserializeObject(bytes, cl);
    }

    public static void writeObjectToConfig(Object o, Configuration config, String key) throws IOException {
        byte[] bytes = InstantiationUtil.serializeObject(o);
        config.setBytes(key, bytes);
    }

    public static <T> byte[] serializeToByteArray(TypeSerializer<T> serializer, T record) throws IOException {
        if (record == null) {
            throw new NullPointerException("Record to serialize to byte array must not be null.");
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream(64);
        OutputViewDataOutputStreamWrapper outputViewWrapper = new OutputViewDataOutputStreamWrapper(new DataOutputStream(bos));
        serializer.serialize(record, outputViewWrapper);
        return bos.toByteArray();
    }

    public static <T> T deserializeFromByteArray(TypeSerializer<T> serializer, byte[] buf) throws IOException {
        if (buf == null) {
            throw new NullPointerException("Byte array to deserialize from must not be null.");
        }
        InputViewDataInputStreamWrapper inputViewWrapper = new InputViewDataInputStreamWrapper(new DataInputStream(new ByteArrayInputStream(buf)));
        T record = serializer.createInstance();
        return serializer.deserialize(record, inputViewWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object deserializeObject(byte[] bytes, ClassLoader cl) throws IOException, ClassNotFoundException {
        ObjectInputStream oois = null;
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(cl);
            oois = new ClassLoaderObjectInputStream(new ByteArrayInputStream(bytes), cl);
            Object object = oois.readObject();
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
            if (oois != null) {
                oois.close();
            }
        }
    }

    public static byte[] serializeObject(Object o) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(o);
        return baos.toByteArray();
    }

    private InstantiationUtil() {
        throw new RuntimeException();
    }

    private static class ClassLoaderObjectInputStream
    extends ObjectInputStream {
        private ClassLoader classLoader;

        @Override
        public Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            if (this.classLoader != null) {
                return Class.forName(desc.getName(), false, this.classLoader);
            }
            return super.resolveClass(desc);
        }

        public ClassLoaderObjectInputStream(InputStream in, ClassLoader classLoader) throws IOException {
            super(in);
            this.classLoader = classLoader;
        }
    }
}

