/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.io.PrintWriter;
import java.io.StringWriter;

public class ExceptionUtils {
    public static String stringifyException(Throwable e) {
        if (e == null) {
            return "(null)";
        }
        try {
            StringWriter stm = new StringWriter();
            PrintWriter wrt = new PrintWriter(stm);
            e.printStackTrace(wrt);
            wrt.close();
            return stm.toString();
        }
        catch (Throwable t) {
            return e.getClass().getName() + " (error while printing stack trace)";
        }
    }

    public static void rethrow(Throwable t) {
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw new RuntimeException(t);
    }

    public static void rethrow(Throwable t, String parentMessage) {
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw new RuntimeException(parentMessage, t);
    }
}

