/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types.parser;

import org.apache.flink.types.StringValue;
import org.apache.flink.types.parser.FieldParser;

public class StringValueParser
extends FieldParser<StringValue> {
    private static final byte WHITESPACE_SPACE = 32;
    private static final byte WHITESPACE_TAB = 9;
    private static final byte QUOTE_DOUBLE = 34;
    private StringValue result;

    @Override
    public int parseField(byte[] bytes, int startPos, int length, char delim, StringValue reusable) {
        byte current;
        int i;
        this.result = reusable;
        byte delByte = (byte)delim;
        for (i = startPos; i < length && ((current = bytes[i]) == 32 || current == 9); ++i) {
        }
        if (i < length && bytes[i] == 34) {
            int quoteStart = ++i;
            while (i < length && bytes[i] != 34) {
                ++i;
            }
            if (i < length) {
                reusable.setValueAscii(bytes, quoteStart, i - quoteStart);
                ++i;
                while (i < length && (current = bytes[i]) != delByte) {
                    if (current == 32 || current == 9) {
                        ++i;
                        continue;
                    }
                    this.setErrorState(FieldParser.ParseErrorState.UNQUOTED_CHARS_AFTER_QUOTED_STRING);
                    return -1;
                }
                return i == length ? length : i + 1;
            }
            this.setErrorState(FieldParser.ParseErrorState.UNTERMINATED_QUOTED_STRING);
            return -1;
        }
        while (i < length && bytes[i] != delByte) {
            ++i;
        }
        reusable.setValueAscii(bytes, startPos, i - startPos);
        return i == length ? length : i + 1;
    }

    @Override
    public StringValue createValue() {
        return new StringValue();
    }

    @Override
    public StringValue getLastResult() {
        return this.result;
    }
}

