/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types.parser;

import org.apache.flink.types.parser.FieldParser;

public class ShortParser
extends FieldParser<Short> {
    private static final int OVERFLOW_BOUND = Short.MAX_VALUE;
    private static final int UNDERFLOW_BOUND = 32768;
    private short result;

    @Override
    public int parseField(byte[] bytes, int startPos, int limit, char delimiter, Short reusable) {
        int val = 0;
        boolean neg = false;
        if (bytes[startPos] == 45) {
            neg = true;
            if (++startPos == limit || bytes[startPos] == delimiter) {
                this.setErrorState(FieldParser.ParseErrorState.NUMERIC_VALUE_ORPHAN_SIGN);
                return -1;
            }
        }
        for (int i = startPos; i < limit; ++i) {
            if (bytes[i] == delimiter) {
                this.result = (short)(neg ? -val : val);
                return i + 1;
            }
            if (bytes[i] < 48 || bytes[i] > 57) {
                this.setErrorState(FieldParser.ParseErrorState.NUMERIC_VALUE_ILLEGAL_CHARACTER);
                return -1;
            }
            val *= 10;
            if ((val += bytes[i] - 48) <= Short.MAX_VALUE || neg && val <= 32768) continue;
            this.setErrorState(FieldParser.ParseErrorState.NUMERIC_VALUE_OVERFLOW_UNDERFLOW);
            return -1;
        }
        this.result = (short)(neg ? -val : val);
        return limit;
    }

    @Override
    public Short createValue() {
        return (short)Short.MIN_VALUE;
    }

    @Override
    public Short getLastResult() {
        return this.result;
    }

    public static final short parseField(byte[] bytes, int startPos, int length) {
        return ShortParser.parseField(bytes, startPos, length, '\uffff');
    }

    public static final short parseField(byte[] bytes, int startPos, int length, char delimiter) {
        if (length <= 0) {
            throw new NumberFormatException("Invalid input: Empty string");
        }
        long val = 0L;
        boolean neg = false;
        if (bytes[startPos] == 45) {
            neg = true;
            if (--length == 0 || bytes[++startPos] == delimiter) {
                throw new NumberFormatException("Orphaned minus sign.");
            }
        }
        while (length > 0) {
            if (bytes[startPos] == delimiter) {
                return (short)(neg ? -val : val);
            }
            if (bytes[startPos] < 48 || bytes[startPos] > 57) {
                throw new NumberFormatException("Invalid character.");
            }
            val *= 10L;
            if (!((val += (long)(bytes[startPos] - 48)) <= 32767L || neg && val <= 32768L)) {
                throw new NumberFormatException("Value overflow/underflow");
            }
            ++startPos;
            --length;
        }
        return (short)(neg ? -val : val);
    }
}

