/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types.parser;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.types.ByteValue;
import org.apache.flink.types.DoubleValue;
import org.apache.flink.types.FloatValue;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.ShortValue;
import org.apache.flink.types.StringValue;
import org.apache.flink.types.parser.ByteParser;
import org.apache.flink.types.parser.ByteValueParser;
import org.apache.flink.types.parser.DoubleParser;
import org.apache.flink.types.parser.DoubleValueParser;
import org.apache.flink.types.parser.FloatParser;
import org.apache.flink.types.parser.FloatValueParser;
import org.apache.flink.types.parser.IntParser;
import org.apache.flink.types.parser.IntValueParser;
import org.apache.flink.types.parser.LongParser;
import org.apache.flink.types.parser.LongValueParser;
import org.apache.flink.types.parser.ShortParser;
import org.apache.flink.types.parser.ShortValueParser;
import org.apache.flink.types.parser.StringParser;
import org.apache.flink.types.parser.StringValueParser;

public abstract class FieldParser<T> {
    private ParseErrorState errorState = ParseErrorState.NONE;
    private static final Map<Class<?>, Class<? extends FieldParser<?>>> PARSERS = new HashMap();

    public abstract int parseField(byte[] var1, int var2, int var3, char var4, T var5);

    public abstract T getLastResult();

    public abstract T createValue();

    protected void setErrorState(ParseErrorState error) {
        this.errorState = error;
    }

    public ParseErrorState getErrorState() {
        return this.errorState;
    }

    public static <T> Class<FieldParser<T>> getParserForType(Class<T> type) {
        Class<FieldParser<T>> parser = PARSERS.get(type);
        if (parser == null) {
            return null;
        }
        Class<FieldParser<T>> typedParser = parser;
        return typedParser;
    }

    static {
        PARSERS.put(Byte.class, ByteParser.class);
        PARSERS.put(Short.class, ShortParser.class);
        PARSERS.put(Integer.class, IntParser.class);
        PARSERS.put(Long.class, LongParser.class);
        PARSERS.put(String.class, StringParser.class);
        PARSERS.put(Float.class, FloatParser.class);
        PARSERS.put(Double.class, DoubleParser.class);
        PARSERS.put(ByteValue.class, ByteValueParser.class);
        PARSERS.put(ShortValue.class, ShortValueParser.class);
        PARSERS.put(IntValue.class, IntValueParser.class);
        PARSERS.put(LongValue.class, LongValueParser.class);
        PARSERS.put(StringValue.class, StringValueParser.class);
        PARSERS.put(FloatValue.class, FloatValueParser.class);
        PARSERS.put(DoubleValue.class, DoubleValueParser.class);
    }

    public static enum ParseErrorState {
        NONE,
        NUMERIC_VALUE_OVERFLOW_UNDERFLOW,
        NUMERIC_VALUE_ORPHAN_SIGN,
        NUMERIC_VALUE_ILLEGAL_CHARACTER,
        NUMERIC_VALUE_FORMAT_ERROR,
        UNTERMINATED_QUOTED_STRING,
        UNQUOTED_CHARS_AFTER_QUOTED_STRING;

    }
}

