/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types;

import java.io.IOException;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.Key;
import org.apache.flink.util.ReflectionUtil;

public abstract class Pair<U extends Key<U>, V extends Key<V>>
implements Key<Pair<U, V>> {
    private static final long serialVersionUID = 1L;
    private final Class<U> firstClass = ReflectionUtil.getTemplateType1(this.getClass());
    private final Class<V> secondClass;
    private U first;
    private V second;

    public Pair() {
        this.secondClass = ReflectionUtil.getTemplateType2(this.getClass());
        try {
            this.first = (Key)this.firstClass.newInstance();
            this.second = (Key)this.secondClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public Pair(U first, V second) {
        this.secondClass = ReflectionUtil.getTemplateType1(this.getClass());
        this.first = first;
        this.second = second;
    }

    public U getFirst() {
        return this.first;
    }

    public void setFirst(U first) {
        if (first == null) {
            throw new NullPointerException("first must not be null");
        }
        this.first = first;
    }

    public V getSecond() {
        return this.second;
    }

    public void setSecond(V second) {
        if (second == null) {
            throw new NullPointerException("second must not be null");
        }
        this.second = second;
    }

    public String toString() {
        return "<" + this.first.toString() + "|" + this.second.toString() + ">";
    }

    @Override
    public void read(DataInputView in) throws IOException {
        this.first.read(in);
        this.second.read(in);
    }

    @Override
    public void write(DataOutputView out) throws IOException {
        this.first.write(out);
        this.second.write(out);
    }

    @Override
    public int compareTo(Pair<U, V> o) {
        int result = this.first.compareTo(o.first);
        if (result == 0) {
            result = this.second.compareTo(o.second);
        }
        return result;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.first.hashCode();
        result = 31 * result + this.second.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Pair other = (Pair)obj;
        return this.first.equals(other.first) && this.second.equals(other.second);
    }
}

