/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types;

import java.io.IOException;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.types.CopyableValue;
import org.apache.flink.types.NormalizableKey;
import org.apache.flink.types.ResettableValue;

public class BooleanValue
implements NormalizableKey<BooleanValue>,
ResettableValue<BooleanValue>,
CopyableValue<BooleanValue> {
    private static final long serialVersionUID = 1L;
    public static final BooleanValue TRUE = new BooleanValue(true);
    public static final BooleanValue FALSE = new BooleanValue(false);
    private boolean value;

    public BooleanValue() {
    }

    public BooleanValue(boolean value) {
        this.value = value;
    }

    public boolean get() {
        return this.value;
    }

    public void set(boolean value) {
        this.value = value;
    }

    public boolean getValue() {
        return this.value;
    }

    @Override
    public void setValue(boolean value) {
        this.value = value;
    }

    @Override
    public void setValue(BooleanValue value) {
        this.value = value.value;
    }

    @Override
    public void write(DataOutputView out) throws IOException {
        out.writeBoolean(this.value);
    }

    @Override
    public void read(DataInputView in) throws IOException {
        this.value = in.readBoolean();
    }

    @Override
    public int hashCode() {
        return this.value ? 1 : 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj.getClass() == BooleanValue.class) {
            return ((BooleanValue)obj).value == this.value;
        }
        return false;
    }

    @Override
    public int compareTo(BooleanValue o) {
        int ov = o.value ? 1 : 0;
        int tv = this.value ? 1 : 0;
        return tv - ov;
    }

    public String toString() {
        return this.value ? "true" : "false";
    }

    @Override
    public int getBinaryLength() {
        return 1;
    }

    @Override
    public void copyTo(BooleanValue target) {
        target.value = this.value;
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        target.write(source, 1);
    }

    @Override
    public int getMaxNormalizedKeyLen() {
        return 1;
    }

    @Override
    public void copyNormalizedKey(MemorySegment target, int offset, int len) {
        if (len > 0) {
            target.put(offset, (byte)(this.value ? 1 : 0));
            ++offset;
            while (len > 1) {
                target.put(offset++, (byte)0);
                --len;
            }
        }
    }
}

