/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.memory;

import java.lang.reflect.Field;
import java.nio.ByteOrder;
import sun.misc.Unsafe;

public class MemoryUtils {
    public static final Unsafe UNSAFE = MemoryUtils.getUnsafe();
    public static final ByteOrder NATIVE_BYTE_ORDER = MemoryUtils.getByteOrder();

    private static Unsafe getUnsafe() {
        try {
            Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            return (Unsafe)unsafeField.get(null);
        }
        catch (SecurityException e) {
            throw new RuntimeException("Could not access the unsafe handle.", e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("The static unsafe handle field was not be found.");
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Bug: Illegal argument reflection access for static field.");
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Access to the unsafe handle is forbidden by the runtime.", e);
        }
    }

    private static ByteOrder getByteOrder() {
        byte[] bytes = new byte[8];
        long value = 1311768467284344303L;
        UNSAFE.putLong(bytes, UNSAFE.arrayBaseOffset(byte[].class), 1311768467284344303L);
        int lower = bytes[0] & 0xFF;
        int higher = bytes[7] & 0xFF;
        if (lower == 18 && higher == 239) {
            return ByteOrder.BIG_ENDIAN;
        }
        if (lower == 239 && higher == 18) {
            return ByteOrder.LITTLE_ENDIAN;
        }
        throw new RuntimeException("Unrecognized byte order.");
    }

    private MemoryUtils() {
    }
}

