/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.MalformedInputException;
import java.text.StringCharacterIterator;
import java.util.Arrays;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.Value;

public class StringRecord
implements Value {
    private static final long serialVersionUID = 1L;
    private static final ThreadLocal<CharsetEncoder> ENCODER_FACTORY = new ThreadLocal<CharsetEncoder>(){

        @Override
        protected CharsetEncoder initialValue() {
            return Charset.forName("UTF-8").newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        }
    };
    private static final ThreadLocal<CharsetDecoder> DECODER_FACTORY = new ThreadLocal<CharsetDecoder>(){

        @Override
        protected CharsetDecoder initialValue() {
            return Charset.forName("UTF-8").newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        }
    };
    private int hash = 0;
    private static final byte[] EMPTY_BYTES = new byte[0];
    private byte[] bytes;
    private int length;
    private static final int LEAD_BYTE = 0;
    private static final int TRAIL_BYTE_1 = 1;
    private static final int TRAIL_BYTE = 2;
    static final int[] bytesFromUTF8 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5};
    static final int[] offsetsFromUTF8 = new int[]{0, 12416, 925824, 63447168, -100130688, -2113396608};

    public StringRecord() {
        this.bytes = EMPTY_BYTES;
        this.hash = 0;
    }

    public StringRecord(String string) {
        this.set(string);
    }

    public StringRecord(StringRecord utf8) {
        this.set(utf8);
    }

    public StringRecord(byte[] utf8) {
        this.set(utf8);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int charAt(int position) {
        if (position > this.length) {
            return -1;
        }
        if (position < 0) {
            return -1;
        }
        ByteBuffer bb = (ByteBuffer)ByteBuffer.wrap(this.bytes).position(position);
        return StringRecord.bytesToCodePoint(bb.slice());
    }

    public int find(String what) {
        return this.find(what, 0);
    }

    public int find(String what, int start) {
        try {
            ByteBuffer src = ByteBuffer.wrap(this.bytes, 0, this.length);
            ByteBuffer tgt = StringRecord.encode(what);
            byte b = tgt.get();
            src.position(start);
            while (src.hasRemaining()) {
                if (b != src.get()) continue;
                src.mark();
                tgt.mark();
                boolean found = true;
                int pos = src.position() - 1;
                while (tgt.hasRemaining()) {
                    if (!src.hasRemaining()) {
                        tgt.reset();
                        src.reset();
                        found = false;
                        break;
                    }
                    if (tgt.get() == src.get()) continue;
                    tgt.reset();
                    src.reset();
                    found = false;
                    break;
                }
                if (!found) continue;
                return pos;
            }
            return -1;
        }
        catch (CharacterCodingException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public void set(String string) {
        try {
            ByteBuffer bb = StringRecord.encode(string, true);
            this.bytes = bb.array();
            this.length = bb.limit();
            this.hash = 0;
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException("Should not have happened " + e.toString());
        }
    }

    public void set(byte[] utf8) {
        this.set(utf8, 0, utf8.length);
    }

    public void set(StringRecord other) {
        this.set(other.getBytes(), 0, other.getLength());
    }

    public int getLength() {
        return this.length;
    }

    public void set(byte[] utf8, int start, int len) {
        this.setCapacity(len, false);
        System.arraycopy(utf8, start, this.bytes, 0, len);
        this.length = len;
        this.hash = 0;
    }

    public void append(byte[] utf8, int start, int len) {
        this.setCapacity(this.length + len, true);
        System.arraycopy(utf8, start, this.bytes, this.length, len);
        this.length += len;
        this.hash = 0;
    }

    public void clear() {
        this.length = 0;
        this.hash = 0;
    }

    private void setCapacity(int len, boolean keepData) {
        if (this.bytes == null || this.bytes.length < len) {
            byte[] newBytes = new byte[len];
            if (this.bytes != null && keepData) {
                System.arraycopy(this.bytes, 0, newBytes, 0, this.length);
            }
            this.bytes = newBytes;
        }
    }

    public String toString() {
        try {
            return StringRecord.decode(this.bytes, 0, this.length);
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException("Should not have happened " + e.toString());
        }
    }

    @Override
    public void read(DataInputView in) throws IOException {
        int newLength = in.readInt();
        this.setCapacity(newLength, false);
        in.readFully(this.bytes, 0, newLength);
        this.length = newLength;
        this.hash = 0;
    }

    public static void skip(DataInput in) throws IOException {
        int length = in.readInt();
        StringRecord.skipFully(in, length);
    }

    public static void skipFully(DataInput in, int len) throws IOException {
        int total;
        int cur = 0;
        for (total = 0; total < len && (cur = in.skipBytes(len - total)) > 0; total += cur) {
        }
        if (total < len) {
            throw new IOException("Not able to skip " + len + " bytes, possibly " + "due to end of input.");
        }
    }

    @Override
    public void write(DataOutputView out) throws IOException {
        out.writeInt(this.length);
        out.write(this.bytes, 0, this.length);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StringRecord)) {
            return false;
        }
        StringRecord sr = (StringRecord)obj;
        if (this.length != sr.getLength()) {
            return false;
        }
        if (this.bytes.length == this.length && sr.bytes.length == sr.length) {
            return Arrays.equals(this.bytes, sr.bytes);
        }
        for (int i = 0; i < this.length; ++i) {
            if (this.bytes[i] == sr.bytes[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0 && this.length > 0) {
            int off = 0;
            byte[] val = this.bytes;
            int len = this.length;
            for (int i = 0; i < len; ++i) {
                h = 31 * h + val[off++];
            }
            this.hash = h;
        }
        return h;
    }

    public static String decode(byte[] utf8) throws CharacterCodingException {
        return StringRecord.decode(ByteBuffer.wrap(utf8), true);
    }

    public static String decode(byte[] utf8, int start, int length) throws CharacterCodingException {
        return StringRecord.decode(ByteBuffer.wrap(utf8, start, length), true);
    }

    public static String decode(byte[] utf8, int start, int length, boolean replace) throws CharacterCodingException {
        return StringRecord.decode(ByteBuffer.wrap(utf8, start, length), replace);
    }

    private static String decode(ByteBuffer utf8, boolean replace) throws CharacterCodingException {
        CharsetDecoder decoder = DECODER_FACTORY.get();
        if (replace) {
            decoder.onMalformedInput(CodingErrorAction.REPLACE);
            decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        }
        String str = decoder.decode(utf8).toString();
        if (replace) {
            decoder.onMalformedInput(CodingErrorAction.REPORT);
            decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        }
        return str;
    }

    public static ByteBuffer encode(String string) throws CharacterCodingException {
        return StringRecord.encode(string, true);
    }

    public static ByteBuffer encode(String string, boolean replace) throws CharacterCodingException {
        CharsetEncoder encoder = ENCODER_FACTORY.get();
        if (replace) {
            encoder.onMalformedInput(CodingErrorAction.REPLACE);
            encoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        }
        ByteBuffer bytes = encoder.encode(CharBuffer.wrap(string.toCharArray()));
        if (replace) {
            encoder.onMalformedInput(CodingErrorAction.REPORT);
            encoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        }
        return bytes;
    }

    public static String readString(DataInput in) throws IOException {
        if (in.readBoolean()) {
            int length = in.readInt();
            if (length < 0) {
                throw new IOException("length of StringRecord is " + length);
            }
            byte[] bytes = new byte[length];
            in.readFully(bytes, 0, length);
            return StringRecord.decode(bytes);
        }
        return null;
    }

    public static int writeString(DataOutput out, String s) throws IOException {
        int length = 0;
        if (s == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            ByteBuffer bytes = StringRecord.encode(s);
            length = bytes.limit();
            out.writeInt(length);
            out.write(bytes.array(), 0, length);
        }
        return length;
    }

    public static void validateUTF8(byte[] utf8) throws MalformedInputException {
        StringRecord.validateUTF8(utf8, 0, utf8.length);
    }

    public static void validateUTF8(byte[] utf8, int start, int len) throws MalformedInputException {
        int leadByte = 0;
        int length = 0;
        int state = 0;
        block11: for (int count = start; count < start + len; ++count) {
            int aByte = utf8[count] & 0xFF;
            switch (state) {
                case 0: {
                    leadByte = aByte;
                    length = bytesFromUTF8[aByte];
                    switch (length) {
                        case 0: {
                            if (leadByte <= 127) continue block11;
                            throw new MalformedInputException(count);
                        }
                        case 1: {
                            if (leadByte < 194 || leadByte > 223) {
                                throw new MalformedInputException(count);
                            }
                            state = 1;
                            continue block11;
                        }
                        case 2: {
                            if (leadByte < 224 || leadByte > 239) {
                                throw new MalformedInputException(count);
                            }
                            state = 1;
                            continue block11;
                        }
                        case 3: {
                            if (leadByte < 240 || leadByte > 244) {
                                throw new MalformedInputException(count);
                            }
                            state = 1;
                            continue block11;
                        }
                    }
                    throw new MalformedInputException(count);
                }
                case 1: {
                    if (leadByte == 240 && aByte < 144) {
                        throw new MalformedInputException(count);
                    }
                    if (leadByte == 244 && aByte > 143) {
                        throw new MalformedInputException(count);
                    }
                    if (leadByte == 224 && aByte < 160) {
                        throw new MalformedInputException(count);
                    }
                    if (leadByte == 237 && aByte > 159) {
                        throw new MalformedInputException(count);
                    }
                }
                case 2: {
                    if (aByte < 128 || aByte > 191) {
                        throw new MalformedInputException(count);
                    }
                    if (--length == 0) {
                        state = 0;
                        continue block11;
                    }
                    state = 2;
                    continue block11;
                }
            }
        }
    }

    public static int bytesToCodePoint(ByteBuffer bytes) {
        bytes.mark();
        byte b = bytes.get();
        bytes.reset();
        int extraBytesToRead = bytesFromUTF8[b & 0xFF];
        if (extraBytesToRead < 0) {
            return -1;
        }
        int ch = 0;
        switch (extraBytesToRead) {
            case 5: {
                ch += bytes.get() & 0xFF;
                ch <<= 6;
            }
            case 4: {
                ch += bytes.get() & 0xFF;
                ch <<= 6;
            }
            case 3: {
                ch += bytes.get() & 0xFF;
                ch <<= 6;
            }
            case 2: {
                ch += bytes.get() & 0xFF;
                ch <<= 6;
            }
            case 1: {
                ch += bytes.get() & 0xFF;
                ch <<= 6;
            }
            case 0: {
                ch += bytes.get() & 0xFF;
            }
        }
        return ch -= offsetsFromUTF8[extraBytesToRead];
    }

    public static int utf8Length(String string) {
        StringCharacterIterator iter = new StringCharacterIterator(string);
        char ch = iter.first();
        int size = 0;
        while (ch != '\uffff') {
            if (ch >= '\ud800' && ch < '\udc00') {
                char trail = iter.next();
                if (trail > '\udbff' && trail < '\ue000') {
                    size += 4;
                } else {
                    size += 3;
                    iter.previous();
                }
            } else {
                size = ch < '\u0080' ? ++size : (ch < '\u0800' ? (size += 2) : (size += 3));
            }
            ch = iter.next();
        }
        return size;
    }
}

