/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs.local;

import java.io.File;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;

public class LocalFileStatus
implements FileStatus {
    private final File file;
    private final Path path;

    public LocalFileStatus(File f, FileSystem fs) {
        this.file = f;
        this.path = new Path(fs.getUri().getScheme() + ":" + f.toURI().getPath());
    }

    @Override
    public long getAccessTime() {
        return 0L;
    }

    @Override
    public long getBlockSize() {
        return this.file.length();
    }

    @Override
    public long getLen() {
        return this.file.length();
    }

    @Override
    public long getModificationTime() {
        return this.file.lastModified();
    }

    @Override
    public short getReplication() {
        return 1;
    }

    @Override
    public boolean isDir() {
        return this.file.isDirectory();
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    public File getFile() {
        return this.file;
    }
}

