/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs;

import java.io.IOException;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.io.LocatableInputSplit;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public class FileInputSplit
extends LocatableInputSplit {
    private static final long serialVersionUID = 1L;
    private Path file;
    private long start;
    private long length;

    public FileInputSplit(int num, Path file, long start, long length, String[] hosts) {
        super(num, hosts);
        this.file = file;
        this.start = start;
        this.length = length;
    }

    public FileInputSplit() {
    }

    public Path getPath() {
        return this.file;
    }

    public long getStart() {
        return this.start;
    }

    public long getLength() {
        return this.length;
    }

    @Override
    public void write(DataOutputView out) throws IOException {
        super.write(out);
        out.writeLong(this.start);
        out.writeLong(this.length);
        if (this.file != null) {
            out.writeBoolean(true);
            this.file.write(out);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public void read(DataInputView in) throws IOException {
        super.read(in);
        this.start = in.readLong();
        this.length = in.readLong();
        boolean isNotNull = in.readBoolean();
        if (isNotNull) {
            this.file = new Path();
            this.file.read(in);
        }
    }

    @Override
    public int hashCode() {
        return this.getSplitNumber() ^ (this.file == null ? 0 : this.file.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj instanceof FileInputSplit && super.equals(obj)) {
            FileInputSplit other = (FileInputSplit)obj;
            return this.start == other.start && this.length == other.length && (this.file == null ? other.file == null : other.file != null && this.file.equals(other.file));
        }
        return false;
    }

    @Override
    public String toString() {
        return "[" + this.getSplitNumber() + "] " + this.file + ":" + this.start + "+" + this.length;
    }
}

