/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.record;

import org.apache.flink.api.common.typeutils.TypePairComparator;
import org.apache.flink.types.Key;
import org.apache.flink.types.NullKeyFieldException;
import org.apache.flink.types.Record;
import org.apache.flink.util.InstantiationUtil;

public class RecordPairComparator
extends TypePairComparator<Record, Record> {
    private final int[] keyFields1;
    private final int[] keyFields2;
    private final Key[] keyHolders1;
    private final Key[] keyHolders2;

    public RecordPairComparator(int[] keyFieldsReference, int[] keyFieldsCandidate, Class<? extends Key<?>>[] keyTypes) {
        if (keyFieldsReference.length != keyFieldsCandidate.length || keyFieldsCandidate.length != keyTypes.length) {
            throw new IllegalArgumentException("The arrays describing the key positions and types must be of the same length.");
        }
        this.keyFields1 = keyFieldsReference;
        this.keyFields2 = keyFieldsCandidate;
        this.keyHolders1 = new Key[keyTypes.length];
        this.keyHolders2 = new Key[keyTypes.length];
        for (int i = 0; i < keyTypes.length; ++i) {
            if (keyTypes[i] == null) {
                throw new NullPointerException("Key type " + i + " is null.");
            }
            this.keyHolders1[i] = InstantiationUtil.instantiate(keyTypes[i], Key.class);
            this.keyHolders2[i] = InstantiationUtil.instantiate(keyTypes[i], Key.class);
        }
    }

    @Override
    public void setReference(Record reference) {
        for (int i = 0; i < this.keyFields1.length; ++i) {
            if (reference.getFieldInto(this.keyFields1[i], this.keyHolders1[i])) continue;
            throw new NullKeyFieldException(this.keyFields1[i]);
        }
    }

    @Override
    public boolean equalToReference(Record candidate) {
        for (int i = 0; i < this.keyFields2.length; ++i) {
            Key k = candidate.getField(this.keyFields2[i], this.keyHolders2[i]);
            if (k == null) {
                throw new NullKeyFieldException(this.keyFields2[i]);
            }
            if (k.equals(this.keyHolders1[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareToReference(Record candidate) {
        for (int i = 0; i < this.keyFields2.length; ++i) {
            Key k = candidate.getField(this.keyFields2[i], this.keyHolders2[i]);
            if (k == null) {
                throw new NullKeyFieldException(this.keyFields2[i]);
            }
            int comp = k.compareTo(this.keyHolders1[i]);
            if (comp == 0) continue;
            return comp;
        }
        return 0;
    }
}

