/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.record;

import java.util.Arrays;
import org.apache.flink.api.common.typeutils.TypeComparatorFactory;
import org.apache.flink.api.common.typeutils.record.RecordComparator;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.types.Key;
import org.apache.flink.types.Record;

public class RecordComparatorFactory
implements TypeComparatorFactory<Record> {
    private static final String NUM_KEYS = "numkeys";
    private static final String KEY_POS_PREFIX = "keypos.";
    private static final String KEY_CLASS_PREFIX = "keyclass.";
    private static final String KEY_SORT_DIRECTION_PREFIX = "key-direction.";
    private int[] positions;
    private Class<? extends Key<?>>[] types;
    private boolean[] sortDirections;

    public RecordComparatorFactory() {
    }

    public RecordComparatorFactory(int[] positions, Class<? extends Key<?>>[] types) {
        this(positions, types, null);
    }

    public RecordComparatorFactory(int[] positions, Class<? extends Key<?>>[] types, boolean[] sortDirections) {
        if (positions == null || types == null) {
            throw new NullPointerException();
        }
        if (positions.length != types.length) {
            throw new IllegalArgumentException();
        }
        this.positions = positions;
        this.types = types;
        if (sortDirections == null) {
            this.sortDirections = new boolean[positions.length];
            Arrays.fill(this.sortDirections, true);
        } else {
            if (sortDirections.length != positions.length) {
                throw new IllegalArgumentException();
            }
            this.sortDirections = sortDirections;
        }
    }

    @Override
    public void writeParametersToConfig(Configuration config) {
        int i;
        for (i = 0; i < this.positions.length; ++i) {
            if (this.positions[i] < 0) {
                throw new IllegalArgumentException("The key position " + i + " is invalid: " + this.positions[i]);
            }
            if (this.types[i] != null && Key.class.isAssignableFrom(this.types[i])) continue;
            throw new IllegalArgumentException("The key type " + i + " is null or not implenting the interface " + Key.class.getName() + ".");
        }
        config.setInteger(NUM_KEYS, this.positions.length);
        for (i = 0; i < this.positions.length; ++i) {
            config.setInteger(KEY_POS_PREFIX + i, this.positions[i]);
            config.setString(KEY_CLASS_PREFIX + i, this.types[i].getName());
            config.setBoolean(KEY_SORT_DIRECTION_PREFIX + i, this.sortDirections[i]);
        }
    }

    @Override
    public void readParametersFromConfig(Configuration config, ClassLoader cl) throws ClassNotFoundException {
        int numKeyFields = config.getInteger(NUM_KEYS, -1);
        if (numKeyFields < 0) {
            throw new IllegalConfigurationException("The number of keys for the comparator is invalid: " + numKeyFields);
        }
        int[] positions = new int[numKeyFields];
        Class[] types = new Class[numKeyFields];
        boolean[] direction = new boolean[numKeyFields];
        for (int i = 0; i < numKeyFields; ++i) {
            int p = config.getInteger(KEY_POS_PREFIX + i, -1);
            if (p < 0) {
                throw new IllegalConfigurationException("Contained invalid position for key no positions for keys.");
            }
            positions[i] = p;
            String name = config.getString(KEY_CLASS_PREFIX + i, null);
            if (name == null) {
                throw new IllegalConfigurationException("The key type (" + i + ") for the comparator is null");
            }
            types[i] = Class.forName(name, true, cl).asSubclass(Key.class);
            direction[i] = config.getBoolean(KEY_SORT_DIRECTION_PREFIX + i, true);
        }
        this.positions = positions;
        this.types = types;
        this.sortDirections = direction;
    }

    public RecordComparator createComparator() {
        return new RecordComparator(this.positions, this.types, this.sortDirections);
    }
}

