/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.record;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.types.Key;
import org.apache.flink.types.KeyFieldOutOfBoundsException;
import org.apache.flink.types.NormalizableKey;
import org.apache.flink.types.NullKeyFieldException;
import org.apache.flink.types.Record;
import org.apache.flink.types.Value;
import org.apache.flink.util.InstantiationUtil;

public final class RecordComparator
extends TypeComparator<Record> {
    private static final long serialVersionUID = 1L;
    private static final int[] HASH_SALT = new int[]{73, 79, 97, 113, 131, 197, 199, 311, 337, 373, 719, 733, 919, 971, 991, 1193, 1931, 3119, 3779, 7793, 7937, 9311, 9377, 11939, 19391, 19937, 37199, 39119, 71993, 91193, 93719, 93911};
    private final int[] keyFields;
    private final Key[] keyHolders;
    private final Key[] transientKeyHolders;
    private final Record temp1;
    private final Record temp2;
    private final boolean[] ascending;
    private final int[] normalizedKeyLengths;
    private final int numLeadingNormalizableKeys;
    private final int normalizableKeyPrefixLen;

    public RecordComparator(int[] keyFields, Class<? extends Key<?>>[] keyTypes) {
        this(keyFields, keyTypes, null);
    }

    public RecordComparator(int[] keyFields, Class<? extends Key<?>>[] keyTypes, boolean[] sortDirection) {
        Key k;
        int i;
        this.keyFields = keyFields;
        this.keyHolders = new Key[keyTypes.length];
        this.transientKeyHolders = new Key[keyTypes.length];
        for (int i2 = 0; i2 < keyTypes.length; ++i2) {
            if (keyTypes[i2] == null) {
                throw new NullPointerException("Key type " + i2 + " is null.");
            }
            this.keyHolders[i2] = InstantiationUtil.instantiate(keyTypes[i2], Key.class);
            this.transientKeyHolders[i2] = InstantiationUtil.instantiate(keyTypes[i2], Key.class);
        }
        this.normalizedKeyLengths = new int[keyFields.length];
        int nKeys = 0;
        int nKeyLen = 0;
        boolean inverted = false;
        for (i = 0; i < this.keyHolders.length && (k = this.keyHolders[i]) instanceof NormalizableKey; ++i) {
            if (sortDirection != null) {
                if (sortDirection[i] && inverted) break;
                if (i == 0 && !sortDirection[0]) {
                    inverted = true;
                }
            }
            ++nKeys;
            int len = ((NormalizableKey)k).getMaxNormalizedKeyLen();
            if (len < 0) {
                throw new RuntimeException("Data type " + k.getClass().getName() + " specifies an invalid length for the normalized key: " + len);
            }
            this.normalizedKeyLengths[i] = len;
            if ((nKeyLen += this.normalizedKeyLengths[i]) >= 0) continue;
            nKeyLen = Integer.MAX_VALUE;
            break;
        }
        this.numLeadingNormalizableKeys = nKeys;
        this.normalizableKeyPrefixLen = nKeyLen;
        this.temp1 = new Record();
        this.temp2 = new Record();
        if (sortDirection != null) {
            this.ascending = sortDirection;
        } else {
            this.ascending = new boolean[keyFields.length];
            for (i = 0; i < this.ascending.length; ++i) {
                this.ascending[i] = true;
            }
        }
    }

    private RecordComparator(RecordComparator toCopy) {
        this.keyFields = toCopy.keyFields;
        this.keyHolders = new Key[toCopy.keyHolders.length];
        this.transientKeyHolders = new Key[toCopy.keyHolders.length];
        try {
            for (int i = 0; i < this.keyHolders.length; ++i) {
                this.keyHolders[i] = (Key)toCopy.keyHolders[i].getClass().newInstance();
                this.transientKeyHolders[i] = (Key)toCopy.keyHolders[i].getClass().newInstance();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not instantiate key classes when duplicating RecordComparator.", ex);
        }
        this.normalizedKeyLengths = toCopy.normalizedKeyLengths;
        this.numLeadingNormalizableKeys = toCopy.numLeadingNormalizableKeys;
        this.normalizableKeyPrefixLen = toCopy.normalizableKeyPrefixLen;
        this.ascending = toCopy.ascending;
        this.temp1 = new Record();
        this.temp2 = new Record();
    }

    @Override
    public int hash(Record object) {
        int i;
        try {
            int code = 0;
            for (i = 0; i < this.keyFields.length; ++i) {
                code ^= object.getField(this.keyFields[i], this.transientKeyHolders[i]).hashCode();
                code *= HASH_SALT[i & 0x1F];
            }
            return code;
        }
        catch (NullPointerException npex) {
            throw new NullKeyFieldException(this.keyFields[i]);
        }
        catch (IndexOutOfBoundsException iobex) {
            throw new KeyFieldOutOfBoundsException(this.keyFields[i]);
        }
    }

    @Override
    public void setReference(Record toCompare) {
        for (int i = 0; i < this.keyFields.length; ++i) {
            if (toCompare.getFieldInto(this.keyFields[i], this.keyHolders[i])) continue;
            throw new NullKeyFieldException(this.keyFields[i]);
        }
    }

    @Override
    public boolean equalToReference(Record candidate) {
        for (int i = 0; i < this.keyFields.length; ++i) {
            Key k = candidate.getField(this.keyFields[i], this.transientKeyHolders[i]);
            if (k == null) {
                throw new NullKeyFieldException(this.keyFields[i]);
            }
            if (k.equals(this.keyHolders[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareToReference(TypeComparator<Record> referencedAccessors) {
        RecordComparator pra = (RecordComparator)referencedAccessors;
        for (int i = 0; i < this.keyFields.length; ++i) {
            int comp = pra.keyHolders[i].compareTo(this.keyHolders[i]);
            if (comp == 0) continue;
            return this.ascending[i] ? comp : -comp;
        }
        return 0;
    }

    @Override
    public int compare(Record first, Record second) {
        int i;
        try {
            for (i = 0; i < this.keyFields.length; ++i) {
                Key k2;
                Key k1 = first.getField(this.keyFields[i], this.keyHolders[i]);
                int cmp = k1.compareTo(k2 = second.getField(this.keyFields[i], this.transientKeyHolders[i]));
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }
        catch (NullPointerException e) {
            throw new NullKeyFieldException(this.keyFields[i]);
        }
    }

    @Override
    public int compareSerialized(DataInputView source1, DataInputView source2) throws IOException {
        this.temp1.read(source1);
        this.temp2.read(source2);
        for (int i = 0; i < this.keyFields.length; ++i) {
            Key k1 = this.temp1.getField(this.keyFields[i], this.keyHolders[i]);
            Key k2 = this.temp2.getField(this.keyFields[i], this.transientKeyHolders[i]);
            if (k1 == null || k2 == null) {
                throw new NullKeyFieldException(this.keyFields[i]);
            }
            int comp = k1.compareTo(k2);
            if (comp == 0) continue;
            return this.ascending[i] ? comp : -comp;
        }
        return 0;
    }

    @Override
    public boolean supportsNormalizedKey() {
        return this.numLeadingNormalizableKeys > 0;
    }

    @Override
    public int getNormalizeKeyLen() {
        return this.normalizableKeyPrefixLen;
    }

    @Override
    public boolean isNormalizedKeyPrefixOnly(int keyBytes) {
        return this.numLeadingNormalizableKeys < this.keyFields.length || this.normalizableKeyPrefixLen == Integer.MAX_VALUE || this.normalizableKeyPrefixLen > keyBytes;
    }

    @Override
    public void putNormalizedKey(Record record, MemorySegment target, int offset, int numBytes) {
        int i = 0;
        try {
            while (i < this.numLeadingNormalizableKeys & numBytes > 0) {
                int len = this.normalizedKeyLengths[i];
                len = numBytes >= len ? len : numBytes;
                ((NormalizableKey)record.getField(this.keyFields[i], this.transientKeyHolders[i])).copyNormalizedKey(target, offset, len);
                numBytes -= len;
                offset += len;
                ++i;
            }
        }
        catch (NullPointerException npex) {
            throw new NullKeyFieldException(this.keyFields[i]);
        }
    }

    @Override
    public boolean invertNormalizedKey() {
        return !this.ascending[0];
    }

    @Override
    public boolean supportsSerializationWithKeyNormalization() {
        return false;
    }

    @Override
    public void writeWithKeyNormalization(Record record, DataOutputView target) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Record readWithKeyDenormalization(Record reuse, DataInputView source) {
        throw new UnsupportedOperationException();
    }

    public RecordComparator duplicate() {
        return new RecordComparator(this);
    }

    public final int[] getKeyPositions() {
        return this.keyFields;
    }

    public final Class<? extends Key<?>>[] getKeyTypes() {
        Class[] keyTypes = new Class[this.keyHolders.length];
        for (int i = 0; i < keyTypes.length; ++i) {
            keyTypes[i] = this.keyHolders[i].getClass();
        }
        return keyTypes;
    }

    public final Key<?>[] getKeysAsCopy(Record record) {
        try {
            Value[] keys = new Key[this.keyFields.length];
            for (int i = 0; i < keys.length; ++i) {
                keys[i] = (Key)this.keyHolders[i].getClass().newInstance();
            }
            if (!record.getFieldsInto(this.keyFields, keys)) {
                throw new RuntimeException("Could not extract keys from record.");
            }
            return keys;
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not instantiate key classes when duplicating RecordComparator.", ex);
        }
    }

    @Override
    public int extractKeys(Object record, Object[] target, int index) {
        throw new UnsupportedOperationException("Record does not support extactKeys and getComparators. This cannot be used with the GenericPairComparator.");
    }

    @Override
    public TypeComparator<?>[] getFlatComparators() {
        throw new UnsupportedOperationException("Record does not support extactKeys and getComparators. This cannot be used with the GenericPairComparator.");
    }

    @Override
    public boolean supportsCompareAgainstReference() {
        return true;
    }

    @Override
    public final int compareAgainstReference(Comparable[] keys) {
        for (int i = 0; i < this.keyFields.length; ++i) {
            int comp = keys[i].compareTo(this.keyHolders[i]);
            if (comp == 0) continue;
            return this.ascending[i] ? comp : -comp;
        }
        return 0;
    }
}

