/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public final class LongSerializer
extends TypeSerializerSingleton<Long> {
    private static final long serialVersionUID = 1L;
    public static final LongSerializer INSTANCE = new LongSerializer();
    private static final Long ZERO = 0L;

    @Override
    public boolean isImmutableType() {
        return true;
    }

    @Override
    public boolean isStateful() {
        return false;
    }

    @Override
    public Long createInstance() {
        return ZERO;
    }

    @Override
    public Long copy(Long from) {
        return from;
    }

    @Override
    public Long copy(Long from, Long reuse) {
        return from;
    }

    @Override
    public int getLength() {
        return 8;
    }

    @Override
    public void serialize(Long record, DataOutputView target) throws IOException {
        target.writeLong(record);
    }

    @Override
    public Long deserialize(DataInputView source) throws IOException {
        return source.readLong();
    }

    @Override
    public Long deserialize(Long reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        target.writeLong(source.readLong());
    }
}

