/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.base.BasicTypeComparator;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.MemorySegment;

public final class FloatComparator
extends BasicTypeComparator<Float> {
    private static final long serialVersionUID = 1L;

    public FloatComparator(boolean ascending) {
        super(ascending);
    }

    @Override
    public int compareSerialized(DataInputView firstSource, DataInputView secondSource) throws IOException {
        float l2;
        float l1 = firstSource.readFloat();
        int comp = l1 < (l2 = secondSource.readFloat()) ? -1 : (l1 > l2 ? 1 : 0);
        return this.ascendingComparison ? comp : -comp;
    }

    @Override
    public boolean supportsNormalizedKey() {
        return false;
    }

    @Override
    public int getNormalizeKeyLen() {
        return 0;
    }

    @Override
    public boolean isNormalizedKeyPrefixOnly(int keyBytes) {
        return true;
    }

    @Override
    public void putNormalizedKey(Float value, MemorySegment target, int offset, int numBytes) {
        throw new UnsupportedOperationException();
    }

    public FloatComparator duplicate() {
        return new FloatComparator(this.ascendingComparison);
    }
}

