/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import java.util.Date;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public final class DateSerializer
extends TypeSerializerSingleton<Date> {
    private static final long serialVersionUID = 1L;
    public static final DateSerializer INSTANCE = new DateSerializer();

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public boolean isStateful() {
        return false;
    }

    @Override
    public Date createInstance() {
        return new Date();
    }

    @Override
    public Date copy(Date from) {
        return new Date(from.getTime());
    }

    @Override
    public Date copy(Date from, Date reuse) {
        reuse.setTime(from.getTime());
        return reuse;
    }

    @Override
    public int getLength() {
        return 8;
    }

    @Override
    public void serialize(Date record, DataOutputView target) throws IOException {
        target.writeLong(record.getTime());
    }

    @Override
    public Date deserialize(DataInputView source) throws IOException {
        return new Date(source.readLong());
    }

    @Override
    public Date deserialize(Date reuse, DataInputView source) throws IOException {
        reuse.setTime(source.readLong());
        return reuse;
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        target.writeLong(source.readLong());
    }
}

