/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public final class ByteSerializer
extends TypeSerializerSingleton<Byte> {
    private static final long serialVersionUID = 1L;
    public static final ByteSerializer INSTANCE = new ByteSerializer();
    private static final Byte ZERO = 0;

    @Override
    public boolean isImmutableType() {
        return true;
    }

    @Override
    public boolean isStateful() {
        return false;
    }

    @Override
    public Byte createInstance() {
        return ZERO;
    }

    @Override
    public Byte copy(Byte from) {
        return from;
    }

    @Override
    public Byte copy(Byte from, Byte reuse) {
        return from;
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public void serialize(Byte record, DataOutputView target) throws IOException {
        target.writeByte(record.byteValue());
    }

    @Override
    public Byte deserialize(DataInputView source) throws IOException {
        return source.readByte();
    }

    @Override
    public Byte deserialize(Byte reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        target.writeByte(source.readByte());
    }
}

