/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeinfo;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.functions.InvalidTypesException;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.GenericArraySerializer;
import org.apache.flink.api.common.typeutils.base.array.StringArraySerializer;

public class BasicArrayTypeInfo<T, C>
extends TypeInformation<T> {
    public static final BasicArrayTypeInfo<String[], String> STRING_ARRAY_TYPE_INFO = new BasicArrayTypeInfo<String[], String>(String[].class, BasicTypeInfo.STRING_TYPE_INFO);
    public static final BasicArrayTypeInfo<Boolean[], Boolean> BOOLEAN_ARRAY_TYPE_INFO = new BasicArrayTypeInfo<Boolean[], Boolean>(Boolean[].class, BasicTypeInfo.BOOLEAN_TYPE_INFO);
    public static final BasicArrayTypeInfo<Byte[], Byte> BYTE_ARRAY_TYPE_INFO = new BasicArrayTypeInfo<Byte[], Byte>(Byte[].class, BasicTypeInfo.BYTE_TYPE_INFO);
    public static final BasicArrayTypeInfo<Short[], Short> SHORT_ARRAY_TYPE_INFO = new BasicArrayTypeInfo<Short[], Short>(Short[].class, BasicTypeInfo.SHORT_TYPE_INFO);
    public static final BasicArrayTypeInfo<Integer[], Integer> INT_ARRAY_TYPE_INFO = new BasicArrayTypeInfo<Integer[], Integer>(Integer[].class, BasicTypeInfo.INT_TYPE_INFO);
    public static final BasicArrayTypeInfo<Long[], Long> LONG_ARRAY_TYPE_INFO = new BasicArrayTypeInfo<Long[], Long>(Long[].class, BasicTypeInfo.LONG_TYPE_INFO);
    public static final BasicArrayTypeInfo<Float[], Float> FLOAT_ARRAY_TYPE_INFO = new BasicArrayTypeInfo<Float[], Float>(Float[].class, BasicTypeInfo.FLOAT_TYPE_INFO);
    public static final BasicArrayTypeInfo<Double[], Double> DOUBLE_ARRAY_TYPE_INFO = new BasicArrayTypeInfo<Double[], Double>(Double[].class, BasicTypeInfo.DOUBLE_TYPE_INFO);
    public static final BasicArrayTypeInfo<Character[], Character> CHAR_ARRAY_TYPE_INFO = new BasicArrayTypeInfo<Character[], Character>(Character[].class, BasicTypeInfo.CHAR_TYPE_INFO);
    private final Class<T> arrayClass;
    private final Class<C> componentClass;
    private final TypeInformation<C> componentInfo;
    private static final Map<Class<?>, BasicArrayTypeInfo<?, ?>> TYPES = new HashMap();

    private BasicArrayTypeInfo(Class<T> arrayClass, BasicTypeInfo<C> componentInfo) {
        this.arrayClass = arrayClass;
        this.componentClass = arrayClass.getComponentType();
        this.componentInfo = componentInfo;
    }

    @Override
    public boolean isBasicType() {
        return false;
    }

    @Override
    public boolean isTupleType() {
        return false;
    }

    @Override
    public int getArity() {
        return 1;
    }

    @Override
    public int getTotalFields() {
        return 1;
    }

    @Override
    public Class<T> getTypeClass() {
        return this.arrayClass;
    }

    public Class<C> getComponentTypeClass() {
        return this.componentClass;
    }

    public TypeInformation<C> getComponentInfo() {
        return this.componentInfo;
    }

    @Override
    public boolean isKeyType() {
        return false;
    }

    @Override
    public TypeSerializer<T> createSerializer() {
        if (this.componentClass.equals(String.class)) {
            return StringArraySerializer.INSTANCE;
        }
        return new GenericArraySerializer<C>(this.componentClass, this.componentInfo.createSerializer());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "<" + this.componentInfo + ">";
    }

    public static <X, C> BasicArrayTypeInfo<X, C> getInfoFor(Class<X> type) {
        if (!type.isArray()) {
            throw new InvalidTypesException("The given class is no array.");
        }
        return TYPES.get(type);
    }

    static {
        TYPES.put(String[].class, STRING_ARRAY_TYPE_INFO);
        TYPES.put(Boolean[].class, BOOLEAN_ARRAY_TYPE_INFO);
        TYPES.put(Byte[].class, BYTE_ARRAY_TYPE_INFO);
        TYPES.put(Short[].class, SHORT_ARRAY_TYPE_INFO);
        TYPES.put(Integer[].class, INT_ARRAY_TYPE_INFO);
        TYPES.put(Long[].class, LONG_ARRAY_TYPE_INFO);
        TYPES.put(Float[].class, FLOAT_ARRAY_TYPE_INFO);
        TYPES.put(Double[].class, DOUBLE_ARRAY_TYPE_INFO);
        TYPES.put(Character[].class, CHAR_ARRAY_TYPE_INFO);
    }
}

