/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.flink.api.common.operators.util.FieldList;

public class FieldSet
implements Iterable<Integer> {
    public static final FieldSet EMPTY_SET = new FieldSet();
    protected final Collection<Integer> collection;

    public FieldSet() {
        this.collection = Collections.emptySet();
    }

    public FieldSet(Integer fieldID) {
        if (fieldID == null) {
            throw new IllegalArgumentException("Field ID must not be null.");
        }
        this.collection = Collections.singleton(fieldID);
    }

    public FieldSet(int ... fieldIDs) {
        if (fieldIDs == null || fieldIDs.length == 0) {
            this.collection = Collections.emptySet();
        } else {
            HashSet<Integer> set = new HashSet<Integer>(2 * fieldIDs.length);
            for (int i = 0; i < fieldIDs.length; ++i) {
                set.add(fieldIDs[i]);
            }
            this.collection = Collections.unmodifiableSet(set);
        }
    }

    public FieldSet(int[] fieldIDs, boolean marker) {
        if (fieldIDs == null || fieldIDs.length == 0) {
            this.collection = Collections.emptySet();
        } else {
            HashSet<Integer> set = new HashSet<Integer>(2 * fieldIDs.length);
            for (int i = 0; i < fieldIDs.length; ++i) {
                set.add(fieldIDs[i]);
            }
            this.collection = Collections.unmodifiableSet(set);
        }
    }

    protected FieldSet(Collection<Integer> fields) {
        this.collection = fields;
    }

    private FieldSet(FieldSet fieldSet, Integer fieldID) {
        if (fieldSet.size() == 0) {
            this.collection = Collections.singleton(fieldID);
        } else {
            HashSet<Integer> set = new HashSet<Integer>(2 * (fieldSet.collection.size() + 1));
            set.addAll(fieldSet.collection);
            set.add(fieldID);
            this.collection = Collections.unmodifiableSet(set);
        }
    }

    private FieldSet(FieldSet fieldSet, int ... fieldIDs) {
        if (fieldIDs == null || fieldIDs.length == 0) {
            this.collection = fieldSet.collection;
        } else {
            HashSet<Integer> set = new HashSet<Integer>(2 * (fieldSet.collection.size() + fieldIDs.length));
            set.addAll(fieldSet.collection);
            for (int i = 0; i < fieldIDs.length; ++i) {
                set.add(fieldIDs[i]);
            }
            this.collection = Collections.unmodifiableSet(set);
        }
    }

    private FieldSet(FieldSet fieldSet1, FieldSet fieldSet2) {
        if (fieldSet2.size() == 0) {
            this.collection = fieldSet1.collection;
        } else if (fieldSet1.size() == 0) {
            this.collection = fieldSet2.collection;
        } else {
            HashSet<Integer> set = new HashSet<Integer>(2 * (fieldSet1.size() + fieldSet2.size()));
            set.addAll(fieldSet1.collection);
            set.addAll(fieldSet2.collection);
            this.collection = Collections.unmodifiableSet(set);
        }
    }

    public FieldSet addField(Integer fieldID) {
        if (fieldID == null) {
            throw new IllegalArgumentException("Field ID must not be null.");
        }
        return new FieldSet(this, fieldID);
    }

    public FieldSet addFields(int ... fieldIDs) {
        return new FieldSet(this, fieldIDs);
    }

    public FieldSet addFields(FieldSet set) {
        if (set == null) {
            throw new IllegalArgumentException("FieldSet to add must not be null.");
        }
        if (set.size() == 0) {
            return this;
        }
        if (this.size() == 0) {
            return set;
        }
        return new FieldSet(this, set);
    }

    public boolean contains(Integer columnIndex) {
        return this.collection.contains(columnIndex);
    }

    public int size() {
        return this.collection.size();
    }

    @Override
    public Iterator<Integer> iterator() {
        return this.collection.iterator();
    }

    public FieldList toFieldList() {
        int[] pos = this.toArray();
        Arrays.sort(pos);
        return new FieldList(pos);
    }

    public int[] toArray() {
        int[] a = new int[this.collection.size()];
        int i = 0;
        for (int col : this.collection) {
            a[i++] = col;
        }
        return a;
    }

    public boolean isValidSubset(FieldSet set) {
        if (set.size() > this.size()) {
            return false;
        }
        for (Integer i : set) {
            if (this.contains(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.collection.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof FieldSet) {
            return this.collection.equals(((FieldSet)obj).collection);
        }
        return false;
    }

    public String toString() {
        StringBuilder bld = new StringBuilder();
        bld.append(this.getDescriptionPrefix());
        for (Integer i : this.collection) {
            bld.append(i);
            bld.append(',');
            bld.append(' ');
        }
        if (this.collection.size() > 0) {
            bld.setLength(bld.length() - 2);
        }
        bld.append(this.getDescriptionSuffix());
        return bld.toString();
    }

    public FieldSet clone() {
        return this;
    }

    protected String getDescriptionPrefix() {
        return "(";
    }

    protected String getDescriptionSuffix() {
        return ")";
    }
}

