/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators.base;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.CopyingListCollector;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.api.common.functions.util.ListCollector;
import org.apache.flink.api.common.operators.SingleInputOperator;
import org.apache.flink.api.common.operators.UnaryOperatorInformation;
import org.apache.flink.api.common.operators.util.UserCodeClassWrapper;
import org.apache.flink.api.common.operators.util.UserCodeObjectWrapper;
import org.apache.flink.api.common.operators.util.UserCodeWrapper;
import org.apache.flink.api.common.typeutils.TypeSerializer;

public class FlatMapOperatorBase<IN, OUT, FT extends FlatMapFunction<IN, OUT>>
extends SingleInputOperator<IN, OUT, FT> {
    public FlatMapOperatorBase(UserCodeWrapper<FT> udf, UnaryOperatorInformation<IN, OUT> operatorInfo, String name) {
        super(udf, operatorInfo, name);
    }

    public FlatMapOperatorBase(FT udf, UnaryOperatorInformation<IN, OUT> operatorInfo, String name) {
        super(new UserCodeObjectWrapper<FT>(udf), operatorInfo, name);
    }

    public FlatMapOperatorBase(Class<? extends FT> udf, UnaryOperatorInformation<IN, OUT> operatorInfo, String name) {
        super(new UserCodeClassWrapper<FT>(udf), operatorInfo, name);
    }

    @Override
    protected List<OUT> executeOnCollections(List<IN> input, RuntimeContext ctx, boolean mutableObjectSafeMode) throws Exception {
        FlatMapFunction function = (FlatMapFunction)this.userFunction.getUserCodeObject();
        FunctionUtils.setFunctionRuntimeContext(function, ctx);
        FunctionUtils.openFunction(function, this.parameters);
        ArrayList result = new ArrayList(input.size());
        if (mutableObjectSafeMode) {
            TypeSerializer inSerializer = ((UnaryOperatorInformation)this.getOperatorInfo()).getInputType().createSerializer();
            TypeSerializer outSerializer = this.getOperatorInfo().getOutputType().createSerializer();
            CopyingListCollector resultCollector = new CopyingListCollector(result, outSerializer);
            for (IN element : input) {
                Object inCopy = inSerializer.copy(element);
                function.flatMap(inCopy, resultCollector);
            }
        } else {
            ListCollector resultCollector = new ListCollector(result);
            for (IN element : input) {
                function.flatMap(element, resultCollector);
            }
        }
        FunctionUtils.closeFunction(function);
        return result;
    }
}

