/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators.base;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.aggregators.AggregatorRegistry;
import org.apache.flink.api.common.functions.AbstractRichFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.operators.BinaryOperatorInformation;
import org.apache.flink.api.common.operators.DualInputOperator;
import org.apache.flink.api.common.operators.IterationOperator;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.OperatorInformation;
import org.apache.flink.api.common.operators.util.UserCodeClassWrapper;
import org.apache.flink.api.common.operators.util.UserCodeWrapper;
import org.apache.flink.util.Visitor;

public class DeltaIterationBase<ST, WT>
extends DualInputOperator<ST, WT, ST, AbstractRichFunction>
implements IterationOperator {
    private final Operator<ST> solutionSetPlaceholder;
    private final Operator<WT> worksetPlaceholder;
    private Operator<ST> solutionSetDelta;
    private Operator<WT> nextWorkset;
    private final int[] solutionSetKeyFields;
    private int maxNumberOfIterations = -1;
    private final AggregatorRegistry aggregators = new AggregatorRegistry();
    private boolean solutionSetUnManaged;

    public DeltaIterationBase(BinaryOperatorInformation<ST, WT, ST> operatorInfo, int keyPosition) {
        this(operatorInfo, new int[]{keyPosition});
    }

    public DeltaIterationBase(BinaryOperatorInformation<ST, WT, ST> operatorInfo, int[] keyPositions) {
        this(operatorInfo, keyPositions, "<Unnamed Workset-Iteration>");
    }

    public DeltaIterationBase(BinaryOperatorInformation<ST, WT, ST> operatorInfo, int keyPosition, String name) {
        this(operatorInfo, new int[]{keyPosition}, name);
    }

    public DeltaIterationBase(BinaryOperatorInformation<ST, WT, ST> operatorInfo, int[] keyPositions, String name) {
        super(new UserCodeClassWrapper<AbstractRichFunction>(AbstractRichFunction.class), operatorInfo, name);
        this.solutionSetKeyFields = keyPositions;
        this.solutionSetPlaceholder = new SolutionSetPlaceHolder<ST>(this, new OperatorInformation<ST>(operatorInfo.getFirstInputType()));
        this.worksetPlaceholder = new WorksetPlaceHolder<WT>(this, new OperatorInformation<WT>(operatorInfo.getSecondInputType()));
    }

    public int[] getSolutionSetKeyFields() {
        return this.solutionSetKeyFields;
    }

    public void setMaximumNumberOfIterations(int maxIterations) {
        this.maxNumberOfIterations = maxIterations;
    }

    public int getMaximumNumberOfIterations() {
        return this.maxNumberOfIterations;
    }

    @Override
    public AggregatorRegistry getAggregators() {
        return this.aggregators;
    }

    public Operator<ST> getSolutionSet() {
        return this.solutionSetPlaceholder;
    }

    public Operator<WT> getWorkset() {
        return this.worksetPlaceholder;
    }

    public void setNextWorkset(Operator<WT> result) {
        this.nextWorkset = result;
    }

    public Operator<WT> getNextWorkset() {
        return this.nextWorkset;
    }

    public void setSolutionSetDelta(Operator<ST> delta) {
        this.solutionSetDelta = delta;
    }

    public Operator<ST> getSolutionSetDelta() {
        return this.solutionSetDelta;
    }

    public Operator<ST> getInitialSolutionSet() {
        return this.getFirstInput();
    }

    public Operator<WT> getInitialWorkset() {
        return this.getSecondInput();
    }

    public void setInitialSolutionSet(Operator<ST> input) {
        this.setFirstInput(input);
    }

    public void setInitialWorkset(Operator<WT> input) {
        this.setSecondInput(input);
    }

    @Override
    public Map<String, Operator<?>> getBroadcastInputs() {
        return Collections.emptyMap();
    }

    @Override
    public void setBroadcastVariable(String name, Operator<?> root) {
        throw new UnsupportedOperationException("The DeltaIteration meta operator cannot have broadcast inputs.");
    }

    @Override
    public <X> void setBroadcastVariables(Map<String, Operator<X>> inputs) {
        throw new UnsupportedOperationException("The DeltaIteration meta operator cannot have broadcast inputs.");
    }

    public void setSolutionSetUnManaged(boolean solutionSetUnManaged) {
        this.solutionSetUnManaged = solutionSetUnManaged;
    }

    public boolean isSolutionSetUnManaged() {
        return this.solutionSetUnManaged;
    }

    @Override
    protected List<ST> executeOnCollections(List<ST> inputData1, List<WT> inputData2, RuntimeContext runtimeContext, boolean mutableObjectSafeMode) {
        throw new UnsupportedOperationException();
    }

    public static class SolutionSetPlaceHolder<ST>
    extends Operator<ST> {
        protected final DeltaIterationBase<ST, ?> containingIteration;

        public SolutionSetPlaceHolder(DeltaIterationBase<ST, ?> container, OperatorInformation<ST> operatorInfo) {
            super(operatorInfo, "Solution Set Place Holder");
            this.containingIteration = container;
        }

        public DeltaIterationBase<ST, ?> getContainingWorksetIteration() {
            return this.containingIteration;
        }

        @Override
        public void accept(Visitor<Operator<?>> visitor) {
            visitor.preVisit(this);
            visitor.postVisit(this);
        }

        @Override
        public UserCodeWrapper<?> getUserCodeWrapper() {
            return null;
        }
    }

    public static class WorksetPlaceHolder<WT>
    extends Operator<WT> {
        private final DeltaIterationBase<?, WT> containingIteration;

        public WorksetPlaceHolder(DeltaIterationBase<?, WT> container, OperatorInformation<WT> operatorInfo) {
            super(operatorInfo, "Workset Place Holder");
            this.containingIteration = container;
        }

        public DeltaIterationBase<?, WT> getContainingWorksetIteration() {
            return this.containingIteration;
        }

        @Override
        public void accept(Visitor<Operator<?>> visitor) {
            visitor.preVisit(this);
            visitor.postVisit(this);
        }

        @Override
        public UserCodeWrapper<?> getUserCodeWrapper() {
            return null;
        }
    }
}

