/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators.base;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.functions.CrossFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.api.common.operators.BinaryOperatorInformation;
import org.apache.flink.api.common.operators.DualInputOperator;
import org.apache.flink.api.common.operators.util.UserCodeClassWrapper;
import org.apache.flink.api.common.operators.util.UserCodeObjectWrapper;
import org.apache.flink.api.common.operators.util.UserCodeWrapper;
import org.apache.flink.api.common.typeutils.TypeSerializer;

public class CrossOperatorBase<IN1, IN2, OUT, FT extends CrossFunction<IN1, IN2, OUT>>
extends DualInputOperator<IN1, IN2, OUT, FT> {
    public CrossOperatorBase(UserCodeWrapper<FT> udf, BinaryOperatorInformation<IN1, IN2, OUT> operatorInfo, String name) {
        super(udf, operatorInfo, name);
    }

    public CrossOperatorBase(FT udf, BinaryOperatorInformation<IN1, IN2, OUT> operatorInfo, String name) {
        this(new UserCodeObjectWrapper<FT>(udf), operatorInfo, name);
    }

    public CrossOperatorBase(Class<? extends FT> udf, BinaryOperatorInformation<IN1, IN2, OUT> operatorInfo, String name) {
        this(new UserCodeClassWrapper<FT>(udf), operatorInfo, name);
    }

    @Override
    protected List<OUT> executeOnCollections(List<IN1> inputData1, List<IN2> inputData2, RuntimeContext ctx, boolean mutableObjectSafeMode) throws Exception {
        CrossFunction function = (CrossFunction)this.userFunction.getUserCodeObject();
        FunctionUtils.setFunctionRuntimeContext(function, ctx);
        FunctionUtils.openFunction(function, this.parameters);
        ArrayList result = new ArrayList(inputData1.size() * inputData2.size());
        if (mutableObjectSafeMode) {
            TypeSerializer inSerializer1 = ((BinaryOperatorInformation)this.getOperatorInfo()).getFirstInputType().createSerializer();
            TypeSerializer inSerializer2 = ((BinaryOperatorInformation)this.getOperatorInfo()).getSecondInputType().createSerializer();
            TypeSerializer outSerializer = this.getOperatorInfo().getOutputType().createSerializer();
            for (IN1 element1 : inputData1) {
                for (IN2 element2 : inputData2) {
                    Object copy1 = inSerializer1.copy(element1);
                    Object copy2 = inSerializer2.copy(element2);
                    Object o = function.cross(copy1, copy2);
                    result.add(outSerializer.copy(o));
                }
            }
        } else {
            for (IN1 element1 : inputData1) {
                for (IN2 element2 : inputData2) {
                    result.add(function.cross(element1, element2));
                }
            }
        }
        FunctionUtils.closeFunction(function);
        return result;
    }

    public static interface CrossWithLarge {
    }

    public static interface CrossWithSmall {
    }
}

