/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.operators.SemanticProperties;
import org.apache.flink.api.common.operators.util.FieldSet;

public class SingleInputSemanticProperties
extends SemanticProperties {
    private static final long serialVersionUID = 1L;
    private Map<Integer, FieldSet> forwardedFields;
    private FieldSet readFields;

    public SingleInputSemanticProperties() {
        this.init();
    }

    public void addForwardedField(int sourceField, int destinationField) {
        FieldSet old = this.forwardedFields.get(sourceField);
        if (old == null) {
            old = FieldSet.EMPTY_SET;
        }
        FieldSet fs = old.addField(destinationField);
        this.forwardedFields.put(sourceField, fs);
    }

    public void addForwardedField(int sourceField, FieldSet destinationFields) {
        FieldSet old = this.forwardedFields.get(sourceField);
        if (old == null) {
            old = FieldSet.EMPTY_SET;
        }
        FieldSet fs = old.addFields(destinationFields);
        this.forwardedFields.put(sourceField, fs);
    }

    public void setForwardedField(int sourceField, FieldSet destinationFields) {
        this.forwardedFields.put(sourceField, destinationFields);
    }

    public FieldSet getForwardedField(int sourceField) {
        return this.forwardedFields.get(sourceField);
    }

    public void addReadFields(FieldSet readFields) {
        this.readFields = this.readFields == null ? readFields : this.readFields.addFields(readFields);
    }

    public void setReadFields(FieldSet readFields) {
        this.readFields = readFields;
    }

    public FieldSet getReadFields() {
        return this.readFields;
    }

    @Override
    public void clearProperties() {
        this.init();
        super.clearProperties();
    }

    private void init() {
        this.forwardedFields = new HashMap<Integer, FieldSet>();
        this.readFields = null;
    }

    public static class AllFieldsConstantProperties
    extends SingleInputSemanticProperties {
        private static final long serialVersionUID = 1L;

        @Override
        public FieldSet getReadFields() {
            return FieldSet.EMPTY_SET;
        }

        @Override
        public FieldSet getWrittenFields() {
            return FieldSet.EMPTY_SET;
        }

        @Override
        public FieldSet getForwardedField(int sourceField) {
            return new FieldSet((Integer)sourceField);
        }

        @Override
        public void addForwardedField(int sourceField, FieldSet destinationFields) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addForwardedField(int sourceField, int destinationField) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setForwardedField(int sourceField, FieldSet destinationFields) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addReadFields(FieldSet readFields) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setReadFields(FieldSet readFields) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addWrittenFields(FieldSet writtenFields) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setWrittenFields(FieldSet writtenFields) {
            throw new UnsupportedOperationException();
        }
    }
}

