/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.operators.SemanticProperties;
import org.apache.flink.api.common.operators.util.FieldSet;

public class DualInputSemanticProperties
extends SemanticProperties {
    private static final long serialVersionUID = 1L;
    private Map<Integer, FieldSet> forwardedFields1;
    private Map<Integer, FieldSet> forwardedFields2;
    private FieldSet readFields1;
    private FieldSet readFields2;

    public DualInputSemanticProperties() {
        this.init();
    }

    public void addForwardedField1(int sourceField, int destinationField) {
        FieldSet old = this.forwardedFields1.get(sourceField);
        if (old == null) {
            old = FieldSet.EMPTY_SET;
        }
        FieldSet fs = old.addField(destinationField);
        this.forwardedFields1.put(sourceField, fs);
    }

    public void addForwardedField1(int sourceField, FieldSet destinationFields) {
        FieldSet old = this.forwardedFields1.get(sourceField);
        if (old == null) {
            old = FieldSet.EMPTY_SET;
        }
        FieldSet fs = old.addFields(destinationFields);
        this.forwardedFields1.put(sourceField, fs);
    }

    public void setForwardedField1(int sourceField, FieldSet destinationFields) {
        this.forwardedFields1.put(sourceField, destinationFields);
    }

    public FieldSet getForwardedField1(int sourceField) {
        return this.forwardedFields1.get(sourceField);
    }

    public void addForwardedField2(int sourceField, int destinationField) {
        FieldSet old = this.forwardedFields2.get(sourceField);
        if (old == null) {
            old = FieldSet.EMPTY_SET;
        }
        FieldSet fs = old.addField(destinationField);
        this.forwardedFields2.put(sourceField, fs);
    }

    public void addForwardedField2(int sourceField, FieldSet destinationFields) {
        FieldSet old = this.forwardedFields2.get(sourceField);
        if (old == null) {
            old = FieldSet.EMPTY_SET;
        }
        FieldSet fs = old.addFields(destinationFields);
        this.forwardedFields2.put(sourceField, fs);
    }

    public void setForwardedField2(int sourceField, FieldSet destinationFields) {
        this.forwardedFields2.put(sourceField, destinationFields);
    }

    public FieldSet getForwardedField2(int sourceField) {
        return this.forwardedFields2.get(sourceField);
    }

    public void addReadFields1(FieldSet readFields) {
        this.readFields1 = this.readFields1 == null ? readFields : this.readFields2.addFields(readFields);
    }

    public void setReadFields1(FieldSet readFields) {
        this.readFields1 = readFields;
    }

    public FieldSet getReadFields1() {
        return this.readFields1;
    }

    public void addReadFields2(FieldSet readFields) {
        this.readFields2 = this.readFields2 == null ? readFields : this.readFields2.addFields(readFields);
    }

    public void setReadFields2(FieldSet readFields) {
        this.readFields2 = readFields;
    }

    public FieldSet getReadFields2() {
        return this.readFields2;
    }

    @Override
    public void clearProperties() {
        this.init();
        super.clearProperties();
    }

    private void init() {
        this.forwardedFields1 = new HashMap<Integer, FieldSet>();
        this.forwardedFields2 = new HashMap<Integer, FieldSet>();
        this.readFields1 = null;
        this.readFields2 = null;
    }
}

